/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.DurationUnits;
import software.amazon.awssdk.services.mediaconnect.model.PriceUnits;
import software.amazon.awssdk.services.mediaconnect.model.ResourceSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Offering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Offering> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(Offering.getter(Offering::currencyCode)).setter(Offering.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(Offering.getter(Offering::duration)).setter(Offering.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurationUnits").getter(Offering.getter(Offering::durationUnitsAsString)).setter(Offering.setter(Builder::durationUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()}).build();
    private static final SdkField<String> OFFERING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingArn").getter(Offering.getter(Offering::offeringArn)).setter(Offering.setter(Builder::offeringArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringArn").build()}).build();
    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingDescription").getter(Offering.getter(Offering::offeringDescription)).setter(Offering.setter(Builder::offeringDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build()}).build();
    private static final SdkField<String> PRICE_PER_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricePerUnit").getter(Offering.getter(Offering::pricePerUnit)).setter(Offering.setter(Builder::pricePerUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricePerUnit").build()}).build();
    private static final SdkField<String> PRICE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PriceUnits").getter(Offering.getter(Offering::priceUnitsAsString)).setter(Offering.setter(Builder::priceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priceUnits").build()}).build();
    private static final SdkField<ResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceSpecification").getter(Offering.getter(Offering::resourceSpecification)).setter(Offering.setter(Builder::resourceSpecification)).constructor(ResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, DURATION_FIELD, DURATION_UNITS_FIELD, OFFERING_ARN_FIELD, OFFERING_DESCRIPTION_FIELD, PRICE_PER_UNIT_FIELD, PRICE_UNITS_FIELD, RESOURCE_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("currencyCode", CURRENCY_CODE_FIELD);
            this.put("duration", DURATION_FIELD);
            this.put("durationUnits", DURATION_UNITS_FIELD);
            this.put("offeringArn", OFFERING_ARN_FIELD);
            this.put("offeringDescription", OFFERING_DESCRIPTION_FIELD);
            this.put("pricePerUnit", PRICE_PER_UNIT_FIELD);
            this.put("priceUnits", PRICE_UNITS_FIELD);
            this.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final Integer duration;
    private final String durationUnits;
    private final String offeringArn;
    private final String offeringDescription;
    private final String pricePerUnit;
    private final String priceUnits;
    private final ResourceSpecification resourceSpecification;

    private Offering(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.offeringArn = builder.offeringArn;
        this.offeringDescription = builder.offeringDescription;
        this.pricePerUnit = builder.pricePerUnit;
        this.priceUnits = builder.priceUnits;
        this.resourceSpecification = builder.resourceSpecification;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final DurationUnits durationUnits() {
        return DurationUnits.fromValue(this.durationUnits);
    }

    public final String durationUnitsAsString() {
        return this.durationUnits;
    }

    public final String offeringArn() {
        return this.offeringArn;
    }

    public final String offeringDescription() {
        return this.offeringDescription;
    }

    public final String pricePerUnit() {
        return this.pricePerUnit;
    }

    public final PriceUnits priceUnits() {
        return PriceUnits.fromValue(this.priceUnits);
    }

    public final String priceUnitsAsString() {
        return this.priceUnits;
    }

    public final ResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricePerUnit());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offering)) {
            return false;
        }
        Offering other = (Offering)obj;
        return Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.durationUnitsAsString(), other.durationUnitsAsString()) && Objects.equals(this.offeringArn(), other.offeringArn()) && Objects.equals(this.offeringDescription(), other.offeringDescription()) && Objects.equals(this.pricePerUnit(), other.pricePerUnit()) && Objects.equals(this.priceUnitsAsString(), other.priceUnitsAsString()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"Offering").add("CurrencyCode", (Object)this.currencyCode()).add("Duration", (Object)this.duration()).add("DurationUnits", (Object)this.durationUnitsAsString()).add("OfferingArn", (Object)this.offeringArn()).add("OfferingDescription", (Object)this.offeringDescription()).add("PricePerUnit", (Object)this.pricePerUnit()).add("PriceUnits", (Object)this.priceUnitsAsString()).add("ResourceSpecification", (Object)this.resourceSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "DurationUnits": {
                return Optional.ofNullable(clazz.cast(this.durationUnitsAsString()));
            }
            case "OfferingArn": {
                return Optional.ofNullable(clazz.cast(this.offeringArn()));
            }
            case "OfferingDescription": {
                return Optional.ofNullable(clazz.cast(this.offeringDescription()));
            }
            case "PricePerUnit": {
                return Optional.ofNullable(clazz.cast(this.pricePerUnit()));
            }
            case "PriceUnits": {
                return Optional.ofNullable(clazz.cast(this.priceUnitsAsString()));
            }
            case "ResourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Offering, T> g) {
        return obj -> g.apply((Offering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private Integer duration;
        private String durationUnits;
        private String offeringArn;
        private String offeringDescription;
        private String pricePerUnit;
        private String priceUnits;
        private ResourceSpecification resourceSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(Offering model) {
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.durationUnits(model.durationUnits);
            this.offeringArn(model.offeringArn);
            this.offeringDescription(model.offeringDescription);
            this.pricePerUnit(model.pricePerUnit);
            this.priceUnits(model.priceUnits);
            this.resourceSpecification(model.resourceSpecification);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getDurationUnits() {
            return this.durationUnits;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        @Override
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        public final Builder durationUnits(DurationUnits durationUnits) {
            this.durationUnits(durationUnits == null ? null : durationUnits.toString());
            return this;
        }

        public final String getOfferingArn() {
            return this.offeringArn;
        }

        public final void setOfferingArn(String offeringArn) {
            this.offeringArn = offeringArn;
        }

        @Override
        public final Builder offeringArn(String offeringArn) {
            this.offeringArn = offeringArn;
            return this;
        }

        public final String getOfferingDescription() {
            return this.offeringDescription;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        @Override
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final String getPricePerUnit() {
            return this.pricePerUnit;
        }

        public final void setPricePerUnit(String pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
        }

        @Override
        public final Builder pricePerUnit(String pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
            return this;
        }

        public final String getPriceUnits() {
            return this.priceUnits;
        }

        public final void setPriceUnits(String priceUnits) {
            this.priceUnits = priceUnits;
        }

        @Override
        public final Builder priceUnits(String priceUnits) {
            this.priceUnits = priceUnits;
            return this;
        }

        @Override
        public final Builder priceUnits(PriceUnits priceUnits) {
            this.priceUnits(priceUnits == null ? null : priceUnits.toString());
            return this;
        }

        public final ResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public Offering build() {
            return new Offering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Offering> {
        public Builder currencyCode(String var1);

        public Builder duration(Integer var1);

        public Builder durationUnits(String var1);

        public Builder durationUnits(DurationUnits var1);

        public Builder offeringArn(String var1);

        public Builder offeringDescription(String var1);

        public Builder pricePerUnit(String var1);

        public Builder priceUnits(String var1);

        public Builder priceUnits(PriceUnits var1);

        public Builder resourceSpecification(ResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ResourceSpecification)((ResourceSpecification.Builder)ResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }
    }
}

