/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Add a network output to an existing bridge.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddBridgeNetworkOutputRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AddBridgeNetworkOutputRequest.Builder, AddBridgeNetworkOutputRequest> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(AddBridgeNetworkOutputRequest::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AddBridgeNetworkOutputRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkName").getter(getter(AddBridgeNetworkOutputRequest::networkName))
            .setter(setter(Builder::networkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AddBridgeNetworkOutputRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AddBridgeNetworkOutputRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<Integer> TTL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Ttl")
            .getter(getter(AddBridgeNetworkOutputRequest::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, NAME_FIELD,
            NETWORK_NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD, TTL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final String name;

    private final String networkName;

    private final Integer port;

    private final String protocol;

    private final Integer ttl;

    private AddBridgeNetworkOutputRequest(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.name = builder.name;
        this.networkName = builder.networkName;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.ttl = builder.ttl;
    }

    /**
     * The network output IP Address.
     * 
     * @return The network output IP Address.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * The network output name. This name is used to reference the output and must be unique among outputs in this
     * bridge.
     * 
     * @return The network output name. This name is used to reference the output and must be unique among outputs in
     *         this bridge.
     */
    public final String name() {
        return name;
    }

    /**
     * The network output's gateway network name.
     * 
     * @return The network output's gateway network name.
     */
    public final String networkName() {
        return networkName;
    }

    /**
     * The network output port.
     * 
     * @return The network output port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * The network output protocol.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The network output protocol.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The network output protocol.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The network output protocol.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * The network output TTL.
     * 
     * @return The network output TTL.
     */
    public final Integer ttl() {
        return ttl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddBridgeNetworkOutputRequest)) {
            return false;
        }
        AddBridgeNetworkOutputRequest other = (AddBridgeNetworkOutputRequest) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(name(), other.name())
                && Objects.equals(networkName(), other.networkName()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(ttl(), other.ttl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddBridgeNetworkOutputRequest").add("IpAddress", ipAddress()).add("Name", name())
                .add("NetworkName", networkName()).add("Port", port()).add("Protocol", protocolAsString()).add("Ttl", ttl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkName":
            return Optional.ofNullable(clazz.cast(networkName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networkName", NETWORK_NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("ttl", TTL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddBridgeNetworkOutputRequest, T> g) {
        return obj -> g.apply((AddBridgeNetworkOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddBridgeNetworkOutputRequest> {
        /**
         * The network output IP Address.
         * 
         * @param ipAddress
         *        The network output IP Address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * The network output name. This name is used to reference the output and must be unique among outputs in this
         * bridge.
         * 
         * @param name
         *        The network output name. This name is used to reference the output and must be unique among outputs in
         *        this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The network output's gateway network name.
         * 
         * @param networkName
         *        The network output's gateway network name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkName(String networkName);

        /**
         * The network output port.
         * 
         * @param port
         *        The network output port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * The network output protocol.
         * 
         * @param protocol
         *        The network output protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The network output protocol.
         * 
         * @param protocol
         *        The network output protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The network output TTL.
         * 
         * @param ttl
         *        The network output TTL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Integer ttl);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private String name;

        private String networkName;

        private Integer port;

        private String protocol;

        private Integer ttl;

        private BuilderImpl() {
        }

        private BuilderImpl(AddBridgeNetworkOutputRequest model) {
            ipAddress(model.ipAddress);
            name(model.name);
            networkName(model.networkName);
            port(model.port);
            protocol(model.protocol);
            ttl(model.ttl);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkName() {
            return networkName;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getTtl() {
            return ttl;
        }

        public final void setTtl(Integer ttl) {
            this.ttl = ttl;
        }

        @Override
        public final Builder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        @Override
        public AddBridgeNetworkOutputRequest build() {
            return new AddBridgeNetworkOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
