/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Add a source to an existing bridge.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddBridgeSourceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AddBridgeSourceRequest.Builder, AddBridgeSourceRequest> {
    private static final SdkField<AddBridgeFlowSourceRequest> FLOW_SOURCE_FIELD = SdkField
            .<AddBridgeFlowSourceRequest> builder(MarshallingType.SDK_POJO).memberName("FlowSource")
            .getter(getter(AddBridgeSourceRequest::flowSource)).setter(setter(Builder::flowSource))
            .constructor(AddBridgeFlowSourceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowSource").build()).build();

    private static final SdkField<AddBridgeNetworkSourceRequest> NETWORK_SOURCE_FIELD = SdkField
            .<AddBridgeNetworkSourceRequest> builder(MarshallingType.SDK_POJO).memberName("NetworkSource")
            .getter(getter(AddBridgeSourceRequest::networkSource)).setter(setter(Builder::networkSource))
            .constructor(AddBridgeNetworkSourceRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_SOURCE_FIELD,
            NETWORK_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AddBridgeFlowSourceRequest flowSource;

    private final AddBridgeNetworkSourceRequest networkSource;

    private AddBridgeSourceRequest(BuilderImpl builder) {
        this.flowSource = builder.flowSource;
        this.networkSource = builder.networkSource;
    }

    /**
     * Returns the value of the FlowSource property for this object.
     * 
     * @return The value of the FlowSource property for this object.
     */
    public final AddBridgeFlowSourceRequest flowSource() {
        return flowSource;
    }

    /**
     * Returns the value of the NetworkSource property for this object.
     * 
     * @return The value of the NetworkSource property for this object.
     */
    public final AddBridgeNetworkSourceRequest networkSource() {
        return networkSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowSource());
        hashCode = 31 * hashCode + Objects.hashCode(networkSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddBridgeSourceRequest)) {
            return false;
        }
        AddBridgeSourceRequest other = (AddBridgeSourceRequest) obj;
        return Objects.equals(flowSource(), other.flowSource()) && Objects.equals(networkSource(), other.networkSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddBridgeSourceRequest").add("FlowSource", flowSource()).add("NetworkSource", networkSource())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowSource":
            return Optional.ofNullable(clazz.cast(flowSource()));
        case "NetworkSource":
            return Optional.ofNullable(clazz.cast(networkSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowSource", FLOW_SOURCE_FIELD);
        map.put("networkSource", NETWORK_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddBridgeSourceRequest, T> g) {
        return obj -> g.apply((AddBridgeSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddBridgeSourceRequest> {
        /**
         * Sets the value of the FlowSource property for this object.
         *
         * @param flowSource
         *        The new value for the FlowSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowSource(AddBridgeFlowSourceRequest flowSource);

        /**
         * Sets the value of the FlowSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AddBridgeFlowSourceRequest.Builder}
         * avoiding the need to create one manually via {@link AddBridgeFlowSourceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddBridgeFlowSourceRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #flowSource(AddBridgeFlowSourceRequest)}.
         * 
         * @param flowSource
         *        a consumer that will call methods on {@link AddBridgeFlowSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowSource(AddBridgeFlowSourceRequest)
         */
        default Builder flowSource(Consumer<AddBridgeFlowSourceRequest.Builder> flowSource) {
            return flowSource(AddBridgeFlowSourceRequest.builder().applyMutation(flowSource).build());
        }

        /**
         * Sets the value of the NetworkSource property for this object.
         *
         * @param networkSource
         *        The new value for the NetworkSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSource(AddBridgeNetworkSourceRequest networkSource);

        /**
         * Sets the value of the NetworkSource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AddBridgeNetworkSourceRequest.Builder}
         * avoiding the need to create one manually via {@link AddBridgeNetworkSourceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddBridgeNetworkSourceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #networkSource(AddBridgeNetworkSourceRequest)}.
         * 
         * @param networkSource
         *        a consumer that will call methods on {@link AddBridgeNetworkSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSource(AddBridgeNetworkSourceRequest)
         */
        default Builder networkSource(Consumer<AddBridgeNetworkSourceRequest.Builder> networkSource) {
            return networkSource(AddBridgeNetworkSourceRequest.builder().applyMutation(networkSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AddBridgeFlowSourceRequest flowSource;

        private AddBridgeNetworkSourceRequest networkSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AddBridgeSourceRequest model) {
            flowSource(model.flowSource);
            networkSource(model.networkSource);
        }

        public final AddBridgeFlowSourceRequest.Builder getFlowSource() {
            return flowSource != null ? flowSource.toBuilder() : null;
        }

        public final void setFlowSource(AddBridgeFlowSourceRequest.BuilderImpl flowSource) {
            this.flowSource = flowSource != null ? flowSource.build() : null;
        }

        @Override
        public final Builder flowSource(AddBridgeFlowSourceRequest flowSource) {
            this.flowSource = flowSource;
            return this;
        }

        public final AddBridgeNetworkSourceRequest.Builder getNetworkSource() {
            return networkSource != null ? networkSource.toBuilder() : null;
        }

        public final void setNetworkSource(AddBridgeNetworkSourceRequest.BuilderImpl networkSource) {
            this.networkSource = networkSource != null ? networkSource.build() : null;
        }

        @Override
        public final Builder networkSource(AddBridgeNetworkSourceRequest networkSource) {
            this.networkSource = networkSource;
            return this;
        }

        @Override
        public AddBridgeSourceRequest build() {
            return new AddBridgeSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
