/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specifies the configuration for audio stream metrics monitoring.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioMonitoringSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioMonitoringSetting.Builder, AudioMonitoringSetting> {
    private static final SdkField<SilentAudio> SILENT_AUDIO_FIELD = SdkField.<SilentAudio> builder(MarshallingType.SDK_POJO)
            .memberName("SilentAudio").getter(getter(AudioMonitoringSetting::silentAudio)).setter(setter(Builder::silentAudio))
            .constructor(SilentAudio::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("silentAudio").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SILENT_AUDIO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SilentAudio silentAudio;

    private AudioMonitoringSetting(BuilderImpl builder) {
        this.silentAudio = builder.silentAudio;
    }

    /**
     * Detects periods of silence.
     * 
     * @return Detects periods of silence.
     */
    public final SilentAudio silentAudio() {
        return silentAudio;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(silentAudio());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioMonitoringSetting)) {
            return false;
        }
        AudioMonitoringSetting other = (AudioMonitoringSetting) obj;
        return Objects.equals(silentAudio(), other.silentAudio());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioMonitoringSetting").add("SilentAudio", silentAudio()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SilentAudio":
            return Optional.ofNullable(clazz.cast(silentAudio()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("silentAudio", SILENT_AUDIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioMonitoringSetting, T> g) {
        return obj -> g.apply((AudioMonitoringSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioMonitoringSetting> {
        /**
         * Detects periods of silence.
         * 
         * @param silentAudio
         *        Detects periods of silence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder silentAudio(SilentAudio silentAudio);

        /**
         * Detects periods of silence. This is a convenience method that creates an instance of the
         * {@link SilentAudio.Builder} avoiding the need to create one manually via {@link SilentAudio#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SilentAudio.Builder#build()} is called immediately and its result
         * is passed to {@link #silentAudio(SilentAudio)}.
         * 
         * @param silentAudio
         *        a consumer that will call methods on {@link SilentAudio.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #silentAudio(SilentAudio)
         */
        default Builder silentAudio(Consumer<SilentAudio.Builder> silentAudio) {
            return silentAudio(SilentAudio.builder().applyMutation(silentAudio).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SilentAudio silentAudio;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioMonitoringSetting model) {
            silentAudio(model.silentAudio);
        }

        public final SilentAudio.Builder getSilentAudio() {
            return silentAudio != null ? silentAudio.toBuilder() : null;
        }

        public final void setSilentAudio(SilentAudio.BuilderImpl silentAudio) {
            this.silentAudio = silentAudio != null ? silentAudio.build() : null;
        }

        @Override
        public final Builder silentAudio(SilentAudio silentAudio) {
            this.silentAudio = silentAudio;
            return this;
        }

        @Override
        public AudioMonitoringSetting build() {
            return new AudioMonitoringSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
