/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BridgeFlowSource implements SdkPojo, Serializable,
        ToCopyableBuilder<BridgeFlowSource.Builder, BridgeFlowSource> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(BridgeFlowSource::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<VpcInterfaceAttachment> FLOW_VPC_INTERFACE_ATTACHMENT_FIELD = SdkField
            .<VpcInterfaceAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("FlowVpcInterfaceAttachment")
            .getter(getter(BridgeFlowSource::flowVpcInterfaceAttachment))
            .setter(setter(Builder::flowVpcInterfaceAttachment))
            .constructor(VpcInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVpcInterfaceAttachment").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(BridgeFlowSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OUTPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputArn").getter(getter(BridgeFlowSource::outputArn)).setter(setter(Builder::outputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            FLOW_VPC_INTERFACE_ATTACHMENT_FIELD, NAME_FIELD, OUTPUT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final VpcInterfaceAttachment flowVpcInterfaceAttachment;

    private final String name;

    private final String outputArn;

    private BridgeFlowSource(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowVpcInterfaceAttachment = builder.flowVpcInterfaceAttachment;
        this.name = builder.name;
        this.outputArn = builder.outputArn;
    }

    /**
     * The ARN of the cloud flow used as a source of this bridge.
     * 
     * @return The ARN of the cloud flow used as a source of this bridge.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The name of the VPC interface attachment to use for this source.
     * 
     * @return The name of the VPC interface attachment to use for this source.
     */
    public final VpcInterfaceAttachment flowVpcInterfaceAttachment() {
        return flowVpcInterfaceAttachment;
    }

    /**
     * The name of the flow source.
     * 
     * @return The name of the flow source.
     */
    public final String name() {
        return name;
    }

    /**
     * The Amazon Resource Number (ARN) of the output.
     * 
     * @return The Amazon Resource Number (ARN) of the output.
     */
    public final String outputArn() {
        return outputArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowVpcInterfaceAttachment());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BridgeFlowSource)) {
            return false;
        }
        BridgeFlowSource other = (BridgeFlowSource) obj;
        return Objects.equals(flowArn(), other.flowArn())
                && Objects.equals(flowVpcInterfaceAttachment(), other.flowVpcInterfaceAttachment())
                && Objects.equals(name(), other.name()) && Objects.equals(outputArn(), other.outputArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BridgeFlowSource").add("FlowArn", flowArn())
                .add("FlowVpcInterfaceAttachment", flowVpcInterfaceAttachment()).add("Name", name())
                .add("OutputArn", outputArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "FlowVpcInterfaceAttachment":
            return Optional.ofNullable(clazz.cast(flowVpcInterfaceAttachment()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OutputArn":
            return Optional.ofNullable(clazz.cast(outputArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("flowVpcInterfaceAttachment", FLOW_VPC_INTERFACE_ATTACHMENT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("outputArn", OUTPUT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BridgeFlowSource, T> g) {
        return obj -> g.apply((BridgeFlowSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BridgeFlowSource> {
        /**
         * The ARN of the cloud flow used as a source of this bridge.
         * 
         * @param flowArn
         *        The ARN of the cloud flow used as a source of this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The name of the VPC interface attachment to use for this source.
         * 
         * @param flowVpcInterfaceAttachment
         *        The name of the VPC interface attachment to use for this source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowVpcInterfaceAttachment(VpcInterfaceAttachment flowVpcInterfaceAttachment);

        /**
         * The name of the VPC interface attachment to use for this source. This is a convenience method that creates an
         * instance of the {@link VpcInterfaceAttachment.Builder} avoiding the need to create one manually via
         * {@link VpcInterfaceAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcInterfaceAttachment.Builder#build()} is called immediately and
         * its result is passed to {@link #flowVpcInterfaceAttachment(VpcInterfaceAttachment)}.
         * 
         * @param flowVpcInterfaceAttachment
         *        a consumer that will call methods on {@link VpcInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowVpcInterfaceAttachment(VpcInterfaceAttachment)
         */
        default Builder flowVpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> flowVpcInterfaceAttachment) {
            return flowVpcInterfaceAttachment(VpcInterfaceAttachment.builder().applyMutation(flowVpcInterfaceAttachment).build());
        }

        /**
         * The name of the flow source.
         * 
         * @param name
         *        The name of the flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The Amazon Resource Number (ARN) of the output.
         * 
         * @param outputArn
         *        The Amazon Resource Number (ARN) of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArn(String outputArn);
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private VpcInterfaceAttachment flowVpcInterfaceAttachment;

        private String name;

        private String outputArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BridgeFlowSource model) {
            flowArn(model.flowArn);
            flowVpcInterfaceAttachment(model.flowVpcInterfaceAttachment);
            name(model.name);
            outputArn(model.outputArn);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final VpcInterfaceAttachment.Builder getFlowVpcInterfaceAttachment() {
            return flowVpcInterfaceAttachment != null ? flowVpcInterfaceAttachment.toBuilder() : null;
        }

        public final void setFlowVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl flowVpcInterfaceAttachment) {
            this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment != null ? flowVpcInterfaceAttachment.build() : null;
        }

        @Override
        public final Builder flowVpcInterfaceAttachment(VpcInterfaceAttachment flowVpcInterfaceAttachment) {
            this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOutputArn() {
            return outputArn;
        }

        public final void setOutputArn(String outputArn) {
            this.outputArn = outputArn;
        }

        @Override
        public final Builder outputArn(String outputArn) {
            this.outputArn = outputArn;
            return this;
        }

        @Override
        public BridgeFlowSource build() {
            return new BridgeFlowSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
