/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The source of the bridge. A network source originates at your premises.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BridgeNetworkSource implements SdkPojo, Serializable,
        ToCopyableBuilder<BridgeNetworkSource.Builder, BridgeNetworkSource> {
    private static final SdkField<String> MULTICAST_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MulticastIp").getter(getter(BridgeNetworkSource::multicastIp)).setter(setter(Builder::multicastIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastIp").build()).build();

    private static final SdkField<MulticastSourceSettings> MULTICAST_SOURCE_SETTINGS_FIELD = SdkField
            .<MulticastSourceSettings> builder(MarshallingType.SDK_POJO).memberName("MulticastSourceSettings")
            .getter(getter(BridgeNetworkSource::multicastSourceSettings)).setter(setter(Builder::multicastSourceSettings))
            .constructor(MulticastSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastSourceSettings").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(BridgeNetworkSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkName").getter(getter(BridgeNetworkSource::networkName)).setter(setter(Builder::networkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(BridgeNetworkSource::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(BridgeNetworkSource::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTICAST_IP_FIELD,
            MULTICAST_SOURCE_SETTINGS_FIELD, NAME_FIELD, NETWORK_NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String multicastIp;

    private final MulticastSourceSettings multicastSourceSettings;

    private final String name;

    private final String networkName;

    private final Integer port;

    private final String protocol;

    private BridgeNetworkSource(BuilderImpl builder) {
        this.multicastIp = builder.multicastIp;
        this.multicastSourceSettings = builder.multicastSourceSettings;
        this.name = builder.name;
        this.networkName = builder.networkName;
        this.port = builder.port;
        this.protocol = builder.protocol;
    }

    /**
     * The network source multicast IP.
     * 
     * @return The network source multicast IP.
     */
    public final String multicastIp() {
        return multicastIp;
    }

    /**
     * Returns the value of the MulticastSourceSettings property for this object.
     * 
     * @return The value of the MulticastSourceSettings property for this object.
     */
    public final MulticastSourceSettings multicastSourceSettings() {
        return multicastSourceSettings;
    }

    /**
     * The name of the network source.
     * 
     * @return The name of the network source.
     */
    public final String name() {
        return name;
    }

    /**
     * The network source's gateway network name.
     * 
     * @return The network source's gateway network name.
     */
    public final String networkName() {
        return networkName;
    }

    /**
     * The network source port.
     * 
     * @return The network source port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * The network source protocol.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The network source protocol.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The network source protocol.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The network source protocol.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multicastIp());
        hashCode = 31 * hashCode + Objects.hashCode(multicastSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BridgeNetworkSource)) {
            return false;
        }
        BridgeNetworkSource other = (BridgeNetworkSource) obj;
        return Objects.equals(multicastIp(), other.multicastIp())
                && Objects.equals(multicastSourceSettings(), other.multicastSourceSettings())
                && Objects.equals(name(), other.name()) && Objects.equals(networkName(), other.networkName())
                && Objects.equals(port(), other.port()) && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BridgeNetworkSource").add("MulticastIp", multicastIp())
                .add("MulticastSourceSettings", multicastSourceSettings()).add("Name", name()).add("NetworkName", networkName())
                .add("Port", port()).add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MulticastIp":
            return Optional.ofNullable(clazz.cast(multicastIp()));
        case "MulticastSourceSettings":
            return Optional.ofNullable(clazz.cast(multicastSourceSettings()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkName":
            return Optional.ofNullable(clazz.cast(networkName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("multicastIp", MULTICAST_IP_FIELD);
        map.put("multicastSourceSettings", MULTICAST_SOURCE_SETTINGS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networkName", NETWORK_NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BridgeNetworkSource, T> g) {
        return obj -> g.apply((BridgeNetworkSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BridgeNetworkSource> {
        /**
         * The network source multicast IP.
         * 
         * @param multicastIp
         *        The network source multicast IP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastIp(String multicastIp);

        /**
         * Sets the value of the MulticastSourceSettings property for this object.
         *
         * @param multicastSourceSettings
         *        The new value for the MulticastSourceSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastSourceSettings(MulticastSourceSettings multicastSourceSettings);

        /**
         * Sets the value of the MulticastSourceSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MulticastSourceSettings.Builder} avoiding
         * the need to create one manually via {@link MulticastSourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MulticastSourceSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #multicastSourceSettings(MulticastSourceSettings)}.
         * 
         * @param multicastSourceSettings
         *        a consumer that will call methods on {@link MulticastSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multicastSourceSettings(MulticastSourceSettings)
         */
        default Builder multicastSourceSettings(Consumer<MulticastSourceSettings.Builder> multicastSourceSettings) {
            return multicastSourceSettings(MulticastSourceSettings.builder().applyMutation(multicastSourceSettings).build());
        }

        /**
         * The name of the network source.
         * 
         * @param name
         *        The name of the network source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The network source's gateway network name.
         * 
         * @param networkName
         *        The network source's gateway network name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkName(String networkName);

        /**
         * The network source port.
         * 
         * @param port
         *        The network source port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * The network source protocol.
         * 
         * @param protocol
         *        The network source protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The network source protocol.
         * 
         * @param protocol
         *        The network source protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);
    }

    static final class BuilderImpl implements Builder {
        private String multicastIp;

        private MulticastSourceSettings multicastSourceSettings;

        private String name;

        private String networkName;

        private Integer port;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(BridgeNetworkSource model) {
            multicastIp(model.multicastIp);
            multicastSourceSettings(model.multicastSourceSettings);
            name(model.name);
            networkName(model.networkName);
            port(model.port);
            protocol(model.protocol);
        }

        public final String getMulticastIp() {
            return multicastIp;
        }

        public final void setMulticastIp(String multicastIp) {
            this.multicastIp = multicastIp;
        }

        @Override
        public final Builder multicastIp(String multicastIp) {
            this.multicastIp = multicastIp;
            return this;
        }

        public final MulticastSourceSettings.Builder getMulticastSourceSettings() {
            return multicastSourceSettings != null ? multicastSourceSettings.toBuilder() : null;
        }

        public final void setMulticastSourceSettings(MulticastSourceSettings.BuilderImpl multicastSourceSettings) {
            this.multicastSourceSettings = multicastSourceSettings != null ? multicastSourceSettings.build() : null;
        }

        @Override
        public final Builder multicastSourceSettings(MulticastSourceSettings multicastSourceSettings) {
            this.multicastSourceSettings = multicastSourceSettings;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkName() {
            return networkName;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public BridgeNetworkSource build() {
            return new BridgeNetworkSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
