/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBridgeResponse extends MediaConnectResponse implements
        ToCopyableBuilder<DescribeBridgeResponse.Builder, DescribeBridgeResponse> {
    private static final SdkField<Bridge> BRIDGE_FIELD = SdkField.<Bridge> builder(MarshallingType.SDK_POJO).memberName("Bridge")
            .getter(getter(DescribeBridgeResponse::bridge)).setter(setter(Builder::bridge)).constructor(Bridge::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridge").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Bridge bridge;

    private DescribeBridgeResponse(BuilderImpl builder) {
        super(builder);
        this.bridge = builder.bridge;
    }

    /**
     * Returns the value of the Bridge property for this object.
     * 
     * @return The value of the Bridge property for this object.
     */
    public final Bridge bridge() {
        return bridge;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bridge());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBridgeResponse)) {
            return false;
        }
        DescribeBridgeResponse other = (DescribeBridgeResponse) obj;
        return Objects.equals(bridge(), other.bridge());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBridgeResponse").add("Bridge", bridge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bridge":
            return Optional.ofNullable(clazz.cast(bridge()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bridge", BRIDGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBridgeResponse, T> g) {
        return obj -> g.apply((DescribeBridgeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBridgeResponse> {
        /**
         * Sets the value of the Bridge property for this object.
         *
         * @param bridge
         *        The new value for the Bridge property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridge(Bridge bridge);

        /**
         * Sets the value of the Bridge property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Bridge.Builder} avoiding the need to
         * create one manually via {@link Bridge#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Bridge.Builder#build()} is called immediately and its result is
         * passed to {@link #bridge(Bridge)}.
         * 
         * @param bridge
         *        a consumer that will call methods on {@link Bridge.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bridge(Bridge)
         */
        default Builder bridge(Consumer<Bridge.Builder> bridge) {
            return bridge(Bridge.builder().applyMutation(bridge).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private Bridge bridge;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBridgeResponse model) {
            super(model);
            bridge(model.bridge);
        }

        public final Bridge.Builder getBridge() {
            return bridge != null ? bridge.toBuilder() : null;
        }

        public final void setBridge(Bridge.BuilderImpl bridge) {
            this.bridge = bridge != null ? bridge.build() : null;
        }

        @Override
        public final Builder bridge(Bridge bridge) {
            this.bridge = bridge;
            return this;
        }

        @Override
        public DescribeBridgeResponse build() {
            return new DescribeBridgeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
