/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlowSourceThumbnailResponse extends MediaConnectResponse implements
        ToCopyableBuilder<DescribeFlowSourceThumbnailResponse.Builder, DescribeFlowSourceThumbnailResponse> {
    private static final SdkField<ThumbnailDetails> THUMBNAIL_DETAILS_FIELD = SdkField
            .<ThumbnailDetails> builder(MarshallingType.SDK_POJO).memberName("ThumbnailDetails")
            .getter(getter(DescribeFlowSourceThumbnailResponse::thumbnailDetails)).setter(setter(Builder::thumbnailDetails))
            .constructor(ThumbnailDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THUMBNAIL_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ThumbnailDetails thumbnailDetails;

    private DescribeFlowSourceThumbnailResponse(BuilderImpl builder) {
        super(builder);
        this.thumbnailDetails = builder.thumbnailDetails;
    }

    /**
     * Returns the value of the ThumbnailDetails property for this object.
     * 
     * @return The value of the ThumbnailDetails property for this object.
     */
    public final ThumbnailDetails thumbnailDetails() {
        return thumbnailDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowSourceThumbnailResponse)) {
            return false;
        }
        DescribeFlowSourceThumbnailResponse other = (DescribeFlowSourceThumbnailResponse) obj;
        return Objects.equals(thumbnailDetails(), other.thumbnailDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFlowSourceThumbnailResponse").add("ThumbnailDetails", thumbnailDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThumbnailDetails":
            return Optional.ofNullable(clazz.cast(thumbnailDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thumbnailDetails", THUMBNAIL_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowSourceThumbnailResponse, T> g) {
        return obj -> g.apply((DescribeFlowSourceThumbnailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFlowSourceThumbnailResponse> {
        /**
         * Sets the value of the ThumbnailDetails property for this object.
         *
         * @param thumbnailDetails
         *        The new value for the ThumbnailDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailDetails(ThumbnailDetails thumbnailDetails);

        /**
         * Sets the value of the ThumbnailDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ThumbnailDetails.Builder} avoiding the
         * need to create one manually via {@link ThumbnailDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThumbnailDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #thumbnailDetails(ThumbnailDetails)}.
         * 
         * @param thumbnailDetails
         *        a consumer that will call methods on {@link ThumbnailDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailDetails(ThumbnailDetails)
         */
        default Builder thumbnailDetails(Consumer<ThumbnailDetails.Builder> thumbnailDetails) {
            return thumbnailDetails(ThumbnailDetails.builder().applyMutation(thumbnailDetails).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private ThumbnailDetails thumbnailDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowSourceThumbnailResponse model) {
            super(model);
            thumbnailDetails(model.thumbnailDetails);
        }

        public final ThumbnailDetails.Builder getThumbnailDetails() {
            return thumbnailDetails != null ? thumbnailDetails.toBuilder() : null;
        }

        public final void setThumbnailDetails(ThumbnailDetails.BuilderImpl thumbnailDetails) {
            this.thumbnailDetails = thumbnailDetails != null ? thumbnailDetails.build() : null;
        }

        @Override
        public final Builder thumbnailDetails(ThumbnailDetails thumbnailDetails) {
            this.thumbnailDetails = thumbnailDetails;
            return this;
        }

        @Override
        public DescribeFlowSourceThumbnailResponse build() {
            return new DescribeFlowSourceThumbnailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
