/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGatewayInstanceResponse extends MediaConnectResponse implements
        ToCopyableBuilder<DescribeGatewayInstanceResponse.Builder, DescribeGatewayInstanceResponse> {
    private static final SdkField<GatewayInstance> GATEWAY_INSTANCE_FIELD = SdkField
            .<GatewayInstance> builder(MarshallingType.SDK_POJO).memberName("GatewayInstance")
            .getter(getter(DescribeGatewayInstanceResponse::gatewayInstance)).setter(setter(Builder::gatewayInstance))
            .constructor(GatewayInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final GatewayInstance gatewayInstance;

    private DescribeGatewayInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayInstance = builder.gatewayInstance;
    }

    /**
     * Returns the value of the GatewayInstance property for this object.
     * 
     * @return The value of the GatewayInstance property for this object.
     */
    public final GatewayInstance gatewayInstance() {
        return gatewayInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayInstanceResponse)) {
            return false;
        }
        DescribeGatewayInstanceResponse other = (DescribeGatewayInstanceResponse) obj;
        return Objects.equals(gatewayInstance(), other.gatewayInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGatewayInstanceResponse").add("GatewayInstance", gatewayInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayInstance":
            return Optional.ofNullable(clazz.cast(gatewayInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayInstance", GATEWAY_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayInstanceResponse, T> g) {
        return obj -> g.apply((DescribeGatewayInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGatewayInstanceResponse> {
        /**
         * Sets the value of the GatewayInstance property for this object.
         *
         * @param gatewayInstance
         *        The new value for the GatewayInstance property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayInstance(GatewayInstance gatewayInstance);

        /**
         * Sets the value of the GatewayInstance property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GatewayInstance.Builder} avoiding the
         * need to create one manually via {@link GatewayInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatewayInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #gatewayInstance(GatewayInstance)}.
         * 
         * @param gatewayInstance
         *        a consumer that will call methods on {@link GatewayInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayInstance(GatewayInstance)
         */
        default Builder gatewayInstance(Consumer<GatewayInstance.Builder> gatewayInstance) {
            return gatewayInstance(GatewayInstance.builder().applyMutation(gatewayInstance).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private GatewayInstance gatewayInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayInstanceResponse model) {
            super(model);
            gatewayInstance(model.gatewayInstance);
        }

        public final GatewayInstance.Builder getGatewayInstance() {
            return gatewayInstance != null ? gatewayInstance.toBuilder() : null;
        }

        public final void setGatewayInstance(GatewayInstance.BuilderImpl gatewayInstance) {
            this.gatewayInstance = gatewayInstance != null ? gatewayInstance.build() : null;
        }

        @Override
        public final Builder gatewayInstance(GatewayInstance gatewayInstance) {
            this.gatewayInstance = gatewayInstance;
            return this;
        }

        @Override
        public DescribeGatewayInstanceResponse build() {
            return new DescribeGatewayInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
