/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to grant entitlements on a flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrantFlowEntitlementsRequest extends MediaConnectRequest implements
        ToCopyableBuilder<GrantFlowEntitlementsRequest.Builder, GrantFlowEntitlementsRequest> {
    private static final SdkField<List<GrantEntitlementRequest>> ENTITLEMENTS_FIELD = SdkField
            .<List<GrantEntitlementRequest>> builder(MarshallingType.LIST)
            .memberName("Entitlements")
            .getter(getter(GrantFlowEntitlementsRequest::entitlements))
            .setter(setter(Builder::entitlements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GrantEntitlementRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(GrantEntitlementRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(GrantFlowEntitlementsRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENTS_FIELD,
            FLOW_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GrantEntitlementRequest> entitlements;

    private final String flowArn;

    private GrantFlowEntitlementsRequest(BuilderImpl builder) {
        super(builder);
        this.entitlements = builder.entitlements;
        this.flowArn = builder.flowArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entitlements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntitlements() {
        return entitlements != null && !(entitlements instanceof SdkAutoConstructList);
    }

    /**
     * The list of entitlements that you want to grant.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntitlements} method.
     * </p>
     * 
     * @return The list of entitlements that you want to grant.
     */
    public final List<GrantEntitlementRequest> entitlements() {
        return entitlements;
    }

    /**
     * The flow that you want to grant entitlements on.
     * 
     * @return The flow that you want to grant entitlements on.
     */
    public final String flowArn() {
        return flowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntitlements() ? entitlements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrantFlowEntitlementsRequest)) {
            return false;
        }
        GrantFlowEntitlementsRequest other = (GrantFlowEntitlementsRequest) obj;
        return hasEntitlements() == other.hasEntitlements() && Objects.equals(entitlements(), other.entitlements())
                && Objects.equals(flowArn(), other.flowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrantFlowEntitlementsRequest").add("Entitlements", hasEntitlements() ? entitlements() : null)
                .add("FlowArn", flowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entitlements":
            return Optional.ofNullable(clazz.cast(entitlements()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entitlements", ENTITLEMENTS_FIELD);
        map.put("flowArn", FLOW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GrantFlowEntitlementsRequest, T> g) {
        return obj -> g.apply((GrantFlowEntitlementsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, GrantFlowEntitlementsRequest> {
        /**
         * The list of entitlements that you want to grant.
         * 
         * @param entitlements
         *        The list of entitlements that you want to grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(Collection<GrantEntitlementRequest> entitlements);

        /**
         * The list of entitlements that you want to grant.
         * 
         * @param entitlements
         *        The list of entitlements that you want to grant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlements(GrantEntitlementRequest... entitlements);

        /**
         * The list of entitlements that you want to grant. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #entitlements(List<GrantEntitlementRequest>)}.
         * 
         * @param entitlements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.GrantEntitlementRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entitlements(java.util.Collection<GrantEntitlementRequest>)
         */
        Builder entitlements(Consumer<GrantEntitlementRequest.Builder>... entitlements);

        /**
         * The flow that you want to grant entitlements on.
         * 
         * @param flowArn
         *        The flow that you want to grant entitlements on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private List<GrantEntitlementRequest> entitlements = DefaultSdkAutoConstructList.getInstance();

        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GrantFlowEntitlementsRequest model) {
            super(model);
            entitlements(model.entitlements);
            flowArn(model.flowArn);
        }

        public final List<GrantEntitlementRequest.Builder> getEntitlements() {
            List<GrantEntitlementRequest.Builder> result = ___listOfGrantEntitlementRequestCopier
                    .copyToBuilder(this.entitlements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlements(Collection<GrantEntitlementRequest.BuilderImpl> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copyFromBuilder(entitlements);
        }

        @Override
        public final Builder entitlements(Collection<GrantEntitlementRequest> entitlements) {
            this.entitlements = ___listOfGrantEntitlementRequestCopier.copy(entitlements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(GrantEntitlementRequest... entitlements) {
            entitlements(Arrays.asList(entitlements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlements(Consumer<GrantEntitlementRequest.Builder>... entitlements) {
            entitlements(Stream.of(entitlements).map(c -> GrantEntitlementRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GrantFlowEntitlementsRequest build() {
            return new GrantFlowEntitlementsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
