/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Provides a summary of a gateway, including its name, ARN, and status.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedGateway implements SdkPojo, Serializable, ToCopyableBuilder<ListedGateway.Builder, ListedGateway> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(ListedGateway::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()).build();

    private static final SdkField<String> GATEWAY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayState").getter(getter(ListedGateway::gatewayStateAsString)).setter(setter(Builder::gatewayState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayState").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListedGateway::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            GATEWAY_STATE_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String gatewayArn;

    private final String gatewayState;

    private final String name;

    private ListedGateway(BuilderImpl builder) {
        this.gatewayArn = builder.gatewayArn;
        this.gatewayState = builder.gatewayState;
        this.name = builder.name;
    }

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     * 
     * @return The Amazon Resource Name (ARN) of the gateway.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * Returns the value of the GatewayState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayState} will
     * return {@link GatewayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gatewayStateAsString}.
     * </p>
     * 
     * @return The value of the GatewayState property for this object.
     * @see GatewayState
     */
    public final GatewayState gatewayState() {
        return GatewayState.fromValue(gatewayState);
    }

    /**
     * Returns the value of the GatewayState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayState} will
     * return {@link GatewayState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gatewayStateAsString}.
     * </p>
     * 
     * @return The value of the GatewayState property for this object.
     * @see GatewayState
     */
    public final String gatewayStateAsString() {
        return gatewayState;
    }

    /**
     * The name of the gateway.
     * 
     * @return The name of the gateway.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedGateway)) {
            return false;
        }
        ListedGateway other = (ListedGateway) obj;
        return Objects.equals(gatewayArn(), other.gatewayArn())
                && Objects.equals(gatewayStateAsString(), other.gatewayStateAsString()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedGateway").add("GatewayArn", gatewayArn()).add("GatewayState", gatewayStateAsString())
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "GatewayState":
            return Optional.ofNullable(clazz.cast(gatewayStateAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("gatewayState", GATEWAY_STATE_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedGateway, T> g) {
        return obj -> g.apply((ListedGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedGateway> {
        /**
         * The Amazon Resource Name (ARN) of the gateway.
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * Sets the value of the GatewayState property for this object.
         *
         * @param gatewayState
         *        The new value for the GatewayState property for this object.
         * @see GatewayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayState
         */
        Builder gatewayState(String gatewayState);

        /**
         * Sets the value of the GatewayState property for this object.
         *
         * @param gatewayState
         *        The new value for the GatewayState property for this object.
         * @see GatewayState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayState
         */
        Builder gatewayState(GatewayState gatewayState);

        /**
         * The name of the gateway.
         * 
         * @param name
         *        The name of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayArn;

        private String gatewayState;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedGateway model) {
            gatewayArn(model.gatewayArn);
            gatewayState(model.gatewayState);
            name(model.name);
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayState() {
            return gatewayState;
        }

        public final void setGatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
        }

        @Override
        public final Builder gatewayState(String gatewayState) {
            this.gatewayState = gatewayState;
            return this;
        }

        @Override
        public final Builder gatewayState(GatewayState gatewayState) {
            this.gatewayState(gatewayState == null ? null : gatewayState.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ListedGateway build() {
            return new ListedGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
