/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The maintenance setting of a flow
 */
@Generated("software.amazon.awssdk:codegen")
public final class Maintenance implements SdkPojo, Serializable, ToCopyableBuilder<Maintenance.Builder, Maintenance> {
    private static final SdkField<String> MAINTENANCE_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceDay").getter(getter(Maintenance::maintenanceDayAsString))
            .setter(setter(Builder::maintenanceDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDay").build()).build();

    private static final SdkField<String> MAINTENANCE_DEADLINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceDeadline").getter(getter(Maintenance::maintenanceDeadline))
            .setter(setter(Builder::maintenanceDeadline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceDeadline").build())
            .build();

    private static final SdkField<String> MAINTENANCE_SCHEDULED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceScheduledDate").getter(getter(Maintenance::maintenanceScheduledDate))
            .setter(setter(Builder::maintenanceScheduledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceScheduledDate").build())
            .build();

    private static final SdkField<String> MAINTENANCE_START_HOUR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaintenanceStartHour").getter(getter(Maintenance::maintenanceStartHour))
            .setter(setter(Builder::maintenanceStartHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceStartHour").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_DAY_FIELD,
            MAINTENANCE_DEADLINE_FIELD, MAINTENANCE_SCHEDULED_DATE_FIELD, MAINTENANCE_START_HOUR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String maintenanceDay;

    private final String maintenanceDeadline;

    private final String maintenanceScheduledDate;

    private final String maintenanceStartHour;

    private Maintenance(BuilderImpl builder) {
        this.maintenanceDay = builder.maintenanceDay;
        this.maintenanceDeadline = builder.maintenanceDeadline;
        this.maintenanceScheduledDate = builder.maintenanceScheduledDate;
        this.maintenanceStartHour = builder.maintenanceStartHour;
    }

    /**
     * A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceDay}
     * will return {@link MaintenanceDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceDayAsString}.
     * </p>
     * 
     * @return A day of a week when the maintenance will happen. Use
     *         Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
     * @see MaintenanceDay
     */
    public final MaintenanceDay maintenanceDay() {
        return MaintenanceDay.fromValue(maintenanceDay);
    }

    /**
     * A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #maintenanceDay}
     * will return {@link MaintenanceDay#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #maintenanceDayAsString}.
     * </p>
     * 
     * @return A day of a week when the maintenance will happen. Use
     *         Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
     * @see MaintenanceDay
     */
    public final String maintenanceDayAsString() {
        return maintenanceDay;
    }

    /**
     * The Maintenance has to be performed before this deadline in ISO UTC format. Example: 2021-01-30T08:30:00Z.
     * 
     * @return The Maintenance has to be performed before this deadline in ISO UTC format. Example:
     *         2021-01-30T08:30:00Z.
     */
    public final String maintenanceDeadline() {
        return maintenanceDeadline;
    }

    /**
     * A scheduled date in ISO UTC format when the maintenance will happen. Use YYYY-MM-DD format. Example: 2021-01-30.
     * 
     * @return A scheduled date in ISO UTC format when the maintenance will happen. Use YYYY-MM-DD format. Example:
     *         2021-01-30.
     */
    public final String maintenanceScheduledDate() {
        return maintenanceScheduledDate;
    }

    /**
     * UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The
     * default value is 02:00.
     * 
     * @return UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00.
     *         The default value is 02:00.
     */
    public final String maintenanceStartHour() {
        return maintenanceStartHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceDayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceDeadline());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceScheduledDate());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceStartHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Maintenance)) {
            return false;
        }
        Maintenance other = (Maintenance) obj;
        return Objects.equals(maintenanceDayAsString(), other.maintenanceDayAsString())
                && Objects.equals(maintenanceDeadline(), other.maintenanceDeadline())
                && Objects.equals(maintenanceScheduledDate(), other.maintenanceScheduledDate())
                && Objects.equals(maintenanceStartHour(), other.maintenanceStartHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Maintenance").add("MaintenanceDay", maintenanceDayAsString())
                .add("MaintenanceDeadline", maintenanceDeadline()).add("MaintenanceScheduledDate", maintenanceScheduledDate())
                .add("MaintenanceStartHour", maintenanceStartHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceDay":
            return Optional.ofNullable(clazz.cast(maintenanceDayAsString()));
        case "MaintenanceDeadline":
            return Optional.ofNullable(clazz.cast(maintenanceDeadline()));
        case "MaintenanceScheduledDate":
            return Optional.ofNullable(clazz.cast(maintenanceScheduledDate()));
        case "MaintenanceStartHour":
            return Optional.ofNullable(clazz.cast(maintenanceStartHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maintenanceDay", MAINTENANCE_DAY_FIELD);
        map.put("maintenanceDeadline", MAINTENANCE_DEADLINE_FIELD);
        map.put("maintenanceScheduledDate", MAINTENANCE_SCHEDULED_DATE_FIELD);
        map.put("maintenanceStartHour", MAINTENANCE_START_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Maintenance, T> g) {
        return obj -> g.apply((Maintenance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Maintenance> {
        /**
         * A day of a week when the maintenance will happen. Use
         * Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * 
         * @param maintenanceDay
         *        A day of a week when the maintenance will happen. Use
         *        Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * @see MaintenanceDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceDay
         */
        Builder maintenanceDay(String maintenanceDay);

        /**
         * A day of a week when the maintenance will happen. Use
         * Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * 
         * @param maintenanceDay
         *        A day of a week when the maintenance will happen. Use
         *        Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
         * @see MaintenanceDay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceDay
         */
        Builder maintenanceDay(MaintenanceDay maintenanceDay);

        /**
         * The Maintenance has to be performed before this deadline in ISO UTC format. Example: 2021-01-30T08:30:00Z.
         * 
         * @param maintenanceDeadline
         *        The Maintenance has to be performed before this deadline in ISO UTC format. Example:
         *        2021-01-30T08:30:00Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceDeadline(String maintenanceDeadline);

        /**
         * A scheduled date in ISO UTC format when the maintenance will happen. Use YYYY-MM-DD format. Example:
         * 2021-01-30.
         * 
         * @param maintenanceScheduledDate
         *        A scheduled date in ISO UTC format when the maintenance will happen. Use YYYY-MM-DD format. Example:
         *        2021-01-30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceScheduledDate(String maintenanceScheduledDate);

        /**
         * UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The
         * default value is 02:00.
         * 
         * @param maintenanceStartHour
         *        UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example:
         *        13:00. The default value is 02:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceStartHour(String maintenanceStartHour);
    }

    static final class BuilderImpl implements Builder {
        private String maintenanceDay;

        private String maintenanceDeadline;

        private String maintenanceScheduledDate;

        private String maintenanceStartHour;

        private BuilderImpl() {
        }

        private BuilderImpl(Maintenance model) {
            maintenanceDay(model.maintenanceDay);
            maintenanceDeadline(model.maintenanceDeadline);
            maintenanceScheduledDate(model.maintenanceScheduledDate);
            maintenanceStartHour(model.maintenanceStartHour);
        }

        public final String getMaintenanceDay() {
            return maintenanceDay;
        }

        public final void setMaintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
        }

        @Override
        public final Builder maintenanceDay(String maintenanceDay) {
            this.maintenanceDay = maintenanceDay;
            return this;
        }

        @Override
        public final Builder maintenanceDay(MaintenanceDay maintenanceDay) {
            this.maintenanceDay(maintenanceDay == null ? null : maintenanceDay.toString());
            return this;
        }

        public final String getMaintenanceDeadline() {
            return maintenanceDeadline;
        }

        public final void setMaintenanceDeadline(String maintenanceDeadline) {
            this.maintenanceDeadline = maintenanceDeadline;
        }

        @Override
        public final Builder maintenanceDeadline(String maintenanceDeadline) {
            this.maintenanceDeadline = maintenanceDeadline;
            return this;
        }

        public final String getMaintenanceScheduledDate() {
            return maintenanceScheduledDate;
        }

        public final void setMaintenanceScheduledDate(String maintenanceScheduledDate) {
            this.maintenanceScheduledDate = maintenanceScheduledDate;
        }

        @Override
        public final Builder maintenanceScheduledDate(String maintenanceScheduledDate) {
            this.maintenanceScheduledDate = maintenanceScheduledDate;
            return this;
        }

        public final String getMaintenanceStartHour() {
            return maintenanceStartHour;
        }

        public final void setMaintenanceStartHour(String maintenanceStartHour) {
            this.maintenanceStartHour = maintenanceStartHour;
        }

        @Override
        public final Builder maintenanceStartHour(String maintenanceStartHour) {
            this.maintenanceStartHour = maintenanceStartHour;
            return this;
        }

        @Override
        public Maintenance build() {
            return new Maintenance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
