/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for source monitoring.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringConfig.Builder, MonitoringConfig> {
    private static final SdkField<String> THUMBNAIL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThumbnailState").getter(getter(MonitoringConfig::thumbnailStateAsString))
            .setter(setter(Builder::thumbnailState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailState").build()).build();

    private static final SdkField<List<AudioMonitoringSetting>> AUDIO_MONITORING_SETTINGS_FIELD = SdkField
            .<List<AudioMonitoringSetting>> builder(MarshallingType.LIST)
            .memberName("AudioMonitoringSettings")
            .getter(getter(MonitoringConfig::audioMonitoringSettings))
            .setter(setter(Builder::audioMonitoringSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioMonitoringSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioMonitoringSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioMonitoringSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTENT_QUALITY_ANALYSIS_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentQualityAnalysisState")
            .getter(getter(MonitoringConfig::contentQualityAnalysisStateAsString))
            .setter(setter(Builder::contentQualityAnalysisState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentQualityAnalysisState")
                    .build()).build();

    private static final SdkField<List<VideoMonitoringSetting>> VIDEO_MONITORING_SETTINGS_FIELD = SdkField
            .<List<VideoMonitoringSetting>> builder(MarshallingType.LIST)
            .memberName("VideoMonitoringSettings")
            .getter(getter(MonitoringConfig::videoMonitoringSettings))
            .setter(setter(Builder::videoMonitoringSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoMonitoringSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VideoMonitoringSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(VideoMonitoringSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THUMBNAIL_STATE_FIELD,
            AUDIO_MONITORING_SETTINGS_FIELD, CONTENT_QUALITY_ANALYSIS_STATE_FIELD, VIDEO_MONITORING_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String thumbnailState;

    private final List<AudioMonitoringSetting> audioMonitoringSettings;

    private final String contentQualityAnalysisState;

    private final List<VideoMonitoringSetting> videoMonitoringSettings;

    private MonitoringConfig(BuilderImpl builder) {
        this.thumbnailState = builder.thumbnailState;
        this.audioMonitoringSettings = builder.audioMonitoringSettings;
        this.contentQualityAnalysisState = builder.contentQualityAnalysisState;
        this.videoMonitoringSettings = builder.videoMonitoringSettings;
    }

    /**
     * The state of thumbnail monitoring.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thumbnailState}
     * will return {@link ThumbnailState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thumbnailStateAsString}.
     * </p>
     * 
     * @return The state of thumbnail monitoring.
     * @see ThumbnailState
     */
    public final ThumbnailState thumbnailState() {
        return ThumbnailState.fromValue(thumbnailState);
    }

    /**
     * The state of thumbnail monitoring.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thumbnailState}
     * will return {@link ThumbnailState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thumbnailStateAsString}.
     * </p>
     * 
     * @return The state of thumbnail monitoring.
     * @see ThumbnailState
     */
    public final String thumbnailStateAsString() {
        return thumbnailState;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioMonitoringSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAudioMonitoringSettings() {
        return audioMonitoringSettings != null && !(audioMonitoringSettings instanceof SdkAutoConstructList);
    }

    /**
     * Contains the settings for audio stream metrics monitoring.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioMonitoringSettings} method.
     * </p>
     * 
     * @return Contains the settings for audio stream metrics monitoring.
     */
    public final List<AudioMonitoringSetting> audioMonitoringSettings() {
        return audioMonitoringSettings;
    }

    /**
     * Indicates whether content quality analysis is enabled or disabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentQualityAnalysisState} will return {@link ContentQualityAnalysisState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #contentQualityAnalysisStateAsString}.
     * </p>
     * 
     * @return Indicates whether content quality analysis is enabled or disabled.
     * @see ContentQualityAnalysisState
     */
    public final ContentQualityAnalysisState contentQualityAnalysisState() {
        return ContentQualityAnalysisState.fromValue(contentQualityAnalysisState);
    }

    /**
     * Indicates whether content quality analysis is enabled or disabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentQualityAnalysisState} will return {@link ContentQualityAnalysisState#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #contentQualityAnalysisStateAsString}.
     * </p>
     * 
     * @return Indicates whether content quality analysis is enabled or disabled.
     * @see ContentQualityAnalysisState
     */
    public final String contentQualityAnalysisStateAsString() {
        return contentQualityAnalysisState;
    }

    /**
     * For responses, this returns true if the service returned a value for the VideoMonitoringSettings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVideoMonitoringSettings() {
        return videoMonitoringSettings != null && !(videoMonitoringSettings instanceof SdkAutoConstructList);
    }

    /**
     * Contains the settings for video stream metrics monitoring.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVideoMonitoringSettings} method.
     * </p>
     * 
     * @return Contains the settings for video stream metrics monitoring.
     */
    public final List<VideoMonitoringSetting> videoMonitoringSettings() {
        return videoMonitoringSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioMonitoringSettings() ? audioMonitoringSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contentQualityAnalysisStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVideoMonitoringSettings() ? videoMonitoringSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfig)) {
            return false;
        }
        MonitoringConfig other = (MonitoringConfig) obj;
        return Objects.equals(thumbnailStateAsString(), other.thumbnailStateAsString())
                && hasAudioMonitoringSettings() == other.hasAudioMonitoringSettings()
                && Objects.equals(audioMonitoringSettings(), other.audioMonitoringSettings())
                && Objects.equals(contentQualityAnalysisStateAsString(), other.contentQualityAnalysisStateAsString())
                && hasVideoMonitoringSettings() == other.hasVideoMonitoringSettings()
                && Objects.equals(videoMonitoringSettings(), other.videoMonitoringSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringConfig").add("ThumbnailState", thumbnailStateAsString())
                .add("AudioMonitoringSettings", hasAudioMonitoringSettings() ? audioMonitoringSettings() : null)
                .add("ContentQualityAnalysisState", contentQualityAnalysisStateAsString())
                .add("VideoMonitoringSettings", hasVideoMonitoringSettings() ? videoMonitoringSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThumbnailState":
            return Optional.ofNullable(clazz.cast(thumbnailStateAsString()));
        case "AudioMonitoringSettings":
            return Optional.ofNullable(clazz.cast(audioMonitoringSettings()));
        case "ContentQualityAnalysisState":
            return Optional.ofNullable(clazz.cast(contentQualityAnalysisStateAsString()));
        case "VideoMonitoringSettings":
            return Optional.ofNullable(clazz.cast(videoMonitoringSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thumbnailState", THUMBNAIL_STATE_FIELD);
        map.put("audioMonitoringSettings", AUDIO_MONITORING_SETTINGS_FIELD);
        map.put("contentQualityAnalysisState", CONTENT_QUALITY_ANALYSIS_STATE_FIELD);
        map.put("videoMonitoringSettings", VIDEO_MONITORING_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfig, T> g) {
        return obj -> g.apply((MonitoringConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringConfig> {
        /**
         * The state of thumbnail monitoring.
         * 
         * @param thumbnailState
         *        The state of thumbnail monitoring.
         * @see ThumbnailState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThumbnailState
         */
        Builder thumbnailState(String thumbnailState);

        /**
         * The state of thumbnail monitoring.
         * 
         * @param thumbnailState
         *        The state of thumbnail monitoring.
         * @see ThumbnailState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThumbnailState
         */
        Builder thumbnailState(ThumbnailState thumbnailState);

        /**
         * Contains the settings for audio stream metrics monitoring.
         * 
         * @param audioMonitoringSettings
         *        Contains the settings for audio stream metrics monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioMonitoringSettings(Collection<AudioMonitoringSetting> audioMonitoringSettings);

        /**
         * Contains the settings for audio stream metrics monitoring.
         * 
         * @param audioMonitoringSettings
         *        Contains the settings for audio stream metrics monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioMonitoringSettings(AudioMonitoringSetting... audioMonitoringSettings);

        /**
         * Contains the settings for audio stream metrics monitoring. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.mediaconnect.model.AudioMonitoringSetting.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.AudioMonitoringSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.AudioMonitoringSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #audioMonitoringSettings(List<AudioMonitoringSetting>)}.
         * 
         * @param audioMonitoringSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.AudioMonitoringSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioMonitoringSettings(java.util.Collection<AudioMonitoringSetting>)
         */
        Builder audioMonitoringSettings(Consumer<AudioMonitoringSetting.Builder>... audioMonitoringSettings);

        /**
         * Indicates whether content quality analysis is enabled or disabled.
         * 
         * @param contentQualityAnalysisState
         *        Indicates whether content quality analysis is enabled or disabled.
         * @see ContentQualityAnalysisState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentQualityAnalysisState
         */
        Builder contentQualityAnalysisState(String contentQualityAnalysisState);

        /**
         * Indicates whether content quality analysis is enabled or disabled.
         * 
         * @param contentQualityAnalysisState
         *        Indicates whether content quality analysis is enabled or disabled.
         * @see ContentQualityAnalysisState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentQualityAnalysisState
         */
        Builder contentQualityAnalysisState(ContentQualityAnalysisState contentQualityAnalysisState);

        /**
         * Contains the settings for video stream metrics monitoring.
         * 
         * @param videoMonitoringSettings
         *        Contains the settings for video stream metrics monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMonitoringSettings(Collection<VideoMonitoringSetting> videoMonitoringSettings);

        /**
         * Contains the settings for video stream metrics monitoring.
         * 
         * @param videoMonitoringSettings
         *        Contains the settings for video stream metrics monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoMonitoringSettings(VideoMonitoringSetting... videoMonitoringSettings);

        /**
         * Contains the settings for video stream metrics monitoring. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.mediaconnect.model.VideoMonitoringSetting.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconnect.model.VideoMonitoringSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.VideoMonitoringSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #videoMonitoringSettings(List<VideoMonitoringSetting>)}.
         * 
         * @param videoMonitoringSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.VideoMonitoringSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoMonitoringSettings(java.util.Collection<VideoMonitoringSetting>)
         */
        Builder videoMonitoringSettings(Consumer<VideoMonitoringSetting.Builder>... videoMonitoringSettings);
    }

    static final class BuilderImpl implements Builder {
        private String thumbnailState;

        private List<AudioMonitoringSetting> audioMonitoringSettings = DefaultSdkAutoConstructList.getInstance();

        private String contentQualityAnalysisState;

        private List<VideoMonitoringSetting> videoMonitoringSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfig model) {
            thumbnailState(model.thumbnailState);
            audioMonitoringSettings(model.audioMonitoringSettings);
            contentQualityAnalysisState(model.contentQualityAnalysisState);
            videoMonitoringSettings(model.videoMonitoringSettings);
        }

        public final String getThumbnailState() {
            return thumbnailState;
        }

        public final void setThumbnailState(String thumbnailState) {
            this.thumbnailState = thumbnailState;
        }

        @Override
        public final Builder thumbnailState(String thumbnailState) {
            this.thumbnailState = thumbnailState;
            return this;
        }

        @Override
        public final Builder thumbnailState(ThumbnailState thumbnailState) {
            this.thumbnailState(thumbnailState == null ? null : thumbnailState.toString());
            return this;
        }

        public final List<AudioMonitoringSetting.Builder> getAudioMonitoringSettings() {
            List<AudioMonitoringSetting.Builder> result = ___listOfAudioMonitoringSettingCopier
                    .copyToBuilder(this.audioMonitoringSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioMonitoringSettings(Collection<AudioMonitoringSetting.BuilderImpl> audioMonitoringSettings) {
            this.audioMonitoringSettings = ___listOfAudioMonitoringSettingCopier.copyFromBuilder(audioMonitoringSettings);
        }

        @Override
        public final Builder audioMonitoringSettings(Collection<AudioMonitoringSetting> audioMonitoringSettings) {
            this.audioMonitoringSettings = ___listOfAudioMonitoringSettingCopier.copy(audioMonitoringSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioMonitoringSettings(AudioMonitoringSetting... audioMonitoringSettings) {
            audioMonitoringSettings(Arrays.asList(audioMonitoringSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioMonitoringSettings(Consumer<AudioMonitoringSetting.Builder>... audioMonitoringSettings) {
            audioMonitoringSettings(Stream.of(audioMonitoringSettings)
                    .map(c -> AudioMonitoringSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getContentQualityAnalysisState() {
            return contentQualityAnalysisState;
        }

        public final void setContentQualityAnalysisState(String contentQualityAnalysisState) {
            this.contentQualityAnalysisState = contentQualityAnalysisState;
        }

        @Override
        public final Builder contentQualityAnalysisState(String contentQualityAnalysisState) {
            this.contentQualityAnalysisState = contentQualityAnalysisState;
            return this;
        }

        @Override
        public final Builder contentQualityAnalysisState(ContentQualityAnalysisState contentQualityAnalysisState) {
            this.contentQualityAnalysisState(contentQualityAnalysisState == null ? null : contentQualityAnalysisState.toString());
            return this;
        }

        public final List<VideoMonitoringSetting.Builder> getVideoMonitoringSettings() {
            List<VideoMonitoringSetting.Builder> result = ___listOfVideoMonitoringSettingCopier
                    .copyToBuilder(this.videoMonitoringSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVideoMonitoringSettings(Collection<VideoMonitoringSetting.BuilderImpl> videoMonitoringSettings) {
            this.videoMonitoringSettings = ___listOfVideoMonitoringSettingCopier.copyFromBuilder(videoMonitoringSettings);
        }

        @Override
        public final Builder videoMonitoringSettings(Collection<VideoMonitoringSetting> videoMonitoringSettings) {
            this.videoMonitoringSettings = ___listOfVideoMonitoringSettingCopier.copy(videoMonitoringSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoMonitoringSettings(VideoMonitoringSetting... videoMonitoringSettings) {
            videoMonitoringSettings(Arrays.asList(videoMonitoringSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoMonitoringSettings(Consumer<VideoMonitoringSetting.Builder>... videoMonitoringSettings) {
            videoMonitoringSettings(Stream.of(videoMonitoringSettings)
                    .map(c -> VideoMonitoringSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MonitoringConfig build() {
            return new MonitoringConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
