/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use
 * each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all
 * flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more
 * outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Reservation implements SdkPojo, Serializable, ToCopyableBuilder<Reservation.Builder, Reservation> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(Reservation::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(Reservation::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurationUnits").getter(getter(Reservation::durationUnitsAsString))
            .setter(setter(Builder::durationUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("End")
            .getter(getter(Reservation::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final SdkField<String> OFFERING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingArn").getter(getter(Reservation::offeringArn)).setter(setter(Builder::offeringArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringArn").build()).build();

    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingDescription").getter(getter(Reservation::offeringDescription))
            .setter(setter(Builder::offeringDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build())
            .build();

    private static final SdkField<String> PRICE_PER_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricePerUnit").getter(getter(Reservation::pricePerUnit)).setter(setter(Builder::pricePerUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricePerUnit").build()).build();

    private static final SdkField<String> PRICE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PriceUnits").getter(getter(Reservation::priceUnitsAsString)).setter(setter(Builder::priceUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priceUnits").build()).build();

    private static final SdkField<String> RESERVATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationArn").getter(getter(Reservation::reservationArn)).setter(setter(Builder::reservationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationArn").build()).build();

    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationName").getter(getter(Reservation::reservationName)).setter(setter(Builder::reservationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationName").build()).build();

    private static final SdkField<String> RESERVATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationState").getter(getter(Reservation::reservationStateAsString))
            .setter(setter(Builder::reservationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationState").build()).build();

    private static final SdkField<ResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField
            .<ResourceSpecification> builder(MarshallingType.SDK_POJO).memberName("ResourceSpecification")
            .getter(getter(Reservation::resourceSpecification)).setter(setter(Builder::resourceSpecification))
            .constructor(ResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build())
            .build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Start")
            .getter(getter(Reservation::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD,
            DURATION_FIELD, DURATION_UNITS_FIELD, END_FIELD, OFFERING_ARN_FIELD, OFFERING_DESCRIPTION_FIELD,
            PRICE_PER_UNIT_FIELD, PRICE_UNITS_FIELD, RESERVATION_ARN_FIELD, RESERVATION_NAME_FIELD, RESERVATION_STATE_FIELD,
            RESOURCE_SPECIFICATION_FIELD, START_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String currencyCode;

    private final Integer duration;

    private final String durationUnits;

    private final String end;

    private final String offeringArn;

    private final String offeringDescription;

    private final String pricePerUnit;

    private final String priceUnits;

    private final String reservationArn;

    private final String reservationName;

    private final String reservationState;

    private final ResourceSpecification resourceSpecification;

    private final String start;

    private Reservation(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.end = builder.end;
        this.offeringArn = builder.offeringArn;
        this.offeringDescription = builder.offeringDescription;
        this.pricePerUnit = builder.pricePerUnit;
        this.priceUnits = builder.priceUnits;
        this.reservationArn = builder.reservationArn;
        this.reservationName = builder.reservationName;
        this.reservationState = builder.reservationState;
        this.resourceSpecification = builder.resourceSpecification;
        this.start = builder.start;
    }

    /**
     * The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
     * 
     * @return The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * The length of time that this reservation is active. MediaConnect defines this value in the offering.
     * 
     * @return The length of time that this reservation is active. MediaConnect defines this value in the offering.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnits}
     * will return {@link DurationUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #durationUnitsAsString}.
     * </p>
     * 
     * @return The unit of measurement for the duration of the reservation. MediaConnect defines this value in the
     *         offering.
     * @see DurationUnits
     */
    public final DurationUnits durationUnits() {
        return DurationUnits.fromValue(durationUnits);
    }

    /**
     * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #durationUnits}
     * will return {@link DurationUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #durationUnitsAsString}.
     * </p>
     * 
     * @return The unit of measurement for the duration of the reservation. MediaConnect defines this value in the
     *         offering.
     * @see DurationUnits
     */
    public final String durationUnitsAsString() {
        return durationUnits;
    }

    /**
     * The day and time that this reservation expires. This value is calculated based on the start date and time that
     * you set and the offering's duration.
     * 
     * @return The day and time that this reservation expires. This value is calculated based on the start date and time
     *         that you set and the offering's duration.
     */
    public final String end() {
        return end;
    }

    /**
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
     * 
     * @return The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
     */
    public final String offeringArn() {
        return offeringArn;
    }

    /**
     * A description of the offering. MediaConnect defines this value in the offering.
     * 
     * @return A description of the offering. MediaConnect defines this value in the offering.
     */
    public final String offeringDescription() {
        return offeringDescription;
    }

    /**
     * The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines
     * this value in the offering.
     * 
     * @return The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect
     *         defines this value in the offering.
     */
    public final String pricePerUnit() {
        return pricePerUnit;
    }

    /**
     * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the
     * rate. MediaConnect defines this value in the offering.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceUnits} will
     * return {@link PriceUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceUnitsAsString}.
     * </p>
     * 
     * @return The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up
     *         the rate. MediaConnect defines this value in the offering.
     * @see PriceUnits
     */
    public final PriceUnits priceUnits() {
        return PriceUnits.fromValue(priceUnits);
    }

    /**
     * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the
     * rate. MediaConnect defines this value in the offering.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceUnits} will
     * return {@link PriceUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceUnitsAsString}.
     * </p>
     * 
     * @return The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up
     *         the rate. MediaConnect defines this value in the offering.
     * @see PriceUnits
     */
    public final String priceUnitsAsString() {
        return priceUnits;
    }

    /**
     * The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
     * 
     * @return The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an
     *         offering.
     */
    public final String reservationArn() {
        return reservationArn;
    }

    /**
     * The name that you assigned to the reservation when you purchased the offering.
     * 
     * @return The name that you assigned to the reservation when you purchased the offering.
     */
    public final String reservationName() {
        return reservationName;
    }

    /**
     * The status of your reservation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reservationState}
     * will return {@link ReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reservationStateAsString}.
     * </p>
     * 
     * @return The status of your reservation.
     * @see ReservationState
     */
    public final ReservationState reservationState() {
        return ReservationState.fromValue(reservationState);
    }

    /**
     * The status of your reservation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reservationState}
     * will return {@link ReservationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reservationStateAsString}.
     * </p>
     * 
     * @return The status of your reservation.
     * @see ReservationState
     */
    public final String reservationStateAsString() {
        return reservationState;
    }

    /**
     * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
     * MediaConnect defines the values that make up the resourceSpecification in the offering.
     * 
     * @return A definition of the amount of outbound bandwidth that you would be reserving if you purchase the
     *         offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
     */
    public final ResourceSpecification resourceSpecification() {
        return resourceSpecification;
    }

    /**
     * The day and time that the reservation becomes active. You set this value when you purchase the offering.
     * 
     * @return The day and time that the reservation becomes active. You set this value when you purchase the offering.
     */
    public final String start() {
        return start;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(offeringArn());
        hashCode = 31 * hashCode + Objects.hashCode(offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(pricePerUnit());
        hashCode = 31 * hashCode + Objects.hashCode(priceUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(reservationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation) obj;
        return Objects.equals(currencyCode(), other.currencyCode()) && Objects.equals(duration(), other.duration())
                && Objects.equals(durationUnitsAsString(), other.durationUnitsAsString()) && Objects.equals(end(), other.end())
                && Objects.equals(offeringArn(), other.offeringArn())
                && Objects.equals(offeringDescription(), other.offeringDescription())
                && Objects.equals(pricePerUnit(), other.pricePerUnit())
                && Objects.equals(priceUnitsAsString(), other.priceUnitsAsString())
                && Objects.equals(reservationArn(), other.reservationArn())
                && Objects.equals(reservationName(), other.reservationName())
                && Objects.equals(reservationStateAsString(), other.reservationStateAsString())
                && Objects.equals(resourceSpecification(), other.resourceSpecification())
                && Objects.equals(start(), other.start());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Reservation").add("CurrencyCode", currencyCode()).add("Duration", duration())
                .add("DurationUnits", durationUnitsAsString()).add("End", end()).add("OfferingArn", offeringArn())
                .add("OfferingDescription", offeringDescription()).add("PricePerUnit", pricePerUnit())
                .add("PriceUnits", priceUnitsAsString()).add("ReservationArn", reservationArn())
                .add("ReservationName", reservationName()).add("ReservationState", reservationStateAsString())
                .add("ResourceSpecification", resourceSpecification()).add("Start", start()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "DurationUnits":
            return Optional.ofNullable(clazz.cast(durationUnitsAsString()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        case "OfferingArn":
            return Optional.ofNullable(clazz.cast(offeringArn()));
        case "OfferingDescription":
            return Optional.ofNullable(clazz.cast(offeringDescription()));
        case "PricePerUnit":
            return Optional.ofNullable(clazz.cast(pricePerUnit()));
        case "PriceUnits":
            return Optional.ofNullable(clazz.cast(priceUnitsAsString()));
        case "ReservationArn":
            return Optional.ofNullable(clazz.cast(reservationArn()));
        case "ReservationName":
            return Optional.ofNullable(clazz.cast(reservationName()));
        case "ReservationState":
            return Optional.ofNullable(clazz.cast(reservationStateAsString()));
        case "ResourceSpecification":
            return Optional.ofNullable(clazz.cast(resourceSpecification()));
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("duration", DURATION_FIELD);
        map.put("durationUnits", DURATION_UNITS_FIELD);
        map.put("end", END_FIELD);
        map.put("offeringArn", OFFERING_ARN_FIELD);
        map.put("offeringDescription", OFFERING_DESCRIPTION_FIELD);
        map.put("pricePerUnit", PRICE_PER_UNIT_FIELD);
        map.put("priceUnits", PRICE_UNITS_FIELD);
        map.put("reservationArn", RESERVATION_ARN_FIELD);
        map.put("reservationName", RESERVATION_NAME_FIELD);
        map.put("reservationState", RESERVATION_STATE_FIELD);
        map.put("resourceSpecification", RESOURCE_SPECIFICATION_FIELD);
        map.put("start", START_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Reservation, T> g) {
        return obj -> g.apply((Reservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Reservation> {
        /**
         * The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
         * 
         * @param currencyCode
         *        The type of currency that is used for billing. The currencyCode used for your reservation is US
         *        dollars.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * The length of time that this reservation is active. MediaConnect defines this value in the offering.
         * 
         * @param duration
         *        The length of time that this reservation is active. MediaConnect defines this value in the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
         * 
         * @param durationUnits
         *        The unit of measurement for the duration of the reservation. MediaConnect defines this value in the
         *        offering.
         * @see DurationUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DurationUnits
         */
        Builder durationUnits(String durationUnits);

        /**
         * The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
         * 
         * @param durationUnits
         *        The unit of measurement for the duration of the reservation. MediaConnect defines this value in the
         *        offering.
         * @see DurationUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DurationUnits
         */
        Builder durationUnits(DurationUnits durationUnits);

        /**
         * The day and time that this reservation expires. This value is calculated based on the start date and time
         * that you set and the offering's duration.
         * 
         * @param end
         *        The day and time that this reservation expires. This value is calculated based on the start date and
         *        time that you set and the offering's duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         * 
         * @param offeringArn
         *        The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringArn(String offeringArn);

        /**
         * A description of the offering. MediaConnect defines this value in the offering.
         * 
         * @param offeringDescription
         *        A description of the offering. MediaConnect defines this value in the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringDescription(String offeringDescription);

        /**
         * The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect
         * defines this value in the offering.
         * 
         * @param pricePerUnit
         *        The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect
         *        defines this value in the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricePerUnit(String pricePerUnit);

        /**
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the
         * rate. MediaConnect defines this value in the offering.
         * 
         * @param priceUnits
         *        The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes
         *        up the rate. MediaConnect defines this value in the offering.
         * @see PriceUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceUnits
         */
        Builder priceUnits(String priceUnits);

        /**
         * The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the
         * rate. MediaConnect defines this value in the offering.
         * 
         * @param priceUnits
         *        The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes
         *        up the rate. MediaConnect defines this value in the offering.
         * @see PriceUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceUnits
         */
        Builder priceUnits(PriceUnits priceUnits);

        /**
         * The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
         * 
         * @param reservationArn
         *        The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationArn(String reservationArn);

        /**
         * The name that you assigned to the reservation when you purchased the offering.
         * 
         * @param reservationName
         *        The name that you assigned to the reservation when you purchased the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationName(String reservationName);

        /**
         * The status of your reservation.
         * 
         * @param reservationState
         *        The status of your reservation.
         * @see ReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationState
         */
        Builder reservationState(String reservationState);

        /**
         * The status of your reservation.
         * 
         * @param reservationState
         *        The status of your reservation.
         * @see ReservationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservationState
         */
        Builder reservationState(ReservationState reservationState);

        /**
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
         * MediaConnect defines the values that make up the resourceSpecification in the offering.
         * 
         * @param resourceSpecification
         *        A definition of the amount of outbound bandwidth that you would be reserving if you purchase the
         *        offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSpecification(ResourceSpecification resourceSpecification);

        /**
         * A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
         * MediaConnect defines the values that make up the resourceSpecification in the offering. This is a convenience
         * method that creates an instance of the {@link ResourceSpecification.Builder} avoiding the need to create one
         * manually via {@link ResourceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceSpecification(ResourceSpecification)}.
         * 
         * @param resourceSpecification
         *        a consumer that will call methods on {@link ResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSpecification(ResourceSpecification)
         */
        default Builder resourceSpecification(Consumer<ResourceSpecification.Builder> resourceSpecification) {
            return resourceSpecification(ResourceSpecification.builder().applyMutation(resourceSpecification).build());
        }

        /**
         * The day and time that the reservation becomes active. You set this value when you purchase the offering.
         * 
         * @param start
         *        The day and time that the reservation becomes active. You set this value when you purchase the
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);
    }

    static final class BuilderImpl implements Builder {
        private String currencyCode;

        private Integer duration;

        private String durationUnits;

        private String end;

        private String offeringArn;

        private String offeringDescription;

        private String pricePerUnit;

        private String priceUnits;

        private String reservationArn;

        private String reservationName;

        private String reservationState;

        private ResourceSpecification resourceSpecification;

        private String start;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            currencyCode(model.currencyCode);
            duration(model.duration);
            durationUnits(model.durationUnits);
            end(model.end);
            offeringArn(model.offeringArn);
            offeringDescription(model.offeringDescription);
            pricePerUnit(model.pricePerUnit);
            priceUnits(model.priceUnits);
            reservationArn(model.reservationArn);
            reservationName(model.reservationName);
            reservationState(model.reservationState);
            resourceSpecification(model.resourceSpecification);
            start(model.start);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getDurationUnits() {
            return durationUnits;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        @Override
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        public final Builder durationUnits(DurationUnits durationUnits) {
            this.durationUnits(durationUnits == null ? null : durationUnits.toString());
            return this;
        }

        public final String getEnd() {
            return end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final String getOfferingArn() {
            return offeringArn;
        }

        public final void setOfferingArn(String offeringArn) {
            this.offeringArn = offeringArn;
        }

        @Override
        public final Builder offeringArn(String offeringArn) {
            this.offeringArn = offeringArn;
            return this;
        }

        public final String getOfferingDescription() {
            return offeringDescription;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        @Override
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final String getPricePerUnit() {
            return pricePerUnit;
        }

        public final void setPricePerUnit(String pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
        }

        @Override
        public final Builder pricePerUnit(String pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
            return this;
        }

        public final String getPriceUnits() {
            return priceUnits;
        }

        public final void setPriceUnits(String priceUnits) {
            this.priceUnits = priceUnits;
        }

        @Override
        public final Builder priceUnits(String priceUnits) {
            this.priceUnits = priceUnits;
            return this;
        }

        @Override
        public final Builder priceUnits(PriceUnits priceUnits) {
            this.priceUnits(priceUnits == null ? null : priceUnits.toString());
            return this;
        }

        public final String getReservationArn() {
            return reservationArn;
        }

        public final void setReservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
        }

        @Override
        public final Builder reservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
            return this;
        }

        public final String getReservationName() {
            return reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final String getReservationState() {
            return reservationState;
        }

        public final void setReservationState(String reservationState) {
            this.reservationState = reservationState;
        }

        @Override
        public final Builder reservationState(String reservationState) {
            this.reservationState = reservationState;
            return this;
        }

        @Override
        public final Builder reservationState(ReservationState reservationState) {
            this.reservationState(reservationState == null ? null : reservationState.toString());
            return this;
        }

        public final ResourceSpecification.Builder getResourceSpecification() {
            return resourceSpecification != null ? resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        public final Builder resourceSpecification(ResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final String getStart() {
            return start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        @Override
        public Reservation build() {
            return new Reservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
