/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeFlowEntitlementResponse extends MediaConnectResponse implements
        ToCopyableBuilder<RevokeFlowEntitlementResponse.Builder, RevokeFlowEntitlementResponse> {
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementArn").getter(getter(RevokeFlowEntitlementResponse::entitlementArn))
            .setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(RevokeFlowEntitlementResponse::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENT_ARN_FIELD,
            FLOW_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String entitlementArn;

    private final String flowArn;

    private RevokeFlowEntitlementResponse(BuilderImpl builder) {
        super(builder);
        this.entitlementArn = builder.entitlementArn;
        this.flowArn = builder.flowArn;
    }

    /**
     * The ARN of the entitlement that was revoked.
     * 
     * @return The ARN of the entitlement that was revoked.
     */
    public final String entitlementArn() {
        return entitlementArn;
    }

    /**
     * The ARN of the flow that the entitlement was revoked from.
     * 
     * @return The ARN of the flow that the entitlement was revoked from.
     */
    public final String flowArn() {
        return flowArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeFlowEntitlementResponse)) {
            return false;
        }
        RevokeFlowEntitlementResponse other = (RevokeFlowEntitlementResponse) obj;
        return Objects.equals(entitlementArn(), other.entitlementArn()) && Objects.equals(flowArn(), other.flowArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeFlowEntitlementResponse").add("EntitlementArn", entitlementArn())
                .add("FlowArn", flowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("entitlementArn", ENTITLEMENT_ARN_FIELD);
        map.put("flowArn", FLOW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeFlowEntitlementResponse, T> g) {
        return obj -> g.apply((RevokeFlowEntitlementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RevokeFlowEntitlementResponse> {
        /**
         * The ARN of the entitlement that was revoked.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement that was revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * The ARN of the flow that the entitlement was revoked from.
         * 
         * @param flowArn
         *        The ARN of the flow that the entitlement was revoked from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String entitlementArn;

        private String flowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeFlowEntitlementResponse model) {
            super(model);
            entitlementArn(model.entitlementArn);
            flowArn(model.flowArn);
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        @Override
        public RevokeFlowEntitlementResponse build() {
            return new RevokeFlowEntitlementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
