/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Attributes related to the transport stream that are used in a source or output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Transport implements SdkPojo, Serializable, ToCopyableBuilder<Transport.Builder, Transport> {
    private static final SdkField<List<String>> CIDR_ALLOW_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CidrAllowList")
            .getter(getter(Transport::cidrAllowList))
            .setter(setter(Builder::cidrAllowList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrAllowList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(Transport::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLatency").getter(getter(Transport::maxLatency)).setter(setter(Builder::maxLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()).build();

    private static final SdkField<Integer> MAX_SYNC_BUFFER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSyncBuffer").getter(getter(Transport::maxSyncBuffer)).setter(setter(Builder::maxSyncBuffer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSyncBuffer").build()).build();

    private static final SdkField<Integer> MIN_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinLatency").getter(getter(Transport::minLatency)).setter(setter(Builder::minLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLatency").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(Transport::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> REMOTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoteId").getter(getter(Transport::remoteId)).setter(setter(Builder::remoteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteId").build()).build();

    private static final SdkField<Integer> SENDER_CONTROL_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SenderControlPort").getter(getter(Transport::senderControlPort))
            .setter(setter(Builder::senderControlPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderControlPort").build()).build();

    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SenderIpAddress").getter(getter(Transport::senderIpAddress)).setter(setter(Builder::senderIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderIpAddress").build()).build();

    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SmoothingLatency").getter(getter(Transport::smoothingLatency)).setter(setter(Builder::smoothingLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()).build();

    private static final SdkField<String> SOURCE_LISTENER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceListenerAddress").getter(getter(Transport::sourceListenerAddress))
            .setter(setter(Builder::sourceListenerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceListenerAddress").build())
            .build();

    private static final SdkField<Integer> SOURCE_LISTENER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourceListenerPort").getter(getter(Transport::sourceListenerPort))
            .setter(setter(Builder::sourceListenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceListenerPort").build())
            .build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(Transport::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_ALLOW_LIST_FIELD,
            MAX_BITRATE_FIELD, MAX_LATENCY_FIELD, MAX_SYNC_BUFFER_FIELD, MIN_LATENCY_FIELD, PROTOCOL_FIELD, REMOTE_ID_FIELD,
            SENDER_CONTROL_PORT_FIELD, SENDER_IP_ADDRESS_FIELD, SMOOTHING_LATENCY_FIELD, SOURCE_LISTENER_ADDRESS_FIELD,
            SOURCE_LISTENER_PORT_FIELD, STREAM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> cidrAllowList;

    private final Integer maxBitrate;

    private final Integer maxLatency;

    private final Integer maxSyncBuffer;

    private final Integer minLatency;

    private final String protocol;

    private final String remoteId;

    private final Integer senderControlPort;

    private final String senderIpAddress;

    private final Integer smoothingLatency;

    private final String sourceListenerAddress;

    private final Integer sourceListenerPort;

    private final String streamId;

    private Transport(BuilderImpl builder) {
        this.cidrAllowList = builder.cidrAllowList;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.maxSyncBuffer = builder.maxSyncBuffer;
        this.minLatency = builder.minLatency;
        this.protocol = builder.protocol;
        this.remoteId = builder.remoteId;
        this.senderControlPort = builder.senderControlPort;
        this.senderIpAddress = builder.senderIpAddress;
        this.smoothingLatency = builder.smoothingLatency;
        this.sourceListenerAddress = builder.sourceListenerAddress;
        this.sourceListenerPort = builder.sourceListenerPort;
        this.streamId = builder.streamId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CidrAllowList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCidrAllowList() {
        return cidrAllowList != null && !(cidrAllowList instanceof SdkAutoConstructList);
    }

    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
     * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCidrAllowList} method.
     * </p>
     * 
     * @return The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
     *         addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
     *         10.0.0.0/16.
     */
    public final List<String> cidrAllowList() {
        return cidrAllowList;
    }

    /**
     * The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based
     * streams.
     * 
     * @return The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and
     *         Fujitsu-based streams.
     */
    public final Integer maxLatency() {
        return maxLatency;
    }

    /**
     * The size of the buffer (in milliseconds) to use to sync incoming source data.
     * 
     * @return The size of the buffer (in milliseconds) to use to sync incoming source data.
     */
    public final Integer maxSyncBuffer() {
        return maxSyncBuffer;
    }

    /**
     * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that
     * you set on your MediaConnect source or output represents the minimal potential latency of that connection. The
     * latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s
     * minimum latency.
     * 
     * @return The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this
     *         value that you set on your MediaConnect source or output represents the minimal potential latency of that
     *         connection. The latency of the stream is set to the highest number between the sender’s minimum latency
     *         and the receiver’s minimum latency.
     */
    public final Integer minLatency() {
        return minLatency;
    }

    /**
     * The protocol that is used by the source or output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source or output.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The protocol that is used by the source or output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source or output.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * The remote ID for the Zixi-pull stream.
     * 
     * @return The remote ID for the Zixi-pull stream.
     */
    public final String remoteId() {
        return remoteId;
    }

    /**
     * The port that the flow uses to send outbound requests to initiate connection with the sender.
     * 
     * @return The port that the flow uses to send outbound requests to initiate connection with the sender.
     */
    public final Integer senderControlPort() {
        return senderControlPort;
    }

    /**
     * The IP address that the flow communicates with to initiate connection with the sender.
     * 
     * @return The IP address that the flow communicates with to initiate connection with the sender.
     */
    public final String senderIpAddress() {
        return senderIpAddress;
    }

    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    public final Integer smoothingLatency() {
        return smoothingLatency;
    }

    /**
     * Source IP or domain name for SRT-caller protocol.
     * 
     * @return Source IP or domain name for SRT-caller protocol.
     */
    public final String sourceListenerAddress() {
        return sourceListenerAddress;
    }

    /**
     * Source port for SRT-caller protocol.
     * 
     * @return Source port for SRT-caller protocol.
     */
    public final Integer sourceListenerPort() {
        return sourceListenerPort;
    }

    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT caller-based
     * streams.
     * 
     * @return The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT
     *         caller-based streams.
     */
    public final String streamId() {
        return streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCidrAllowList() ? cidrAllowList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(maxSyncBuffer());
        hashCode = 31 * hashCode + Objects.hashCode(minLatency());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remoteId());
        hashCode = 31 * hashCode + Objects.hashCode(senderControlPort());
        hashCode = 31 * hashCode + Objects.hashCode(senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(sourceListenerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(sourceListenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transport)) {
            return false;
        }
        Transport other = (Transport) obj;
        return hasCidrAllowList() == other.hasCidrAllowList() && Objects.equals(cidrAllowList(), other.cidrAllowList())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(maxLatency(), other.maxLatency())
                && Objects.equals(maxSyncBuffer(), other.maxSyncBuffer()) && Objects.equals(minLatency(), other.minLatency())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(remoteId(), other.remoteId())
                && Objects.equals(senderControlPort(), other.senderControlPort())
                && Objects.equals(senderIpAddress(), other.senderIpAddress())
                && Objects.equals(smoothingLatency(), other.smoothingLatency())
                && Objects.equals(sourceListenerAddress(), other.sourceListenerAddress())
                && Objects.equals(sourceListenerPort(), other.sourceListenerPort())
                && Objects.equals(streamId(), other.streamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Transport").add("CidrAllowList", hasCidrAllowList() ? cidrAllowList() : null)
                .add("MaxBitrate", maxBitrate()).add("MaxLatency", maxLatency()).add("MaxSyncBuffer", maxSyncBuffer())
                .add("MinLatency", minLatency()).add("Protocol", protocolAsString()).add("RemoteId", remoteId())
                .add("SenderControlPort", senderControlPort()).add("SenderIpAddress", senderIpAddress())
                .add("SmoothingLatency", smoothingLatency()).add("SourceListenerAddress", sourceListenerAddress())
                .add("SourceListenerPort", sourceListenerPort()).add("StreamId", streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrAllowList":
            return Optional.ofNullable(clazz.cast(cidrAllowList()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MaxLatency":
            return Optional.ofNullable(clazz.cast(maxLatency()));
        case "MaxSyncBuffer":
            return Optional.ofNullable(clazz.cast(maxSyncBuffer()));
        case "MinLatency":
            return Optional.ofNullable(clazz.cast(minLatency()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "RemoteId":
            return Optional.ofNullable(clazz.cast(remoteId()));
        case "SenderControlPort":
            return Optional.ofNullable(clazz.cast(senderControlPort()));
        case "SenderIpAddress":
            return Optional.ofNullable(clazz.cast(senderIpAddress()));
        case "SmoothingLatency":
            return Optional.ofNullable(clazz.cast(smoothingLatency()));
        case "SourceListenerAddress":
            return Optional.ofNullable(clazz.cast(sourceListenerAddress()));
        case "SourceListenerPort":
            return Optional.ofNullable(clazz.cast(sourceListenerPort()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cidrAllowList", CIDR_ALLOW_LIST_FIELD);
        map.put("maxBitrate", MAX_BITRATE_FIELD);
        map.put("maxLatency", MAX_LATENCY_FIELD);
        map.put("maxSyncBuffer", MAX_SYNC_BUFFER_FIELD);
        map.put("minLatency", MIN_LATENCY_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("remoteId", REMOTE_ID_FIELD);
        map.put("senderControlPort", SENDER_CONTROL_PORT_FIELD);
        map.put("senderIpAddress", SENDER_IP_ADDRESS_FIELD);
        map.put("smoothingLatency", SMOOTHING_LATENCY_FIELD);
        map.put("sourceListenerAddress", SOURCE_LISTENER_ADDRESS_FIELD);
        map.put("sourceListenerPort", SOURCE_LISTENER_PORT_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Transport, T> g) {
        return obj -> g.apply((Transport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Transport> {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(Collection<String> cidrAllowList);

        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(String... cidrAllowList);

        /**
         * The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.
         * 
         * @param maxBitrate
         *        The smoothing max bitrate (in bps) for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based
         * streams.
         * 
         * @param maxLatency
         *        The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and
         *        Fujitsu-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLatency(Integer maxLatency);

        /**
         * The size of the buffer (in milliseconds) to use to sync incoming source data.
         * 
         * @param maxSyncBuffer
         *        The size of the buffer (in milliseconds) to use to sync incoming source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSyncBuffer(Integer maxSyncBuffer);

        /**
         * The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value
         * that you set on your MediaConnect source or output represents the minimal potential latency of that
         * connection. The latency of the stream is set to the highest number between the sender’s minimum latency and
         * the receiver’s minimum latency.
         * 
         * @param minLatency
         *        The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this
         *        value that you set on your MediaConnect source or output represents the minimal potential latency of
         *        that connection. The latency of the stream is set to the highest number between the sender’s minimum
         *        latency and the receiver’s minimum latency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLatency(Integer minLatency);

        /**
         * The protocol that is used by the source or output.
         * 
         * @param protocol
         *        The protocol that is used by the source or output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The protocol that is used by the source or output.
         * 
         * @param protocol
         *        The protocol that is used by the source or output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The remote ID for the Zixi-pull stream.
         * 
         * @param remoteId
         *        The remote ID for the Zixi-pull stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteId(String remoteId);

        /**
         * The port that the flow uses to send outbound requests to initiate connection with the sender.
         * 
         * @param senderControlPort
         *        The port that the flow uses to send outbound requests to initiate connection with the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderControlPort(Integer senderControlPort);

        /**
         * The IP address that the flow communicates with to initiate connection with the sender.
         * 
         * @param senderIpAddress
         *        The IP address that the flow communicates with to initiate connection with the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderIpAddress(String senderIpAddress);

        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * 
         * @param smoothingLatency
         *        The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smoothingLatency(Integer smoothingLatency);

        /**
         * Source IP or domain name for SRT-caller protocol.
         * 
         * @param sourceListenerAddress
         *        Source IP or domain name for SRT-caller protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceListenerAddress(String sourceListenerAddress);

        /**
         * Source port for SRT-caller protocol.
         * 
         * @param sourceListenerPort
         *        Source port for SRT-caller protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceListenerPort(Integer sourceListenerPort);

        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT
         * caller-based streams.
         * 
         * @param streamId
         *        The stream ID that you want to use for this transport. This parameter applies only to Zixi and SRT
         *        caller-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cidrAllowList = DefaultSdkAutoConstructList.getInstance();

        private Integer maxBitrate;

        private Integer maxLatency;

        private Integer maxSyncBuffer;

        private Integer minLatency;

        private String protocol;

        private String remoteId;

        private Integer senderControlPort;

        private String senderIpAddress;

        private Integer smoothingLatency;

        private String sourceListenerAddress;

        private Integer sourceListenerPort;

        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(Transport model) {
            cidrAllowList(model.cidrAllowList);
            maxBitrate(model.maxBitrate);
            maxLatency(model.maxLatency);
            maxSyncBuffer(model.maxSyncBuffer);
            minLatency(model.minLatency);
            protocol(model.protocol);
            remoteId(model.remoteId);
            senderControlPort(model.senderControlPort);
            senderIpAddress(model.senderIpAddress);
            smoothingLatency(model.smoothingLatency);
            sourceListenerAddress(model.sourceListenerAddress);
            sourceListenerPort(model.sourceListenerPort);
            streamId(model.streamId);
        }

        public final Collection<String> getCidrAllowList() {
            if (cidrAllowList instanceof SdkAutoConstructList) {
                return null;
            }
            return cidrAllowList;
        }

        public final void setCidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
        }

        @Override
        public final Builder cidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowList(String... cidrAllowList) {
            cidrAllowList(Arrays.asList(cidrAllowList));
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMaxLatency() {
            return maxLatency;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final Integer getMaxSyncBuffer() {
            return maxSyncBuffer;
        }

        public final void setMaxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
        }

        @Override
        public final Builder maxSyncBuffer(Integer maxSyncBuffer) {
            this.maxSyncBuffer = maxSyncBuffer;
            return this;
        }

        public final Integer getMinLatency() {
            return minLatency;
        }

        public final void setMinLatency(Integer minLatency) {
            this.minLatency = minLatency;
        }

        @Override
        public final Builder minLatency(Integer minLatency) {
            this.minLatency = minLatency;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getRemoteId() {
            return remoteId;
        }

        public final void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        @Override
        public final Builder remoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public final Integer getSenderControlPort() {
            return senderControlPort;
        }

        public final void setSenderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
        }

        @Override
        public final Builder senderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
            return this;
        }

        public final String getSenderIpAddress() {
            return senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final Integer getSmoothingLatency() {
            return smoothingLatency;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final String getSourceListenerAddress() {
            return sourceListenerAddress;
        }

        public final void setSourceListenerAddress(String sourceListenerAddress) {
            this.sourceListenerAddress = sourceListenerAddress;
        }

        @Override
        public final Builder sourceListenerAddress(String sourceListenerAddress) {
            this.sourceListenerAddress = sourceListenerAddress;
            return this;
        }

        public final Integer getSourceListenerPort() {
            return sourceListenerPort;
        }

        public final void setSourceListenerPort(Integer sourceListenerPort) {
            this.sourceListenerPort = sourceListenerPort;
        }

        @Override
        public final Builder sourceListenerPort(Integer sourceListenerPort) {
            this.sourceListenerPort = sourceListenerPort;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public Transport build() {
            return new Transport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
