/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The metadata of an elementary transport stream.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransportStream implements SdkPojo, Serializable, ToCopyableBuilder<TransportStream.Builder, TransportStream> {
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Channels").getter(getter(TransportStream::channels)).setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()).build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Codec")
            .getter(getter(TransportStream::codec)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameRate").getter(getter(TransportStream::frameRate)).setter(setter(Builder::frameRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameRate").build()).build();

    private static final SdkField<FrameResolution> FRAME_RESOLUTION_FIELD = SdkField
            .<FrameResolution> builder(MarshallingType.SDK_POJO).memberName("FrameResolution")
            .getter(getter(TransportStream::frameResolution)).setter(setter(Builder::frameResolution))
            .constructor(FrameResolution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameResolution").build()).build();

    private static final SdkField<Integer> PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pid")
            .getter(getter(TransportStream::pid)).setter(setter(Builder::pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleRate").getter(getter(TransportStream::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final SdkField<Integer> SAMPLE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleSize").getter(getter(TransportStream::sampleSize)).setter(setter(Builder::sampleSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleSize").build()).build();

    private static final SdkField<String> STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamType").getter(getter(TransportStream::streamType)).setter(setter(Builder::streamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, CODEC_FIELD,
            FRAME_RATE_FIELD, FRAME_RESOLUTION_FIELD, PID_FIELD, SAMPLE_RATE_FIELD, SAMPLE_SIZE_FIELD, STREAM_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer channels;

    private final String codec;

    private final String frameRate;

    private final FrameResolution frameResolution;

    private final Integer pid;

    private final Integer sampleRate;

    private final Integer sampleSize;

    private final String streamType;

    private TransportStream(BuilderImpl builder) {
        this.channels = builder.channels;
        this.codec = builder.codec;
        this.frameRate = builder.frameRate;
        this.frameResolution = builder.frameResolution;
        this.pid = builder.pid;
        this.sampleRate = builder.sampleRate;
        this.sampleSize = builder.sampleSize;
        this.streamType = builder.streamType;
    }

    /**
     * The number of channels in the audio stream.
     * 
     * @return The number of channels in the audio stream.
     */
    public final Integer channels() {
        return channels;
    }

    /**
     * The codec used by the stream.
     * 
     * @return The codec used by the stream.
     */
    public final String codec() {
        return codec;
    }

    /**
     * The frame rate used by the video stream.
     * 
     * @return The frame rate used by the video stream.
     */
    public final String frameRate() {
        return frameRate;
    }

    /**
     * Returns the value of the FrameResolution property for this object.
     * 
     * @return The value of the FrameResolution property for this object.
     */
    public final FrameResolution frameResolution() {
        return frameResolution;
    }

    /**
     * The Packet ID (PID) as it is reported in the Program Map Table.
     * 
     * @return The Packet ID (PID) as it is reported in the Program Map Table.
     */
    public final Integer pid() {
        return pid;
    }

    /**
     * The sample rate used by the audio stream.
     * 
     * @return The sample rate used by the audio stream.
     */
    public final Integer sampleRate() {
        return sampleRate;
    }

    /**
     * The sample bit size used by the audio stream.
     * 
     * @return The sample bit size used by the audio stream.
     */
    public final Integer sampleSize() {
        return sampleSize;
    }

    /**
     * The Stream Type as it is reported in the Program Map Table.
     * 
     * @return The Stream Type as it is reported in the Program Map Table.
     */
    public final String streamType() {
        return streamType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channels());
        hashCode = 31 * hashCode + Objects.hashCode(codec());
        hashCode = 31 * hashCode + Objects.hashCode(frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(frameResolution());
        hashCode = 31 * hashCode + Objects.hashCode(pid());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(streamType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransportStream)) {
            return false;
        }
        TransportStream other = (TransportStream) obj;
        return Objects.equals(channels(), other.channels()) && Objects.equals(codec(), other.codec())
                && Objects.equals(frameRate(), other.frameRate()) && Objects.equals(frameResolution(), other.frameResolution())
                && Objects.equals(pid(), other.pid()) && Objects.equals(sampleRate(), other.sampleRate())
                && Objects.equals(sampleSize(), other.sampleSize()) && Objects.equals(streamType(), other.streamType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransportStream").add("Channels", channels()).add("Codec", codec())
                .add("FrameRate", frameRate()).add("FrameResolution", frameResolution()).add("Pid", pid())
                .add("SampleRate", sampleRate()).add("SampleSize", sampleSize()).add("StreamType", streamType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "Codec":
            return Optional.ofNullable(clazz.cast(codec()));
        case "FrameRate":
            return Optional.ofNullable(clazz.cast(frameRate()));
        case "FrameResolution":
            return Optional.ofNullable(clazz.cast(frameResolution()));
        case "Pid":
            return Optional.ofNullable(clazz.cast(pid()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "SampleSize":
            return Optional.ofNullable(clazz.cast(sampleSize()));
        case "StreamType":
            return Optional.ofNullable(clazz.cast(streamType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channels", CHANNELS_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("frameRate", FRAME_RATE_FIELD);
        map.put("frameResolution", FRAME_RESOLUTION_FIELD);
        map.put("pid", PID_FIELD);
        map.put("sampleRate", SAMPLE_RATE_FIELD);
        map.put("sampleSize", SAMPLE_SIZE_FIELD);
        map.put("streamType", STREAM_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransportStream, T> g) {
        return obj -> g.apply((TransportStream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransportStream> {
        /**
         * The number of channels in the audio stream.
         * 
         * @param channels
         *        The number of channels in the audio stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Integer channels);

        /**
         * The codec used by the stream.
         * 
         * @param codec
         *        The codec used by the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codec(String codec);

        /**
         * The frame rate used by the video stream.
         * 
         * @param frameRate
         *        The frame rate used by the video stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameRate(String frameRate);

        /**
         * Sets the value of the FrameResolution property for this object.
         *
         * @param frameResolution
         *        The new value for the FrameResolution property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameResolution(FrameResolution frameResolution);

        /**
         * Sets the value of the FrameResolution property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FrameResolution.Builder} avoiding the
         * need to create one manually via {@link FrameResolution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FrameResolution.Builder#build()} is called immediately and its
         * result is passed to {@link #frameResolution(FrameResolution)}.
         * 
         * @param frameResolution
         *        a consumer that will call methods on {@link FrameResolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameResolution(FrameResolution)
         */
        default Builder frameResolution(Consumer<FrameResolution.Builder> frameResolution) {
            return frameResolution(FrameResolution.builder().applyMutation(frameResolution).build());
        }

        /**
         * The Packet ID (PID) as it is reported in the Program Map Table.
         * 
         * @param pid
         *        The Packet ID (PID) as it is reported in the Program Map Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pid(Integer pid);

        /**
         * The sample rate used by the audio stream.
         * 
         * @param sampleRate
         *        The sample rate used by the audio stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);

        /**
         * The sample bit size used by the audio stream.
         * 
         * @param sampleSize
         *        The sample bit size used by the audio stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleSize(Integer sampleSize);

        /**
         * The Stream Type as it is reported in the Program Map Table.
         * 
         * @param streamType
         *        The Stream Type as it is reported in the Program Map Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamType(String streamType);
    }

    static final class BuilderImpl implements Builder {
        private Integer channels;

        private String codec;

        private String frameRate;

        private FrameResolution frameResolution;

        private Integer pid;

        private Integer sampleRate;

        private Integer sampleSize;

        private String streamType;

        private BuilderImpl() {
        }

        private BuilderImpl(TransportStream model) {
            channels(model.channels);
            codec(model.codec);
            frameRate(model.frameRate);
            frameResolution(model.frameResolution);
            pid(model.pid);
            sampleRate(model.sampleRate);
            sampleSize(model.sampleSize);
            streamType(model.streamType);
        }

        public final Integer getChannels() {
            return channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final String getCodec() {
            return codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final String getFrameRate() {
            return frameRate;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final FrameResolution.Builder getFrameResolution() {
            return frameResolution != null ? frameResolution.toBuilder() : null;
        }

        public final void setFrameResolution(FrameResolution.BuilderImpl frameResolution) {
            this.frameResolution = frameResolution != null ? frameResolution.build() : null;
        }

        @Override
        public final Builder frameResolution(FrameResolution frameResolution) {
            this.frameResolution = frameResolution;
            return this;
        }

        public final Integer getPid() {
            return pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Integer getSampleSize() {
            return sampleSize;
        }

        public final void setSampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getStreamType() {
            return streamType;
        }

        public final void setStreamType(String streamType) {
            this.streamType = streamType;
        }

        @Override
        public final Builder streamType(String streamType) {
            this.streamType = streamType;
            return this;
        }

        @Override
        public TransportStream build() {
            return new TransportStream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
