/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The metadata of a single transport stream program.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransportStreamProgram implements SdkPojo, Serializable,
        ToCopyableBuilder<TransportStreamProgram.Builder, TransportStreamProgram> {
    private static final SdkField<Integer> PCR_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PcrPid").getter(getter(TransportStreamProgram::pcrPid)).setter(setter(Builder::pcrPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPid").build()).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(TransportStreamProgram::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()).build();

    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramNumber").getter(getter(TransportStreamProgram::programNumber))
            .setter(setter(Builder::programNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()).build();

    private static final SdkField<Integer> PROGRAM_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramPid").getter(getter(TransportStreamProgram::programPid)).setter(setter(Builder::programPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programPid").build()).build();

    private static final SdkField<List<TransportStream>> STREAMS_FIELD = SdkField
            .<List<TransportStream>> builder(MarshallingType.LIST)
            .memberName("Streams")
            .getter(getter(TransportStreamProgram::streams))
            .setter(setter(Builder::streams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransportStream> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransportStream::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PCR_PID_FIELD,
            PROGRAM_NAME_FIELD, PROGRAM_NUMBER_FIELD, PROGRAM_PID_FIELD, STREAMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer pcrPid;

    private final String programName;

    private final Integer programNumber;

    private final Integer programPid;

    private final List<TransportStream> streams;

    private TransportStreamProgram(BuilderImpl builder) {
        this.pcrPid = builder.pcrPid;
        this.programName = builder.programName;
        this.programNumber = builder.programNumber;
        this.programPid = builder.programPid;
        this.streams = builder.streams;
    }

    /**
     * The Program Clock Reference (PCR) Packet ID (PID) as it is reported in the Program Association Table.
     * 
     * @return The Program Clock Reference (PCR) Packet ID (PID) as it is reported in the Program Association Table.
     */
    public final Integer pcrPid() {
        return pcrPid;
    }

    /**
     * The program name as it is reported in the Program Association Table.
     * 
     * @return The program name as it is reported in the Program Association Table.
     */
    public final String programName() {
        return programName;
    }

    /**
     * The program number as it is reported in the Program Association Table.
     * 
     * @return The program number as it is reported in the Program Association Table.
     */
    public final Integer programNumber() {
        return programNumber;
    }

    /**
     * The program Packet ID (PID) as it is reported in the Program Association Table.
     * 
     * @return The program Packet ID (PID) as it is reported in the Program Association Table.
     */
    public final Integer programPid() {
        return programPid;
    }

    /**
     * For responses, this returns true if the service returned a value for the Streams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStreams() {
        return streams != null && !(streams instanceof SdkAutoConstructList);
    }

    /**
     * The list of elementary transport streams in the program. The list includes video, audio, and data streams.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreams} method.
     * </p>
     * 
     * @return The list of elementary transport streams in the program. The list includes video, audio, and data
     *         streams.
     */
    public final List<TransportStream> streams() {
        return streams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        hashCode = 31 * hashCode + Objects.hashCode(programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(programPid());
        hashCode = 31 * hashCode + Objects.hashCode(hasStreams() ? streams() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransportStreamProgram)) {
            return false;
        }
        TransportStreamProgram other = (TransportStreamProgram) obj;
        return Objects.equals(pcrPid(), other.pcrPid()) && Objects.equals(programName(), other.programName())
                && Objects.equals(programNumber(), other.programNumber()) && Objects.equals(programPid(), other.programPid())
                && hasStreams() == other.hasStreams() && Objects.equals(streams(), other.streams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransportStreamProgram").add("PcrPid", pcrPid()).add("ProgramName", programName())
                .add("ProgramNumber", programNumber()).add("ProgramPid", programPid())
                .add("Streams", hasStreams() ? streams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PcrPid":
            return Optional.ofNullable(clazz.cast(pcrPid()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        case "ProgramNumber":
            return Optional.ofNullable(clazz.cast(programNumber()));
        case "ProgramPid":
            return Optional.ofNullable(clazz.cast(programPid()));
        case "Streams":
            return Optional.ofNullable(clazz.cast(streams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pcrPid", PCR_PID_FIELD);
        map.put("programName", PROGRAM_NAME_FIELD);
        map.put("programNumber", PROGRAM_NUMBER_FIELD);
        map.put("programPid", PROGRAM_PID_FIELD);
        map.put("streams", STREAMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransportStreamProgram, T> g) {
        return obj -> g.apply((TransportStreamProgram) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransportStreamProgram> {
        /**
         * The Program Clock Reference (PCR) Packet ID (PID) as it is reported in the Program Association Table.
         * 
         * @param pcrPid
         *        The Program Clock Reference (PCR) Packet ID (PID) as it is reported in the Program Association Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcrPid(Integer pcrPid);

        /**
         * The program name as it is reported in the Program Association Table.
         * 
         * @param programName
         *        The program name as it is reported in the Program Association Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        /**
         * The program number as it is reported in the Program Association Table.
         * 
         * @param programNumber
         *        The program number as it is reported in the Program Association Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programNumber(Integer programNumber);

        /**
         * The program Packet ID (PID) as it is reported in the Program Association Table.
         * 
         * @param programPid
         *        The program Packet ID (PID) as it is reported in the Program Association Table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programPid(Integer programPid);

        /**
         * The list of elementary transport streams in the program. The list includes video, audio, and data streams.
         * 
         * @param streams
         *        The list of elementary transport streams in the program. The list includes video, audio, and data
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Collection<TransportStream> streams);

        /**
         * The list of elementary transport streams in the program. The list includes video, audio, and data streams.
         * 
         * @param streams
         *        The list of elementary transport streams in the program. The list includes video, audio, and data
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(TransportStream... streams);

        /**
         * The list of elementary transport streams in the program. The list includes video, audio, and data streams.
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconnect.model.TransportStream.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediaconnect.model.TransportStream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconnect.model.TransportStream.Builder#build()} is called
         * immediately and its result is passed to {@link #streams(List<TransportStream>)}.
         * 
         * @param streams
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconnect.model.TransportStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(java.util.Collection<TransportStream>)
         */
        Builder streams(Consumer<TransportStream.Builder>... streams);
    }

    static final class BuilderImpl implements Builder {
        private Integer pcrPid;

        private String programName;

        private Integer programNumber;

        private Integer programPid;

        private List<TransportStream> streams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransportStreamProgram model) {
            pcrPid(model.pcrPid);
            programName(model.programName);
            programNumber(model.programNumber);
            programPid(model.programPid);
            streams(model.streams);
        }

        public final Integer getPcrPid() {
            return pcrPid;
        }

        public final void setPcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
        }

        @Override
        public final Builder pcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final String getProgramName() {
            return programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final Integer getProgramNumber() {
            return programNumber;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final Integer getProgramPid() {
            return programPid;
        }

        public final void setProgramPid(Integer programPid) {
            this.programPid = programPid;
        }

        @Override
        public final Builder programPid(Integer programPid) {
            this.programPid = programPid;
            return this;
        }

        public final List<TransportStream.Builder> getStreams() {
            List<TransportStream.Builder> result = ___listOfTransportStreamCopier.copyToBuilder(this.streams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreams(Collection<TransportStream.BuilderImpl> streams) {
            this.streams = ___listOfTransportStreamCopier.copyFromBuilder(streams);
        }

        @Override
        public final Builder streams(Collection<TransportStream> streams) {
            this.streams = ___listOfTransportStreamCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(TransportStream... streams) {
            streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<TransportStream.Builder>... streams) {
            streams(Stream.of(streams).map(c -> TransportStream.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransportStreamProgram build() {
            return new TransportStreamProgram(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
