/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Update the flow source of the bridge.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBridgeFlowSourceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateBridgeFlowSourceRequest.Builder, UpdateBridgeFlowSourceRequest> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateBridgeFlowSourceRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<VpcInterfaceAttachment> FLOW_VPC_INTERFACE_ATTACHMENT_FIELD = SdkField
            .<VpcInterfaceAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("FlowVpcInterfaceAttachment")
            .getter(getter(UpdateBridgeFlowSourceRequest::flowVpcInterfaceAttachment))
            .setter(setter(Builder::flowVpcInterfaceAttachment))
            .constructor(VpcInterfaceAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVpcInterfaceAttachment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            FLOW_VPC_INTERFACE_ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final VpcInterfaceAttachment flowVpcInterfaceAttachment;

    private UpdateBridgeFlowSourceRequest(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowVpcInterfaceAttachment = builder.flowVpcInterfaceAttachment;
    }

    /**
     * The ARN of the cloud flow to use as a source of this bridge.
     * 
     * @return The ARN of the cloud flow to use as a source of this bridge.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The name of the VPC interface attachment to use for this source.
     * 
     * @return The name of the VPC interface attachment to use for this source.
     */
    public final VpcInterfaceAttachment flowVpcInterfaceAttachment() {
        return flowVpcInterfaceAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowVpcInterfaceAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeFlowSourceRequest)) {
            return false;
        }
        UpdateBridgeFlowSourceRequest other = (UpdateBridgeFlowSourceRequest) obj;
        return Objects.equals(flowArn(), other.flowArn())
                && Objects.equals(flowVpcInterfaceAttachment(), other.flowVpcInterfaceAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBridgeFlowSourceRequest").add("FlowArn", flowArn())
                .add("FlowVpcInterfaceAttachment", flowVpcInterfaceAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "FlowVpcInterfaceAttachment":
            return Optional.ofNullable(clazz.cast(flowVpcInterfaceAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("flowVpcInterfaceAttachment", FLOW_VPC_INTERFACE_ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeFlowSourceRequest, T> g) {
        return obj -> g.apply((UpdateBridgeFlowSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateBridgeFlowSourceRequest> {
        /**
         * The ARN of the cloud flow to use as a source of this bridge.
         * 
         * @param flowArn
         *        The ARN of the cloud flow to use as a source of this bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The name of the VPC interface attachment to use for this source.
         * 
         * @param flowVpcInterfaceAttachment
         *        The name of the VPC interface attachment to use for this source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowVpcInterfaceAttachment(VpcInterfaceAttachment flowVpcInterfaceAttachment);

        /**
         * The name of the VPC interface attachment to use for this source. This is a convenience method that creates an
         * instance of the {@link VpcInterfaceAttachment.Builder} avoiding the need to create one manually via
         * {@link VpcInterfaceAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcInterfaceAttachment.Builder#build()} is called immediately and
         * its result is passed to {@link #flowVpcInterfaceAttachment(VpcInterfaceAttachment)}.
         * 
         * @param flowVpcInterfaceAttachment
         *        a consumer that will call methods on {@link VpcInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flowVpcInterfaceAttachment(VpcInterfaceAttachment)
         */
        default Builder flowVpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> flowVpcInterfaceAttachment) {
            return flowVpcInterfaceAttachment(VpcInterfaceAttachment.builder().applyMutation(flowVpcInterfaceAttachment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private VpcInterfaceAttachment flowVpcInterfaceAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeFlowSourceRequest model) {
            flowArn(model.flowArn);
            flowVpcInterfaceAttachment(model.flowVpcInterfaceAttachment);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final VpcInterfaceAttachment.Builder getFlowVpcInterfaceAttachment() {
            return flowVpcInterfaceAttachment != null ? flowVpcInterfaceAttachment.toBuilder() : null;
        }

        public final void setFlowVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl flowVpcInterfaceAttachment) {
            this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment != null ? flowVpcInterfaceAttachment.build() : null;
        }

        @Override
        public final Builder flowVpcInterfaceAttachment(VpcInterfaceAttachment flowVpcInterfaceAttachment) {
            this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment;
            return this;
        }

        @Override
        public UpdateBridgeFlowSourceRequest build() {
            return new UpdateBridgeFlowSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
