/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The fields that you want to update in the bridge output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBridgeOutputRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateBridgeOutputRequest.Builder, UpdateBridgeOutputRequest> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeArn").getter(getter(UpdateBridgeOutputRequest::bridgeArn)).setter(setter(Builder::bridgeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("bridgeArn").build()).build();

    private static final SdkField<UpdateBridgeNetworkOutputRequest> NETWORK_OUTPUT_FIELD = SdkField
            .<UpdateBridgeNetworkOutputRequest> builder(MarshallingType.SDK_POJO).memberName("NetworkOutput")
            .getter(getter(UpdateBridgeOutputRequest::networkOutput)).setter(setter(Builder::networkOutput))
            .constructor(UpdateBridgeNetworkOutputRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkOutput").build()).build();

    private static final SdkField<String> OUTPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputName").getter(getter(UpdateBridgeOutputRequest::outputName)).setter(setter(Builder::outputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("outputName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD,
            NETWORK_OUTPUT_FIELD, OUTPUT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String bridgeArn;

    private final UpdateBridgeNetworkOutputRequest networkOutput;

    private final String outputName;

    private UpdateBridgeOutputRequest(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.networkOutput = builder.networkOutput;
        this.outputName = builder.outputName;
    }

    /**
     * The ARN of the bridge that you want to update.
     * 
     * @return The ARN of the bridge that you want to update.
     */
    public final String bridgeArn() {
        return bridgeArn;
    }

    /**
     * Returns the value of the NetworkOutput property for this object.
     * 
     * @return The value of the NetworkOutput property for this object.
     */
    public final UpdateBridgeNetworkOutputRequest networkOutput() {
        return networkOutput;
    }

    /**
     * The name of the bridge output that you want to update.
     * 
     * @return The name of the bridge output that you want to update.
     */
    public final String outputName() {
        return outputName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkOutput());
        hashCode = 31 * hashCode + Objects.hashCode(outputName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeOutputRequest)) {
            return false;
        }
        UpdateBridgeOutputRequest other = (UpdateBridgeOutputRequest) obj;
        return Objects.equals(bridgeArn(), other.bridgeArn()) && Objects.equals(networkOutput(), other.networkOutput())
                && Objects.equals(outputName(), other.outputName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBridgeOutputRequest").add("BridgeArn", bridgeArn()).add("NetworkOutput", networkOutput())
                .add("OutputName", outputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgeArn":
            return Optional.ofNullable(clazz.cast(bridgeArn()));
        case "NetworkOutput":
            return Optional.ofNullable(clazz.cast(networkOutput()));
        case "OutputName":
            return Optional.ofNullable(clazz.cast(outputName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("networkOutput", NETWORK_OUTPUT_FIELD);
        map.put("outputName", OUTPUT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeOutputRequest, T> g) {
        return obj -> g.apply((UpdateBridgeOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBridgeOutputRequest> {
        /**
         * The ARN of the bridge that you want to update.
         * 
         * @param bridgeArn
         *        The ARN of the bridge that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeArn(String bridgeArn);

        /**
         * Sets the value of the NetworkOutput property for this object.
         *
         * @param networkOutput
         *        The new value for the NetworkOutput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkOutput(UpdateBridgeNetworkOutputRequest networkOutput);

        /**
         * Sets the value of the NetworkOutput property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UpdateBridgeNetworkOutputRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateBridgeNetworkOutputRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateBridgeNetworkOutputRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #networkOutput(UpdateBridgeNetworkOutputRequest)}.
         * 
         * @param networkOutput
         *        a consumer that will call methods on {@link UpdateBridgeNetworkOutputRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkOutput(UpdateBridgeNetworkOutputRequest)
         */
        default Builder networkOutput(Consumer<UpdateBridgeNetworkOutputRequest.Builder> networkOutput) {
            return networkOutput(UpdateBridgeNetworkOutputRequest.builder().applyMutation(networkOutput).build());
        }

        /**
         * The name of the bridge output that you want to update.
         * 
         * @param outputName
         *        The name of the bridge output that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputName(String outputName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String bridgeArn;

        private UpdateBridgeNetworkOutputRequest networkOutput;

        private String outputName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeOutputRequest model) {
            super(model);
            bridgeArn(model.bridgeArn);
            networkOutput(model.networkOutput);
            outputName(model.outputName);
        }

        public final String getBridgeArn() {
            return bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final UpdateBridgeNetworkOutputRequest.Builder getNetworkOutput() {
            return networkOutput != null ? networkOutput.toBuilder() : null;
        }

        public final void setNetworkOutput(UpdateBridgeNetworkOutputRequest.BuilderImpl networkOutput) {
            this.networkOutput = networkOutput != null ? networkOutput.build() : null;
        }

        @Override
        public final Builder networkOutput(UpdateBridgeNetworkOutputRequest networkOutput) {
            this.networkOutput = networkOutput;
            return this;
        }

        public final String getOutputName() {
            return outputName;
        }

        public final void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        @Override
        public final Builder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBridgeOutputRequest build() {
            return new UpdateBridgeOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
