/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBridgeOutputResponse extends MediaConnectResponse implements
        ToCopyableBuilder<UpdateBridgeOutputResponse.Builder, UpdateBridgeOutputResponse> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeArn").getter(getter(UpdateBridgeOutputResponse::bridgeArn)).setter(setter(Builder::bridgeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()).build();

    private static final SdkField<BridgeOutput> OUTPUT_FIELD = SdkField.<BridgeOutput> builder(MarshallingType.SDK_POJO)
            .memberName("Output").getter(getter(UpdateBridgeOutputResponse::output)).setter(setter(Builder::output))
            .constructor(BridgeOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BRIDGE_ARN_FIELD, OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String bridgeArn;

    private final BridgeOutput output;

    private UpdateBridgeOutputResponse(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.output = builder.output;
    }

    /**
     * The Amazon Resource Number (ARN) of the bridge.
     * 
     * @return The Amazon Resource Number (ARN) of the bridge.
     */
    public final String bridgeArn() {
        return bridgeArn;
    }

    /**
     * The output that you updated.
     * 
     * @return The output that you updated.
     */
    public final BridgeOutput output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeOutputResponse)) {
            return false;
        }
        UpdateBridgeOutputResponse other = (UpdateBridgeOutputResponse) obj;
        return Objects.equals(bridgeArn(), other.bridgeArn()) && Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBridgeOutputResponse").add("BridgeArn", bridgeArn()).add("Output", output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgeArn":
            return Optional.ofNullable(clazz.cast(bridgeArn()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("output", OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeOutputResponse, T> g) {
        return obj -> g.apply((UpdateBridgeOutputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBridgeOutputResponse> {
        /**
         * The Amazon Resource Number (ARN) of the bridge.
         * 
         * @param bridgeArn
         *        The Amazon Resource Number (ARN) of the bridge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeArn(String bridgeArn);

        /**
         * The output that you updated.
         * 
         * @param output
         *        The output that you updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(BridgeOutput output);

        /**
         * The output that you updated. This is a convenience method that creates an instance of the
         * {@link BridgeOutput.Builder} avoiding the need to create one manually via {@link BridgeOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BridgeOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #output(BridgeOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link BridgeOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(BridgeOutput)
         */
        default Builder output(Consumer<BridgeOutput.Builder> output) {
            return output(BridgeOutput.builder().applyMutation(output).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String bridgeArn;

        private BridgeOutput output;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeOutputResponse model) {
            super(model);
            bridgeArn(model.bridgeArn);
            output(model.output);
        }

        public final String getBridgeArn() {
            return bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final BridgeOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(BridgeOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(BridgeOutput output) {
            this.output = output;
            return this;
        }

        @Override
        public UpdateBridgeOutputResponse build() {
            return new UpdateBridgeOutputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
