/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update the bridge.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBridgeRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateBridgeRequest.Builder, UpdateBridgeRequest> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgeArn").getter(getter(UpdateBridgeRequest::bridgeArn)).setter(setter(Builder::bridgeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("bridgeArn").build()).build();

    private static final SdkField<UpdateEgressGatewayBridgeRequest> EGRESS_GATEWAY_BRIDGE_FIELD = SdkField
            .<UpdateEgressGatewayBridgeRequest> builder(MarshallingType.SDK_POJO).memberName("EgressGatewayBridge")
            .getter(getter(UpdateBridgeRequest::egressGatewayBridge)).setter(setter(Builder::egressGatewayBridge))
            .constructor(UpdateEgressGatewayBridgeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressGatewayBridge").build())
            .build();

    private static final SdkField<UpdateIngressGatewayBridgeRequest> INGRESS_GATEWAY_BRIDGE_FIELD = SdkField
            .<UpdateIngressGatewayBridgeRequest> builder(MarshallingType.SDK_POJO).memberName("IngressGatewayBridge")
            .getter(getter(UpdateBridgeRequest::ingressGatewayBridge)).setter(setter(Builder::ingressGatewayBridge))
            .constructor(UpdateIngressGatewayBridgeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressGatewayBridge").build())
            .build();

    private static final SdkField<UpdateFailoverConfig> SOURCE_FAILOVER_CONFIG_FIELD = SdkField
            .<UpdateFailoverConfig> builder(MarshallingType.SDK_POJO).memberName("SourceFailoverConfig")
            .getter(getter(UpdateBridgeRequest::sourceFailoverConfig)).setter(setter(Builder::sourceFailoverConfig))
            .constructor(UpdateFailoverConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFailoverConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD,
            EGRESS_GATEWAY_BRIDGE_FIELD, INGRESS_GATEWAY_BRIDGE_FIELD, SOURCE_FAILOVER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String bridgeArn;

    private final UpdateEgressGatewayBridgeRequest egressGatewayBridge;

    private final UpdateIngressGatewayBridgeRequest ingressGatewayBridge;

    private final UpdateFailoverConfig sourceFailoverConfig;

    private UpdateBridgeRequest(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.egressGatewayBridge = builder.egressGatewayBridge;
        this.ingressGatewayBridge = builder.ingressGatewayBridge;
        this.sourceFailoverConfig = builder.sourceFailoverConfig;
    }

    /**
     * The Amazon Resource Number (ARN) of the bridge that you want to update.
     * 
     * @return The Amazon Resource Number (ARN) of the bridge that you want to update.
     */
    public final String bridgeArn() {
        return bridgeArn;
    }

    /**
     * Returns the value of the EgressGatewayBridge property for this object.
     * 
     * @return The value of the EgressGatewayBridge property for this object.
     */
    public final UpdateEgressGatewayBridgeRequest egressGatewayBridge() {
        return egressGatewayBridge;
    }

    /**
     * Returns the value of the IngressGatewayBridge property for this object.
     * 
     * @return The value of the IngressGatewayBridge property for this object.
     */
    public final UpdateIngressGatewayBridgeRequest ingressGatewayBridge() {
        return ingressGatewayBridge;
    }

    /**
     * Returns the value of the SourceFailoverConfig property for this object.
     * 
     * @return The value of the SourceFailoverConfig property for this object.
     */
    public final UpdateFailoverConfig sourceFailoverConfig() {
        return sourceFailoverConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(egressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(ingressGatewayBridge());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFailoverConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeRequest)) {
            return false;
        }
        UpdateBridgeRequest other = (UpdateBridgeRequest) obj;
        return Objects.equals(bridgeArn(), other.bridgeArn())
                && Objects.equals(egressGatewayBridge(), other.egressGatewayBridge())
                && Objects.equals(ingressGatewayBridge(), other.ingressGatewayBridge())
                && Objects.equals(sourceFailoverConfig(), other.sourceFailoverConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBridgeRequest").add("BridgeArn", bridgeArn())
                .add("EgressGatewayBridge", egressGatewayBridge()).add("IngressGatewayBridge", ingressGatewayBridge())
                .add("SourceFailoverConfig", sourceFailoverConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgeArn":
            return Optional.ofNullable(clazz.cast(bridgeArn()));
        case "EgressGatewayBridge":
            return Optional.ofNullable(clazz.cast(egressGatewayBridge()));
        case "IngressGatewayBridge":
            return Optional.ofNullable(clazz.cast(ingressGatewayBridge()));
        case "SourceFailoverConfig":
            return Optional.ofNullable(clazz.cast(sourceFailoverConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("egressGatewayBridge", EGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("ingressGatewayBridge", INGRESS_GATEWAY_BRIDGE_FIELD);
        map.put("sourceFailoverConfig", SOURCE_FAILOVER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeRequest, T> g) {
        return obj -> g.apply((UpdateBridgeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBridgeRequest> {
        /**
         * The Amazon Resource Number (ARN) of the bridge that you want to update.
         * 
         * @param bridgeArn
         *        The Amazon Resource Number (ARN) of the bridge that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bridgeArn(String bridgeArn);

        /**
         * Sets the value of the EgressGatewayBridge property for this object.
         *
         * @param egressGatewayBridge
         *        The new value for the EgressGatewayBridge property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressGatewayBridge(UpdateEgressGatewayBridgeRequest egressGatewayBridge);

        /**
         * Sets the value of the EgressGatewayBridge property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UpdateEgressGatewayBridgeRequest.Builder}
         * avoiding the need to create one manually via {@link UpdateEgressGatewayBridgeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateEgressGatewayBridgeRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #egressGatewayBridge(UpdateEgressGatewayBridgeRequest)}.
         * 
         * @param egressGatewayBridge
         *        a consumer that will call methods on {@link UpdateEgressGatewayBridgeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressGatewayBridge(UpdateEgressGatewayBridgeRequest)
         */
        default Builder egressGatewayBridge(Consumer<UpdateEgressGatewayBridgeRequest.Builder> egressGatewayBridge) {
            return egressGatewayBridge(UpdateEgressGatewayBridgeRequest.builder().applyMutation(egressGatewayBridge).build());
        }

        /**
         * Sets the value of the IngressGatewayBridge property for this object.
         *
         * @param ingressGatewayBridge
         *        The new value for the IngressGatewayBridge property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressGatewayBridge(UpdateIngressGatewayBridgeRequest ingressGatewayBridge);

        /**
         * Sets the value of the IngressGatewayBridge property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link UpdateIngressGatewayBridgeRequest.Builder} avoiding the need to create one manually via
         * {@link UpdateIngressGatewayBridgeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateIngressGatewayBridgeRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ingressGatewayBridge(UpdateIngressGatewayBridgeRequest)}.
         * 
         * @param ingressGatewayBridge
         *        a consumer that will call methods on {@link UpdateIngressGatewayBridgeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressGatewayBridge(UpdateIngressGatewayBridgeRequest)
         */
        default Builder ingressGatewayBridge(Consumer<UpdateIngressGatewayBridgeRequest.Builder> ingressGatewayBridge) {
            return ingressGatewayBridge(UpdateIngressGatewayBridgeRequest.builder().applyMutation(ingressGatewayBridge).build());
        }

        /**
         * Sets the value of the SourceFailoverConfig property for this object.
         *
         * @param sourceFailoverConfig
         *        The new value for the SourceFailoverConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFailoverConfig(UpdateFailoverConfig sourceFailoverConfig);

        /**
         * Sets the value of the SourceFailoverConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UpdateFailoverConfig.Builder} avoiding
         * the need to create one manually via {@link UpdateFailoverConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateFailoverConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceFailoverConfig(UpdateFailoverConfig)}.
         * 
         * @param sourceFailoverConfig
         *        a consumer that will call methods on {@link UpdateFailoverConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFailoverConfig(UpdateFailoverConfig)
         */
        default Builder sourceFailoverConfig(Consumer<UpdateFailoverConfig.Builder> sourceFailoverConfig) {
            return sourceFailoverConfig(UpdateFailoverConfig.builder().applyMutation(sourceFailoverConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String bridgeArn;

        private UpdateEgressGatewayBridgeRequest egressGatewayBridge;

        private UpdateIngressGatewayBridgeRequest ingressGatewayBridge;

        private UpdateFailoverConfig sourceFailoverConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeRequest model) {
            super(model);
            bridgeArn(model.bridgeArn);
            egressGatewayBridge(model.egressGatewayBridge);
            ingressGatewayBridge(model.ingressGatewayBridge);
            sourceFailoverConfig(model.sourceFailoverConfig);
        }

        public final String getBridgeArn() {
            return bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final UpdateEgressGatewayBridgeRequest.Builder getEgressGatewayBridge() {
            return egressGatewayBridge != null ? egressGatewayBridge.toBuilder() : null;
        }

        public final void setEgressGatewayBridge(UpdateEgressGatewayBridgeRequest.BuilderImpl egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge != null ? egressGatewayBridge.build() : null;
        }

        @Override
        public final Builder egressGatewayBridge(UpdateEgressGatewayBridgeRequest egressGatewayBridge) {
            this.egressGatewayBridge = egressGatewayBridge;
            return this;
        }

        public final UpdateIngressGatewayBridgeRequest.Builder getIngressGatewayBridge() {
            return ingressGatewayBridge != null ? ingressGatewayBridge.toBuilder() : null;
        }

        public final void setIngressGatewayBridge(UpdateIngressGatewayBridgeRequest.BuilderImpl ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge != null ? ingressGatewayBridge.build() : null;
        }

        @Override
        public final Builder ingressGatewayBridge(UpdateIngressGatewayBridgeRequest ingressGatewayBridge) {
            this.ingressGatewayBridge = ingressGatewayBridge;
            return this;
        }

        public final UpdateFailoverConfig.Builder getSourceFailoverConfig() {
            return sourceFailoverConfig != null ? sourceFailoverConfig.toBuilder() : null;
        }

        public final void setSourceFailoverConfig(UpdateFailoverConfig.BuilderImpl sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig != null ? sourceFailoverConfig.build() : null;
        }

        @Override
        public final Builder sourceFailoverConfig(UpdateFailoverConfig sourceFailoverConfig) {
            this.sourceFailoverConfig = sourceFailoverConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBridgeRequest build() {
            return new UpdateBridgeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
