/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The entitlement fields that you want to update.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowEntitlementRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateFlowEntitlementRequest.Builder, UpdateFlowEntitlementRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFlowEntitlementRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<UpdateEncryption> ENCRYPTION_FIELD = SdkField
            .<UpdateEncryption> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(UpdateFlowEntitlementRequest::encryption)).setter(setter(Builder::encryption))
            .constructor(UpdateEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementArn").getter(getter(UpdateFlowEntitlementRequest::entitlementArn))
            .setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entitlementArn").build()).build();

    private static final SdkField<String> ENTITLEMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementStatus").getter(getter(UpdateFlowEntitlementRequest::entitlementStatusAsString))
            .setter(setter(Builder::entitlementStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementStatus").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(UpdateFlowEntitlementRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<List<String>> SUBSCRIBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subscribers")
            .getter(getter(UpdateFlowEntitlementRequest::subscribers))
            .setter(setter(Builder::subscribers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ENCRYPTION_FIELD, ENTITLEMENT_ARN_FIELD, ENTITLEMENT_STATUS_FIELD, FLOW_ARN_FIELD, SUBSCRIBERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final UpdateEncryption encryption;

    private final String entitlementArn;

    private final String entitlementStatus;

    private final String flowArn;

    private final List<String> subscribers;

    private UpdateFlowEntitlementRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.encryption = builder.encryption;
        this.entitlementArn = builder.entitlementArn;
        this.entitlementStatus = builder.entitlementStatus;
        this.flowArn = builder.flowArn;
        this.subscribers = builder.subscribers;
    }

    /**
     * A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and
     * will not be seen by the subscriber or end user.
     * 
     * @return A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console
     *         and will not be seen by the subscriber or end user.
     */
    public final String description() {
        return description;
    }

    /**
     * The type of encryption that will be used on the output associated with this entitlement. Allowable encryption
     * types: static-key, speke.
     * 
     * @return The type of encryption that will be used on the output associated with this entitlement. Allowable
     *         encryption types: static-key, speke.
     */
    public final UpdateEncryption encryption() {
        return encryption;
    }

    /**
     * The ARN of the entitlement that you want to update.
     * 
     * @return The ARN of the entitlement that you want to update.
     */
    public final String entitlementArn() {
        return entitlementArn;
    }

    /**
     * An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming
     * content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request,
     * MediaConnect leaves the value unchanged.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entitlementStatus}
     * will return {@link EntitlementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entitlementStatusAsString}.
     * </p>
     * 
     * @return An indication of whether you want to enable the entitlement to allow access, or disable it to stop
     *         streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field
     *         in your request, MediaConnect leaves the value unchanged.
     * @see EntitlementStatus
     */
    public final EntitlementStatus entitlementStatus() {
        return EntitlementStatus.fromValue(entitlementStatus);
    }

    /**
     * An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming
     * content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request,
     * MediaConnect leaves the value unchanged.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entitlementStatus}
     * will return {@link EntitlementStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entitlementStatusAsString}.
     * </p>
     * 
     * @return An indication of whether you want to enable the entitlement to allow access, or disable it to stop
     *         streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field
     *         in your request, MediaConnect leaves the value unchanged.
     * @see EntitlementStatus
     */
    public final String entitlementStatusAsString() {
        return entitlementStatus;
    }

    /**
     * The flow that is associated with the entitlement that you want to update.
     * 
     * @return The flow that is associated with the entitlement that you want to update.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subscribers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribers() {
        return subscribers != null && !(subscribers instanceof SdkAutoConstructList);
    }

    /**
     * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
     * allowed to create their own flow using your content as the source.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribers} method.
     * </p>
     * 
     * @return The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will
     *         be allowed to create their own flow using your content as the source.
     */
    public final List<String> subscribers() {
        return subscribers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribers() ? subscribers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowEntitlementRequest)) {
            return false;
        }
        UpdateFlowEntitlementRequest other = (UpdateFlowEntitlementRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(encryption(), other.encryption())
                && Objects.equals(entitlementArn(), other.entitlementArn())
                && Objects.equals(entitlementStatusAsString(), other.entitlementStatusAsString())
                && Objects.equals(flowArn(), other.flowArn()) && hasSubscribers() == other.hasSubscribers()
                && Objects.equals(subscribers(), other.subscribers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowEntitlementRequest").add("Description", description()).add("Encryption", encryption())
                .add("EntitlementArn", entitlementArn()).add("EntitlementStatus", entitlementStatusAsString())
                .add("FlowArn", flowArn()).add("Subscribers", hasSubscribers() ? subscribers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "EntitlementStatus":
            return Optional.ofNullable(clazz.cast(entitlementStatusAsString()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "Subscribers":
            return Optional.ofNullable(clazz.cast(subscribers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryption", ENCRYPTION_FIELD);
        map.put("entitlementArn", ENTITLEMENT_ARN_FIELD);
        map.put("entitlementStatus", ENTITLEMENT_STATUS_FIELD);
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("subscribers", SUBSCRIBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowEntitlementRequest, T> g) {
        return obj -> g.apply((UpdateFlowEntitlementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowEntitlementRequest> {
        /**
         * A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and
         * will not be seen by the subscriber or end user.
         * 
         * @param description
         *        A description of the entitlement. This description appears only on the AWS Elemental MediaConnect
         *        console and will not be seen by the subscriber or end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The type of encryption that will be used on the output associated with this entitlement. Allowable encryption
         * types: static-key, speke.
         * 
         * @param encryption
         *        The type of encryption that will be used on the output associated with this entitlement. Allowable
         *        encryption types: static-key, speke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(UpdateEncryption encryption);

        /**
         * The type of encryption that will be used on the output associated with this entitlement. Allowable encryption
         * types: static-key, speke. This is a convenience method that creates an instance of the
         * {@link UpdateEncryption.Builder} avoiding the need to create one manually via
         * {@link UpdateEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(UpdateEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link UpdateEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(UpdateEncryption)
         */
        default Builder encryption(Consumer<UpdateEncryption.Builder> encryption) {
            return encryption(UpdateEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * The ARN of the entitlement that you want to update.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming
         * content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your
         * request, MediaConnect leaves the value unchanged.
         * 
         * @param entitlementStatus
         *        An indication of whether you want to enable the entitlement to allow access, or disable it to stop
         *        streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus
         *        field in your request, MediaConnect leaves the value unchanged.
         * @see EntitlementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementStatus
         */
        Builder entitlementStatus(String entitlementStatus);

        /**
         * An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming
         * content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your
         * request, MediaConnect leaves the value unchanged.
         * 
         * @param entitlementStatus
         *        An indication of whether you want to enable the entitlement to allow access, or disable it to stop
         *        streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus
         *        field in your request, MediaConnect leaves the value unchanged.
         * @see EntitlementStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementStatus
         */
        Builder entitlementStatus(EntitlementStatus entitlementStatus);

        /**
         * The flow that is associated with the entitlement that you want to update.
         * 
         * @param flowArn
         *        The flow that is associated with the entitlement that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
         * allowed to create their own flow using your content as the source.
         * 
         * @param subscribers
         *        The AWS account IDs that you want to share your content with. The receiving accounts (subscribers)
         *        will be allowed to create their own flow using your content as the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(Collection<String> subscribers);

        /**
         * The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be
         * allowed to create their own flow using your content as the source.
         * 
         * @param subscribers
         *        The AWS account IDs that you want to share your content with. The receiving accounts (subscribers)
         *        will be allowed to create their own flow using your content as the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribers(String... subscribers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private String description;

        private UpdateEncryption encryption;

        private String entitlementArn;

        private String entitlementStatus;

        private String flowArn;

        private List<String> subscribers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowEntitlementRequest model) {
            super(model);
            description(model.description);
            encryption(model.encryption);
            entitlementArn(model.entitlementArn);
            entitlementStatus(model.entitlementStatus);
            flowArn(model.flowArn);
            subscribers(model.subscribers);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final UpdateEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(UpdateEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(UpdateEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final String getEntitlementStatus() {
            return entitlementStatus;
        }

        public final void setEntitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
        }

        @Override
        public final Builder entitlementStatus(String entitlementStatus) {
            this.entitlementStatus = entitlementStatus;
            return this;
        }

        @Override
        public final Builder entitlementStatus(EntitlementStatus entitlementStatus) {
            this.entitlementStatus(entitlementStatus == null ? null : entitlementStatus.toString());
            return this;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final Collection<String> getSubscribers() {
            if (subscribers instanceof SdkAutoConstructList) {
                return null;
            }
            return subscribers;
        }

        public final void setSubscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
        }

        @Override
        public final Builder subscribers(Collection<String> subscribers) {
            this.subscribers = ___listOf__stringCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(String... subscribers) {
            subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowEntitlementRequest build() {
            return new UpdateFlowEntitlementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
