/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowResponse extends MediaConnectResponse implements
        ToCopyableBuilder<UpdateFlowResponse.Builder, UpdateFlowResponse> {
    private static final SdkField<Flow> FLOW_FIELD = SdkField.<Flow> builder(MarshallingType.SDK_POJO).memberName("Flow")
            .getter(getter(UpdateFlowResponse::flow)).setter(setter(Builder::flow)).constructor(Flow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Flow flow;

    private UpdateFlowResponse(BuilderImpl builder) {
        super(builder);
        this.flow = builder.flow;
    }

    /**
     * Returns the value of the Flow property for this object.
     * 
     * @return The value of the Flow property for this object.
     */
    public final Flow flow() {
        return flow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowResponse)) {
            return false;
        }
        UpdateFlowResponse other = (UpdateFlowResponse) obj;
        return Objects.equals(flow(), other.flow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFlowResponse").add("Flow", flow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Flow":
            return Optional.ofNullable(clazz.cast(flow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flow", FLOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowResponse, T> g) {
        return obj -> g.apply((UpdateFlowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowResponse> {
        /**
         * Sets the value of the Flow property for this object.
         *
         * @param flow
         *        The new value for the Flow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flow(Flow flow);

        /**
         * Sets the value of the Flow property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Flow.Builder} avoiding the need to create
         * one manually via {@link Flow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Flow.Builder#build()} is called immediately and its result is
         * passed to {@link #flow(Flow)}.
         * 
         * @param flow
         *        a consumer that will call methods on {@link Flow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flow(Flow)
         */
        default Builder flow(Consumer<Flow.Builder> flow) {
            return flow(Flow.builder().applyMutation(flow).build());
        }
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private Flow flow;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowResponse model) {
            super(model);
            flow(model.flow);
        }

        public final Flow.Builder getFlow() {
            return flow != null ? flow.toBuilder() : null;
        }

        public final void setFlow(Flow.BuilderImpl flow) {
            this.flow = flow != null ? flow.build() : null;
        }

        @Override
        public final Builder flow(Flow flow) {
            this.flow = flow;
            return this;
        }

        @Override
        public UpdateFlowResponse build() {
            return new UpdateFlowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
