/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGatewayInstanceResponse extends MediaConnectResponse implements
        ToCopyableBuilder<UpdateGatewayInstanceResponse.Builder, UpdateGatewayInstanceResponse> {
    private static final SdkField<String> BRIDGE_PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BridgePlacement").getter(getter(UpdateGatewayInstanceResponse::bridgePlacementAsString))
            .setter(setter(Builder::bridgePlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgePlacement").build()).build();

    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayInstanceArn").getter(getter(UpdateGatewayInstanceResponse::gatewayInstanceArn))
            .setter(setter(Builder::gatewayInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstanceArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_PLACEMENT_FIELD,
            GATEWAY_INSTANCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String bridgePlacement;

    private final String gatewayInstanceArn;

    private UpdateGatewayInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.bridgePlacement = builder.bridgePlacement;
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
    }

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bridgePlacement}
     * will return {@link BridgePlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bridgePlacementAsString}.
     * </p>
     * 
     * @return The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
     *         AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
     *         bridges can be added to this instance.
     * @see BridgePlacement
     */
    public final BridgePlacement bridgePlacement() {
        return BridgePlacement.fromValue(bridgePlacement);
    }

    /**
     * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or AVAILABLE. If
     * it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges can be added to
     * this instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bridgePlacement}
     * will return {@link BridgePlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bridgePlacementAsString}.
     * </p>
     * 
     * @return The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
     *         AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
     *         bridges can be added to this instance.
     * @see BridgePlacement
     */
    public final String bridgePlacementAsString() {
        return bridgePlacement;
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     * 
     * @return The Amazon Resource Name (ARN) of the instance.
     */
    public final String gatewayInstanceArn() {
        return gatewayInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bridgePlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayInstanceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayInstanceResponse)) {
            return false;
        }
        UpdateGatewayInstanceResponse other = (UpdateGatewayInstanceResponse) obj;
        return Objects.equals(bridgePlacementAsString(), other.bridgePlacementAsString())
                && Objects.equals(gatewayInstanceArn(), other.gatewayInstanceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGatewayInstanceResponse").add("BridgePlacement", bridgePlacementAsString())
                .add("GatewayInstanceArn", gatewayInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BridgePlacement":
            return Optional.ofNullable(clazz.cast(bridgePlacementAsString()));
        case "GatewayInstanceArn":
            return Optional.ofNullable(clazz.cast(gatewayInstanceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bridgePlacement", BRIDGE_PLACEMENT_FIELD);
        map.put("gatewayInstanceArn", GATEWAY_INSTANCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayInstanceResponse, T> g) {
        return obj -> g.apply((UpdateGatewayInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGatewayInstanceResponse> {
        /**
         * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
         * AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges
         * can be added to this instance.
         * 
         * @param bridgePlacement
         *        The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
         *        AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
         *        bridges can be added to this instance.
         * @see BridgePlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BridgePlacement
         */
        Builder bridgePlacement(String bridgePlacement);

        /**
         * The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
         * AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new bridges
         * can be added to this instance.
         * 
         * @param bridgePlacement
         *        The availability of the instance to host new bridges. The bridgePlacement property can be LOCKED or
         *        AVAILABLE. If it is LOCKED, no new bridges can be deployed to this instance. If it is AVAILABLE, new
         *        bridges can be added to this instance.
         * @see BridgePlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BridgePlacement
         */
        Builder bridgePlacement(BridgePlacement bridgePlacement);

        /**
         * The Amazon Resource Name (ARN) of the instance.
         * 
         * @param gatewayInstanceArn
         *        The Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayInstanceArn(String gatewayInstanceArn);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String bridgePlacement;

        private String gatewayInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayInstanceResponse model) {
            super(model);
            bridgePlacement(model.bridgePlacement);
            gatewayInstanceArn(model.gatewayInstanceArn);
        }

        public final String getBridgePlacement() {
            return bridgePlacement;
        }

        public final void setBridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
        }

        @Override
        public final Builder bridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
            return this;
        }

        @Override
        public final Builder bridgePlacement(BridgePlacement bridgePlacement) {
            this.bridgePlacement(bridgePlacement == null ? null : bridgePlacement.toString());
            return this;
        }

        public final String getGatewayInstanceArn() {
            return gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        @Override
        public UpdateGatewayInstanceResponse build() {
            return new UpdateGatewayInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
