/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specifies the configuration for video stream metrics monitoring.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoMonitoringSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoMonitoringSetting.Builder, VideoMonitoringSetting> {
    private static final SdkField<BlackFrames> BLACK_FRAMES_FIELD = SdkField.<BlackFrames> builder(MarshallingType.SDK_POJO)
            .memberName("BlackFrames").getter(getter(VideoMonitoringSetting::blackFrames)).setter(setter(Builder::blackFrames))
            .constructor(BlackFrames::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blackFrames").build()).build();

    private static final SdkField<FrozenFrames> FROZEN_FRAMES_FIELD = SdkField.<FrozenFrames> builder(MarshallingType.SDK_POJO)
            .memberName("FrozenFrames").getter(getter(VideoMonitoringSetting::frozenFrames))
            .setter(setter(Builder::frozenFrames)).constructor(FrozenFrames::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frozenFrames").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACK_FRAMES_FIELD,
            FROZEN_FRAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BlackFrames blackFrames;

    private final FrozenFrames frozenFrames;

    private VideoMonitoringSetting(BuilderImpl builder) {
        this.blackFrames = builder.blackFrames;
        this.frozenFrames = builder.frozenFrames;
    }

    /**
     * Detects video frames that are black.
     * 
     * @return Detects video frames that are black.
     */
    public final BlackFrames blackFrames() {
        return blackFrames;
    }

    /**
     * Detects video frames that have not changed.
     * 
     * @return Detects video frames that have not changed.
     */
    public final FrozenFrames frozenFrames() {
        return frozenFrames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blackFrames());
        hashCode = 31 * hashCode + Objects.hashCode(frozenFrames());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoMonitoringSetting)) {
            return false;
        }
        VideoMonitoringSetting other = (VideoMonitoringSetting) obj;
        return Objects.equals(blackFrames(), other.blackFrames()) && Objects.equals(frozenFrames(), other.frozenFrames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoMonitoringSetting").add("BlackFrames", blackFrames()).add("FrozenFrames", frozenFrames())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlackFrames":
            return Optional.ofNullable(clazz.cast(blackFrames()));
        case "FrozenFrames":
            return Optional.ofNullable(clazz.cast(frozenFrames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("blackFrames", BLACK_FRAMES_FIELD);
        map.put("frozenFrames", FROZEN_FRAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoMonitoringSetting, T> g) {
        return obj -> g.apply((VideoMonitoringSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoMonitoringSetting> {
        /**
         * Detects video frames that are black.
         * 
         * @param blackFrames
         *        Detects video frames that are black.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blackFrames(BlackFrames blackFrames);

        /**
         * Detects video frames that are black. This is a convenience method that creates an instance of the
         * {@link BlackFrames.Builder} avoiding the need to create one manually via {@link BlackFrames#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlackFrames.Builder#build()} is called immediately and its result
         * is passed to {@link #blackFrames(BlackFrames)}.
         * 
         * @param blackFrames
         *        a consumer that will call methods on {@link BlackFrames.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blackFrames(BlackFrames)
         */
        default Builder blackFrames(Consumer<BlackFrames.Builder> blackFrames) {
            return blackFrames(BlackFrames.builder().applyMutation(blackFrames).build());
        }

        /**
         * Detects video frames that have not changed.
         * 
         * @param frozenFrames
         *        Detects video frames that have not changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frozenFrames(FrozenFrames frozenFrames);

        /**
         * Detects video frames that have not changed. This is a convenience method that creates an instance of the
         * {@link FrozenFrames.Builder} avoiding the need to create one manually via {@link FrozenFrames#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FrozenFrames.Builder#build()} is called immediately and its
         * result is passed to {@link #frozenFrames(FrozenFrames)}.
         * 
         * @param frozenFrames
         *        a consumer that will call methods on {@link FrozenFrames.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frozenFrames(FrozenFrames)
         */
        default Builder frozenFrames(Consumer<FrozenFrames.Builder> frozenFrames) {
            return frozenFrames(FrozenFrames.builder().applyMutation(frozenFrames).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlackFrames blackFrames;

        private FrozenFrames frozenFrames;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoMonitoringSetting model) {
            blackFrames(model.blackFrames);
            frozenFrames(model.frozenFrames);
        }

        public final BlackFrames.Builder getBlackFrames() {
            return blackFrames != null ? blackFrames.toBuilder() : null;
        }

        public final void setBlackFrames(BlackFrames.BuilderImpl blackFrames) {
            this.blackFrames = blackFrames != null ? blackFrames.build() : null;
        }

        @Override
        public final Builder blackFrames(BlackFrames blackFrames) {
            this.blackFrames = blackFrames;
            return this;
        }

        public final FrozenFrames.Builder getFrozenFrames() {
            return frozenFrames != null ? frozenFrames.toBuilder() : null;
        }

        public final void setFrozenFrames(FrozenFrames.BuilderImpl frozenFrames) {
            this.frozenFrames = frozenFrames != null ? frozenFrames.build() : null;
        }

        @Override
        public final Builder frozenFrames(FrozenFrames frozenFrames) {
            this.frozenFrames = frozenFrames;
            return this;
        }

        @Override
        public VideoMonitoringSetting build() {
            return new VideoMonitoringSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
