/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveBridgeSourceResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, RemoveBridgeSourceResponse> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(RemoveBridgeSourceResponse.getter(RemoveBridgeSourceResponse::bridgeArn)).setter(RemoveBridgeSourceResponse.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceName").getter(RemoveBridgeSourceResponse.getter(RemoveBridgeSourceResponse::sourceName)).setter(RemoveBridgeSourceResponse.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, SOURCE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveBridgeSourceResponse.memberNameToFieldInitializer();
    private final String bridgeArn;
    private final String sourceName;

    private RemoveBridgeSourceResponse(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.sourceName = builder.sourceName;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final String sourceName() {
        return this.sourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveBridgeSourceResponse)) {
            return false;
        }
        RemoveBridgeSourceResponse other = (RemoveBridgeSourceResponse)((Object)obj);
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && Objects.equals(this.sourceName(), other.sourceName());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveBridgeSourceResponse").add("BridgeArn", (Object)this.bridgeArn()).add("SourceName", (Object)this.sourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "SourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("sourceName", SOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveBridgeSourceResponse, T> g) {
        return obj -> g.apply((RemoveBridgeSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String bridgeArn;
        private String sourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveBridgeSourceResponse model) {
            super(model);
            this.bridgeArn(model.bridgeArn);
            this.sourceName(model.sourceName);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public RemoveBridgeSourceResponse build() {
            return new RemoveBridgeSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveBridgeSourceResponse> {
        public Builder bridgeArn(String var1);

        public Builder sourceName(String var1);
    }
}

