/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterface;
import software.amazon.awssdk.services.mediaconnect.model.___listOfVpcInterfaceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddFlowVpcInterfacesResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, AddFlowVpcInterfacesResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(AddFlowVpcInterfacesResponse.getter(AddFlowVpcInterfacesResponse::flowArn)).setter(AddFlowVpcInterfacesResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<List<VpcInterface>> VPC_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcInterfaces").getter(AddFlowVpcInterfacesResponse.getter(AddFlowVpcInterfacesResponse::vpcInterfaces)).setter(AddFlowVpcInterfacesResponse.setter(Builder::vpcInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, VPC_INTERFACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddFlowVpcInterfacesResponse.memberNameToFieldInitializer();
    private final String flowArn;
    private final List<VpcInterface> vpcInterfaces;

    private AddFlowVpcInterfacesResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.vpcInterfaces = builder.vpcInterfaces;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final boolean hasVpcInterfaces() {
        return this.vpcInterfaces != null && !(this.vpcInterfaces instanceof SdkAutoConstructList);
    }

    public final List<VpcInterface> vpcInterfaces() {
        return this.vpcInterfaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcInterfaces() ? this.vpcInterfaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddFlowVpcInterfacesResponse)) {
            return false;
        }
        AddFlowVpcInterfacesResponse other = (AddFlowVpcInterfacesResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && this.hasVpcInterfaces() == other.hasVpcInterfaces() && Objects.equals(this.vpcInterfaces(), other.vpcInterfaces());
    }

    public final String toString() {
        return ToString.builder((String)"AddFlowVpcInterfacesResponse").add("FlowArn", (Object)this.flowArn()).add("VpcInterfaces", this.hasVpcInterfaces() ? this.vpcInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "VpcInterfaces": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("vpcInterfaces", VPC_INTERFACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddFlowVpcInterfacesResponse, T> g) {
        return obj -> g.apply((AddFlowVpcInterfacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private List<VpcInterface> vpcInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddFlowVpcInterfacesResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.vpcInterfaces(model.vpcInterfaces);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final List<VpcInterface.Builder> getVpcInterfaces() {
            List<VpcInterface.Builder> result = ___listOfVpcInterfaceCopier.copyToBuilder(this.vpcInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcInterfaces(Collection<VpcInterface.BuilderImpl> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copyFromBuilder(vpcInterfaces);
        }

        @Override
        public final Builder vpcInterfaces(Collection<VpcInterface> vpcInterfaces) {
            this.vpcInterfaces = ___listOfVpcInterfaceCopier.copy(vpcInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(VpcInterface ... vpcInterfaces) {
            this.vpcInterfaces(Arrays.asList(vpcInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcInterfaces(Consumer<VpcInterface.Builder> ... vpcInterfaces) {
            this.vpcInterfaces(Stream.of(vpcInterfaces).map(c -> (VpcInterface)((VpcInterface.Builder)VpcInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddFlowVpcInterfacesResponse build() {
            return new AddFlowVpcInterfacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddFlowVpcInterfacesResponse> {
        public Builder flowArn(String var1);

        public Builder vpcInterfaces(Collection<VpcInterface> var1);

        public Builder vpcInterfaces(VpcInterface ... var1);

        public Builder vpcInterfaces(Consumer<VpcInterface.Builder> ... var1);
    }
}

