/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.BridgeState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedBridge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedBridge> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(ListedBridge.getter(ListedBridge::bridgeArn)).setter(ListedBridge.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeArn").build()}).build();
    private static final SdkField<String> BRIDGE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeState").getter(ListedBridge.getter(ListedBridge::bridgeStateAsString)).setter(ListedBridge.setter(Builder::bridgeState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeState").build()}).build();
    private static final SdkField<String> BRIDGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeType").getter(ListedBridge.getter(ListedBridge::bridgeType)).setter(ListedBridge.setter(Builder::bridgeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgeType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ListedBridge.getter(ListedBridge::name)).setter(ListedBridge.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PLACEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementArn").getter(ListedBridge.getter(ListedBridge::placementArn)).setter(ListedBridge.setter(Builder::placementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, BRIDGE_STATE_FIELD, BRIDGE_TYPE_FIELD, NAME_FIELD, PLACEMENT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListedBridge.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bridgeArn;
    private final String bridgeState;
    private final String bridgeType;
    private final String name;
    private final String placementArn;

    private ListedBridge(BuilderImpl builder) {
        this.bridgeArn = builder.bridgeArn;
        this.bridgeState = builder.bridgeState;
        this.bridgeType = builder.bridgeType;
        this.name = builder.name;
        this.placementArn = builder.placementArn;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final BridgeState bridgeState() {
        return BridgeState.fromValue(this.bridgeState);
    }

    public final String bridgeStateAsString() {
        return this.bridgeState;
    }

    public final String bridgeType() {
        return this.bridgeType;
    }

    public final String name() {
        return this.name;
    }

    public final String placementArn() {
        return this.placementArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedBridge)) {
            return false;
        }
        ListedBridge other = (ListedBridge)obj;
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && Objects.equals(this.bridgeStateAsString(), other.bridgeStateAsString()) && Objects.equals(this.bridgeType(), other.bridgeType()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.placementArn(), other.placementArn());
    }

    public final String toString() {
        return ToString.builder((String)"ListedBridge").add("BridgeArn", (Object)this.bridgeArn()).add("BridgeState", (Object)this.bridgeStateAsString()).add("BridgeType", (Object)this.bridgeType()).add("Name", (Object)this.name()).add("PlacementArn", (Object)this.placementArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "BridgeState": {
                return Optional.ofNullable(clazz.cast(this.bridgeStateAsString()));
            }
            case "BridgeType": {
                return Optional.ofNullable(clazz.cast(this.bridgeType()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PlacementArn": {
                return Optional.ofNullable(clazz.cast(this.placementArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("bridgeArn", BRIDGE_ARN_FIELD);
        map.put("bridgeState", BRIDGE_STATE_FIELD);
        map.put("bridgeType", BRIDGE_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("placementArn", PLACEMENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedBridge, T> g) {
        return obj -> g.apply((ListedBridge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bridgeArn;
        private String bridgeState;
        private String bridgeType;
        private String name;
        private String placementArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedBridge model) {
            this.bridgeArn(model.bridgeArn);
            this.bridgeState(model.bridgeState);
            this.bridgeType(model.bridgeType);
            this.name(model.name);
            this.placementArn(model.placementArn);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final String getBridgeState() {
            return this.bridgeState;
        }

        public final void setBridgeState(String bridgeState) {
            this.bridgeState = bridgeState;
        }

        @Override
        public final Builder bridgeState(String bridgeState) {
            this.bridgeState = bridgeState;
            return this;
        }

        @Override
        public final Builder bridgeState(BridgeState bridgeState) {
            this.bridgeState(bridgeState == null ? null : bridgeState.toString());
            return this;
        }

        public final String getBridgeType() {
            return this.bridgeType;
        }

        public final void setBridgeType(String bridgeType) {
            this.bridgeType = bridgeType;
        }

        @Override
        public final Builder bridgeType(String bridgeType) {
            this.bridgeType = bridgeType;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlacementArn() {
            return this.placementArn;
        }

        public final void setPlacementArn(String placementArn) {
            this.placementArn = placementArn;
        }

        @Override
        public final Builder placementArn(String placementArn) {
            this.placementArn = placementArn;
            return this;
        }

        public ListedBridge build() {
            return new ListedBridge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedBridge> {
        public Builder bridgeArn(String var1);

        public Builder bridgeState(String var1);

        public Builder bridgeState(BridgeState var1);

        public Builder bridgeType(String var1);

        public Builder name(String var1);

        public Builder placementArn(String var1);
    }
}

