/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeNetworkOutputRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBridgeOutputRequest
extends MediaConnectRequest
implements ToCopyableBuilder<Builder, UpdateBridgeOutputRequest> {
    private static final SdkField<String> BRIDGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgeArn").getter(UpdateBridgeOutputRequest.getter(UpdateBridgeOutputRequest::bridgeArn)).setter(UpdateBridgeOutputRequest.setter(Builder::bridgeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("BridgeArn").build()}).build();
    private static final SdkField<UpdateBridgeNetworkOutputRequest> NETWORK_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkOutput").getter(UpdateBridgeOutputRequest.getter(UpdateBridgeOutputRequest::networkOutput)).setter(UpdateBridgeOutputRequest.setter(Builder::networkOutput)).constructor(UpdateBridgeNetworkOutputRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkOutput").build()}).build();
    private static final SdkField<String> OUTPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputName").getter(UpdateBridgeOutputRequest.getter(UpdateBridgeOutputRequest::outputName)).setter(UpdateBridgeOutputRequest.setter(Builder::outputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutputName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_ARN_FIELD, NETWORK_OUTPUT_FIELD, OUTPUT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBridgeOutputRequest.memberNameToFieldInitializer();
    private final String bridgeArn;
    private final UpdateBridgeNetworkOutputRequest networkOutput;
    private final String outputName;

    private UpdateBridgeOutputRequest(BuilderImpl builder) {
        super(builder);
        this.bridgeArn = builder.bridgeArn;
        this.networkOutput = builder.networkOutput;
        this.outputName = builder.outputName;
    }

    public final String bridgeArn() {
        return this.bridgeArn;
    }

    public final UpdateBridgeNetworkOutputRequest networkOutput() {
        return this.networkOutput;
    }

    public final String outputName() {
        return this.outputName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBridgeOutputRequest)) {
            return false;
        }
        UpdateBridgeOutputRequest other = (UpdateBridgeOutputRequest)((Object)obj);
        return Objects.equals(this.bridgeArn(), other.bridgeArn()) && Objects.equals(this.networkOutput(), other.networkOutput()) && Objects.equals(this.outputName(), other.outputName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBridgeOutputRequest").add("BridgeArn", (Object)this.bridgeArn()).add("NetworkOutput", (Object)this.networkOutput()).add("OutputName", (Object)this.outputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgeArn": {
                return Optional.ofNullable(clazz.cast(this.bridgeArn()));
            }
            case "NetworkOutput": {
                return Optional.ofNullable(clazz.cast(this.networkOutput()));
            }
            case "OutputName": {
                return Optional.ofNullable(clazz.cast(this.outputName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BridgeArn", BRIDGE_ARN_FIELD);
        map.put("networkOutput", NETWORK_OUTPUT_FIELD);
        map.put("OutputName", OUTPUT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBridgeOutputRequest, T> g) {
        return obj -> g.apply((UpdateBridgeOutputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectRequest.BuilderImpl
    implements Builder {
        private String bridgeArn;
        private UpdateBridgeNetworkOutputRequest networkOutput;
        private String outputName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBridgeOutputRequest model) {
            super(model);
            this.bridgeArn(model.bridgeArn);
            this.networkOutput(model.networkOutput);
            this.outputName(model.outputName);
        }

        public final String getBridgeArn() {
            return this.bridgeArn;
        }

        public final void setBridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
        }

        @Override
        public final Builder bridgeArn(String bridgeArn) {
            this.bridgeArn = bridgeArn;
            return this;
        }

        public final UpdateBridgeNetworkOutputRequest.Builder getNetworkOutput() {
            return this.networkOutput != null ? this.networkOutput.toBuilder() : null;
        }

        public final void setNetworkOutput(UpdateBridgeNetworkOutputRequest.BuilderImpl networkOutput) {
            this.networkOutput = networkOutput != null ? networkOutput.build() : null;
        }

        @Override
        public final Builder networkOutput(UpdateBridgeNetworkOutputRequest networkOutput) {
            this.networkOutput = networkOutput;
            return this;
        }

        public final String getOutputName() {
            return this.outputName;
        }

        public final void setOutputName(String outputName) {
            this.outputName = outputName;
        }

        @Override
        public final Builder outputName(String outputName) {
            this.outputName = outputName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBridgeOutputRequest build() {
            return new UpdateBridgeOutputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBridgeOutputRequest> {
        public Builder bridgeArn(String var1);

        public Builder networkOutput(UpdateBridgeNetworkOutputRequest var1);

        default public Builder networkOutput(Consumer<UpdateBridgeNetworkOutputRequest.Builder> networkOutput) {
            return this.networkOutput((UpdateBridgeNetworkOutputRequest)((UpdateBridgeNetworkOutputRequest.Builder)UpdateBridgeNetworkOutputRequest.builder().applyMutation(networkOutput)).build());
        }

        public Builder outputName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

