/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.BridgePlacement;
import software.amazon.awssdk.services.mediaconnect.model.ConnectionStatus;
import software.amazon.awssdk.services.mediaconnect.model.InstanceState;
import software.amazon.awssdk.services.mediaconnect.model.MessageDetail;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMessageDetailCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewayInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewayInstance> {
    private static final SdkField<String> BRIDGE_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BridgePlacement").getter(GatewayInstance.getter(GatewayInstance::bridgePlacementAsString)).setter(GatewayInstance.setter(Builder::bridgePlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bridgePlacement").build()}).build();
    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionStatus").getter(GatewayInstance.getter(GatewayInstance::connectionStatusAsString)).setter(GatewayInstance.setter(Builder::connectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionStatus").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(GatewayInstance.getter(GatewayInstance::gatewayArn)).setter(GatewayInstance.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()}).build();
    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayInstanceArn").getter(GatewayInstance.getter(GatewayInstance::gatewayInstanceArn)).setter(GatewayInstance.setter(Builder::gatewayInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstanceArn").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GatewayInstance.getter(GatewayInstance::instanceId)).setter(GatewayInstance.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<List<MessageDetail>> INSTANCE_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceMessages").getter(GatewayInstance.getter(GatewayInstance::instanceMessages)).setter(GatewayInstance.setter(Builder::instanceMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceState").getter(GatewayInstance.getter(GatewayInstance::instanceStateAsString)).setter(GatewayInstance.setter(Builder::instanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()}).build();
    private static final SdkField<Integer> RUNNING_BRIDGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RunningBridgeCount").getter(GatewayInstance.getter(GatewayInstance::runningBridgeCount)).setter(GatewayInstance.setter(Builder::runningBridgeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningBridgeCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRIDGE_PLACEMENT_FIELD, CONNECTION_STATUS_FIELD, GATEWAY_ARN_FIELD, GATEWAY_INSTANCE_ARN_FIELD, INSTANCE_ID_FIELD, INSTANCE_MESSAGES_FIELD, INSTANCE_STATE_FIELD, RUNNING_BRIDGE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GatewayInstance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bridgePlacement;
    private final String connectionStatus;
    private final String gatewayArn;
    private final String gatewayInstanceArn;
    private final String instanceId;
    private final List<MessageDetail> instanceMessages;
    private final String instanceState;
    private final Integer runningBridgeCount;

    private GatewayInstance(BuilderImpl builder) {
        this.bridgePlacement = builder.bridgePlacement;
        this.connectionStatus = builder.connectionStatus;
        this.gatewayArn = builder.gatewayArn;
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
        this.instanceId = builder.instanceId;
        this.instanceMessages = builder.instanceMessages;
        this.instanceState = builder.instanceState;
        this.runningBridgeCount = builder.runningBridgeCount;
    }

    public final BridgePlacement bridgePlacement() {
        return BridgePlacement.fromValue(this.bridgePlacement);
    }

    public final String bridgePlacementAsString() {
        return this.bridgePlacement;
    }

    public final ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(this.connectionStatus);
    }

    public final String connectionStatusAsString() {
        return this.connectionStatus;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final String gatewayInstanceArn() {
        return this.gatewayInstanceArn;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasInstanceMessages() {
        return this.instanceMessages != null && !(this.instanceMessages instanceof SdkAutoConstructList);
    }

    public final List<MessageDetail> instanceMessages() {
        return this.instanceMessages;
    }

    public final InstanceState instanceState() {
        return InstanceState.fromValue(this.instanceState);
    }

    public final String instanceStateAsString() {
        return this.instanceState;
    }

    public final Integer runningBridgeCount() {
        return this.runningBridgeCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bridgePlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceMessages() ? this.instanceMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningBridgeCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewayInstance)) {
            return false;
        }
        GatewayInstance other = (GatewayInstance)obj;
        return Objects.equals(this.bridgePlacementAsString(), other.bridgePlacementAsString()) && Objects.equals(this.connectionStatusAsString(), other.connectionStatusAsString()) && Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.gatewayInstanceArn(), other.gatewayInstanceArn()) && Objects.equals(this.instanceId(), other.instanceId()) && this.hasInstanceMessages() == other.hasInstanceMessages() && Objects.equals(this.instanceMessages(), other.instanceMessages()) && Objects.equals(this.instanceStateAsString(), other.instanceStateAsString()) && Objects.equals(this.runningBridgeCount(), other.runningBridgeCount());
    }

    public final String toString() {
        return ToString.builder((String)"GatewayInstance").add("BridgePlacement", (Object)this.bridgePlacementAsString()).add("ConnectionStatus", (Object)this.connectionStatusAsString()).add("GatewayArn", (Object)this.gatewayArn()).add("GatewayInstanceArn", (Object)this.gatewayInstanceArn()).add("InstanceId", (Object)this.instanceId()).add("InstanceMessages", this.hasInstanceMessages() ? this.instanceMessages() : null).add("InstanceState", (Object)this.instanceStateAsString()).add("RunningBridgeCount", (Object)this.runningBridgeCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BridgePlacement": {
                return Optional.ofNullable(clazz.cast(this.bridgePlacementAsString()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatusAsString()));
            }
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "GatewayInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayInstanceArn()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceMessages": {
                return Optional.ofNullable(clazz.cast(this.instanceMessages()));
            }
            case "InstanceState": {
                return Optional.ofNullable(clazz.cast(this.instanceStateAsString()));
            }
            case "RunningBridgeCount": {
                return Optional.ofNullable(clazz.cast(this.runningBridgeCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bridgePlacement", BRIDGE_PLACEMENT_FIELD);
        map.put("connectionStatus", CONNECTION_STATUS_FIELD);
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("gatewayInstanceArn", GATEWAY_INSTANCE_ARN_FIELD);
        map.put("instanceId", INSTANCE_ID_FIELD);
        map.put("instanceMessages", INSTANCE_MESSAGES_FIELD);
        map.put("instanceState", INSTANCE_STATE_FIELD);
        map.put("runningBridgeCount", RUNNING_BRIDGE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewayInstance, T> g) {
        return obj -> g.apply((GatewayInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bridgePlacement;
        private String connectionStatus;
        private String gatewayArn;
        private String gatewayInstanceArn;
        private String instanceId;
        private List<MessageDetail> instanceMessages = DefaultSdkAutoConstructList.getInstance();
        private String instanceState;
        private Integer runningBridgeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewayInstance model) {
            this.bridgePlacement(model.bridgePlacement);
            this.connectionStatus(model.connectionStatus);
            this.gatewayArn(model.gatewayArn);
            this.gatewayInstanceArn(model.gatewayInstanceArn);
            this.instanceId(model.instanceId);
            this.instanceMessages(model.instanceMessages);
            this.instanceState(model.instanceState);
            this.runningBridgeCount(model.runningBridgeCount);
        }

        public final String getBridgePlacement() {
            return this.bridgePlacement;
        }

        public final void setBridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
        }

        @Override
        public final Builder bridgePlacement(String bridgePlacement) {
            this.bridgePlacement = bridgePlacement;
            return this;
        }

        @Override
        public final Builder bridgePlacement(BridgePlacement bridgePlacement) {
            this.bridgePlacement(bridgePlacement == null ? null : bridgePlacement.toString());
            return this;
        }

        public final String getConnectionStatus() {
            return this.connectionStatus;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayInstanceArn() {
            return this.gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final List<MessageDetail.Builder> getInstanceMessages() {
            List<MessageDetail.Builder> result = ___listOfMessageDetailCopier.copyToBuilder(this.instanceMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceMessages(Collection<MessageDetail.BuilderImpl> instanceMessages) {
            this.instanceMessages = ___listOfMessageDetailCopier.copyFromBuilder(instanceMessages);
        }

        @Override
        public final Builder instanceMessages(Collection<MessageDetail> instanceMessages) {
            this.instanceMessages = ___listOfMessageDetailCopier.copy(instanceMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMessages(MessageDetail ... instanceMessages) {
            this.instanceMessages(Arrays.asList(instanceMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMessages(Consumer<MessageDetail.Builder> ... instanceMessages) {
            this.instanceMessages(Stream.of(instanceMessages).map(c -> (MessageDetail)((MessageDetail.Builder)MessageDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceState() {
            return this.instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState(instanceState == null ? null : instanceState.toString());
            return this;
        }

        public final Integer getRunningBridgeCount() {
            return this.runningBridgeCount;
        }

        public final void setRunningBridgeCount(Integer runningBridgeCount) {
            this.runningBridgeCount = runningBridgeCount;
        }

        @Override
        public final Builder runningBridgeCount(Integer runningBridgeCount) {
            this.runningBridgeCount = runningBridgeCount;
            return this;
        }

        public GatewayInstance build() {
            return new GatewayInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewayInstance> {
        public Builder bridgePlacement(String var1);

        public Builder bridgePlacement(BridgePlacement var1);

        public Builder connectionStatus(String var1);

        public Builder connectionStatus(ConnectionStatus var1);

        public Builder gatewayArn(String var1);

        public Builder gatewayInstanceArn(String var1);

        public Builder instanceId(String var1);

        public Builder instanceMessages(Collection<MessageDetail> var1);

        public Builder instanceMessages(MessageDetail ... var1);

        public Builder instanceMessages(Consumer<MessageDetail.Builder> ... var1);

        public Builder instanceState(String var1);

        public Builder instanceState(InstanceState var1);

        public Builder runningBridgeCount(Integer var1);
    }
}

