/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update the source of a flow.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowSourceRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateFlowSourceRequest.Builder, UpdateFlowSourceRequest> {
    private static final SdkField<UpdateEncryption> DECRYPTION_FIELD = SdkField
            .<UpdateEncryption> builder(MarshallingType.SDK_POJO).getter(getter(UpdateFlowSourceRequest::decryption))
            .setter(setter(Builder::decryption)).constructor(UpdateEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowSourceRequest::entitlementArn)).setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowSourceRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFlowSourceRequest::ingestPort)).setter(setter(Builder::ingestPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFlowSourceRequest::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFlowSourceRequest::maxLatency)).setter(setter(Builder::maxLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowSourceRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowSourceRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceArn").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowSourceRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowSourceRequest::whitelistCidr)).setter(setter(Builder::whitelistCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD,
            DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD, FLOW_ARN_FIELD, INGEST_PORT_FIELD, MAX_BITRATE_FIELD, MAX_LATENCY_FIELD,
            PROTOCOL_FIELD, SOURCE_ARN_FIELD, STREAM_ID_FIELD, WHITELIST_CIDR_FIELD));

    private final UpdateEncryption decryption;

    private final String description;

    private final String entitlementArn;

    private final String flowArn;

    private final Integer ingestPort;

    private final Integer maxBitrate;

    private final Integer maxLatency;

    private final String protocol;

    private final String sourceArn;

    private final String streamId;

    private final String whitelistCidr;

    private UpdateFlowSourceRequest(BuilderImpl builder) {
        super(builder);
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.flowArn = builder.flowArn;
        this.ingestPort = builder.ingestPort;
        this.maxBitrate = builder.maxBitrate;
        this.maxLatency = builder.maxLatency;
        this.protocol = builder.protocol;
        this.sourceArn = builder.sourceArn;
        this.streamId = builder.streamId;
        this.whitelistCidr = builder.whitelistCidr;
    }

    /**
     * The type of encryption used on the content ingested from this source.
     * 
     * @return The type of encryption used on the content ingested from this source.
     */
    public UpdateEncryption decryption() {
        return decryption;
    }

    /**
     * A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect
     * account.
     * 
     * @return A description for the source. This value is not used or seen outside of the current AWS Elemental
     *         MediaConnect account.
     */
    public String description() {
        return description;
    }

    /**
     * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
     * originator, and the ARN is generated as part of the originator's flow.
     * 
     * @return The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
     *         originator, and the ARN is generated as part of the originator's flow.
     */
    public String entitlementArn() {
        return entitlementArn;
    }

    /**
     * The flow that is associated with the source that you want to update.
     * 
     * @return The flow that is associated with the source that you want to update.
     */
    public String flowArn() {
        return flowArn;
    }

    /**
     * The port that the flow will be listening on for incoming content.
     * 
     * @return The port that the flow will be listening on for incoming content.
     */
    public Integer ingestPort() {
        return ingestPort;
    }

    /**
     * The smoothing max bitrate for RTP and RTP-FEC streams.
     * 
     * @return The smoothing max bitrate for RTP and RTP-FEC streams.
     */
    public Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * The maximum latency in milliseconds for Zixi-based streams.
     * 
     * @return The maximum latency in milliseconds for Zixi-based streams.
     */
    public Integer maxLatency() {
        return maxLatency;
    }

    /**
     * The protocol that is used by the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source.
     * @see Protocol
     */
    public Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The protocol that is used by the source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol that is used by the source.
     * @see Protocol
     */
    public String protocolAsString() {
        return protocol;
    }

    /**
     * The ARN of the source that you want to update.
     * 
     * @return The ARN of the source that you want to update.
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     * 
     * @return The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    public String streamId() {
        return streamId;
    }

    /**
     * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should
     * be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * 
     * @return The range of IP addresses that should be allowed to contribute content to your source. These IP addresses
     *         should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     */
    public String whitelistCidr() {
        return whitelistCidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(decryption());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(whitelistCidr());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowSourceRequest)) {
            return false;
        }
        UpdateFlowSourceRequest other = (UpdateFlowSourceRequest) obj;
        return Objects.equals(decryption(), other.decryption()) && Objects.equals(description(), other.description())
                && Objects.equals(entitlementArn(), other.entitlementArn()) && Objects.equals(flowArn(), other.flowArn())
                && Objects.equals(ingestPort(), other.ingestPort()) && Objects.equals(maxBitrate(), other.maxBitrate())
                && Objects.equals(maxLatency(), other.maxLatency())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(streamId(), other.streamId()) && Objects.equals(whitelistCidr(), other.whitelistCidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFlowSourceRequest").add("Decryption", decryption()).add("Description", description())
                .add("EntitlementArn", entitlementArn()).add("FlowArn", flowArn()).add("IngestPort", ingestPort())
                .add("MaxBitrate", maxBitrate()).add("MaxLatency", maxLatency()).add("Protocol", protocolAsString())
                .add("SourceArn", sourceArn()).add("StreamId", streamId()).add("WhitelistCidr", whitelistCidr()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Decryption":
            return Optional.ofNullable(clazz.cast(decryption()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "IngestPort":
            return Optional.ofNullable(clazz.cast(ingestPort()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MaxLatency":
            return Optional.ofNullable(clazz.cast(maxLatency()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "WhitelistCidr":
            return Optional.ofNullable(clazz.cast(whitelistCidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowSourceRequest, T> g) {
        return obj -> g.apply((UpdateFlowSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowSourceRequest> {
        /**
         * The type of encryption used on the content ingested from this source.
         * 
         * @param decryption
         *        The type of encryption used on the content ingested from this source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryption(UpdateEncryption decryption);

        /**
         * The type of encryption used on the content ingested from this source. This is a convenience that creates an
         * instance of the {@link UpdateEncryption.Builder} avoiding the need to create one manually via
         * {@link UpdateEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #decryption(UpdateEncryption)}.
         * 
         * @param decryption
         *        a consumer that will call methods on {@link UpdateEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryption(UpdateEncryption)
         */
        default Builder decryption(Consumer<UpdateEncryption.Builder> decryption) {
            return decryption(UpdateEncryption.builder().applyMutation(decryption).build());
        }

        /**
         * A description for the source. This value is not used or seen outside of the current AWS Elemental
         * MediaConnect account.
         * 
         * @param description
         *        A description for the source. This value is not used or seen outside of the current AWS Elemental
         *        MediaConnect account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow
         * originator, and the ARN is generated as part of the originator's flow.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the
         *        flow originator, and the ARN is generated as part of the originator's flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * The flow that is associated with the source that you want to update.
         * 
         * @param flowArn
         *        The flow that is associated with the source that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The port that the flow will be listening on for incoming content.
         * 
         * @param ingestPort
         *        The port that the flow will be listening on for incoming content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestPort(Integer ingestPort);

        /**
         * The smoothing max bitrate for RTP and RTP-FEC streams.
         * 
         * @param maxBitrate
         *        The smoothing max bitrate for RTP and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * The maximum latency in milliseconds for Zixi-based streams.
         * 
         * @param maxLatency
         *        The maximum latency in milliseconds for Zixi-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLatency(Integer maxLatency);

        /**
         * The protocol that is used by the source.
         * 
         * @param protocol
         *        The protocol that is used by the source.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The protocol that is used by the source.
         * 
         * @param protocol
         *        The protocol that is used by the source.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The ARN of the source that you want to update.
         * 
         * @param sourceArn
         *        The ARN of the source that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         * 
         * @param streamId
         *        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * The range of IP addresses that should be allowed to contribute content to your source. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param whitelistCidr
         *        The range of IP addresses that should be allowed to contribute content to your source. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistCidr(String whitelistCidr);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private UpdateEncryption decryption;

        private String description;

        private String entitlementArn;

        private String flowArn;

        private Integer ingestPort;

        private Integer maxBitrate;

        private Integer maxLatency;

        private String protocol;

        private String sourceArn;

        private String streamId;

        private String whitelistCidr;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowSourceRequest model) {
            super(model);
            decryption(model.decryption);
            description(model.description);
            entitlementArn(model.entitlementArn);
            flowArn(model.flowArn);
            ingestPort(model.ingestPort);
            maxBitrate(model.maxBitrate);
            maxLatency(model.maxLatency);
            protocol(model.protocol);
            sourceArn(model.sourceArn);
            streamId(model.streamId);
            whitelistCidr(model.whitelistCidr);
        }

        public final UpdateEncryption.Builder getDecryption() {
            return decryption != null ? decryption.toBuilder() : null;
        }

        @Override
        public final Builder decryption(UpdateEncryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final void setDecryption(UpdateEncryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Integer getIngestPort() {
            return ingestPort;
        }

        @Override
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMaxLatency() {
            return maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getProtocolAsString() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getStreamId() {
            return streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getWhitelistCidr() {
            return whitelistCidr;
        }

        @Override
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowSourceRequest build() {
            return new UpdateFlowSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
