/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for an output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Output implements SdkPojo, Serializable, ToCopyableBuilder<Output.Builder, Output> {
    private static final SdkField<Integer> DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Output::dataTransferSubscriberFeePercent))
            .setter(setter(Builder::dataTransferSubscriberFeePercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferSubscriberFeePercent")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Output::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Output::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(Output::encryption)).setter(setter(Builder::encryption)).constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Output::entitlementArn)).setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final SdkField<String> MEDIA_LIVE_INPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Output::mediaLiveInputArn)).setter(setter(Builder::mediaLiveInputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaLiveInputArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Output::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OUTPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Output::outputArn)).setter(setter(Builder::outputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArn").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Output::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<Transport> TRANSPORT_FIELD = SdkField.<Transport> builder(MarshallingType.SDK_POJO)
            .getter(getter(Output::transport)).setter(setter(Builder::transport)).constructor(Transport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD, DESCRIPTION_FIELD, DESTINATION_FIELD, ENCRYPTION_FIELD,
            ENTITLEMENT_ARN_FIELD, MEDIA_LIVE_INPUT_ARN_FIELD, NAME_FIELD, OUTPUT_ARN_FIELD, PORT_FIELD, TRANSPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer dataTransferSubscriberFeePercent;

    private final String description;

    private final String destination;

    private final Encryption encryption;

    private final String entitlementArn;

    private final String mediaLiveInputArn;

    private final String name;

    private final String outputArn;

    private final Integer port;

    private final Transport transport;

    private Output(BuilderImpl builder) {
        this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
        this.description = builder.description;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.entitlementArn = builder.entitlementArn;
        this.mediaLiveInputArn = builder.mediaLiveInputArn;
        this.name = builder.name;
        this.outputArn = builder.outputArn;
        this.port = builder.port;
        this.transport = builder.transport;
    }

    /**
     * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     * 
     * @return Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
     */
    public Integer dataTransferSubscriberFeePercent() {
        return dataTransferSubscriberFeePercent;
    }

    /**
     * A description of the output.
     * 
     * @return A description of the output.
     */
    public String description() {
        return description;
    }

    /**
     * The address where you want to send the output.
     * 
     * @return The address where you want to send the output.
     */
    public String destination() {
        return destination;
    }

    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
     * (static-key).
     * 
     * @return The type of key used for the encryption. If no keyType is provided, the service will use the default
     *         setting (static-key).
     */
    public Encryption encryption() {
        return encryption;
    }

    /**
     * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
     * 
     * @return The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
     */
    public String entitlementArn() {
        return entitlementArn;
    }

    /**
     * The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added
     * by creating a MediaLive input.
     * 
     * @return The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that
     *         were added by creating a MediaLive input.
     */
    public String mediaLiveInputArn() {
        return mediaLiveInputArn;
    }

    /**
     * The name of the output. This value must be unique within the current flow.
     * 
     * @return The name of the output. This value must be unique within the current flow.
     */
    public String name() {
        return name;
    }

    /**
     * The ARN of the output.
     * 
     * @return The ARN of the output.
     */
    public String outputArn() {
        return outputArn;
    }

    /**
     * The port to use when content is distributed to this output.
     * 
     * @return The port to use when content is distributed to this output.
     */
    public Integer port() {
        return port;
    }

    /**
     * Attributes related to the transport stream that are used in the output.
     * 
     * @return Attributes related to the transport stream that are used in the output.
     */
    public Transport transport() {
        return transport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataTransferSubscriberFeePercent());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(mediaLiveInputArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputArn());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(transport());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        return Objects.equals(dataTransferSubscriberFeePercent(), other.dataTransferSubscriberFeePercent())
                && Objects.equals(description(), other.description()) && Objects.equals(destination(), other.destination())
                && Objects.equals(encryption(), other.encryption()) && Objects.equals(entitlementArn(), other.entitlementArn())
                && Objects.equals(mediaLiveInputArn(), other.mediaLiveInputArn()) && Objects.equals(name(), other.name())
                && Objects.equals(outputArn(), other.outputArn()) && Objects.equals(port(), other.port())
                && Objects.equals(transport(), other.transport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Output").add("DataTransferSubscriberFeePercent", dataTransferSubscriberFeePercent())
                .add("Description", description()).add("Destination", destination()).add("Encryption", encryption())
                .add("EntitlementArn", entitlementArn()).add("MediaLiveInputArn", mediaLiveInputArn()).add("Name", name())
                .add("OutputArn", outputArn()).add("Port", port()).add("Transport", transport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataTransferSubscriberFeePercent":
            return Optional.ofNullable(clazz.cast(dataTransferSubscriberFeePercent()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        case "MediaLiveInputArn":
            return Optional.ofNullable(clazz.cast(mediaLiveInputArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OutputArn":
            return Optional.ofNullable(clazz.cast(outputArn()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Transport":
            return Optional.ofNullable(clazz.cast(transport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Output> {
        /**
         * Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         * 
         * @param dataTransferSubscriberFeePercent
         *        Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent);

        /**
         * A description of the output.
         * 
         * @param description
         *        A description of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The address where you want to send the output.
         * 
         * @param destination
         *        The address where you want to send the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
         * (static-key).
         * 
         * @param encryption
         *        The type of key used for the encryption. If no keyType is provided, the service will use the default
         *        setting (static-key).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
         * (static-key). This is a convenience that creates an instance of the {@link Encryption.Builder} avoiding the
         * need to create one manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }

        /**
         * The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
         * 
         * @param entitlementArn
         *        The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);

        /**
         * The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were
         * added by creating a MediaLive input.
         * 
         * @param mediaLiveInputArn
         *        The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that
         *        were added by creating a MediaLive input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaLiveInputArn(String mediaLiveInputArn);

        /**
         * The name of the output. This value must be unique within the current flow.
         * 
         * @param name
         *        The name of the output. This value must be unique within the current flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The ARN of the output.
         * 
         * @param outputArn
         *        The ARN of the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArn(String outputArn);

        /**
         * The port to use when content is distributed to this output.
         * 
         * @param port
         *        The port to use when content is distributed to this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * Attributes related to the transport stream that are used in the output.
         * 
         * @param transport
         *        Attributes related to the transport stream that are used in the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transport(Transport transport);

        /**
         * Attributes related to the transport stream that are used in the output. This is a convenience that creates an
         * instance of the {@link Transport.Builder} avoiding the need to create one manually via
         * {@link Transport#builder()}.
         *
         * When the {@link Consumer} completes, {@link Transport.Builder#build()} is called immediately and its result
         * is passed to {@link #transport(Transport)}.
         * 
         * @param transport
         *        a consumer that will call methods on {@link Transport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transport(Transport)
         */
        default Builder transport(Consumer<Transport.Builder> transport) {
            return transport(Transport.builder().applyMutation(transport).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer dataTransferSubscriberFeePercent;

        private String description;

        private String destination;

        private Encryption encryption;

        private String entitlementArn;

        private String mediaLiveInputArn;

        private String name;

        private String outputArn;

        private Integer port;

        private Transport transport;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            dataTransferSubscriberFeePercent(model.dataTransferSubscriberFeePercent);
            description(model.description);
            destination(model.destination);
            encryption(model.encryption);
            entitlementArn(model.entitlementArn);
            mediaLiveInputArn(model.mediaLiveInputArn);
            name(model.name);
            outputArn(model.outputArn);
            port(model.port);
            transport(model.transport);
        }

        public final Integer getDataTransferSubscriberFeePercent() {
            return dataTransferSubscriberFeePercent;
        }

        @Override
        public final Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        public final void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        public final String getMediaLiveInputArn() {
            return mediaLiveInputArn;
        }

        @Override
        public final Builder mediaLiveInputArn(String mediaLiveInputArn) {
            this.mediaLiveInputArn = mediaLiveInputArn;
            return this;
        }

        public final void setMediaLiveInputArn(String mediaLiveInputArn) {
            this.mediaLiveInputArn = mediaLiveInputArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOutputArn() {
            return outputArn;
        }

        @Override
        public final Builder outputArn(String outputArn) {
            this.outputArn = outputArn;
            return this;
        }

        public final void setOutputArn(String outputArn) {
            this.outputArn = outputArn;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Transport.Builder getTransport() {
            return transport != null ? transport.toBuilder() : null;
        }

        @Override
        public final Builder transport(Transport transport) {
            this.transport = transport;
            return this;
        }

        public final void setTransport(Transport.BuilderImpl transport) {
            this.transport = transport != null ? transport.build() : null;
        }

        @Override
        public Output build() {
            return new Output(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
