/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The fields that you want to update in the output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFlowOutputRequest extends MediaConnectRequest implements
        ToCopyableBuilder<UpdateFlowOutputRequest.Builder, UpdateFlowOutputRequest> {
    private static final SdkField<List<String>> CIDR_ALLOW_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateFlowOutputRequest::cidrAllowList))
            .setter(setter(Builder::cidrAllowList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrAllowList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowOutputRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowOutputRequest::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<UpdateEncryption> ENCRYPTION_FIELD = SdkField
            .<UpdateEncryption> builder(MarshallingType.SDK_POJO).getter(getter(UpdateFlowOutputRequest::encryption))
            .setter(setter(Builder::encryption)).constructor(UpdateEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowOutputRequest::flowArn)).setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowArn").build()).build();

    private static final SdkField<Integer> MAX_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFlowOutputRequest::maxLatency)).setter(setter(Builder::maxLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLatency").build()).build();

    private static final SdkField<String> OUTPUT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowOutputRequest::outputArn)).setter(setter(Builder::outputArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("outputArn").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFlowOutputRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowOutputRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> REMOTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowOutputRequest::remoteId)).setter(setter(Builder::remoteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteId").build()).build();

    private static final SdkField<Integer> SMOOTHING_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFlowOutputRequest::smoothingLatency)).setter(setter(Builder::smoothingLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smoothingLatency").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFlowOutputRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_ALLOW_LIST_FIELD,
            DESCRIPTION_FIELD, DESTINATION_FIELD, ENCRYPTION_FIELD, FLOW_ARN_FIELD, MAX_LATENCY_FIELD, OUTPUT_ARN_FIELD,
            PORT_FIELD, PROTOCOL_FIELD, REMOTE_ID_FIELD, SMOOTHING_LATENCY_FIELD, STREAM_ID_FIELD));

    private final List<String> cidrAllowList;

    private final String description;

    private final String destination;

    private final UpdateEncryption encryption;

    private final String flowArn;

    private final Integer maxLatency;

    private final String outputArn;

    private final Integer port;

    private final String protocol;

    private final String remoteId;

    private final Integer smoothingLatency;

    private final String streamId;

    private UpdateFlowOutputRequest(BuilderImpl builder) {
        super(builder);
        this.cidrAllowList = builder.cidrAllowList;
        this.description = builder.description;
        this.destination = builder.destination;
        this.encryption = builder.encryption;
        this.flowArn = builder.flowArn;
        this.maxLatency = builder.maxLatency;
        this.outputArn = builder.outputArn;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.remoteId = builder.remoteId;
        this.smoothingLatency = builder.smoothingLatency;
        this.streamId = builder.streamId;
    }

    /**
     * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
     * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
     *         addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
     *         10.0.0.0/16.
     */
    public List<String> cidrAllowList() {
        return cidrAllowList;
    }

    /**
     * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not
     * be seen by the end user.
     * 
     * @return A description of the output. This description appears only on the AWS Elemental MediaConnect console and
     *         will not be seen by the end user.
     */
    public String description() {
        return description;
    }

    /**
     * The IP address where you want to send the output.
     * 
     * @return The IP address where you want to send the output.
     */
    public String destination() {
        return destination;
    }

    /**
     * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
     * (static-key).
     * 
     * @return The type of key used for the encryption. If no keyType is provided, the service will use the default
     *         setting (static-key).
     */
    public UpdateEncryption encryption() {
        return encryption;
    }

    /**
     * The flow that is associated with the output that you want to update.
     * 
     * @return The flow that is associated with the output that you want to update.
     */
    public String flowArn() {
        return flowArn;
    }

    /**
     * The maximum latency in milliseconds for Zixi-based streams.
     * 
     * @return The maximum latency in milliseconds for Zixi-based streams.
     */
    public Integer maxLatency() {
        return maxLatency;
    }

    /**
     * The ARN of the output that you want to update.
     * 
     * @return The ARN of the output that you want to update.
     */
    public String outputArn() {
        return outputArn;
    }

    /**
     * The port to use when content is distributed to this output.
     * 
     * @return The port to use when content is distributed to this output.
     */
    public Integer port() {
        return port;
    }

    /**
     * The protocol to use for the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for the output.
     * @see Protocol
     */
    public Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * The protocol to use for the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use for the output.
     * @see Protocol
     */
    public String protocolAsString() {
        return protocol;
    }

    /**
     * The remote ID for the Zixi-pull stream.
     * 
     * @return The remote ID for the Zixi-pull stream.
     */
    public String remoteId() {
        return remoteId;
    }

    /**
     * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     * 
     * @return The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
     */
    public Integer smoothingLatency() {
        return smoothingLatency;
    }

    /**
     * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     * 
     * @return The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
     */
    public String streamId() {
        return streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidrAllowList());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxLatency());
        hashCode = 31 * hashCode + Objects.hashCode(outputArn());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(remoteId());
        hashCode = 31 * hashCode + Objects.hashCode(smoothingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFlowOutputRequest)) {
            return false;
        }
        UpdateFlowOutputRequest other = (UpdateFlowOutputRequest) obj;
        return Objects.equals(cidrAllowList(), other.cidrAllowList()) && Objects.equals(description(), other.description())
                && Objects.equals(destination(), other.destination()) && Objects.equals(encryption(), other.encryption())
                && Objects.equals(flowArn(), other.flowArn()) && Objects.equals(maxLatency(), other.maxLatency())
                && Objects.equals(outputArn(), other.outputArn()) && Objects.equals(port(), other.port())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(remoteId(), other.remoteId())
                && Objects.equals(smoothingLatency(), other.smoothingLatency()) && Objects.equals(streamId(), other.streamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFlowOutputRequest").add("CidrAllowList", cidrAllowList())
                .add("Description", description()).add("Destination", destination()).add("Encryption", encryption())
                .add("FlowArn", flowArn()).add("MaxLatency", maxLatency()).add("OutputArn", outputArn()).add("Port", port())
                .add("Protocol", protocolAsString()).add("RemoteId", remoteId()).add("SmoothingLatency", smoothingLatency())
                .add("StreamId", streamId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrAllowList":
            return Optional.ofNullable(clazz.cast(cidrAllowList()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "MaxLatency":
            return Optional.ofNullable(clazz.cast(maxLatency()));
        case "OutputArn":
            return Optional.ofNullable(clazz.cast(outputArn()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "RemoteId":
            return Optional.ofNullable(clazz.cast(remoteId()));
        case "SmoothingLatency":
            return Optional.ofNullable(clazz.cast(smoothingLatency()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFlowOutputRequest, T> g) {
        return obj -> g.apply((UpdateFlowOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFlowOutputRequest> {
        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(Collection<String> cidrAllowList);

        /**
         * The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses
         * should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
         * 
         * @param cidrAllowList
         *        The range of IP addresses that should be allowed to initiate output requests to this flow. These IP
         *        addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example,
         *        10.0.0.0/16.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowList(String... cidrAllowList);

        /**
         * A description of the output. This description appears only on the AWS Elemental MediaConnect console and will
         * not be seen by the end user.
         * 
         * @param description
         *        A description of the output. This description appears only on the AWS Elemental MediaConnect console
         *        and will not be seen by the end user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The IP address where you want to send the output.
         * 
         * @param destination
         *        The IP address where you want to send the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
         * (static-key).
         * 
         * @param encryption
         *        The type of key used for the encryption. If no keyType is provided, the service will use the default
         *        setting (static-key).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(UpdateEncryption encryption);

        /**
         * The type of key used for the encryption. If no keyType is provided, the service will use the default setting
         * (static-key). This is a convenience that creates an instance of the {@link UpdateEncryption.Builder} avoiding
         * the need to create one manually via {@link UpdateEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(UpdateEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link UpdateEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(UpdateEncryption)
         */
        default Builder encryption(Consumer<UpdateEncryption.Builder> encryption) {
            return encryption(UpdateEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * The flow that is associated with the output that you want to update.
         * 
         * @param flowArn
         *        The flow that is associated with the output that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The maximum latency in milliseconds for Zixi-based streams.
         * 
         * @param maxLatency
         *        The maximum latency in milliseconds for Zixi-based streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLatency(Integer maxLatency);

        /**
         * The ARN of the output that you want to update.
         * 
         * @param outputArn
         *        The ARN of the output that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArn(String outputArn);

        /**
         * The port to use when content is distributed to this output.
         * 
         * @param port
         *        The port to use when content is distributed to this output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * The protocol to use for the output.
         * 
         * @param protocol
         *        The protocol to use for the output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * The protocol to use for the output.
         * 
         * @param protocol
         *        The protocol to use for the output.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * The remote ID for the Zixi-pull stream.
         * 
         * @param remoteId
         *        The remote ID for the Zixi-pull stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteId(String remoteId);

        /**
         * The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * 
         * @param smoothingLatency
         *        The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smoothingLatency(Integer smoothingLatency);

        /**
         * The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
         * 
         * @param streamId
         *        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConnectRequest.BuilderImpl implements Builder {
        private List<String> cidrAllowList = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String destination;

        private UpdateEncryption encryption;

        private String flowArn;

        private Integer maxLatency;

        private String outputArn;

        private Integer port;

        private String protocol;

        private String remoteId;

        private Integer smoothingLatency;

        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFlowOutputRequest model) {
            super(model);
            cidrAllowList(model.cidrAllowList);
            description(model.description);
            destination(model.destination);
            encryption(model.encryption);
            flowArn(model.flowArn);
            maxLatency(model.maxLatency);
            outputArn(model.outputArn);
            port(model.port);
            protocol(model.protocol);
            remoteId(model.remoteId);
            smoothingLatency(model.smoothingLatency);
            streamId(model.streamId);
        }

        public final Collection<String> getCidrAllowList() {
            return cidrAllowList;
        }

        @Override
        public final Builder cidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowList(String... cidrAllowList) {
            cidrAllowList(Arrays.asList(cidrAllowList));
            return this;
        }

        public final void setCidrAllowList(Collection<String> cidrAllowList) {
            this.cidrAllowList = ___listOf__stringCopier.copy(cidrAllowList);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final UpdateEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(UpdateEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(UpdateEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final String getFlowArn() {
            return flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        public final Integer getMaxLatency() {
            return maxLatency;
        }

        @Override
        public final Builder maxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
            return this;
        }

        public final void setMaxLatency(Integer maxLatency) {
            this.maxLatency = maxLatency;
        }

        public final String getOutputArn() {
            return outputArn;
        }

        @Override
        public final Builder outputArn(String outputArn) {
            this.outputArn = outputArn;
            return this;
        }

        public final void setOutputArn(String outputArn) {
            this.outputArn = outputArn;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getProtocolAsString() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRemoteId() {
            return remoteId;
        }

        @Override
        public final Builder remoteId(String remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public final void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public final Integer getSmoothingLatency() {
            return smoothingLatency;
        }

        @Override
        public final Builder smoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
            return this;
        }

        public final void setSmoothingLatency(Integer smoothingLatency) {
            this.smoothingLatency = smoothingLatency;
        }

        public final String getStreamId() {
            return streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFlowOutputRequest build() {
            return new UpdateFlowOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
