/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.DvbNitSettings;
import software.amazon.awssdk.services.mediaconvert.model.DvbSdtSettings;
import software.amazon.awssdk.services.mediaconvert.model.DvbTdtSettings;
import software.amazon.awssdk.services.mediaconvert.model.M2tsAudioBufferModel;
import software.amazon.awssdk.services.mediaconvert.model.M2tsAudioDuration;
import software.amazon.awssdk.services.mediaconvert.model.M2tsBufferModel;
import software.amazon.awssdk.services.mediaconvert.model.M2tsEbpAudioInterval;
import software.amazon.awssdk.services.mediaconvert.model.M2tsEbpPlacement;
import software.amazon.awssdk.services.mediaconvert.model.M2tsEsRateInPes;
import software.amazon.awssdk.services.mediaconvert.model.M2tsForceTsVideoEbpOrder;
import software.amazon.awssdk.services.mediaconvert.model.M2tsNielsenId3;
import software.amazon.awssdk.services.mediaconvert.model.M2tsPcrControl;
import software.amazon.awssdk.services.mediaconvert.model.M2tsRateMode;
import software.amazon.awssdk.services.mediaconvert.model.M2tsScte35Esam;
import software.amazon.awssdk.services.mediaconvert.model.M2tsScte35Source;
import software.amazon.awssdk.services.mediaconvert.model.M2tsSegmentationMarkers;
import software.amazon.awssdk.services.mediaconvert.model.M2tsSegmentationStyle;
import software.amazon.awssdk.services.mediaconvert.model.___listOf__integerMin32Max8182Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class M2tsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, M2tsSettings> {
    private static final SdkField<String> AUDIO_BUFFER_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioBufferModel").getter(M2tsSettings.getter(M2tsSettings::audioBufferModelAsString)).setter(M2tsSettings.setter(Builder::audioBufferModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioBufferModel").build()}).build();
    private static final SdkField<String> AUDIO_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioDuration").getter(M2tsSettings.getter(M2tsSettings::audioDurationAsString)).setter(M2tsSettings.setter(Builder::audioDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDuration").build()}).build();
    private static final SdkField<Integer> AUDIO_FRAMES_PER_PES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AudioFramesPerPes").getter(M2tsSettings.getter(M2tsSettings::audioFramesPerPes)).setter(M2tsSettings.setter(Builder::audioFramesPerPes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioFramesPerPes").build()}).build();
    private static final SdkField<List<Integer>> AUDIO_PIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioPids").getter(M2tsSettings.getter(M2tsSettings::audioPids)).setter(M2tsSettings.setter(Builder::audioPids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioPids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(M2tsSettings.getter(M2tsSettings::bitrate)).setter(M2tsSettings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> BUFFER_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BufferModel").getter(M2tsSettings.getter(M2tsSettings::bufferModelAsString)).setter(M2tsSettings.setter(Builder::bufferModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufferModel").build()}).build();
    private static final SdkField<DvbNitSettings> DVB_NIT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DvbNitSettings").getter(M2tsSettings.getter(M2tsSettings::dvbNitSettings)).setter(M2tsSettings.setter(Builder::dvbNitSettings)).constructor(DvbNitSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbNitSettings").build()}).build();
    private static final SdkField<DvbSdtSettings> DVB_SDT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DvbSdtSettings").getter(M2tsSettings.getter(M2tsSettings::dvbSdtSettings)).setter(M2tsSettings.setter(Builder::dvbSdtSettings)).constructor(DvbSdtSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSdtSettings").build()}).build();
    private static final SdkField<List<Integer>> DVB_SUB_PIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DvbSubPids").getter(M2tsSettings.getter(M2tsSettings::dvbSubPids)).setter(M2tsSettings.setter(Builder::dvbSubPids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubPids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DvbTdtSettings> DVB_TDT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DvbTdtSettings").getter(M2tsSettings.getter(M2tsSettings::dvbTdtSettings)).setter(M2tsSettings.setter(Builder::dvbTdtSettings)).constructor(DvbTdtSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbTdtSettings").build()}).build();
    private static final SdkField<Integer> DVB_TELETEXT_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DvbTeletextPid").getter(M2tsSettings.getter(M2tsSettings::dvbTeletextPid)).setter(M2tsSettings.setter(Builder::dvbTeletextPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbTeletextPid").build()}).build();
    private static final SdkField<String> EBP_AUDIO_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EbpAudioInterval").getter(M2tsSettings.getter(M2tsSettings::ebpAudioIntervalAsString)).setter(M2tsSettings.setter(Builder::ebpAudioInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebpAudioInterval").build()}).build();
    private static final SdkField<String> EBP_PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EbpPlacement").getter(M2tsSettings.getter(M2tsSettings::ebpPlacementAsString)).setter(M2tsSettings.setter(Builder::ebpPlacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebpPlacement").build()}).build();
    private static final SdkField<String> ES_RATE_IN_PES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EsRateInPes").getter(M2tsSettings.getter(M2tsSettings::esRateInPesAsString)).setter(M2tsSettings.setter(Builder::esRateInPes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("esRateInPes").build()}).build();
    private static final SdkField<String> FORCE_TS_VIDEO_EBP_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForceTsVideoEbpOrder").getter(M2tsSettings.getter(M2tsSettings::forceTsVideoEbpOrderAsString)).setter(M2tsSettings.setter(Builder::forceTsVideoEbpOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceTsVideoEbpOrder").build()}).build();
    private static final SdkField<Double> FRAGMENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FragmentTime").getter(M2tsSettings.getter(M2tsSettings::fragmentTime)).setter(M2tsSettings.setter(Builder::fragmentTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentTime").build()}).build();
    private static final SdkField<Integer> MAX_PCR_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxPcrInterval").getter(M2tsSettings.getter(M2tsSettings::maxPcrInterval)).setter(M2tsSettings.setter(Builder::maxPcrInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPcrInterval").build()}).build();
    private static final SdkField<Integer> MIN_EBP_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinEbpInterval").getter(M2tsSettings.getter(M2tsSettings::minEbpInterval)).setter(M2tsSettings.setter(Builder::minEbpInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minEbpInterval").build()}).build();
    private static final SdkField<String> NIELSEN_ID3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NielsenId3").getter(M2tsSettings.getter(M2tsSettings::nielsenId3AsString)).setter(M2tsSettings.setter(Builder::nielsenId3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3").build()}).build();
    private static final SdkField<Double> NULL_PACKET_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("NullPacketBitrate").getter(M2tsSettings.getter(M2tsSettings::nullPacketBitrate)).setter(M2tsSettings.setter(Builder::nullPacketBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nullPacketBitrate").build()}).build();
    private static final SdkField<Integer> PAT_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PatInterval").getter(M2tsSettings.getter(M2tsSettings::patInterval)).setter(M2tsSettings.setter(Builder::patInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patInterval").build()}).build();
    private static final SdkField<String> PCR_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PcrControl").getter(M2tsSettings.getter(M2tsSettings::pcrControlAsString)).setter(M2tsSettings.setter(Builder::pcrControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrControl").build()}).build();
    private static final SdkField<Integer> PCR_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PcrPid").getter(M2tsSettings.getter(M2tsSettings::pcrPid)).setter(M2tsSettings.setter(Builder::pcrPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPid").build()}).build();
    private static final SdkField<Integer> PMT_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PmtInterval").getter(M2tsSettings.getter(M2tsSettings::pmtInterval)).setter(M2tsSettings.setter(Builder::pmtInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtInterval").build()}).build();
    private static final SdkField<Integer> PMT_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PmtPid").getter(M2tsSettings.getter(M2tsSettings::pmtPid)).setter(M2tsSettings.setter(Builder::pmtPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtPid").build()}).build();
    private static final SdkField<Integer> PRIVATE_METADATA_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PrivateMetadataPid").getter(M2tsSettings.getter(M2tsSettings::privateMetadataPid)).setter(M2tsSettings.setter(Builder::privateMetadataPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateMetadataPid").build()}).build();
    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramNumber").getter(M2tsSettings.getter(M2tsSettings::programNumber)).setter(M2tsSettings.setter(Builder::programNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()}).build();
    private static final SdkField<String> RATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateMode").getter(M2tsSettings.getter(M2tsSettings::rateModeAsString)).setter(M2tsSettings.setter(Builder::rateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateMode").build()}).build();
    private static final SdkField<M2tsScte35Esam> SCTE35_ESAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scte35Esam").getter(M2tsSettings.getter(M2tsSettings::scte35Esam)).setter(M2tsSettings.setter(Builder::scte35Esam)).constructor(M2tsScte35Esam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Esam").build()}).build();
    private static final SdkField<Integer> SCTE35_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Scte35Pid").getter(M2tsSettings.getter(M2tsSettings::scte35Pid)).setter(M2tsSettings.setter(Builder::scte35Pid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Pid").build()}).build();
    private static final SdkField<String> SCTE35_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Source").getter(M2tsSettings.getter(M2tsSettings::scte35SourceAsString)).setter(M2tsSettings.setter(Builder::scte35Source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Source").build()}).build();
    private static final SdkField<String> SEGMENTATION_MARKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentationMarkers").getter(M2tsSettings.getter(M2tsSettings::segmentationMarkersAsString)).setter(M2tsSettings.setter(Builder::segmentationMarkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationMarkers").build()}).build();
    private static final SdkField<String> SEGMENTATION_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentationStyle").getter(M2tsSettings.getter(M2tsSettings::segmentationStyleAsString)).setter(M2tsSettings.setter(Builder::segmentationStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationStyle").build()}).build();
    private static final SdkField<Double> SEGMENTATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SegmentationTime").getter(M2tsSettings.getter(M2tsSettings::segmentationTime)).setter(M2tsSettings.setter(Builder::segmentationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationTime").build()}).build();
    private static final SdkField<Integer> TIMED_METADATA_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimedMetadataPid").getter(M2tsSettings.getter(M2tsSettings::timedMetadataPid)).setter(M2tsSettings.setter(Builder::timedMetadataPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataPid").build()}).build();
    private static final SdkField<Integer> TRANSPORT_STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransportStreamId").getter(M2tsSettings.getter(M2tsSettings::transportStreamId)).setter(M2tsSettings.setter(Builder::transportStreamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamId").build()}).build();
    private static final SdkField<Integer> VIDEO_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VideoPid").getter(M2tsSettings.getter(M2tsSettings::videoPid)).setter(M2tsSettings.setter(Builder::videoPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoPid").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_BUFFER_MODEL_FIELD, AUDIO_DURATION_FIELD, AUDIO_FRAMES_PER_PES_FIELD, AUDIO_PIDS_FIELD, BITRATE_FIELD, BUFFER_MODEL_FIELD, DVB_NIT_SETTINGS_FIELD, DVB_SDT_SETTINGS_FIELD, DVB_SUB_PIDS_FIELD, DVB_TDT_SETTINGS_FIELD, DVB_TELETEXT_PID_FIELD, EBP_AUDIO_INTERVAL_FIELD, EBP_PLACEMENT_FIELD, ES_RATE_IN_PES_FIELD, FORCE_TS_VIDEO_EBP_ORDER_FIELD, FRAGMENT_TIME_FIELD, MAX_PCR_INTERVAL_FIELD, MIN_EBP_INTERVAL_FIELD, NIELSEN_ID3_FIELD, NULL_PACKET_BITRATE_FIELD, PAT_INTERVAL_FIELD, PCR_CONTROL_FIELD, PCR_PID_FIELD, PMT_INTERVAL_FIELD, PMT_PID_FIELD, PRIVATE_METADATA_PID_FIELD, PROGRAM_NUMBER_FIELD, RATE_MODE_FIELD, SCTE35_ESAM_FIELD, SCTE35_PID_FIELD, SCTE35_SOURCE_FIELD, SEGMENTATION_MARKERS_FIELD, SEGMENTATION_STYLE_FIELD, SEGMENTATION_TIME_FIELD, TIMED_METADATA_PID_FIELD, TRANSPORT_STREAM_ID_FIELD, VIDEO_PID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioBufferModel;
    private final String audioDuration;
    private final Integer audioFramesPerPes;
    private final List<Integer> audioPids;
    private final Integer bitrate;
    private final String bufferModel;
    private final DvbNitSettings dvbNitSettings;
    private final DvbSdtSettings dvbSdtSettings;
    private final List<Integer> dvbSubPids;
    private final DvbTdtSettings dvbTdtSettings;
    private final Integer dvbTeletextPid;
    private final String ebpAudioInterval;
    private final String ebpPlacement;
    private final String esRateInPes;
    private final String forceTsVideoEbpOrder;
    private final Double fragmentTime;
    private final Integer maxPcrInterval;
    private final Integer minEbpInterval;
    private final String nielsenId3;
    private final Double nullPacketBitrate;
    private final Integer patInterval;
    private final String pcrControl;
    private final Integer pcrPid;
    private final Integer pmtInterval;
    private final Integer pmtPid;
    private final Integer privateMetadataPid;
    private final Integer programNumber;
    private final String rateMode;
    private final M2tsScte35Esam scte35Esam;
    private final Integer scte35Pid;
    private final String scte35Source;
    private final String segmentationMarkers;
    private final String segmentationStyle;
    private final Double segmentationTime;
    private final Integer timedMetadataPid;
    private final Integer transportStreamId;
    private final Integer videoPid;

    private M2tsSettings(BuilderImpl builder) {
        this.audioBufferModel = builder.audioBufferModel;
        this.audioDuration = builder.audioDuration;
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioPids = builder.audioPids;
        this.bitrate = builder.bitrate;
        this.bufferModel = builder.bufferModel;
        this.dvbNitSettings = builder.dvbNitSettings;
        this.dvbSdtSettings = builder.dvbSdtSettings;
        this.dvbSubPids = builder.dvbSubPids;
        this.dvbTdtSettings = builder.dvbTdtSettings;
        this.dvbTeletextPid = builder.dvbTeletextPid;
        this.ebpAudioInterval = builder.ebpAudioInterval;
        this.ebpPlacement = builder.ebpPlacement;
        this.esRateInPes = builder.esRateInPes;
        this.forceTsVideoEbpOrder = builder.forceTsVideoEbpOrder;
        this.fragmentTime = builder.fragmentTime;
        this.maxPcrInterval = builder.maxPcrInterval;
        this.minEbpInterval = builder.minEbpInterval;
        this.nielsenId3 = builder.nielsenId3;
        this.nullPacketBitrate = builder.nullPacketBitrate;
        this.patInterval = builder.patInterval;
        this.pcrControl = builder.pcrControl;
        this.pcrPid = builder.pcrPid;
        this.pmtInterval = builder.pmtInterval;
        this.pmtPid = builder.pmtPid;
        this.privateMetadataPid = builder.privateMetadataPid;
        this.programNumber = builder.programNumber;
        this.rateMode = builder.rateMode;
        this.scte35Esam = builder.scte35Esam;
        this.scte35Pid = builder.scte35Pid;
        this.scte35Source = builder.scte35Source;
        this.segmentationMarkers = builder.segmentationMarkers;
        this.segmentationStyle = builder.segmentationStyle;
        this.segmentationTime = builder.segmentationTime;
        this.timedMetadataPid = builder.timedMetadataPid;
        this.transportStreamId = builder.transportStreamId;
        this.videoPid = builder.videoPid;
    }

    public M2tsAudioBufferModel audioBufferModel() {
        return M2tsAudioBufferModel.fromValue(this.audioBufferModel);
    }

    public String audioBufferModelAsString() {
        return this.audioBufferModel;
    }

    public M2tsAudioDuration audioDuration() {
        return M2tsAudioDuration.fromValue(this.audioDuration);
    }

    public String audioDurationAsString() {
        return this.audioDuration;
    }

    public Integer audioFramesPerPes() {
        return this.audioFramesPerPes;
    }

    public boolean hasAudioPids() {
        return this.audioPids != null && !(this.audioPids instanceof SdkAutoConstructList);
    }

    public List<Integer> audioPids() {
        return this.audioPids;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public M2tsBufferModel bufferModel() {
        return M2tsBufferModel.fromValue(this.bufferModel);
    }

    public String bufferModelAsString() {
        return this.bufferModel;
    }

    public DvbNitSettings dvbNitSettings() {
        return this.dvbNitSettings;
    }

    public DvbSdtSettings dvbSdtSettings() {
        return this.dvbSdtSettings;
    }

    public boolean hasDvbSubPids() {
        return this.dvbSubPids != null && !(this.dvbSubPids instanceof SdkAutoConstructList);
    }

    public List<Integer> dvbSubPids() {
        return this.dvbSubPids;
    }

    public DvbTdtSettings dvbTdtSettings() {
        return this.dvbTdtSettings;
    }

    public Integer dvbTeletextPid() {
        return this.dvbTeletextPid;
    }

    public M2tsEbpAudioInterval ebpAudioInterval() {
        return M2tsEbpAudioInterval.fromValue(this.ebpAudioInterval);
    }

    public String ebpAudioIntervalAsString() {
        return this.ebpAudioInterval;
    }

    public M2tsEbpPlacement ebpPlacement() {
        return M2tsEbpPlacement.fromValue(this.ebpPlacement);
    }

    public String ebpPlacementAsString() {
        return this.ebpPlacement;
    }

    public M2tsEsRateInPes esRateInPes() {
        return M2tsEsRateInPes.fromValue(this.esRateInPes);
    }

    public String esRateInPesAsString() {
        return this.esRateInPes;
    }

    public M2tsForceTsVideoEbpOrder forceTsVideoEbpOrder() {
        return M2tsForceTsVideoEbpOrder.fromValue(this.forceTsVideoEbpOrder);
    }

    public String forceTsVideoEbpOrderAsString() {
        return this.forceTsVideoEbpOrder;
    }

    public Double fragmentTime() {
        return this.fragmentTime;
    }

    public Integer maxPcrInterval() {
        return this.maxPcrInterval;
    }

    public Integer minEbpInterval() {
        return this.minEbpInterval;
    }

    public M2tsNielsenId3 nielsenId3() {
        return M2tsNielsenId3.fromValue(this.nielsenId3);
    }

    public String nielsenId3AsString() {
        return this.nielsenId3;
    }

    public Double nullPacketBitrate() {
        return this.nullPacketBitrate;
    }

    public Integer patInterval() {
        return this.patInterval;
    }

    public M2tsPcrControl pcrControl() {
        return M2tsPcrControl.fromValue(this.pcrControl);
    }

    public String pcrControlAsString() {
        return this.pcrControl;
    }

    public Integer pcrPid() {
        return this.pcrPid;
    }

    public Integer pmtInterval() {
        return this.pmtInterval;
    }

    public Integer pmtPid() {
        return this.pmtPid;
    }

    public Integer privateMetadataPid() {
        return this.privateMetadataPid;
    }

    public Integer programNumber() {
        return this.programNumber;
    }

    public M2tsRateMode rateMode() {
        return M2tsRateMode.fromValue(this.rateMode);
    }

    public String rateModeAsString() {
        return this.rateMode;
    }

    public M2tsScte35Esam scte35Esam() {
        return this.scte35Esam;
    }

    public Integer scte35Pid() {
        return this.scte35Pid;
    }

    public M2tsScte35Source scte35Source() {
        return M2tsScte35Source.fromValue(this.scte35Source);
    }

    public String scte35SourceAsString() {
        return this.scte35Source;
    }

    public M2tsSegmentationMarkers segmentationMarkers() {
        return M2tsSegmentationMarkers.fromValue(this.segmentationMarkers);
    }

    public String segmentationMarkersAsString() {
        return this.segmentationMarkers;
    }

    public M2tsSegmentationStyle segmentationStyle() {
        return M2tsSegmentationStyle.fromValue(this.segmentationStyle);
    }

    public String segmentationStyleAsString() {
        return this.segmentationStyle;
    }

    public Double segmentationTime() {
        return this.segmentationTime;
    }

    public Integer timedMetadataPid() {
        return this.timedMetadataPid;
    }

    public Integer transportStreamId() {
        return this.transportStreamId;
    }

    public Integer videoPid() {
        return this.videoPid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioBufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioPids() ? this.audioPids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbNitSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSdtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDvbSubPids() ? this.dvbSubPids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbTdtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbTeletextPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebpAudioIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebpPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.esRateInPesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceTsVideoEbpOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPcrInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.minEbpInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenId3AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullPacketBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.patInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35Esam());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationMarkersAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoPid());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2tsSettings)) {
            return false;
        }
        M2tsSettings other = (M2tsSettings)obj;
        return Objects.equals(this.audioBufferModelAsString(), other.audioBufferModelAsString()) && Objects.equals(this.audioDurationAsString(), other.audioDurationAsString()) && Objects.equals(this.audioFramesPerPes(), other.audioFramesPerPes()) && this.hasAudioPids() == other.hasAudioPids() && Objects.equals(this.audioPids(), other.audioPids()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bufferModelAsString(), other.bufferModelAsString()) && Objects.equals(this.dvbNitSettings(), other.dvbNitSettings()) && Objects.equals(this.dvbSdtSettings(), other.dvbSdtSettings()) && this.hasDvbSubPids() == other.hasDvbSubPids() && Objects.equals(this.dvbSubPids(), other.dvbSubPids()) && Objects.equals(this.dvbTdtSettings(), other.dvbTdtSettings()) && Objects.equals(this.dvbTeletextPid(), other.dvbTeletextPid()) && Objects.equals(this.ebpAudioIntervalAsString(), other.ebpAudioIntervalAsString()) && Objects.equals(this.ebpPlacementAsString(), other.ebpPlacementAsString()) && Objects.equals(this.esRateInPesAsString(), other.esRateInPesAsString()) && Objects.equals(this.forceTsVideoEbpOrderAsString(), other.forceTsVideoEbpOrderAsString()) && Objects.equals(this.fragmentTime(), other.fragmentTime()) && Objects.equals(this.maxPcrInterval(), other.maxPcrInterval()) && Objects.equals(this.minEbpInterval(), other.minEbpInterval()) && Objects.equals(this.nielsenId3AsString(), other.nielsenId3AsString()) && Objects.equals(this.nullPacketBitrate(), other.nullPacketBitrate()) && Objects.equals(this.patInterval(), other.patInterval()) && Objects.equals(this.pcrControlAsString(), other.pcrControlAsString()) && Objects.equals(this.pcrPid(), other.pcrPid()) && Objects.equals(this.pmtInterval(), other.pmtInterval()) && Objects.equals(this.pmtPid(), other.pmtPid()) && Objects.equals(this.privateMetadataPid(), other.privateMetadataPid()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.rateModeAsString(), other.rateModeAsString()) && Objects.equals(this.scte35Esam(), other.scte35Esam()) && Objects.equals(this.scte35Pid(), other.scte35Pid()) && Objects.equals(this.scte35SourceAsString(), other.scte35SourceAsString()) && Objects.equals(this.segmentationMarkersAsString(), other.segmentationMarkersAsString()) && Objects.equals(this.segmentationStyleAsString(), other.segmentationStyleAsString()) && Objects.equals(this.segmentationTime(), other.segmentationTime()) && Objects.equals(this.timedMetadataPid(), other.timedMetadataPid()) && Objects.equals(this.transportStreamId(), other.transportStreamId()) && Objects.equals(this.videoPid(), other.videoPid());
    }

    public String toString() {
        return ToString.builder((String)"M2tsSettings").add("AudioBufferModel", (Object)this.audioBufferModelAsString()).add("AudioDuration", (Object)this.audioDurationAsString()).add("AudioFramesPerPes", (Object)this.audioFramesPerPes()).add("AudioPids", this.hasAudioPids() ? this.audioPids() : null).add("Bitrate", (Object)this.bitrate()).add("BufferModel", (Object)this.bufferModelAsString()).add("DvbNitSettings", (Object)this.dvbNitSettings()).add("DvbSdtSettings", (Object)this.dvbSdtSettings()).add("DvbSubPids", this.hasDvbSubPids() ? this.dvbSubPids() : null).add("DvbTdtSettings", (Object)this.dvbTdtSettings()).add("DvbTeletextPid", (Object)this.dvbTeletextPid()).add("EbpAudioInterval", (Object)this.ebpAudioIntervalAsString()).add("EbpPlacement", (Object)this.ebpPlacementAsString()).add("EsRateInPes", (Object)this.esRateInPesAsString()).add("ForceTsVideoEbpOrder", (Object)this.forceTsVideoEbpOrderAsString()).add("FragmentTime", (Object)this.fragmentTime()).add("MaxPcrInterval", (Object)this.maxPcrInterval()).add("MinEbpInterval", (Object)this.minEbpInterval()).add("NielsenId3", (Object)this.nielsenId3AsString()).add("NullPacketBitrate", (Object)this.nullPacketBitrate()).add("PatInterval", (Object)this.patInterval()).add("PcrControl", (Object)this.pcrControlAsString()).add("PcrPid", (Object)this.pcrPid()).add("PmtInterval", (Object)this.pmtInterval()).add("PmtPid", (Object)this.pmtPid()).add("PrivateMetadataPid", (Object)this.privateMetadataPid()).add("ProgramNumber", (Object)this.programNumber()).add("RateMode", (Object)this.rateModeAsString()).add("Scte35Esam", (Object)this.scte35Esam()).add("Scte35Pid", (Object)this.scte35Pid()).add("Scte35Source", (Object)this.scte35SourceAsString()).add("SegmentationMarkers", (Object)this.segmentationMarkersAsString()).add("SegmentationStyle", (Object)this.segmentationStyleAsString()).add("SegmentationTime", (Object)this.segmentationTime()).add("TimedMetadataPid", (Object)this.timedMetadataPid()).add("TransportStreamId", (Object)this.transportStreamId()).add("VideoPid", (Object)this.videoPid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioBufferModel": {
                return Optional.ofNullable(clazz.cast(this.audioBufferModelAsString()));
            }
            case "AudioDuration": {
                return Optional.ofNullable(clazz.cast(this.audioDurationAsString()));
            }
            case "AudioFramesPerPes": {
                return Optional.ofNullable(clazz.cast(this.audioFramesPerPes()));
            }
            case "AudioPids": {
                return Optional.ofNullable(clazz.cast(this.audioPids()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "BufferModel": {
                return Optional.ofNullable(clazz.cast(this.bufferModelAsString()));
            }
            case "DvbNitSettings": {
                return Optional.ofNullable(clazz.cast(this.dvbNitSettings()));
            }
            case "DvbSdtSettings": {
                return Optional.ofNullable(clazz.cast(this.dvbSdtSettings()));
            }
            case "DvbSubPids": {
                return Optional.ofNullable(clazz.cast(this.dvbSubPids()));
            }
            case "DvbTdtSettings": {
                return Optional.ofNullable(clazz.cast(this.dvbTdtSettings()));
            }
            case "DvbTeletextPid": {
                return Optional.ofNullable(clazz.cast(this.dvbTeletextPid()));
            }
            case "EbpAudioInterval": {
                return Optional.ofNullable(clazz.cast(this.ebpAudioIntervalAsString()));
            }
            case "EbpPlacement": {
                return Optional.ofNullable(clazz.cast(this.ebpPlacementAsString()));
            }
            case "EsRateInPes": {
                return Optional.ofNullable(clazz.cast(this.esRateInPesAsString()));
            }
            case "ForceTsVideoEbpOrder": {
                return Optional.ofNullable(clazz.cast(this.forceTsVideoEbpOrderAsString()));
            }
            case "FragmentTime": {
                return Optional.ofNullable(clazz.cast(this.fragmentTime()));
            }
            case "MaxPcrInterval": {
                return Optional.ofNullable(clazz.cast(this.maxPcrInterval()));
            }
            case "MinEbpInterval": {
                return Optional.ofNullable(clazz.cast(this.minEbpInterval()));
            }
            case "NielsenId3": {
                return Optional.ofNullable(clazz.cast(this.nielsenId3AsString()));
            }
            case "NullPacketBitrate": {
                return Optional.ofNullable(clazz.cast(this.nullPacketBitrate()));
            }
            case "PatInterval": {
                return Optional.ofNullable(clazz.cast(this.patInterval()));
            }
            case "PcrControl": {
                return Optional.ofNullable(clazz.cast(this.pcrControlAsString()));
            }
            case "PcrPid": {
                return Optional.ofNullable(clazz.cast(this.pcrPid()));
            }
            case "PmtInterval": {
                return Optional.ofNullable(clazz.cast(this.pmtInterval()));
            }
            case "PmtPid": {
                return Optional.ofNullable(clazz.cast(this.pmtPid()));
            }
            case "PrivateMetadataPid": {
                return Optional.ofNullable(clazz.cast(this.privateMetadataPid()));
            }
            case "ProgramNumber": {
                return Optional.ofNullable(clazz.cast(this.programNumber()));
            }
            case "RateMode": {
                return Optional.ofNullable(clazz.cast(this.rateModeAsString()));
            }
            case "Scte35Esam": {
                return Optional.ofNullable(clazz.cast(this.scte35Esam()));
            }
            case "Scte35Pid": {
                return Optional.ofNullable(clazz.cast(this.scte35Pid()));
            }
            case "Scte35Source": {
                return Optional.ofNullable(clazz.cast(this.scte35SourceAsString()));
            }
            case "SegmentationMarkers": {
                return Optional.ofNullable(clazz.cast(this.segmentationMarkersAsString()));
            }
            case "SegmentationStyle": {
                return Optional.ofNullable(clazz.cast(this.segmentationStyleAsString()));
            }
            case "SegmentationTime": {
                return Optional.ofNullable(clazz.cast(this.segmentationTime()));
            }
            case "TimedMetadataPid": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataPid()));
            }
            case "TransportStreamId": {
                return Optional.ofNullable(clazz.cast(this.transportStreamId()));
            }
            case "VideoPid": {
                return Optional.ofNullable(clazz.cast(this.videoPid()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<M2tsSettings, T> g) {
        return obj -> g.apply((M2tsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioBufferModel;
        private String audioDuration;
        private Integer audioFramesPerPes;
        private List<Integer> audioPids = DefaultSdkAutoConstructList.getInstance();
        private Integer bitrate;
        private String bufferModel;
        private DvbNitSettings dvbNitSettings;
        private DvbSdtSettings dvbSdtSettings;
        private List<Integer> dvbSubPids = DefaultSdkAutoConstructList.getInstance();
        private DvbTdtSettings dvbTdtSettings;
        private Integer dvbTeletextPid;
        private String ebpAudioInterval;
        private String ebpPlacement;
        private String esRateInPes;
        private String forceTsVideoEbpOrder;
        private Double fragmentTime;
        private Integer maxPcrInterval;
        private Integer minEbpInterval;
        private String nielsenId3;
        private Double nullPacketBitrate;
        private Integer patInterval;
        private String pcrControl;
        private Integer pcrPid;
        private Integer pmtInterval;
        private Integer pmtPid;
        private Integer privateMetadataPid;
        private Integer programNumber;
        private String rateMode;
        private M2tsScte35Esam scte35Esam;
        private Integer scte35Pid;
        private String scte35Source;
        private String segmentationMarkers;
        private String segmentationStyle;
        private Double segmentationTime;
        private Integer timedMetadataPid;
        private Integer transportStreamId;
        private Integer videoPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M2tsSettings model) {
            this.audioBufferModel(model.audioBufferModel);
            this.audioDuration(model.audioDuration);
            this.audioFramesPerPes(model.audioFramesPerPes);
            this.audioPids(model.audioPids);
            this.bitrate(model.bitrate);
            this.bufferModel(model.bufferModel);
            this.dvbNitSettings(model.dvbNitSettings);
            this.dvbSdtSettings(model.dvbSdtSettings);
            this.dvbSubPids(model.dvbSubPids);
            this.dvbTdtSettings(model.dvbTdtSettings);
            this.dvbTeletextPid(model.dvbTeletextPid);
            this.ebpAudioInterval(model.ebpAudioInterval);
            this.ebpPlacement(model.ebpPlacement);
            this.esRateInPes(model.esRateInPes);
            this.forceTsVideoEbpOrder(model.forceTsVideoEbpOrder);
            this.fragmentTime(model.fragmentTime);
            this.maxPcrInterval(model.maxPcrInterval);
            this.minEbpInterval(model.minEbpInterval);
            this.nielsenId3(model.nielsenId3);
            this.nullPacketBitrate(model.nullPacketBitrate);
            this.patInterval(model.patInterval);
            this.pcrControl(model.pcrControl);
            this.pcrPid(model.pcrPid);
            this.pmtInterval(model.pmtInterval);
            this.pmtPid(model.pmtPid);
            this.privateMetadataPid(model.privateMetadataPid);
            this.programNumber(model.programNumber);
            this.rateMode(model.rateMode);
            this.scte35Esam(model.scte35Esam);
            this.scte35Pid(model.scte35Pid);
            this.scte35Source(model.scte35Source);
            this.segmentationMarkers(model.segmentationMarkers);
            this.segmentationStyle(model.segmentationStyle);
            this.segmentationTime(model.segmentationTime);
            this.timedMetadataPid(model.timedMetadataPid);
            this.transportStreamId(model.transportStreamId);
            this.videoPid(model.videoPid);
        }

        public final String getAudioBufferModel() {
            return this.audioBufferModel;
        }

        @Override
        public final Builder audioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
            return this;
        }

        @Override
        public final Builder audioBufferModel(M2tsAudioBufferModel audioBufferModel) {
            this.audioBufferModel(audioBufferModel == null ? null : audioBufferModel.toString());
            return this;
        }

        public final void setAudioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
        }

        public final String getAudioDuration() {
            return this.audioDuration;
        }

        @Override
        public final Builder audioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public final Builder audioDuration(M2tsAudioDuration audioDuration) {
            this.audioDuration(audioDuration == null ? null : audioDuration.toString());
            return this;
        }

        public final void setAudioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
        }

        public final Integer getAudioFramesPerPes() {
            return this.audioFramesPerPes;
        }

        @Override
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        public final Collection<Integer> getAudioPids() {
            if (this.audioPids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audioPids;
        }

        @Override
        public final Builder audioPids(Collection<Integer> audioPids) {
            this.audioPids = ___listOf__integerMin32Max8182Copier.copy(audioPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioPids(Integer ... audioPids) {
            this.audioPids(Arrays.asList(audioPids));
            return this;
        }

        public final void setAudioPids(Collection<Integer> audioPids) {
            this.audioPids = ___listOf__integerMin32Max8182Copier.copy(audioPids);
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getBufferModel() {
            return this.bufferModel;
        }

        @Override
        public final Builder bufferModel(String bufferModel) {
            this.bufferModel = bufferModel;
            return this;
        }

        @Override
        public final Builder bufferModel(M2tsBufferModel bufferModel) {
            this.bufferModel(bufferModel == null ? null : bufferModel.toString());
            return this;
        }

        public final void setBufferModel(String bufferModel) {
            this.bufferModel = bufferModel;
        }

        public final DvbNitSettings.Builder getDvbNitSettings() {
            return this.dvbNitSettings != null ? this.dvbNitSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbNitSettings(DvbNitSettings dvbNitSettings) {
            this.dvbNitSettings = dvbNitSettings;
            return this;
        }

        public final void setDvbNitSettings(DvbNitSettings.BuilderImpl dvbNitSettings) {
            this.dvbNitSettings = dvbNitSettings != null ? dvbNitSettings.build() : null;
        }

        public final DvbSdtSettings.Builder getDvbSdtSettings() {
            return this.dvbSdtSettings != null ? this.dvbSdtSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSdtSettings(DvbSdtSettings dvbSdtSettings) {
            this.dvbSdtSettings = dvbSdtSettings;
            return this;
        }

        public final void setDvbSdtSettings(DvbSdtSettings.BuilderImpl dvbSdtSettings) {
            this.dvbSdtSettings = dvbSdtSettings != null ? dvbSdtSettings.build() : null;
        }

        public final Collection<Integer> getDvbSubPids() {
            if (this.dvbSubPids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dvbSubPids;
        }

        @Override
        public final Builder dvbSubPids(Collection<Integer> dvbSubPids) {
            this.dvbSubPids = ___listOf__integerMin32Max8182Copier.copy(dvbSubPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dvbSubPids(Integer ... dvbSubPids) {
            this.dvbSubPids(Arrays.asList(dvbSubPids));
            return this;
        }

        public final void setDvbSubPids(Collection<Integer> dvbSubPids) {
            this.dvbSubPids = ___listOf__integerMin32Max8182Copier.copy(dvbSubPids);
        }

        public final DvbTdtSettings.Builder getDvbTdtSettings() {
            return this.dvbTdtSettings != null ? this.dvbTdtSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbTdtSettings(DvbTdtSettings dvbTdtSettings) {
            this.dvbTdtSettings = dvbTdtSettings;
            return this;
        }

        public final void setDvbTdtSettings(DvbTdtSettings.BuilderImpl dvbTdtSettings) {
            this.dvbTdtSettings = dvbTdtSettings != null ? dvbTdtSettings.build() : null;
        }

        public final Integer getDvbTeletextPid() {
            return this.dvbTeletextPid;
        }

        @Override
        public final Builder dvbTeletextPid(Integer dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
            return this;
        }

        public final void setDvbTeletextPid(Integer dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
        }

        public final String getEbpAudioInterval() {
            return this.ebpAudioInterval;
        }

        @Override
        public final Builder ebpAudioInterval(String ebpAudioInterval) {
            this.ebpAudioInterval = ebpAudioInterval;
            return this;
        }

        @Override
        public final Builder ebpAudioInterval(M2tsEbpAudioInterval ebpAudioInterval) {
            this.ebpAudioInterval(ebpAudioInterval == null ? null : ebpAudioInterval.toString());
            return this;
        }

        public final void setEbpAudioInterval(String ebpAudioInterval) {
            this.ebpAudioInterval = ebpAudioInterval;
        }

        public final String getEbpPlacement() {
            return this.ebpPlacement;
        }

        @Override
        public final Builder ebpPlacement(String ebpPlacement) {
            this.ebpPlacement = ebpPlacement;
            return this;
        }

        @Override
        public final Builder ebpPlacement(M2tsEbpPlacement ebpPlacement) {
            this.ebpPlacement(ebpPlacement == null ? null : ebpPlacement.toString());
            return this;
        }

        public final void setEbpPlacement(String ebpPlacement) {
            this.ebpPlacement = ebpPlacement;
        }

        public final String getEsRateInPes() {
            return this.esRateInPes;
        }

        @Override
        public final Builder esRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
            return this;
        }

        @Override
        public final Builder esRateInPes(M2tsEsRateInPes esRateInPes) {
            this.esRateInPes(esRateInPes == null ? null : esRateInPes.toString());
            return this;
        }

        public final void setEsRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
        }

        public final String getForceTsVideoEbpOrder() {
            return this.forceTsVideoEbpOrder;
        }

        @Override
        public final Builder forceTsVideoEbpOrder(String forceTsVideoEbpOrder) {
            this.forceTsVideoEbpOrder = forceTsVideoEbpOrder;
            return this;
        }

        @Override
        public final Builder forceTsVideoEbpOrder(M2tsForceTsVideoEbpOrder forceTsVideoEbpOrder) {
            this.forceTsVideoEbpOrder(forceTsVideoEbpOrder == null ? null : forceTsVideoEbpOrder.toString());
            return this;
        }

        public final void setForceTsVideoEbpOrder(String forceTsVideoEbpOrder) {
            this.forceTsVideoEbpOrder = forceTsVideoEbpOrder;
        }

        public final Double getFragmentTime() {
            return this.fragmentTime;
        }

        @Override
        public final Builder fragmentTime(Double fragmentTime) {
            this.fragmentTime = fragmentTime;
            return this;
        }

        public final void setFragmentTime(Double fragmentTime) {
            this.fragmentTime = fragmentTime;
        }

        public final Integer getMaxPcrInterval() {
            return this.maxPcrInterval;
        }

        @Override
        public final Builder maxPcrInterval(Integer maxPcrInterval) {
            this.maxPcrInterval = maxPcrInterval;
            return this;
        }

        public final void setMaxPcrInterval(Integer maxPcrInterval) {
            this.maxPcrInterval = maxPcrInterval;
        }

        public final Integer getMinEbpInterval() {
            return this.minEbpInterval;
        }

        @Override
        public final Builder minEbpInterval(Integer minEbpInterval) {
            this.minEbpInterval = minEbpInterval;
            return this;
        }

        public final void setMinEbpInterval(Integer minEbpInterval) {
            this.minEbpInterval = minEbpInterval;
        }

        public final String getNielsenId3() {
            return this.nielsenId3;
        }

        @Override
        public final Builder nielsenId3(String nielsenId3) {
            this.nielsenId3 = nielsenId3;
            return this;
        }

        @Override
        public final Builder nielsenId3(M2tsNielsenId3 nielsenId3) {
            this.nielsenId3(nielsenId3 == null ? null : nielsenId3.toString());
            return this;
        }

        public final void setNielsenId3(String nielsenId3) {
            this.nielsenId3 = nielsenId3;
        }

        public final Double getNullPacketBitrate() {
            return this.nullPacketBitrate;
        }

        @Override
        public final Builder nullPacketBitrate(Double nullPacketBitrate) {
            this.nullPacketBitrate = nullPacketBitrate;
            return this;
        }

        public final void setNullPacketBitrate(Double nullPacketBitrate) {
            this.nullPacketBitrate = nullPacketBitrate;
        }

        public final Integer getPatInterval() {
            return this.patInterval;
        }

        @Override
        public final Builder patInterval(Integer patInterval) {
            this.patInterval = patInterval;
            return this;
        }

        public final void setPatInterval(Integer patInterval) {
            this.patInterval = patInterval;
        }

        public final String getPcrControl() {
            return this.pcrControl;
        }

        @Override
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        public final Builder pcrControl(M2tsPcrControl pcrControl) {
            this.pcrControl(pcrControl == null ? null : pcrControl.toString());
            return this;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        public final Integer getPcrPid() {
            return this.pcrPid;
        }

        @Override
        public final Builder pcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final void setPcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
        }

        public final Integer getPmtInterval() {
            return this.pmtInterval;
        }

        @Override
        public final Builder pmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
            return this;
        }

        public final void setPmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
        }

        public final Integer getPmtPid() {
            return this.pmtPid;
        }

        @Override
        public final Builder pmtPid(Integer pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final void setPmtPid(Integer pmtPid) {
            this.pmtPid = pmtPid;
        }

        public final Integer getPrivateMetadataPid() {
            return this.privateMetadataPid;
        }

        @Override
        public final Builder privateMetadataPid(Integer privateMetadataPid) {
            this.privateMetadataPid = privateMetadataPid;
            return this;
        }

        public final void setPrivateMetadataPid(Integer privateMetadataPid) {
            this.privateMetadataPid = privateMetadataPid;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public final String getRateMode() {
            return this.rateMode;
        }

        @Override
        public final Builder rateMode(String rateMode) {
            this.rateMode = rateMode;
            return this;
        }

        @Override
        public final Builder rateMode(M2tsRateMode rateMode) {
            this.rateMode(rateMode == null ? null : rateMode.toString());
            return this;
        }

        public final void setRateMode(String rateMode) {
            this.rateMode = rateMode;
        }

        public final M2tsScte35Esam.Builder getScte35Esam() {
            return this.scte35Esam != null ? this.scte35Esam.toBuilder() : null;
        }

        @Override
        public final Builder scte35Esam(M2tsScte35Esam scte35Esam) {
            this.scte35Esam = scte35Esam;
            return this;
        }

        public final void setScte35Esam(M2tsScte35Esam.BuilderImpl scte35Esam) {
            this.scte35Esam = scte35Esam != null ? scte35Esam.build() : null;
        }

        public final Integer getScte35Pid() {
            return this.scte35Pid;
        }

        @Override
        public final Builder scte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final void setScte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        public final String getScte35Source() {
            return this.scte35Source;
        }

        @Override
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        public final Builder scte35Source(M2tsScte35Source scte35Source) {
            this.scte35Source(scte35Source == null ? null : scte35Source.toString());
            return this;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        public final String getSegmentationMarkers() {
            return this.segmentationMarkers;
        }

        @Override
        public final Builder segmentationMarkers(String segmentationMarkers) {
            this.segmentationMarkers = segmentationMarkers;
            return this;
        }

        @Override
        public final Builder segmentationMarkers(M2tsSegmentationMarkers segmentationMarkers) {
            this.segmentationMarkers(segmentationMarkers == null ? null : segmentationMarkers.toString());
            return this;
        }

        public final void setSegmentationMarkers(String segmentationMarkers) {
            this.segmentationMarkers = segmentationMarkers;
        }

        public final String getSegmentationStyle() {
            return this.segmentationStyle;
        }

        @Override
        public final Builder segmentationStyle(String segmentationStyle) {
            this.segmentationStyle = segmentationStyle;
            return this;
        }

        @Override
        public final Builder segmentationStyle(M2tsSegmentationStyle segmentationStyle) {
            this.segmentationStyle(segmentationStyle == null ? null : segmentationStyle.toString());
            return this;
        }

        public final void setSegmentationStyle(String segmentationStyle) {
            this.segmentationStyle = segmentationStyle;
        }

        public final Double getSegmentationTime() {
            return this.segmentationTime;
        }

        @Override
        public final Builder segmentationTime(Double segmentationTime) {
            this.segmentationTime = segmentationTime;
            return this;
        }

        public final void setSegmentationTime(Double segmentationTime) {
            this.segmentationTime = segmentationTime;
        }

        public final Integer getTimedMetadataPid() {
            return this.timedMetadataPid;
        }

        @Override
        public final Builder timedMetadataPid(Integer timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
            return this;
        }

        public final void setTimedMetadataPid(Integer timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
        }

        public final Integer getTransportStreamId() {
            return this.transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final Integer getVideoPid() {
            return this.videoPid;
        }

        @Override
        public final Builder videoPid(Integer videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        public final void setVideoPid(Integer videoPid) {
            this.videoPid = videoPid;
        }

        public M2tsSettings build() {
            return new M2tsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, M2tsSettings> {
        public Builder audioBufferModel(String var1);

        public Builder audioBufferModel(M2tsAudioBufferModel var1);

        public Builder audioDuration(String var1);

        public Builder audioDuration(M2tsAudioDuration var1);

        public Builder audioFramesPerPes(Integer var1);

        public Builder audioPids(Collection<Integer> var1);

        public Builder audioPids(Integer ... var1);

        public Builder bitrate(Integer var1);

        public Builder bufferModel(String var1);

        public Builder bufferModel(M2tsBufferModel var1);

        public Builder dvbNitSettings(DvbNitSettings var1);

        default public Builder dvbNitSettings(Consumer<DvbNitSettings.Builder> dvbNitSettings) {
            return this.dvbNitSettings((DvbNitSettings)((DvbNitSettings.Builder)DvbNitSettings.builder().applyMutation(dvbNitSettings)).build());
        }

        public Builder dvbSdtSettings(DvbSdtSettings var1);

        default public Builder dvbSdtSettings(Consumer<DvbSdtSettings.Builder> dvbSdtSettings) {
            return this.dvbSdtSettings((DvbSdtSettings)((DvbSdtSettings.Builder)DvbSdtSettings.builder().applyMutation(dvbSdtSettings)).build());
        }

        public Builder dvbSubPids(Collection<Integer> var1);

        public Builder dvbSubPids(Integer ... var1);

        public Builder dvbTdtSettings(DvbTdtSettings var1);

        default public Builder dvbTdtSettings(Consumer<DvbTdtSettings.Builder> dvbTdtSettings) {
            return this.dvbTdtSettings((DvbTdtSettings)((DvbTdtSettings.Builder)DvbTdtSettings.builder().applyMutation(dvbTdtSettings)).build());
        }

        public Builder dvbTeletextPid(Integer var1);

        public Builder ebpAudioInterval(String var1);

        public Builder ebpAudioInterval(M2tsEbpAudioInterval var1);

        public Builder ebpPlacement(String var1);

        public Builder ebpPlacement(M2tsEbpPlacement var1);

        public Builder esRateInPes(String var1);

        public Builder esRateInPes(M2tsEsRateInPes var1);

        public Builder forceTsVideoEbpOrder(String var1);

        public Builder forceTsVideoEbpOrder(M2tsForceTsVideoEbpOrder var1);

        public Builder fragmentTime(Double var1);

        public Builder maxPcrInterval(Integer var1);

        public Builder minEbpInterval(Integer var1);

        public Builder nielsenId3(String var1);

        public Builder nielsenId3(M2tsNielsenId3 var1);

        public Builder nullPacketBitrate(Double var1);

        public Builder patInterval(Integer var1);

        public Builder pcrControl(String var1);

        public Builder pcrControl(M2tsPcrControl var1);

        public Builder pcrPid(Integer var1);

        public Builder pmtInterval(Integer var1);

        public Builder pmtPid(Integer var1);

        public Builder privateMetadataPid(Integer var1);

        public Builder programNumber(Integer var1);

        public Builder rateMode(String var1);

        public Builder rateMode(M2tsRateMode var1);

        public Builder scte35Esam(M2tsScte35Esam var1);

        default public Builder scte35Esam(Consumer<M2tsScte35Esam.Builder> scte35Esam) {
            return this.scte35Esam((M2tsScte35Esam)((M2tsScte35Esam.Builder)M2tsScte35Esam.builder().applyMutation(scte35Esam)).build());
        }

        public Builder scte35Pid(Integer var1);

        public Builder scte35Source(String var1);

        public Builder scte35Source(M2tsScte35Source var1);

        public Builder segmentationMarkers(String var1);

        public Builder segmentationMarkers(M2tsSegmentationMarkers var1);

        public Builder segmentationStyle(String var1);

        public Builder segmentationStyle(M2tsSegmentationStyle var1);

        public Builder segmentationTime(Double var1);

        public Builder timedMetadataPid(Integer var1);

        public Builder transportStreamId(Integer var1);

        public Builder videoPid(Integer var1);
    }
}

