/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpusSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpusSettings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(OpusSettings.getter(OpusSettings::bitrate)).setter(OpusSettings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Channels").getter(OpusSettings.getter(OpusSettings::channels)).setter(OpusSettings.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleRate").getter(OpusSettings.getter(OpusSettings::sampleRate)).setter(OpusSettings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, CHANNELS_FIELD, SAMPLE_RATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer bitrate;
    private final Integer channels;
    private final Integer sampleRate;

    private OpusSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.channels = builder.channels;
        this.sampleRate = builder.sampleRate;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public Integer channels() {
        return this.channels;
    }

    public Integer sampleRate() {
        return this.sampleRate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpusSettings)) {
            return false;
        }
        OpusSettings other = (OpusSettings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.sampleRate(), other.sampleRate());
    }

    public String toString() {
        return ToString.builder((String)"OpusSettings").add("Bitrate", (Object)this.bitrate()).add("Channels", (Object)this.channels()).add("SampleRate", (Object)this.sampleRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpusSettings, T> g) {
        return obj -> g.apply((OpusSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitrate;
        private Integer channels;
        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(OpusSettings model) {
            this.bitrate(model.bitrate);
            this.channels(model.channels);
            this.sampleRate(model.sampleRate);
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final Integer getChannels() {
            return this.channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        public OpusSettings build() {
            return new OpusSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpusSettings> {
        public Builder bitrate(Integer var1);

        public Builder channels(Integer var1);

        public Builder sampleRate(Integer var1);
    }
}

