/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MxfProfile {
    D_10("D_10"),
    XDCAM("XDCAM"),
    OP1_A("OP1A"),
    XAVC("XAVC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MxfProfile(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MxfProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MxfProfile.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MxfProfile> knownValues() {
        return Stream.of(MxfProfile.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

