/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts one of
 * two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the value of Bitrate
 * control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality with the setting VBR
 * quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and valid values depend on the
 * rate control mode.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AacSettings implements SdkPojo, Serializable, ToCopyableBuilder<AacSettings.Builder, AacSettings> {
    private static final SdkField<String> AUDIO_DESCRIPTION_BROADCASTER_MIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AudioDescriptionBroadcasterMix")
            .getter(getter(AacSettings::audioDescriptionBroadcasterMixAsString))
            .setter(setter(Builder::audioDescriptionBroadcasterMix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptionBroadcasterMix")
                    .build()).build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(AacSettings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecProfile").getter(getter(AacSettings::codecProfileAsString)).setter(setter(Builder::codecProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodingMode").getter(getter(AacSettings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateControlMode").getter(getter(AacSettings::rateControlModeAsString))
            .setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<String> RAW_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RawFormat").getter(getter(AacSettings::rawFormatAsString)).setter(setter(Builder::rawFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawFormat").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleRate").getter(getter(AacSettings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final SdkField<String> SPECIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Specification").getter(getter(AacSettings::specificationAsString))
            .setter(setter(Builder::specification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specification").build()).build();

    private static final SdkField<String> VBR_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VbrQuality").getter(getter(AacSettings::vbrQualityAsString)).setter(setter(Builder::vbrQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vbrQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUDIO_DESCRIPTION_BROADCASTER_MIX_FIELD, BITRATE_FIELD, CODEC_PROFILE_FIELD, CODING_MODE_FIELD,
            RATE_CONTROL_MODE_FIELD, RAW_FORMAT_FIELD, SAMPLE_RATE_FIELD, SPECIFICATION_FIELD, VBR_QUALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioDescriptionBroadcasterMix;

    private final Integer bitrate;

    private final String codecProfile;

    private final String codingMode;

    private final String rateControlMode;

    private final String rawFormat;

    private final Integer sampleRate;

    private final String specification;

    private final String vbrQuality;

    private AacSettings(BuilderImpl builder) {
        this.audioDescriptionBroadcasterMix = builder.audioDescriptionBroadcasterMix;
        this.bitrate = builder.bitrate;
        this.codecProfile = builder.codecProfile;
        this.codingMode = builder.codingMode;
        this.rateControlMode = builder.rateControlMode;
        this.rawFormat = builder.rawFormat;
        this.sampleRate = builder.sampleRate;
        this.specification = builder.specification;
        this.vbrQuality = builder.vbrQuality;
    }

    /**
     * Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo
     * pair. The value for AudioType will be set to 3, which signals to downstream systems that this stream contains
     * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder
     * does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide in
     * AudioType and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio
     * description (AD). In this case, the encoder will use any values you provide for AudioType and
     * FollowInputAudioType.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioDescriptionBroadcasterMix} will return
     * {@link AacAudioDescriptionBroadcasterMix#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioDescriptionBroadcasterMixAsString}.
     * </p>
     * 
     * @return Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a
     *         stereo pair. The value for AudioType will be set to 3, which signals to downstream systems that this
     *         stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain
     *         pre-mixed audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the
     *         encoder ignores any values you provide in AudioType and FollowInputAudioType. Choose NORMAL when the
     *         input does not contain pre-mixed audio + audio description (AD). In this case, the encoder will use any
     *         values you provide for AudioType and FollowInputAudioType.
     * @see AacAudioDescriptionBroadcasterMix
     */
    public final AacAudioDescriptionBroadcasterMix audioDescriptionBroadcasterMix() {
        return AacAudioDescriptionBroadcasterMix.fromValue(audioDescriptionBroadcasterMix);
    }

    /**
     * Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo
     * pair. The value for AudioType will be set to 3, which signals to downstream systems that this stream contains
     * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder
     * does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide in
     * AudioType and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio
     * description (AD). In this case, the encoder will use any values you provide for AudioType and
     * FollowInputAudioType.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioDescriptionBroadcasterMix} will return
     * {@link AacAudioDescriptionBroadcasterMix#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioDescriptionBroadcasterMixAsString}.
     * </p>
     * 
     * @return Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a
     *         stereo pair. The value for AudioType will be set to 3, which signals to downstream systems that this
     *         stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain
     *         pre-mixed audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the
     *         encoder ignores any values you provide in AudioType and FollowInputAudioType. Choose NORMAL when the
     *         input does not contain pre-mixed audio + audio description (AD). In this case, the encoder will use any
     *         values you provide for AudioType and FollowInputAudioType.
     * @see AacAudioDescriptionBroadcasterMix
     */
    public final String audioDescriptionBroadcasterMixAsString() {
        return audioDescriptionBroadcasterMix;
    }

    /**
     * Specify the average bitrate in bits per second. The set of valid values for this setting is: 6000, 8000, 10000,
     * 12000, 14000, 16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000,
     * 160000, 192000, 224000, 256000, 288000, 320000, 384000, 448000, 512000, 576000, 640000, 768000, 896000, 1024000.
     * The value you set is also constrained by the values that you choose for Profile (codecProfile), Bitrate control
     * mode (codingMode), and Sample rate (sampleRate). Default values depend on Bitrate control mode and Profile.
     * 
     * @return Specify the average bitrate in bits per second. The set of valid values for this setting is: 6000, 8000,
     *         10000, 12000, 14000, 16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000,
     *         128000, 160000, 192000, 224000, 256000, 288000, 320000, 384000, 448000, 512000, 576000, 640000, 768000,
     *         896000, 1024000. The value you set is also constrained by the values that you choose for Profile
     *         (codecProfile), Bitrate control mode (codingMode), and Sample rate (sampleRate). Default values depend on
     *         Bitrate control mode and Profile.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * AAC Profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link AacCodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return AAC Profile.
     * @see AacCodecProfile
     */
    public final AacCodecProfile codecProfile() {
        return AacCodecProfile.fromValue(codecProfile);
    }

    /**
     * AAC Profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link AacCodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return AAC Profile.
     * @see AacCodecProfile
     */
    public final String codecProfileAsString() {
        return codecProfile;
    }

    /**
     * Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and
     * profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control track and
     * emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101
     * 154 Annex E.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link AacCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode
     *         and profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control
     *         track and emits a mono AAC encode of the description track, with control data emitted in the PES header
     *         as per ETSI TS 101 154 Annex E.
     * @see AacCodingMode
     */
    public final AacCodingMode codingMode() {
        return AacCodingMode.fromValue(codingMode);
    }

    /**
     * Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and
     * profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control track and
     * emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101
     * 154 Annex E.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link AacCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode
     *         and profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control
     *         track and emits a mono AAC encode of the description track, with control data emitted in the PES header
     *         as per ETSI TS 101 154 Annex E.
     * @see AacCodingMode
     */
    public final String codingModeAsString() {
        return codingMode;
    }

    /**
     * Rate Control Mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link AacRateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Rate Control Mode.
     * @see AacRateControlMode
     */
    public final AacRateControlMode rateControlMode() {
        return AacRateControlMode.fromValue(rateControlMode);
    }

    /**
     * Rate Control Mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link AacRateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Rate Control Mode.
     * @see AacRateControlMode
     */
    public final String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose "No container" for
     * the output container.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rawFormat} will
     * return {@link AacRawFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rawFormatAsString}.
     * </p>
     * 
     * @return Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose
     *         "No container" for the output container.
     * @see AacRawFormat
     */
    public final AacRawFormat rawFormat() {
        return AacRawFormat.fromValue(rawFormat);
    }

    /**
     * Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose "No container" for
     * the output container.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rawFormat} will
     * return {@link AacRawFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rawFormatAsString}.
     * </p>
     * 
     * @return Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose
     *         "No container" for the output container.
     * @see AacRawFormat
     */
    public final String rawFormatAsString() {
        return rawFormat;
    }

    /**
     * Sample rate in Hz. Valid values depend on rate control mode and profile.
     * 
     * @return Sample rate in Hz. Valid values depend on rate control mode and profile.
     */
    public final Integer sampleRate() {
        return sampleRate;
    }

    /**
     * Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specification}
     * will return {@link AacSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #specificationAsString}.
     * </p>
     * 
     * @return Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     * @see AacSpecification
     */
    public final AacSpecification specification() {
        return AacSpecification.fromValue(specification);
    }

    /**
     * Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specification}
     * will return {@link AacSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #specificationAsString}.
     * </p>
     * 
     * @return Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     * @see AacSpecification
     */
    public final String specificationAsString() {
        return specification;
    }

    /**
     * VBR Quality Level - Only used if rate_control_mode is VBR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vbrQuality} will
     * return {@link AacVbrQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vbrQualityAsString}.
     * </p>
     * 
     * @return VBR Quality Level - Only used if rate_control_mode is VBR.
     * @see AacVbrQuality
     */
    public final AacVbrQuality vbrQuality() {
        return AacVbrQuality.fromValue(vbrQuality);
    }

    /**
     * VBR Quality Level - Only used if rate_control_mode is VBR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vbrQuality} will
     * return {@link AacVbrQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vbrQualityAsString}.
     * </p>
     * 
     * @return VBR Quality Level - Only used if rate_control_mode is VBR.
     * @see AacVbrQuality
     */
    public final String vbrQualityAsString() {
        return vbrQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioDescriptionBroadcasterMixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rawFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(specificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vbrQualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AacSettings)) {
            return false;
        }
        AacSettings other = (AacSettings) obj;
        return Objects.equals(audioDescriptionBroadcasterMixAsString(), other.audioDescriptionBroadcasterMixAsString())
                && Objects.equals(bitrate(), other.bitrate())
                && Objects.equals(codecProfileAsString(), other.codecProfileAsString())
                && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(rawFormatAsString(), other.rawFormatAsString())
                && Objects.equals(sampleRate(), other.sampleRate())
                && Objects.equals(specificationAsString(), other.specificationAsString())
                && Objects.equals(vbrQualityAsString(), other.vbrQualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AacSettings").add("AudioDescriptionBroadcasterMix", audioDescriptionBroadcasterMixAsString())
                .add("Bitrate", bitrate()).add("CodecProfile", codecProfileAsString()).add("CodingMode", codingModeAsString())
                .add("RateControlMode", rateControlModeAsString()).add("RawFormat", rawFormatAsString())
                .add("SampleRate", sampleRate()).add("Specification", specificationAsString())
                .add("VbrQuality", vbrQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDescriptionBroadcasterMix":
            return Optional.ofNullable(clazz.cast(audioDescriptionBroadcasterMixAsString()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "CodecProfile":
            return Optional.ofNullable(clazz.cast(codecProfileAsString()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "RawFormat":
            return Optional.ofNullable(clazz.cast(rawFormatAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "Specification":
            return Optional.ofNullable(clazz.cast(specificationAsString()));
        case "VbrQuality":
            return Optional.ofNullable(clazz.cast(vbrQualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AacSettings, T> g) {
        return obj -> g.apply((AacSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AacSettings> {
        /**
         * Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo
         * pair. The value for AudioType will be set to 3, which signals to downstream systems that this stream contains
         * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder
         * does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide
         * in AudioType and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio
         * description (AD). In this case, the encoder will use any values you provide for AudioType and
         * FollowInputAudioType.
         * 
         * @param audioDescriptionBroadcasterMix
         *        Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a
         *        stereo pair. The value for AudioType will be set to 3, which signals to downstream systems that this
         *        stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain
         *        pre-mixed audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the
         *        encoder ignores any values you provide in AudioType and FollowInputAudioType. Choose NORMAL when the
         *        input does not contain pre-mixed audio + audio description (AD). In this case, the encoder will use
         *        any values you provide for AudioType and FollowInputAudioType.
         * @see AacAudioDescriptionBroadcasterMix
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacAudioDescriptionBroadcasterMix
         */
        Builder audioDescriptionBroadcasterMix(String audioDescriptionBroadcasterMix);

        /**
         * Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a stereo
         * pair. The value for AudioType will be set to 3, which signals to downstream systems that this stream contains
         * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder
         * does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the encoder ignores any values you provide
         * in AudioType and FollowInputAudioType. Choose NORMAL when the input does not contain pre-mixed audio + audio
         * description (AD). In this case, the encoder will use any values you provide for AudioType and
         * FollowInputAudioType.
         * 
         * @param audioDescriptionBroadcasterMix
         *        Choose BROADCASTER_MIXED_AD when the input contains pre-mixed main audio + audio description (AD) as a
         *        stereo pair. The value for AudioType will be set to 3, which signals to downstream systems that this
         *        stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain
         *        pre-mixed audio; the encoder does not perform the mixing. When you choose BROADCASTER_MIXED_AD, the
         *        encoder ignores any values you provide in AudioType and FollowInputAudioType. Choose NORMAL when the
         *        input does not contain pre-mixed audio + audio description (AD). In this case, the encoder will use
         *        any values you provide for AudioType and FollowInputAudioType.
         * @see AacAudioDescriptionBroadcasterMix
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacAudioDescriptionBroadcasterMix
         */
        Builder audioDescriptionBroadcasterMix(AacAudioDescriptionBroadcasterMix audioDescriptionBroadcasterMix);

        /**
         * Specify the average bitrate in bits per second. The set of valid values for this setting is: 6000, 8000,
         * 10000, 12000, 14000, 16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000,
         * 128000, 160000, 192000, 224000, 256000, 288000, 320000, 384000, 448000, 512000, 576000, 640000, 768000,
         * 896000, 1024000. The value you set is also constrained by the values that you choose for Profile
         * (codecProfile), Bitrate control mode (codingMode), and Sample rate (sampleRate). Default values depend on
         * Bitrate control mode and Profile.
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second. The set of valid values for this setting is: 6000,
         *        8000, 10000, 12000, 14000, 16000, 20000, 24000, 28000, 32000, 40000, 48000, 56000, 64000, 80000,
         *        96000, 112000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 384000, 448000, 512000, 576000,
         *        640000, 768000, 896000, 1024000. The value you set is also constrained by the values that you choose
         *        for Profile (codecProfile), Bitrate control mode (codingMode), and Sample rate (sampleRate). Default
         *        values depend on Bitrate control mode and Profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * AAC Profile.
         * 
         * @param codecProfile
         *        AAC Profile.
         * @see AacCodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacCodecProfile
         */
        Builder codecProfile(String codecProfile);

        /**
         * AAC Profile.
         * 
         * @param codecProfile
         *        AAC Profile.
         * @see AacCodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacCodecProfile
         */
        Builder codecProfile(AacCodecProfile codecProfile);

        /**
         * Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and
         * profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control track
         * and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI
         * TS 101 154 Annex E.
         * 
         * @param codingMode
         *        Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control
         *        mode and profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus
         *        control track and emits a mono AAC encode of the description track, with control data emitted in the
         *        PES header as per ETSI TS 101 154 Annex E.
         * @see AacCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacCodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and
         * profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus control track
         * and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI
         * TS 101 154 Annex E.
         * 
         * @param codingMode
         *        Mono (Audio Description), Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control
         *        mode and profile. "1.0 - Audio Description (Receiver Mix)" setting receives a stereo description plus
         *        control track and emits a mono AAC encode of the description track, with control data emitted in the
         *        PES header as per ETSI TS 101 154 Annex E.
         * @see AacCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacCodingMode
         */
        Builder codingMode(AacCodingMode codingMode);

        /**
         * Rate Control Mode.
         * 
         * @param rateControlMode
         *        Rate Control Mode.
         * @see AacRateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacRateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Rate Control Mode.
         * 
         * @param rateControlMode
         *        Rate Control Mode.
         * @see AacRateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacRateControlMode
         */
        Builder rateControlMode(AacRateControlMode rateControlMode);

        /**
         * Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose "No container"
         * for the output container.
         * 
         * @param rawFormat
         *        Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose
         *        "No container" for the output container.
         * @see AacRawFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacRawFormat
         */
        Builder rawFormat(String rawFormat);

        /**
         * Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose "No container"
         * for the output container.
         * 
         * @param rawFormat
         *        Enables LATM/LOAS AAC output. Note that if you use LATM/LOAS AAC in an output, you must choose
         *        "No container" for the output container.
         * @see AacRawFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacRawFormat
         */
        Builder rawFormat(AacRawFormat rawFormat);

        /**
         * Sample rate in Hz. Valid values depend on rate control mode and profile.
         * 
         * @param sampleRate
         *        Sample rate in Hz. Valid values depend on rate control mode and profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);

        /**
         * Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * 
         * @param specification
         *        Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * @see AacSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacSpecification
         */
        Builder specification(String specification);

        /**
         * Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * 
         * @param specification
         *        Use MPEG-2 AAC instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * @see AacSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacSpecification
         */
        Builder specification(AacSpecification specification);

        /**
         * VBR Quality Level - Only used if rate_control_mode is VBR.
         * 
         * @param vbrQuality
         *        VBR Quality Level - Only used if rate_control_mode is VBR.
         * @see AacVbrQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacVbrQuality
         */
        Builder vbrQuality(String vbrQuality);

        /**
         * VBR Quality Level - Only used if rate_control_mode is VBR.
         * 
         * @param vbrQuality
         *        VBR Quality Level - Only used if rate_control_mode is VBR.
         * @see AacVbrQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacVbrQuality
         */
        Builder vbrQuality(AacVbrQuality vbrQuality);
    }

    static final class BuilderImpl implements Builder {
        private String audioDescriptionBroadcasterMix;

        private Integer bitrate;

        private String codecProfile;

        private String codingMode;

        private String rateControlMode;

        private String rawFormat;

        private Integer sampleRate;

        private String specification;

        private String vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(AacSettings model) {
            audioDescriptionBroadcasterMix(model.audioDescriptionBroadcasterMix);
            bitrate(model.bitrate);
            codecProfile(model.codecProfile);
            codingMode(model.codingMode);
            rateControlMode(model.rateControlMode);
            rawFormat(model.rawFormat);
            sampleRate(model.sampleRate);
            specification(model.specification);
            vbrQuality(model.vbrQuality);
        }

        public final String getAudioDescriptionBroadcasterMix() {
            return audioDescriptionBroadcasterMix;
        }

        public final void setAudioDescriptionBroadcasterMix(String audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix = audioDescriptionBroadcasterMix;
        }

        @Override
        @Transient
        public final Builder audioDescriptionBroadcasterMix(String audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix = audioDescriptionBroadcasterMix;
            return this;
        }

        @Override
        @Transient
        public final Builder audioDescriptionBroadcasterMix(AacAudioDescriptionBroadcasterMix audioDescriptionBroadcasterMix) {
            this.audioDescriptionBroadcasterMix(audioDescriptionBroadcasterMix == null ? null : audioDescriptionBroadcasterMix
                    .toString());
            return this;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        @Transient
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getCodecProfile() {
            return codecProfile;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        @Override
        @Transient
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        @Transient
        public final Builder codecProfile(AacCodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        @Transient
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder codingMode(AacCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        @Transient
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        @Transient
        public final Builder rateControlMode(AacRateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final String getRawFormat() {
            return rawFormat;
        }

        public final void setRawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
        }

        @Override
        @Transient
        public final Builder rawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder rawFormat(AacRawFormat rawFormat) {
            this.rawFormat(rawFormat == null ? null : rawFormat.toString());
            return this;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        @Transient
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final String getSpecification() {
            return specification;
        }

        public final void setSpecification(String specification) {
            this.specification = specification;
        }

        @Override
        @Transient
        public final Builder specification(String specification) {
            this.specification = specification;
            return this;
        }

        @Override
        @Transient
        public final Builder specification(AacSpecification specification) {
            this.specification(specification == null ? null : specification.toString());
            return this;
        }

        public final String getVbrQuality() {
            return vbrQuality;
        }

        public final void setVbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        @Override
        @Transient
        public final Builder vbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        @Override
        @Transient
        public final Builder vbrQuality(AacVbrQuality vbrQuality) {
            this.vbrQuality(vbrQuality == null ? null : vbrQuality.toString());
            return this;
        }

        @Override
        public AacSettings build() {
            return new AacSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
