/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Eac3AtmosSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Eac3AtmosSettings.Builder, Eac3AtmosSettings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(Eac3AtmosSettings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BitstreamMode").getter(getter(Eac3AtmosSettings::bitstreamModeAsString))
            .setter(setter(Builder::bitstreamMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodingMode").getter(getter(Eac3AtmosSettings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<String> DIALOGUE_INTELLIGENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DialogueIntelligence").getter(getter(Eac3AtmosSettings::dialogueIntelligenceAsString))
            .setter(setter(Builder::dialogueIntelligence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogueIntelligence").build())
            .build();

    private static final SdkField<String> DOWNMIX_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DownmixControl").getter(getter(Eac3AtmosSettings::downmixControlAsString))
            .setter(setter(Builder::downmixControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downmixControl").build()).build();

    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_LINE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DynamicRangeCompressionLine")
            .getter(getter(Eac3AtmosSettings::dynamicRangeCompressionLineAsString))
            .setter(setter(Builder::dynamicRangeCompressionLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionLine")
                    .build()).build();

    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_RF_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamicRangeCompressionRf").getter(getter(Eac3AtmosSettings::dynamicRangeCompressionRfAsString))
            .setter(setter(Builder::dynamicRangeCompressionRf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionRf").build())
            .build();

    private static final SdkField<String> DYNAMIC_RANGE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamicRangeControl").getter(getter(Eac3AtmosSettings::dynamicRangeControlAsString))
            .setter(setter(Builder::dynamicRangeControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeControl").build())
            .build();

    private static final SdkField<Double> LO_RO_CENTER_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LoRoCenterMixLevel").getter(getter(Eac3AtmosSettings::loRoCenterMixLevel))
            .setter(setter(Builder::loRoCenterMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoCenterMixLevel").build())
            .build();

    private static final SdkField<Double> LO_RO_SURROUND_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LoRoSurroundMixLevel").getter(getter(Eac3AtmosSettings::loRoSurroundMixLevel))
            .setter(setter(Builder::loRoSurroundMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoSurroundMixLevel").build())
            .build();

    private static final SdkField<Double> LT_RT_CENTER_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LtRtCenterMixLevel").getter(getter(Eac3AtmosSettings::ltRtCenterMixLevel))
            .setter(setter(Builder::ltRtCenterMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtCenterMixLevel").build())
            .build();

    private static final SdkField<Double> LT_RT_SURROUND_MIX_LEVEL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LtRtSurroundMixLevel").getter(getter(Eac3AtmosSettings::ltRtSurroundMixLevel))
            .setter(setter(Builder::ltRtSurroundMixLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtSurroundMixLevel").build())
            .build();

    private static final SdkField<String> METERING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeteringMode").getter(getter(Eac3AtmosSettings::meteringModeAsString))
            .setter(setter(Builder::meteringMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meteringMode").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleRate").getter(getter(Eac3AtmosSettings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final SdkField<Integer> SPEECH_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SpeechThreshold").getter(getter(Eac3AtmosSettings::speechThreshold))
            .setter(setter(Builder::speechThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechThreshold").build()).build();

    private static final SdkField<String> STEREO_DOWNMIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StereoDownmix").getter(getter(Eac3AtmosSettings::stereoDownmixAsString))
            .setter(setter(Builder::stereoDownmix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stereoDownmix").build()).build();

    private static final SdkField<String> SURROUND_EX_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SurroundExMode").getter(getter(Eac3AtmosSettings::surroundExModeAsString))
            .setter(setter(Builder::surroundExMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundExMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD,
            BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DIALOGUE_INTELLIGENCE_FIELD, DOWNMIX_CONTROL_FIELD,
            DYNAMIC_RANGE_COMPRESSION_LINE_FIELD, DYNAMIC_RANGE_COMPRESSION_RF_FIELD, DYNAMIC_RANGE_CONTROL_FIELD,
            LO_RO_CENTER_MIX_LEVEL_FIELD, LO_RO_SURROUND_MIX_LEVEL_FIELD, LT_RT_CENTER_MIX_LEVEL_FIELD,
            LT_RT_SURROUND_MIX_LEVEL_FIELD, METERING_MODE_FIELD, SAMPLE_RATE_FIELD, SPEECH_THRESHOLD_FIELD, STEREO_DOWNMIX_FIELD,
            SURROUND_EX_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bitrate;

    private final String bitstreamMode;

    private final String codingMode;

    private final String dialogueIntelligence;

    private final String downmixControl;

    private final String dynamicRangeCompressionLine;

    private final String dynamicRangeCompressionRf;

    private final String dynamicRangeControl;

    private final Double loRoCenterMixLevel;

    private final Double loRoSurroundMixLevel;

    private final Double ltRtCenterMixLevel;

    private final Double ltRtSurroundMixLevel;

    private final String meteringMode;

    private final Integer sampleRate;

    private final Integer speechThreshold;

    private final String stereoDownmix;

    private final String surroundExMode;

    private Eac3AtmosSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dialogueIntelligence = builder.dialogueIntelligence;
        this.downmixControl = builder.downmixControl;
        this.dynamicRangeCompressionLine = builder.dynamicRangeCompressionLine;
        this.dynamicRangeCompressionRf = builder.dynamicRangeCompressionRf;
        this.dynamicRangeControl = builder.dynamicRangeControl;
        this.loRoCenterMixLevel = builder.loRoCenterMixLevel;
        this.loRoSurroundMixLevel = builder.loRoSurroundMixLevel;
        this.ltRtCenterMixLevel = builder.ltRtCenterMixLevel;
        this.ltRtSurroundMixLevel = builder.ltRtSurroundMixLevel;
        this.meteringMode = builder.meteringMode;
        this.sampleRate = builder.sampleRate;
        this.speechThreshold = builder.speechThreshold;
        this.stereoDownmix = builder.stereoDownmix;
        this.surroundExMode = builder.surroundExMode;
    }

    /**
     * Specify the average bitrate for this output in bits per second. Valid values: 384k, 448k, 576k, 640k, 768k, 1024k
     * Default value: 448k Note that MediaConvert supports 384k only with channel-based immersive (CBI) 7.1.4 and 5.1.4
     * inputs. For CBI 9.1.6 and other input types, MediaConvert automatically increases your output bitrate to 448k.
     * 
     * @return Specify the average bitrate for this output in bits per second. Valid values: 384k, 448k, 576k, 640k,
     *         768k, 1024k Default value: 448k Note that MediaConvert supports 384k only with channel-based immersive
     *         (CBI) 7.1.4 and 5.1.4 inputs. For CBI 9.1.6 and other input types, MediaConvert automatically increases
     *         your output bitrate to 448k.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3
     * bitstream mode, see ATSC A/52-2012 (Annex E).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Eac3AtmosBitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the
     *         EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
     * @see Eac3AtmosBitstreamMode
     */
    public final Eac3AtmosBitstreamMode bitstreamMode() {
        return Eac3AtmosBitstreamMode.fromValue(bitstreamMode);
    }

    /**
     * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3
     * bitstream mode, see ATSC A/52-2012 (Annex E).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Eac3AtmosBitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the
     *         EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
     * @see Eac3AtmosBitstreamMode
     */
    public final String bitstreamModeAsString() {
        return bitstreamMode;
    }

    /**
     * The coding mode for Dolby Digital Plus JOC (Atmos).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Eac3AtmosCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codingModeAsString}.
     * </p>
     * 
     * @return The coding mode for Dolby Digital Plus JOC (Atmos).
     * @see Eac3AtmosCodingMode
     */
    public final Eac3AtmosCodingMode codingMode() {
        return Eac3AtmosCodingMode.fromValue(codingMode);
    }

    /**
     * The coding mode for Dolby Digital Plus JOC (Atmos).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Eac3AtmosCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codingModeAsString}.
     * </p>
     * 
     * @return The coding mode for Dolby Digital Plus JOC (Atmos).
     * @see Eac3AtmosCodingMode
     */
    public final String codingModeAsString() {
        return codingMode;
    }

    /**
     * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dialogueIntelligence} will return {@link Eac3AtmosDialogueIntelligence#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dialogueIntelligenceAsString}.
     * </p>
     * 
     * @return Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     * @see Eac3AtmosDialogueIntelligence
     */
    public final Eac3AtmosDialogueIntelligence dialogueIntelligence() {
        return Eac3AtmosDialogueIntelligence.fromValue(dialogueIntelligence);
    }

    /**
     * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dialogueIntelligence} will return {@link Eac3AtmosDialogueIntelligence#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dialogueIntelligenceAsString}.
     * </p>
     * 
     * @return Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
     * @see Eac3AtmosDialogueIntelligence
     */
    public final String dialogueIntelligenceAsString() {
        return dialogueIntelligence;
    }

    /**
     * Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default value, Custom
     * (SPECIFIED) to provide downmix values in your job settings. Choose Follow source (INITIALIZE_FROM_SOURCE) to use
     * the metadata from your input. Related settings--Use these settings to specify your downmix values: Left
     * only/Right only surround (LoRoSurroundMixLevel), Left total/Right total surround (LtRtSurroundMixLevel), Left
     * total/Right total center (LtRtCenterMixLevel), Left only/Right only center (LoRoCenterMixLevel), and Stereo
     * downmix (StereoDownmix). When you keep Custom (SPECIFIED) for Downmix control (DownmixControl) and you don't
     * specify values for the related settings, MediaConvert uses default values for those settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downmixControl}
     * will return {@link Eac3AtmosDownmixControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #downmixControlAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default
     *         value, Custom (SPECIFIED) to provide downmix values in your job settings. Choose Follow source
     *         (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to
     *         specify your downmix values: Left only/Right only surround (LoRoSurroundMixLevel), Left total/Right total
     *         surround (LtRtSurroundMixLevel), Left total/Right total center (LtRtCenterMixLevel), Left only/Right only
     *         center (LoRoCenterMixLevel), and Stereo downmix (StereoDownmix). When you keep Custom (SPECIFIED) for
     *         Downmix control (DownmixControl) and you don't specify values for the related settings, MediaConvert uses
     *         default values for those settings.
     * @see Eac3AtmosDownmixControl
     */
    public final Eac3AtmosDownmixControl downmixControl() {
        return Eac3AtmosDownmixControl.fromValue(downmixControl);
    }

    /**
     * Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default value, Custom
     * (SPECIFIED) to provide downmix values in your job settings. Choose Follow source (INITIALIZE_FROM_SOURCE) to use
     * the metadata from your input. Related settings--Use these settings to specify your downmix values: Left
     * only/Right only surround (LoRoSurroundMixLevel), Left total/Right total surround (LtRtSurroundMixLevel), Left
     * total/Right total center (LtRtCenterMixLevel), Left only/Right only center (LoRoCenterMixLevel), and Stereo
     * downmix (StereoDownmix). When you keep Custom (SPECIFIED) for Downmix control (DownmixControl) and you don't
     * specify values for the related settings, MediaConvert uses default values for those settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downmixControl}
     * will return {@link Eac3AtmosDownmixControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #downmixControlAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default
     *         value, Custom (SPECIFIED) to provide downmix values in your job settings. Choose Follow source
     *         (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to
     *         specify your downmix values: Left only/Right only surround (LoRoSurroundMixLevel), Left total/Right total
     *         surround (LtRtSurroundMixLevel), Left total/Right total center (LtRtCenterMixLevel), Left only/Right only
     *         center (LoRoCenterMixLevel), and Stereo downmix (StereoDownmix). When you keep Custom (SPECIFIED) for
     *         Downmix control (DownmixControl) and you don't specify values for the related settings, MediaConvert uses
     *         default values for those settings.
     * @see Eac3AtmosDownmixControl
     */
    public final String downmixControlAsString() {
        return downmixControl;
    }

    /**
     * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
     * Dolby stream for the line operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related
     * setting: To have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the
     * setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression
     * line (DynamicRangeCompressionLine). For information about the Dolby DRC operating modes and profiles, see the
     * Dynamic Range Control chapter of the Dolby Metadata Guide at
     * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionLine} will return
     * {@link Eac3AtmosDynamicRangeCompressionLine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRangeCompressionLineAsString}.
     * </p>
     * 
     * @return Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in
     *         the Dolby stream for the line operating mode. Default value: Film light
     *         (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify
     *         here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control
     *         (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression line
     *         (DynamicRangeCompressionLine). For information about the Dolby DRC operating modes and profiles, see the
     *         Dynamic Range Control chapter of the Dolby Metadata Guide at
     *         https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * @see Eac3AtmosDynamicRangeCompressionLine
     */
    public final Eac3AtmosDynamicRangeCompressionLine dynamicRangeCompressionLine() {
        return Eac3AtmosDynamicRangeCompressionLine.fromValue(dynamicRangeCompressionLine);
    }

    /**
     * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
     * Dolby stream for the line operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related
     * setting: To have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the
     * setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression
     * line (DynamicRangeCompressionLine). For information about the Dolby DRC operating modes and profiles, see the
     * Dynamic Range Control chapter of the Dolby Metadata Guide at
     * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionLine} will return
     * {@link Eac3AtmosDynamicRangeCompressionLine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRangeCompressionLineAsString}.
     * </p>
     * 
     * @return Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in
     *         the Dolby stream for the line operating mode. Default value: Film light
     *         (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify
     *         here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control
     *         (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression line
     *         (DynamicRangeCompressionLine). For information about the Dolby DRC operating modes and profiles, see the
     *         Dynamic Range Control chapter of the Dolby Metadata Guide at
     *         https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * @see Eac3AtmosDynamicRangeCompressionLine
     */
    public final String dynamicRangeCompressionLineAsString() {
        return dynamicRangeCompressionLine;
    }

    /**
     * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
     * Dolby stream for the RF operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related
     * setting: To have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the
     * setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF
     * (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the Dynamic
     * Range Control chapter of the Dolby Metadata Guide at
     * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionRf} will return {@link Eac3AtmosDynamicRangeCompressionRf#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dynamicRangeCompressionRfAsString}.
     * </p>
     * 
     * @return Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in
     *         the Dolby stream for the RF operating mode. Default value: Film light
     *         (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify
     *         here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control
     *         (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF
     *         (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the
     *         Dynamic Range Control chapter of the Dolby Metadata Guide at
     *         https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * @see Eac3AtmosDynamicRangeCompressionRf
     */
    public final Eac3AtmosDynamicRangeCompressionRf dynamicRangeCompressionRf() {
        return Eac3AtmosDynamicRangeCompressionRf.fromValue(dynamicRangeCompressionRf);
    }

    /**
     * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
     * Dolby stream for the RF operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related
     * setting: To have MediaConvert use the value you specify here, keep the default value, Custom (SPECIFIED) for the
     * setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF
     * (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the Dynamic
     * Range Control chapter of the Dolby Metadata Guide at
     * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionRf} will return {@link Eac3AtmosDynamicRangeCompressionRf#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dynamicRangeCompressionRfAsString}.
     * </p>
     * 
     * @return Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in
     *         the Dolby stream for the RF operating mode. Default value: Film light
     *         (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify
     *         here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control
     *         (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF
     *         (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the
     *         Dynamic Range Control chapter of the Dolby Metadata Guide at
     *         https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * @see Eac3AtmosDynamicRangeCompressionRf
     */
    public final String dynamicRangeCompressionRfAsString() {
        return dynamicRangeCompressionRf;
    }

    /**
     * Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the default
     * value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose Follow source
     * (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify
     * your dynamic range control values: Dynamic range compression line (DynamicRangeCompressionLine) and Dynamic range
     * compression RF (DynamicRangeCompressionRf). When you keep the value Custom (SPECIFIED) for Dynamic range control
     * (DynamicRangeControl) and you don't specify values for the related settings, MediaConvert uses default values for
     * those settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeControl} will return {@link Eac3AtmosDynamicRangeControl#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dynamicRangeControlAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the
     *         default value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose
     *         Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these
     *         settings to specify your dynamic range control values: Dynamic range compression line
     *         (DynamicRangeCompressionLine) and Dynamic range compression RF (DynamicRangeCompressionRf). When you keep
     *         the value Custom (SPECIFIED) for Dynamic range control (DynamicRangeControl) and you don't specify values
     *         for the related settings, MediaConvert uses default values for those settings.
     * @see Eac3AtmosDynamicRangeControl
     */
    public final Eac3AtmosDynamicRangeControl dynamicRangeControl() {
        return Eac3AtmosDynamicRangeControl.fromValue(dynamicRangeControl);
    }

    /**
     * Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the default
     * value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose Follow source
     * (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify
     * your dynamic range control values: Dynamic range compression line (DynamicRangeCompressionLine) and Dynamic range
     * compression RF (DynamicRangeCompressionRf). When you keep the value Custom (SPECIFIED) for Dynamic range control
     * (DynamicRangeControl) and you don't specify values for the related settings, MediaConvert uses default values for
     * those settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeControl} will return {@link Eac3AtmosDynamicRangeControl#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #dynamicRangeControlAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the
     *         default value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose
     *         Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these
     *         settings to specify your dynamic range control values: Dynamic range compression line
     *         (DynamicRangeCompressionLine) and Dynamic range compression RF (DynamicRangeCompressionRf). When you keep
     *         the value Custom (SPECIFIED) for Dynamic range control (DynamicRangeControl) and you don't specify values
     *         for the related settings, MediaConvert uses default values for those settings.
     * @see Eac3AtmosDynamicRangeControl
     */
    public final String dynamicRangeControlAsString() {
        return dynamicRangeControl;
    }

    /**
     * Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center).
     * MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid
     * values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value depends on
     * the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use
     * this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl).
     * Otherwise, MediaConvert ignores Left only/Right only center (LoRoCenterMixLevel).
     * 
     * @return Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center).
     *         MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB).
     *         Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value
     *         depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To
     *         have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix
     *         control (DownmixControl). Otherwise, MediaConvert ignores Left only/Right only center
     *         (LoRoCenterMixLevel).
     */
    public final Double loRoCenterMixLevel() {
        return loRoCenterMixLevel;
    }

    /**
     * Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround). MediaConvert uses
     * this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid values: -1.5, -3.0,
     * -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the service uses this value depends on
     * the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use
     * this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl).
     * Otherwise, MediaConvert ignores Left only/Right only surround (LoRoSurroundMixLevel).
     * 
     * @return Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround).
     *         MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB).
     *         Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the
     *         service uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix).
     *         Related setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the
     *         setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores Left only/Right only surround
     *         (LoRoSurroundMixLevel).
     */
    public final Double loRoSurroundMixLevel() {
        return loRoSurroundMixLevel;
    }

    /**
     * Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center).
     * MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid
     * values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value depends on
     * the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use
     * this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl).
     * Otherwise, MediaConvert ignores Left total/Right total center (LtRtCenterMixLevel).
     * 
     * @return Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center).
     *         MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB)
     *         Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value
     *         depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To
     *         have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix
     *         control (DownmixControl). Otherwise, MediaConvert ignores Left total/Right total center
     *         (LtRtCenterMixLevel).
     */
    public final Double ltRtCenterMixLevel() {
        return ltRtCenterMixLevel;
    }

    /**
     * Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt surround).
     * MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid
     * values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the service uses
     * this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To
     * have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control
     * (DownmixControl). Otherwise, the service ignores Left total/Right total surround (LtRtSurroundMixLevel).
     * 
     * @return Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt
     *         surround). MediaConvert uses this value for downmixing. Default value: -3 dB
     *         (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes
     *         the channel. Related setting: How the service uses this value depends on the value that you choose for
     *         Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the
     *         default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, the
     *         service ignores Left total/Right total surround (LtRtSurroundMixLevel).
     */
    public final Double ltRtSurroundMixLevel() {
        return ltRtSurroundMixLevel;
    }

    /**
     * Choose how the service meters the loudness of your audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteringMode} will
     * return {@link Eac3AtmosMeteringMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #meteringModeAsString}.
     * </p>
     * 
     * @return Choose how the service meters the loudness of your audio.
     * @see Eac3AtmosMeteringMode
     */
    public final Eac3AtmosMeteringMode meteringMode() {
        return Eac3AtmosMeteringMode.fromValue(meteringMode);
    }

    /**
     * Choose how the service meters the loudness of your audio.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #meteringMode} will
     * return {@link Eac3AtmosMeteringMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #meteringModeAsString}.
     * </p>
     * 
     * @return Choose how the service meters the loudness of your audio.
     * @see Eac3AtmosMeteringMode
     */
    public final String meteringModeAsString() {
        return meteringMode;
    }

    /**
     * This value is always 48000. It represents the sample rate in Hz.
     * 
     * @return This value is always 48000. It represents the sample rate in Hz.
     */
    public final Integer sampleRate() {
        return sampleRate;
    }

    /**
     * Specify the percentage of audio content, from 0% to 100%, that must be speech in order for the encoder to use the
     * measured speech loudness as the overall program loudness. Default value: 15%
     * 
     * @return Specify the percentage of audio content, from 0% to 100%, that must be speech in order for the encoder to
     *         use the measured speech loudness as the overall program loudness. Default value: 15%
     */
    public final Integer speechThreshold() {
        return speechThreshold;
    }

    /**
     * Choose how the service does stereo downmixing. Default value: Not indicated
     * (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep the default
     * value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores
     * Stereo downmix (StereoDownmix).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stereoDownmix}
     * will return {@link Eac3AtmosStereoDownmix#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stereoDownmixAsString}.
     * </p>
     * 
     * @return Choose how the service does stereo downmixing. Default value: Not indicated
     *         (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep the
     *         default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise,
     *         MediaConvert ignores Stereo downmix (StereoDownmix).
     * @see Eac3AtmosStereoDownmix
     */
    public final Eac3AtmosStereoDownmix stereoDownmix() {
        return Eac3AtmosStereoDownmix.fromValue(stereoDownmix);
    }

    /**
     * Choose how the service does stereo downmixing. Default value: Not indicated
     * (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep the default
     * value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert ignores
     * Stereo downmix (StereoDownmix).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stereoDownmix}
     * will return {@link Eac3AtmosStereoDownmix#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stereoDownmixAsString}.
     * </p>
     * 
     * @return Choose how the service does stereo downmixing. Default value: Not indicated
     *         (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep the
     *         default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise,
     *         MediaConvert ignores Stereo downmix (StereoDownmix).
     * @see Eac3AtmosStereoDownmix
     */
    public final String stereoDownmixAsString() {
        return stereoDownmix;
    }

    /**
     * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left and
     * right surround channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #surroundExMode}
     * will return {@link Eac3AtmosSurroundExMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #surroundExModeAsString}.
     * </p>
     * 
     * @return Specify whether your input audio has an additional center rear surround channel matrix encoded into your
     *         left and right surround channels.
     * @see Eac3AtmosSurroundExMode
     */
    public final Eac3AtmosSurroundExMode surroundExMode() {
        return Eac3AtmosSurroundExMode.fromValue(surroundExMode);
    }

    /**
     * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left and
     * right surround channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #surroundExMode}
     * will return {@link Eac3AtmosSurroundExMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #surroundExModeAsString}.
     * </p>
     * 
     * @return Specify whether your input audio has an additional center rear surround channel matrix encoded into your
     *         left and right surround channels.
     * @see Eac3AtmosSurroundExMode
     */
    public final String surroundExModeAsString() {
        return surroundExMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialogueIntelligenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(downmixControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeCompressionLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeCompressionRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loRoCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(loRoSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(ltRtCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(ltRtSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(meteringModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(speechThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(stereoDownmixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(surroundExModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eac3AtmosSettings)) {
            return false;
        }
        Eac3AtmosSettings other = (Eac3AtmosSettings) obj;
        return Objects.equals(bitrate(), other.bitrate())
                && Objects.equals(bitstreamModeAsString(), other.bitstreamModeAsString())
                && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(dialogueIntelligenceAsString(), other.dialogueIntelligenceAsString())
                && Objects.equals(downmixControlAsString(), other.downmixControlAsString())
                && Objects.equals(dynamicRangeCompressionLineAsString(), other.dynamicRangeCompressionLineAsString())
                && Objects.equals(dynamicRangeCompressionRfAsString(), other.dynamicRangeCompressionRfAsString())
                && Objects.equals(dynamicRangeControlAsString(), other.dynamicRangeControlAsString())
                && Objects.equals(loRoCenterMixLevel(), other.loRoCenterMixLevel())
                && Objects.equals(loRoSurroundMixLevel(), other.loRoSurroundMixLevel())
                && Objects.equals(ltRtCenterMixLevel(), other.ltRtCenterMixLevel())
                && Objects.equals(ltRtSurroundMixLevel(), other.ltRtSurroundMixLevel())
                && Objects.equals(meteringModeAsString(), other.meteringModeAsString())
                && Objects.equals(sampleRate(), other.sampleRate()) && Objects.equals(speechThreshold(), other.speechThreshold())
                && Objects.equals(stereoDownmixAsString(), other.stereoDownmixAsString())
                && Objects.equals(surroundExModeAsString(), other.surroundExModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Eac3AtmosSettings").add("Bitrate", bitrate()).add("BitstreamMode", bitstreamModeAsString())
                .add("CodingMode", codingModeAsString()).add("DialogueIntelligence", dialogueIntelligenceAsString())
                .add("DownmixControl", downmixControlAsString())
                .add("DynamicRangeCompressionLine", dynamicRangeCompressionLineAsString())
                .add("DynamicRangeCompressionRf", dynamicRangeCompressionRfAsString())
                .add("DynamicRangeControl", dynamicRangeControlAsString()).add("LoRoCenterMixLevel", loRoCenterMixLevel())
                .add("LoRoSurroundMixLevel", loRoSurroundMixLevel()).add("LtRtCenterMixLevel", ltRtCenterMixLevel())
                .add("LtRtSurroundMixLevel", ltRtSurroundMixLevel()).add("MeteringMode", meteringModeAsString())
                .add("SampleRate", sampleRate()).add("SpeechThreshold", speechThreshold())
                .add("StereoDownmix", stereoDownmixAsString()).add("SurroundExMode", surroundExModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "BitstreamMode":
            return Optional.ofNullable(clazz.cast(bitstreamModeAsString()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "DialogueIntelligence":
            return Optional.ofNullable(clazz.cast(dialogueIntelligenceAsString()));
        case "DownmixControl":
            return Optional.ofNullable(clazz.cast(downmixControlAsString()));
        case "DynamicRangeCompressionLine":
            return Optional.ofNullable(clazz.cast(dynamicRangeCompressionLineAsString()));
        case "DynamicRangeCompressionRf":
            return Optional.ofNullable(clazz.cast(dynamicRangeCompressionRfAsString()));
        case "DynamicRangeControl":
            return Optional.ofNullable(clazz.cast(dynamicRangeControlAsString()));
        case "LoRoCenterMixLevel":
            return Optional.ofNullable(clazz.cast(loRoCenterMixLevel()));
        case "LoRoSurroundMixLevel":
            return Optional.ofNullable(clazz.cast(loRoSurroundMixLevel()));
        case "LtRtCenterMixLevel":
            return Optional.ofNullable(clazz.cast(ltRtCenterMixLevel()));
        case "LtRtSurroundMixLevel":
            return Optional.ofNullable(clazz.cast(ltRtSurroundMixLevel()));
        case "MeteringMode":
            return Optional.ofNullable(clazz.cast(meteringModeAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "SpeechThreshold":
            return Optional.ofNullable(clazz.cast(speechThreshold()));
        case "StereoDownmix":
            return Optional.ofNullable(clazz.cast(stereoDownmixAsString()));
        case "SurroundExMode":
            return Optional.ofNullable(clazz.cast(surroundExModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Eac3AtmosSettings, T> g) {
        return obj -> g.apply((Eac3AtmosSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Eac3AtmosSettings> {
        /**
         * Specify the average bitrate for this output in bits per second. Valid values: 384k, 448k, 576k, 640k, 768k,
         * 1024k Default value: 448k Note that MediaConvert supports 384k only with channel-based immersive (CBI) 7.1.4
         * and 5.1.4 inputs. For CBI 9.1.6 and other input types, MediaConvert automatically increases your output
         * bitrate to 448k.
         * 
         * @param bitrate
         *        Specify the average bitrate for this output in bits per second. Valid values: 384k, 448k, 576k, 640k,
         *        768k, 1024k Default value: 448k Note that MediaConvert supports 384k only with channel-based immersive
         *        (CBI) 7.1.4 and 5.1.4 inputs. For CBI 9.1.6 and other input types, MediaConvert automatically
         *        increases your output bitrate to 448k.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3
         * bitstream mode, see ATSC A/52-2012 (Annex E).
         * 
         * @param bitstreamMode
         *        Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about
         *        the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         * @see Eac3AtmosBitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosBitstreamMode
         */
        Builder bitstreamMode(String bitstreamMode);

        /**
         * Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about the EAC3
         * bitstream mode, see ATSC A/52-2012 (Annex E).
         * 
         * @param bitstreamMode
         *        Specify the bitstream mode for the E-AC-3 stream that the encoder emits. For more information about
         *        the EAC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         * @see Eac3AtmosBitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosBitstreamMode
         */
        Builder bitstreamMode(Eac3AtmosBitstreamMode bitstreamMode);

        /**
         * The coding mode for Dolby Digital Plus JOC (Atmos).
         * 
         * @param codingMode
         *        The coding mode for Dolby Digital Plus JOC (Atmos).
         * @see Eac3AtmosCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosCodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * The coding mode for Dolby Digital Plus JOC (Atmos).
         * 
         * @param codingMode
         *        The coding mode for Dolby Digital Plus JOC (Atmos).
         * @see Eac3AtmosCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosCodingMode
         */
        Builder codingMode(Eac3AtmosCodingMode codingMode);

        /**
         * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         * 
         * @param dialogueIntelligence
         *        Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         * @see Eac3AtmosDialogueIntelligence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDialogueIntelligence
         */
        Builder dialogueIntelligence(String dialogueIntelligence);

        /**
         * Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         * 
         * @param dialogueIntelligence
         *        Enable Dolby Dialogue Intelligence to adjust loudness based on dialogue analysis.
         * @see Eac3AtmosDialogueIntelligence
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDialogueIntelligence
         */
        Builder dialogueIntelligence(Eac3AtmosDialogueIntelligence dialogueIntelligence);

        /**
         * Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default value,
         * Custom (SPECIFIED) to provide downmix values in your job settings. Choose Follow source
         * (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify
         * your downmix values: Left only/Right only surround (LoRoSurroundMixLevel), Left total/Right total surround
         * (LtRtSurroundMixLevel), Left total/Right total center (LtRtCenterMixLevel), Left only/Right only center
         * (LoRoCenterMixLevel), and Stereo downmix (StereoDownmix). When you keep Custom (SPECIFIED) for Downmix
         * control (DownmixControl) and you don't specify values for the related settings, MediaConvert uses default
         * values for those settings.
         * 
         * @param downmixControl
         *        Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default
         *        value, Custom (SPECIFIED) to provide downmix values in your job settings. Choose Follow source
         *        (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to
         *        specify your downmix values: Left only/Right only surround (LoRoSurroundMixLevel), Left total/Right
         *        total surround (LtRtSurroundMixLevel), Left total/Right total center (LtRtCenterMixLevel), Left
         *        only/Right only center (LoRoCenterMixLevel), and Stereo downmix (StereoDownmix). When you keep Custom
         *        (SPECIFIED) for Downmix control (DownmixControl) and you don't specify values for the related
         *        settings, MediaConvert uses default values for those settings.
         * @see Eac3AtmosDownmixControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDownmixControl
         */
        Builder downmixControl(String downmixControl);

        /**
         * Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default value,
         * Custom (SPECIFIED) to provide downmix values in your job settings. Choose Follow source
         * (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify
         * your downmix values: Left only/Right only surround (LoRoSurroundMixLevel), Left total/Right total surround
         * (LtRtSurroundMixLevel), Left total/Right total center (LtRtCenterMixLevel), Left only/Right only center
         * (LoRoCenterMixLevel), and Stereo downmix (StereoDownmix). When you keep Custom (SPECIFIED) for Downmix
         * control (DownmixControl) and you don't specify values for the related settings, MediaConvert uses default
         * values for those settings.
         * 
         * @param downmixControl
         *        Specify whether MediaConvert should use any downmix metadata from your input file. Keep the default
         *        value, Custom (SPECIFIED) to provide downmix values in your job settings. Choose Follow source
         *        (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to
         *        specify your downmix values: Left only/Right only surround (LoRoSurroundMixLevel), Left total/Right
         *        total surround (LtRtSurroundMixLevel), Left total/Right total center (LtRtCenterMixLevel), Left
         *        only/Right only center (LoRoCenterMixLevel), and Stereo downmix (StereoDownmix). When you keep Custom
         *        (SPECIFIED) for Downmix control (DownmixControl) and you don't specify values for the related
         *        settings, MediaConvert uses default values for those settings.
         * @see Eac3AtmosDownmixControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDownmixControl
         */
        Builder downmixControl(Eac3AtmosDownmixControl downmixControl);

        /**
         * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
         * Dolby stream for the line operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT)
         * Related setting: To have MediaConvert use the value you specify here, keep the default value, Custom
         * (SPECIFIED) for the setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores
         * Dynamic range compression line (DynamicRangeCompressionLine). For information about the Dolby DRC operating
         * modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * 
         * @param dynamicRangeCompressionLine
         *        Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata
         *        in the Dolby stream for the line operating mode. Default value: Film light
         *        (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify
         *        here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control
         *        (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression line
         *        (DynamicRangeCompressionLine). For information about the Dolby DRC operating modes and profiles, see
         *        the Dynamic Range Control chapter of the Dolby Metadata Guide at
         *        https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * @see Eac3AtmosDynamicRangeCompressionLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeCompressionLine
         */
        Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine);

        /**
         * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
         * Dolby stream for the line operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT)
         * Related setting: To have MediaConvert use the value you specify here, keep the default value, Custom
         * (SPECIFIED) for the setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores
         * Dynamic range compression line (DynamicRangeCompressionLine). For information about the Dolby DRC operating
         * modes and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * 
         * @param dynamicRangeCompressionLine
         *        Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata
         *        in the Dolby stream for the line operating mode. Default value: Film light
         *        (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify
         *        here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control
         *        (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression line
         *        (DynamicRangeCompressionLine). For information about the Dolby DRC operating modes and profiles, see
         *        the Dynamic Range Control chapter of the Dolby Metadata Guide at
         *        https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * @see Eac3AtmosDynamicRangeCompressionLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeCompressionLine
         */
        Builder dynamicRangeCompressionLine(Eac3AtmosDynamicRangeCompressionLine dynamicRangeCompressionLine);

        /**
         * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
         * Dolby stream for the RF operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT)
         * Related setting: To have MediaConvert use the value you specify here, keep the default value, Custom
         * (SPECIFIED) for the setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores
         * Dynamic range compression RF (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes
         * and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * 
         * @param dynamicRangeCompressionRf
         *        Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata
         *        in the Dolby stream for the RF operating mode. Default value: Film light
         *        (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify
         *        here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control
         *        (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF
         *        (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the
         *        Dynamic Range Control chapter of the Dolby Metadata Guide at
         *        https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * @see Eac3AtmosDynamicRangeCompressionRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeCompressionRf
         */
        Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf);

        /**
         * Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in the
         * Dolby stream for the RF operating mode. Default value: Film light (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT)
         * Related setting: To have MediaConvert use the value you specify here, keep the default value, Custom
         * (SPECIFIED) for the setting Dynamic range control (DynamicRangeControl). Otherwise, MediaConvert ignores
         * Dynamic range compression RF (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes
         * and profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * 
         * @param dynamicRangeCompressionRf
         *        Choose the Dolby dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata
         *        in the Dolby stream for the RF operating mode. Default value: Film light
         *        (ATMOS_STORAGE_DDP_COMPR_FILM_LIGHT) Related setting: To have MediaConvert use the value you specify
         *        here, keep the default value, Custom (SPECIFIED) for the setting Dynamic range control
         *        (DynamicRangeControl). Otherwise, MediaConvert ignores Dynamic range compression RF
         *        (DynamicRangeCompressionRf). For information about the Dolby DRC operating modes and profiles, see the
         *        Dynamic Range Control chapter of the Dolby Metadata Guide at
         *        https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * @see Eac3AtmosDynamicRangeCompressionRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeCompressionRf
         */
        Builder dynamicRangeCompressionRf(Eac3AtmosDynamicRangeCompressionRf dynamicRangeCompressionRf);

        /**
         * Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the
         * default value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose
         * Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these
         * settings to specify your dynamic range control values: Dynamic range compression line
         * (DynamicRangeCompressionLine) and Dynamic range compression RF (DynamicRangeCompressionRf). When you keep the
         * value Custom (SPECIFIED) for Dynamic range control (DynamicRangeControl) and you don't specify values for the
         * related settings, MediaConvert uses default values for those settings.
         * 
         * @param dynamicRangeControl
         *        Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep
         *        the default value, Custom (SPECIFIED), to provide dynamic range control values in your job settings.
         *        Choose Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related
         *        settings--Use these settings to specify your dynamic range control values: Dynamic range compression
         *        line (DynamicRangeCompressionLine) and Dynamic range compression RF (DynamicRangeCompressionRf). When
         *        you keep the value Custom (SPECIFIED) for Dynamic range control (DynamicRangeControl) and you don't
         *        specify values for the related settings, MediaConvert uses default values for those settings.
         * @see Eac3AtmosDynamicRangeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeControl
         */
        Builder dynamicRangeControl(String dynamicRangeControl);

        /**
         * Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the
         * default value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose
         * Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these
         * settings to specify your dynamic range control values: Dynamic range compression line
         * (DynamicRangeCompressionLine) and Dynamic range compression RF (DynamicRangeCompressionRf). When you keep the
         * value Custom (SPECIFIED) for Dynamic range control (DynamicRangeControl) and you don't specify values for the
         * related settings, MediaConvert uses default values for those settings.
         * 
         * @param dynamicRangeControl
         *        Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep
         *        the default value, Custom (SPECIFIED), to provide dynamic range control values in your job settings.
         *        Choose Follow source (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related
         *        settings--Use these settings to specify your dynamic range control values: Dynamic range compression
         *        line (DynamicRangeCompressionLine) and Dynamic range compression RF (DynamicRangeCompressionRf). When
         *        you keep the value Custom (SPECIFIED) for Dynamic range control (DynamicRangeControl) and you don't
         *        specify values for the related settings, MediaConvert uses default values for those settings.
         * @see Eac3AtmosDynamicRangeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosDynamicRangeControl
         */
        Builder dynamicRangeControl(Eac3AtmosDynamicRangeControl dynamicRangeControl);

        /**
         * Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center).
         * MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB).
         * Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value
         * depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have
         * MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control
         * (DownmixControl). Otherwise, MediaConvert ignores Left only/Right only center (LoRoCenterMixLevel).
         * 
         * @param loRoCenterMixLevel
         *        Specify a value for the following Dolby Atmos setting: Left only/Right only center mix (Lo/Ro center).
         *        MediaConvert uses this value for downmixing. Default value: -3 dB
         *        (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0.
         *        Related setting: How the service uses this value depends on the value that you choose for Stereo
         *        downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the
         *        default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise,
         *        MediaConvert ignores Left only/Right only center (LoRoCenterMixLevel).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRoCenterMixLevel(Double loRoCenterMixLevel);

        /**
         * Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround). MediaConvert
         * uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid values:
         * -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the service uses this
         * value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To
         * have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control
         * (DownmixControl). Otherwise, MediaConvert ignores Left only/Right only surround (LoRoSurroundMixLevel).
         * 
         * @param loRoSurroundMixLevel
         *        Specify a value for the following Dolby Atmos setting: Left only/Right only (Lo/Ro surround).
         *        MediaConvert uses this value for downmixing. Default value: -3 dB
         *        (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB). Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60
         *        mutes the channel. Related setting: How the service uses this value depends on the value that you
         *        choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this
         *        value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl).
         *        Otherwise, MediaConvert ignores Left only/Right only surround (LoRoSurroundMixLevel).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel);

        /**
         * Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt center).
         * MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid
         * values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related setting: How the service uses this value depends
         * on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have
         * MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting Downmix control
         * (DownmixControl). Otherwise, MediaConvert ignores Left total/Right total center (LtRtCenterMixLevel).
         * 
         * @param ltRtCenterMixLevel
         *        Specify a value for the following Dolby Atmos setting: Left total/Right total center mix (Lt/Rt
         *        center). MediaConvert uses this value for downmixing. Default value: -3 dB
         *        (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid values: 3.0, 1.5, 0.0, -1.5, -3.0, -4.5, and -6.0. Related
         *        setting: How the service uses this value depends on the value that you choose for Stereo downmix
         *        (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this value, keep the default
         *        value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert
         *        ignores Left total/Right total center (LtRtCenterMixLevel).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel);

        /**
         * Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt surround).
         * MediaConvert uses this value for downmixing. Default value: -3 dB (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid
         * values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60 mutes the channel. Related setting: How the service
         * uses this value depends on the value that you choose for Stereo downmix (Eac3AtmosStereoDownmix). Related
         * setting: To have MediaConvert use this value, keep the default value, Custom (SPECIFIED) for the setting
         * Downmix control (DownmixControl). Otherwise, the service ignores Left total/Right total surround
         * (LtRtSurroundMixLevel).
         * 
         * @param ltRtSurroundMixLevel
         *        Specify a value for the following Dolby Atmos setting: Left total/Right total surround mix (Lt/Rt
         *        surround). MediaConvert uses this value for downmixing. Default value: -3 dB
         *        (ATMOS_STORAGE_DDP_MIXLEV_MINUS_3_DB) Valid values: -1.5, -3.0, -4.5, -6.0, and -60. The value -60
         *        mutes the channel. Related setting: How the service uses this value depends on the value that you
         *        choose for Stereo downmix (Eac3AtmosStereoDownmix). Related setting: To have MediaConvert use this
         *        value, keep the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl).
         *        Otherwise, the service ignores Left total/Right total surround (LtRtSurroundMixLevel).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel);

        /**
         * Choose how the service meters the loudness of your audio.
         * 
         * @param meteringMode
         *        Choose how the service meters the loudness of your audio.
         * @see Eac3AtmosMeteringMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosMeteringMode
         */
        Builder meteringMode(String meteringMode);

        /**
         * Choose how the service meters the loudness of your audio.
         * 
         * @param meteringMode
         *        Choose how the service meters the loudness of your audio.
         * @see Eac3AtmosMeteringMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosMeteringMode
         */
        Builder meteringMode(Eac3AtmosMeteringMode meteringMode);

        /**
         * This value is always 48000. It represents the sample rate in Hz.
         * 
         * @param sampleRate
         *        This value is always 48000. It represents the sample rate in Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);

        /**
         * Specify the percentage of audio content, from 0% to 100%, that must be speech in order for the encoder to use
         * the measured speech loudness as the overall program loudness. Default value: 15%
         * 
         * @param speechThreshold
         *        Specify the percentage of audio content, from 0% to 100%, that must be speech in order for the encoder
         *        to use the measured speech loudness as the overall program loudness. Default value: 15%
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speechThreshold(Integer speechThreshold);

        /**
         * Choose how the service does stereo downmixing. Default value: Not indicated
         * (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep the
         * default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert
         * ignores Stereo downmix (StereoDownmix).
         * 
         * @param stereoDownmix
         *        Choose how the service does stereo downmixing. Default value: Not indicated
         *        (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep
         *        the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise,
         *        MediaConvert ignores Stereo downmix (StereoDownmix).
         * @see Eac3AtmosStereoDownmix
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosStereoDownmix
         */
        Builder stereoDownmix(String stereoDownmix);

        /**
         * Choose how the service does stereo downmixing. Default value: Not indicated
         * (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep the
         * default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise, MediaConvert
         * ignores Stereo downmix (StereoDownmix).
         * 
         * @param stereoDownmix
         *        Choose how the service does stereo downmixing. Default value: Not indicated
         *        (ATMOS_STORAGE_DDP_DMIXMOD_NOT_INDICATED) Related setting: To have MediaConvert use this value, keep
         *        the default value, Custom (SPECIFIED) for the setting Downmix control (DownmixControl). Otherwise,
         *        MediaConvert ignores Stereo downmix (StereoDownmix).
         * @see Eac3AtmosStereoDownmix
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosStereoDownmix
         */
        Builder stereoDownmix(Eac3AtmosStereoDownmix stereoDownmix);

        /**
         * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left
         * and right surround channels.
         * 
         * @param surroundExMode
         *        Specify whether your input audio has an additional center rear surround channel matrix encoded into
         *        your left and right surround channels.
         * @see Eac3AtmosSurroundExMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosSurroundExMode
         */
        Builder surroundExMode(String surroundExMode);

        /**
         * Specify whether your input audio has an additional center rear surround channel matrix encoded into your left
         * and right surround channels.
         * 
         * @param surroundExMode
         *        Specify whether your input audio has an additional center rear surround channel matrix encoded into
         *        your left and right surround channels.
         * @see Eac3AtmosSurroundExMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Eac3AtmosSurroundExMode
         */
        Builder surroundExMode(Eac3AtmosSurroundExMode surroundExMode);
    }

    static final class BuilderImpl implements Builder {
        private Integer bitrate;

        private String bitstreamMode;

        private String codingMode;

        private String dialogueIntelligence;

        private String downmixControl;

        private String dynamicRangeCompressionLine;

        private String dynamicRangeCompressionRf;

        private String dynamicRangeControl;

        private Double loRoCenterMixLevel;

        private Double loRoSurroundMixLevel;

        private Double ltRtCenterMixLevel;

        private Double ltRtSurroundMixLevel;

        private String meteringMode;

        private Integer sampleRate;

        private Integer speechThreshold;

        private String stereoDownmix;

        private String surroundExMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Eac3AtmosSettings model) {
            bitrate(model.bitrate);
            bitstreamMode(model.bitstreamMode);
            codingMode(model.codingMode);
            dialogueIntelligence(model.dialogueIntelligence);
            downmixControl(model.downmixControl);
            dynamicRangeCompressionLine(model.dynamicRangeCompressionLine);
            dynamicRangeCompressionRf(model.dynamicRangeCompressionRf);
            dynamicRangeControl(model.dynamicRangeControl);
            loRoCenterMixLevel(model.loRoCenterMixLevel);
            loRoSurroundMixLevel(model.loRoSurroundMixLevel);
            ltRtCenterMixLevel(model.ltRtCenterMixLevel);
            ltRtSurroundMixLevel(model.ltRtSurroundMixLevel);
            meteringMode(model.meteringMode);
            sampleRate(model.sampleRate);
            speechThreshold(model.speechThreshold);
            stereoDownmix(model.stereoDownmix);
            surroundExMode(model.surroundExMode);
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        @Transient
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getBitstreamMode() {
            return bitstreamMode;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        @Override
        @Transient
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        @Transient
        public final Builder bitstreamMode(Eac3AtmosBitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        @Transient
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        @Transient
        public final Builder codingMode(Eac3AtmosCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final String getDialogueIntelligence() {
            return dialogueIntelligence;
        }

        public final void setDialogueIntelligence(String dialogueIntelligence) {
            this.dialogueIntelligence = dialogueIntelligence;
        }

        @Override
        @Transient
        public final Builder dialogueIntelligence(String dialogueIntelligence) {
            this.dialogueIntelligence = dialogueIntelligence;
            return this;
        }

        @Override
        @Transient
        public final Builder dialogueIntelligence(Eac3AtmosDialogueIntelligence dialogueIntelligence) {
            this.dialogueIntelligence(dialogueIntelligence == null ? null : dialogueIntelligence.toString());
            return this;
        }

        public final String getDownmixControl() {
            return downmixControl;
        }

        public final void setDownmixControl(String downmixControl) {
            this.downmixControl = downmixControl;
        }

        @Override
        @Transient
        public final Builder downmixControl(String downmixControl) {
            this.downmixControl = downmixControl;
            return this;
        }

        @Override
        @Transient
        public final Builder downmixControl(Eac3AtmosDownmixControl downmixControl) {
            this.downmixControl(downmixControl == null ? null : downmixControl.toString());
            return this;
        }

        public final String getDynamicRangeCompressionLine() {
            return dynamicRangeCompressionLine;
        }

        public final void setDynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
            return this;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionLine(Eac3AtmosDynamicRangeCompressionLine dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine(dynamicRangeCompressionLine == null ? null : dynamicRangeCompressionLine.toString());
            return this;
        }

        public final String getDynamicRangeCompressionRf() {
            return dynamicRangeCompressionRf;
        }

        public final void setDynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
            return this;
        }

        @Override
        @Transient
        public final Builder dynamicRangeCompressionRf(Eac3AtmosDynamicRangeCompressionRf dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf(dynamicRangeCompressionRf == null ? null : dynamicRangeCompressionRf.toString());
            return this;
        }

        public final String getDynamicRangeControl() {
            return dynamicRangeControl;
        }

        public final void setDynamicRangeControl(String dynamicRangeControl) {
            this.dynamicRangeControl = dynamicRangeControl;
        }

        @Override
        @Transient
        public final Builder dynamicRangeControl(String dynamicRangeControl) {
            this.dynamicRangeControl = dynamicRangeControl;
            return this;
        }

        @Override
        @Transient
        public final Builder dynamicRangeControl(Eac3AtmosDynamicRangeControl dynamicRangeControl) {
            this.dynamicRangeControl(dynamicRangeControl == null ? null : dynamicRangeControl.toString());
            return this;
        }

        public final Double getLoRoCenterMixLevel() {
            return loRoCenterMixLevel;
        }

        public final void setLoRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
        }

        @Override
        @Transient
        public final Builder loRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
            return this;
        }

        public final Double getLoRoSurroundMixLevel() {
            return loRoSurroundMixLevel;
        }

        public final void setLoRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
        }

        @Override
        @Transient
        public final Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
            return this;
        }

        public final Double getLtRtCenterMixLevel() {
            return ltRtCenterMixLevel;
        }

        public final void setLtRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
        }

        @Override
        @Transient
        public final Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
            return this;
        }

        public final Double getLtRtSurroundMixLevel() {
            return ltRtSurroundMixLevel;
        }

        public final void setLtRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
        }

        @Override
        @Transient
        public final Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
            return this;
        }

        public final String getMeteringMode() {
            return meteringMode;
        }

        public final void setMeteringMode(String meteringMode) {
            this.meteringMode = meteringMode;
        }

        @Override
        @Transient
        public final Builder meteringMode(String meteringMode) {
            this.meteringMode = meteringMode;
            return this;
        }

        @Override
        @Transient
        public final Builder meteringMode(Eac3AtmosMeteringMode meteringMode) {
            this.meteringMode(meteringMode == null ? null : meteringMode.toString());
            return this;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        @Transient
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Integer getSpeechThreshold() {
            return speechThreshold;
        }

        public final void setSpeechThreshold(Integer speechThreshold) {
            this.speechThreshold = speechThreshold;
        }

        @Override
        @Transient
        public final Builder speechThreshold(Integer speechThreshold) {
            this.speechThreshold = speechThreshold;
            return this;
        }

        public final String getStereoDownmix() {
            return stereoDownmix;
        }

        public final void setStereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
        }

        @Override
        @Transient
        public final Builder stereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
            return this;
        }

        @Override
        @Transient
        public final Builder stereoDownmix(Eac3AtmosStereoDownmix stereoDownmix) {
            this.stereoDownmix(stereoDownmix == null ? null : stereoDownmix.toString());
            return this;
        }

        public final String getSurroundExMode() {
            return surroundExMode;
        }

        public final void setSurroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
        }

        @Override
        @Transient
        public final Builder surroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
            return this;
        }

        @Override
        @Transient
        public final Builder surroundExMode(Eac3AtmosSurroundExMode surroundExMode) {
            this.surroundExMode(surroundExMode == null ? null : surroundExMode.toString());
            return this;
        }

        @Override
        public Eac3AtmosSettings build() {
            return new Eac3AtmosSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
