/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for embedded captions Source
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmbeddedSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<EmbeddedSourceSettings.Builder, EmbeddedSourceSettings> {
    private static final SdkField<String> CONVERT608_TO708_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Convert608To708").getter(getter(EmbeddedSourceSettings::convert608To708AsString))
            .setter(setter(Builder::convert608To708))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convert608To708").build()).build();

    private static final SdkField<Integer> SOURCE608_CHANNEL_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Source608ChannelNumber").getter(getter(EmbeddedSourceSettings::source608ChannelNumber))
            .setter(setter(Builder::source608ChannelNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source608ChannelNumber").build())
            .build();

    private static final SdkField<Integer> SOURCE608_TRACK_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Source608TrackNumber").getter(getter(EmbeddedSourceSettings::source608TrackNumber))
            .setter(setter(Builder::source608TrackNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source608TrackNumber").build())
            .build();

    private static final SdkField<String> TERMINATE_CAPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TerminateCaptions").getter(getter(EmbeddedSourceSettings::terminateCaptionsAsString))
            .setter(setter(Builder::terminateCaptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateCaptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERT608_TO708_FIELD,
            SOURCE608_CHANNEL_NUMBER_FIELD, SOURCE608_TRACK_NUMBER_FIELD, TERMINATE_CAPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String convert608To708;

    private final Integer source608ChannelNumber;

    private final Integer source608TrackNumber;

    private final String terminateCaptions;

    private EmbeddedSourceSettings(BuilderImpl builder) {
        this.convert608To708 = builder.convert608To708;
        this.source608ChannelNumber = builder.source608ChannelNumber;
        this.source608TrackNumber = builder.source608TrackNumber;
        this.terminateCaptions = builder.terminateCaptions;
    }

    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
     * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using
     * the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link EmbeddedConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
     *         choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data
     *         through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data
     *         into 708.
     * @see EmbeddedConvert608To708
     */
    public final EmbeddedConvert608To708 convert608To708() {
        return EmbeddedConvert608To708.fromValue(convert608To708);
    }

    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
     * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using
     * the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link EmbeddedConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
     *         choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data
     *         through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data
     *         into 708.
     * @see EmbeddedConvert608To708
     */
    public final String convert608To708AsString() {
        return convert608To708;
    }

    /**
     * Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
     * passthrough.
     * 
     * @return Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
     *         passthrough.
     */
    public final Integer source608ChannelNumber() {
        return source608ChannelNumber;
    }

    /**
     * Specifies the video track index used for extracting captions. The system only supports one input video track, so
     * this should always be set to '1'.
     * 
     * @return Specifies the video track index used for extracting captions. The system only supports one input video
     *         track, so this should always be set to '1'.
     */
    public final Integer source608TrackNumber() {
        return source608TrackNumber;
    }

    /**
     * By default, the service terminates any unterminated captions at the end of each input. If you want the caption to
     * continue onto your next input, disable this setting.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #terminateCaptions}
     * will return {@link EmbeddedTerminateCaptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #terminateCaptionsAsString}.
     * </p>
     * 
     * @return By default, the service terminates any unterminated captions at the end of each input. If you want the
     *         caption to continue onto your next input, disable this setting.
     * @see EmbeddedTerminateCaptions
     */
    public final EmbeddedTerminateCaptions terminateCaptions() {
        return EmbeddedTerminateCaptions.fromValue(terminateCaptions);
    }

    /**
     * By default, the service terminates any unterminated captions at the end of each input. If you want the caption to
     * continue onto your next input, disable this setting.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #terminateCaptions}
     * will return {@link EmbeddedTerminateCaptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #terminateCaptionsAsString}.
     * </p>
     * 
     * @return By default, the service terminates any unterminated captions at the end of each input. If you want the
     *         caption to continue onto your next input, disable this setting.
     * @see EmbeddedTerminateCaptions
     */
    public final String terminateCaptionsAsString() {
        return terminateCaptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(convert608To708AsString());
        hashCode = 31 * hashCode + Objects.hashCode(source608ChannelNumber());
        hashCode = 31 * hashCode + Objects.hashCode(source608TrackNumber());
        hashCode = 31 * hashCode + Objects.hashCode(terminateCaptionsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmbeddedSourceSettings)) {
            return false;
        }
        EmbeddedSourceSettings other = (EmbeddedSourceSettings) obj;
        return Objects.equals(convert608To708AsString(), other.convert608To708AsString())
                && Objects.equals(source608ChannelNumber(), other.source608ChannelNumber())
                && Objects.equals(source608TrackNumber(), other.source608TrackNumber())
                && Objects.equals(terminateCaptionsAsString(), other.terminateCaptionsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmbeddedSourceSettings").add("Convert608To708", convert608To708AsString())
                .add("Source608ChannelNumber", source608ChannelNumber()).add("Source608TrackNumber", source608TrackNumber())
                .add("TerminateCaptions", terminateCaptionsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Convert608To708":
            return Optional.ofNullable(clazz.cast(convert608To708AsString()));
        case "Source608ChannelNumber":
            return Optional.ofNullable(clazz.cast(source608ChannelNumber()));
        case "Source608TrackNumber":
            return Optional.ofNullable(clazz.cast(source608TrackNumber()));
        case "TerminateCaptions":
            return Optional.ofNullable(clazz.cast(terminateCaptionsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmbeddedSourceSettings, T> g) {
        return obj -> g.apply((EmbeddedSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmbeddedSourceSettings> {
        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
         * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through
         * using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         * 
         * @param convert608To708
         *        Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
         *        choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608
         *        data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the
         *        608 data into 708.
         * @see EmbeddedConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddedConvert608To708
         */
        Builder convert608To708(String convert608To708);

        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
         * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through
         * using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         * 
         * @param convert608To708
         *        Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
         *        choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608
         *        data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the
         *        608 data into 708.
         * @see EmbeddedConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddedConvert608To708
         */
        Builder convert608To708(EmbeddedConvert608To708 convert608To708);

        /**
         * Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
         * passthrough.
         * 
         * @param source608ChannelNumber
         *        Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
         *        passthrough.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source608ChannelNumber(Integer source608ChannelNumber);

        /**
         * Specifies the video track index used for extracting captions. The system only supports one input video track,
         * so this should always be set to '1'.
         * 
         * @param source608TrackNumber
         *        Specifies the video track index used for extracting captions. The system only supports one input video
         *        track, so this should always be set to '1'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source608TrackNumber(Integer source608TrackNumber);

        /**
         * By default, the service terminates any unterminated captions at the end of each input. If you want the
         * caption to continue onto your next input, disable this setting.
         * 
         * @param terminateCaptions
         *        By default, the service terminates any unterminated captions at the end of each input. If you want the
         *        caption to continue onto your next input, disable this setting.
         * @see EmbeddedTerminateCaptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddedTerminateCaptions
         */
        Builder terminateCaptions(String terminateCaptions);

        /**
         * By default, the service terminates any unterminated captions at the end of each input. If you want the
         * caption to continue onto your next input, disable this setting.
         * 
         * @param terminateCaptions
         *        By default, the service terminates any unterminated captions at the end of each input. If you want the
         *        caption to continue onto your next input, disable this setting.
         * @see EmbeddedTerminateCaptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddedTerminateCaptions
         */
        Builder terminateCaptions(EmbeddedTerminateCaptions terminateCaptions);
    }

    static final class BuilderImpl implements Builder {
        private String convert608To708;

        private Integer source608ChannelNumber;

        private Integer source608TrackNumber;

        private String terminateCaptions;

        private BuilderImpl() {
        }

        private BuilderImpl(EmbeddedSourceSettings model) {
            convert608To708(model.convert608To708);
            source608ChannelNumber(model.source608ChannelNumber);
            source608TrackNumber(model.source608TrackNumber);
            terminateCaptions(model.terminateCaptions);
        }

        public final String getConvert608To708() {
            return convert608To708;
        }

        public final void setConvert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
        }

        @Override
        @Transient
        public final Builder convert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
            return this;
        }

        @Override
        @Transient
        public final Builder convert608To708(EmbeddedConvert608To708 convert608To708) {
            this.convert608To708(convert608To708 == null ? null : convert608To708.toString());
            return this;
        }

        public final Integer getSource608ChannelNumber() {
            return source608ChannelNumber;
        }

        public final void setSource608ChannelNumber(Integer source608ChannelNumber) {
            this.source608ChannelNumber = source608ChannelNumber;
        }

        @Override
        @Transient
        public final Builder source608ChannelNumber(Integer source608ChannelNumber) {
            this.source608ChannelNumber = source608ChannelNumber;
            return this;
        }

        public final Integer getSource608TrackNumber() {
            return source608TrackNumber;
        }

        public final void setSource608TrackNumber(Integer source608TrackNumber) {
            this.source608TrackNumber = source608TrackNumber;
        }

        @Override
        @Transient
        public final Builder source608TrackNumber(Integer source608TrackNumber) {
            this.source608TrackNumber = source608TrackNumber;
            return this;
        }

        public final String getTerminateCaptions() {
            return terminateCaptions;
        }

        public final void setTerminateCaptions(String terminateCaptions) {
            this.terminateCaptions = terminateCaptions;
        }

        @Override
        @Transient
        public final Builder terminateCaptions(String terminateCaptions) {
            this.terminateCaptions = terminateCaptions;
            return this;
        }

        @Override
        @Transient
        public final Builder terminateCaptions(EmbeddedTerminateCaptions terminateCaptions) {
            this.terminateCaptions(terminateCaptions == null ? null : terminateCaptions.toString());
            return this;
        }

        @Override
        public EmbeddedSourceSettings build() {
            return new EmbeddedSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
