/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video
 * quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for
 * further video quality improvement. For more information about QVBR, see
 * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H265SceneChangeDetect {
    DISABLED("DISABLED"),

    ENABLED("ENABLED"),

    TRANSITION_DETECTION("TRANSITION_DETECTION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265SceneChangeDetect> VALUE_MAP = EnumUtils.uniqueIndex(H265SceneChangeDetect.class,
            H265SceneChangeDetect::toString);

    private final String value;

    private H265SceneChangeDetect(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H265SceneChangeDetect corresponding to the value
     */
    public static H265SceneChangeDetect fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H265SceneChangeDetect}s
     */
    public static Set<H265SceneChangeDetect> knownValues() {
        Set<H265SceneChangeDetect> knownValues = EnumSet.allOf(H265SceneChangeDetect.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
