/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use Rotate (InputRotate) to specify how the service rotates your video. You can choose automatic rotation or specify
 * a rotation. You can specify a clockwise rotation of 0, 90, 180, or 270 degrees. If your input video container is .mov
 * or .mp4 and your input has rotation metadata, you can choose Automatic to have the service rotate your video
 * according to the rotation specified in the metadata. The rotation must be within one degree of 90, 180, or 270
 * degrees. If the rotation metadata specifies any other rotation, the service will default to no rotation. By default,
 * the service does no rotation, even if your input video has rotation metadata. The service doesn't pass through
 * rotation metadata.
 */
@Generated("software.amazon.awssdk:codegen")
public enum InputRotate {
    DEGREE_0("DEGREE_0"),

    DEGREES_90("DEGREES_90"),

    DEGREES_180("DEGREES_180"),

    DEGREES_270("DEGREES_270"),

    AUTO("AUTO"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputRotate> VALUE_MAP = EnumUtils.uniqueIndex(InputRotate.class, InputRotate::toString);

    private final String value;

    private InputRotate(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InputRotate corresponding to the value
     */
    public static InputRotate fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InputRotate}s
     */
    public static Set<InputRotate> knownValues() {
        Set<InputRotate> knownValues = EnumSet.allOf(InputRotate.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
