/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * These settings relate to the fragmented MP4 container for the segments in your DASH outputs.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MpdSettings implements SdkPojo, Serializable, ToCopyableBuilder<MpdSettings.Builder, MpdSettings> {
    private static final SdkField<String> ACCESSIBILITY_CAPTION_HINTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessibilityCaptionHints").getter(getter(MpdSettings::accessibilityCaptionHintsAsString))
            .setter(setter(Builder::accessibilityCaptionHints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessibilityCaptionHints").build())
            .build();

    private static final SdkField<String> AUDIO_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioDuration").getter(getter(MpdSettings::audioDurationAsString))
            .setter(setter(Builder::audioDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDuration").build()).build();

    private static final SdkField<String> CAPTION_CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptionContainerType").getter(getter(MpdSettings::captionContainerTypeAsString))
            .setter(setter(Builder::captionContainerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionContainerType").build())
            .build();

    private static final SdkField<String> SCTE35_ESAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Esam").getter(getter(MpdSettings::scte35EsamAsString)).setter(setter(Builder::scte35Esam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Esam").build()).build();

    private static final SdkField<String> SCTE35_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Source").getter(getter(MpdSettings::scte35SourceAsString)).setter(setter(Builder::scte35Source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCESSIBILITY_CAPTION_HINTS_FIELD, AUDIO_DURATION_FIELD, CAPTION_CONTAINER_TYPE_FIELD, SCTE35_ESAM_FIELD,
            SCTE35_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessibilityCaptionHints;

    private final String audioDuration;

    private final String captionContainerType;

    private final String scte35Esam;

    private final String scte35Source;

    private MpdSettings(BuilderImpl builder) {
        this.accessibilityCaptionHints = builder.accessibilityCaptionHints;
        this.audioDuration = builder.audioDuration;
        this.captionContainerType = builder.captionContainerType;
        this.scte35Esam = builder.scte35Esam;
        this.scte35Source = builder.scte35Source;
    }

    /**
     * Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <Accessibility> elements
     * for embedded 608 captions. This markup isn't generally required, but some video players require it to discover
     * and play embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these elements out. When you
     * enable this setting, this is the markup that MediaConvert includes in your manifest: <Accessibility
     * schemeIdUri="urn:scte:dash:cc:cea-608:2015" value="CC1=eng"/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessibilityCaptionHints} will return {@link MpdAccessibilityCaptionHints#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #accessibilityCaptionHintsAsString}.
     * </p>
     * 
     * @return Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <Accessibility>
     *         elements for embedded 608 captions. This markup isn't generally required, but some video players require
     *         it to discover and play embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these
     *         elements out. When you enable this setting, this is the markup that MediaConvert includes in your
     *         manifest: <Accessibility schemeIdUri="urn:scte:dash:cc:cea-608:2015" value="CC1=eng"/>
     * @see MpdAccessibilityCaptionHints
     */
    public final MpdAccessibilityCaptionHints accessibilityCaptionHints() {
        return MpdAccessibilityCaptionHints.fromValue(accessibilityCaptionHints);
    }

    /**
     * Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <Accessibility> elements
     * for embedded 608 captions. This markup isn't generally required, but some video players require it to discover
     * and play embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these elements out. When you
     * enable this setting, this is the markup that MediaConvert includes in your manifest: <Accessibility
     * schemeIdUri="urn:scte:dash:cc:cea-608:2015" value="CC1=eng"/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessibilityCaptionHints} will return {@link MpdAccessibilityCaptionHints#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #accessibilityCaptionHintsAsString}.
     * </p>
     * 
     * @return Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <Accessibility>
     *         elements for embedded 608 captions. This markup isn't generally required, but some video players require
     *         it to discover and play embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these
     *         elements out. When you enable this setting, this is the markup that MediaConvert includes in your
     *         manifest: <Accessibility schemeIdUri="urn:scte:dash:cc:cea-608:2015" value="CC1=eng"/>
     * @see MpdAccessibilityCaptionHints
     */
    public final String accessibilityCaptionHintsAsString() {
        return accessibilityCaptionHints;
    }

    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     * sensitive to very small duration differences between video and audio. For this situation, choose Match video
     * duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
     * (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with
     * silence or trims them to ensure that the total duration of each audio stream is at least as long as the total
     * duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame
     * longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment
     * of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the
     * default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioDuration}
     * will return {@link MpdAudioDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioDurationAsString}.
     * </p>
     * 
     * @return Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     *         sensitive to very small duration differences between video and audio. For this situation, choose Match
     *         video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
     *         (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio
     *         streams with silence or trims them to ensure that the total duration of each audio stream is at least as
     *         long as the total duration of the video stream. After padding or trimming, the audio stream duration is
     *         no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only
     *         to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to
     *         the end of the file. When you keep the default value, any minor discrepancies between audio and video
     *         duration will depend on your output audio codec.
     * @see MpdAudioDuration
     */
    public final MpdAudioDuration audioDuration() {
        return MpdAudioDuration.fromValue(audioDuration);
    }

    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     * sensitive to very small duration differences between video and audio. For this situation, choose Match video
     * duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
     * (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams with
     * silence or trims them to ensure that the total duration of each audio stream is at least as long as the total
     * duration of the video stream. After padding or trimming, the audio stream duration is no more than one frame
     * longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the last segment
     * of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the
     * default value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioDuration}
     * will return {@link MpdAudioDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioDurationAsString}.
     * </p>
     * 
     * @return Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     *         sensitive to very small duration differences between video and audio. For this situation, choose Match
     *         video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
     *         (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio
     *         streams with silence or trims them to ensure that the total duration of each audio stream is at least as
     *         long as the total duration of the video stream. After padding or trimming, the audio stream duration is
     *         no more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only
     *         to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to
     *         the end of the file. When you keep the default value, any minor discrepancies between audio and video
     *         duration will depend on your output audio codec.
     * @see MpdAudioDuration
     */
    public final String audioDurationAsString() {
        return audioDuration;
    }

    /**
     * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar
     * captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a
     * raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented
     * MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionContainerType} will return {@link MpdCaptionContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #captionContainerTypeAsString}.
     * </p>
     * 
     * @return Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify
     *         sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a
     *         single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format
     *         contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your video and
     *         audio fragmented MP4 files.
     * @see MpdCaptionContainerType
     */
    public final MpdCaptionContainerType captionContainerType() {
        return MpdCaptionContainerType.fromValue(captionContainerType);
    }

    /**
     * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar
     * captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a
     * raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented
     * MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionContainerType} will return {@link MpdCaptionContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #captionContainerTypeAsString}.
     * </p>
     * 
     * @return Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify
     *         sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a
     *         single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format
     *         contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your video and
     *         audio fragmented MP4 files.
     * @see MpdCaptionContainerType
     */
    public final String captionContainerTypeAsString() {
        return captionContainerType;
    }

    /**
     * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this
     * output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC
     * XML (sccXml).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Esam} will
     * return {@link MpdScte35Esam#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35EsamAsString}.
     * </p>
     * 
     * @return Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
     *         this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
     *         setting SCC XML (sccXml).
     * @see MpdScte35Esam
     */
    public final MpdScte35Esam scte35Esam() {
        return MpdScte35Esam.fromValue(scte35Esam);
    }

    /**
     * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this
     * output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC
     * XML (sccXml).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Esam} will
     * return {@link MpdScte35Esam#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35EsamAsString}.
     * </p>
     * 
     * @return Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
     *         this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
     *         setting SCC XML (sccXml).
     * @see MpdScte35Esam
     */
    public final String scte35EsamAsString() {
        return scte35Esam;
    }

    /**
     * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if
     * you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't
     * want those SCTE-35 markers in this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Source} will
     * return {@link MpdScte35Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35SourceAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
     *         (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
     *         None (NONE) if you don't want those SCTE-35 markers in this output.
     * @see MpdScte35Source
     */
    public final MpdScte35Source scte35Source() {
        return MpdScte35Source.fromValue(scte35Source);
    }

    /**
     * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if
     * you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't
     * want those SCTE-35 markers in this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Source} will
     * return {@link MpdScte35Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35SourceAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
     *         (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
     *         None (NONE) if you don't want those SCTE-35 markers in this output.
     * @see MpdScte35Source
     */
    public final String scte35SourceAsString() {
        return scte35Source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessibilityCaptionHintsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(audioDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(captionContainerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35EsamAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35SourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MpdSettings)) {
            return false;
        }
        MpdSettings other = (MpdSettings) obj;
        return Objects.equals(accessibilityCaptionHintsAsString(), other.accessibilityCaptionHintsAsString())
                && Objects.equals(audioDurationAsString(), other.audioDurationAsString())
                && Objects.equals(captionContainerTypeAsString(), other.captionContainerTypeAsString())
                && Objects.equals(scte35EsamAsString(), other.scte35EsamAsString())
                && Objects.equals(scte35SourceAsString(), other.scte35SourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MpdSettings").add("AccessibilityCaptionHints", accessibilityCaptionHintsAsString())
                .add("AudioDuration", audioDurationAsString()).add("CaptionContainerType", captionContainerTypeAsString())
                .add("Scte35Esam", scte35EsamAsString()).add("Scte35Source", scte35SourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessibilityCaptionHints":
            return Optional.ofNullable(clazz.cast(accessibilityCaptionHintsAsString()));
        case "AudioDuration":
            return Optional.ofNullable(clazz.cast(audioDurationAsString()));
        case "CaptionContainerType":
            return Optional.ofNullable(clazz.cast(captionContainerTypeAsString()));
        case "Scte35Esam":
            return Optional.ofNullable(clazz.cast(scte35EsamAsString()));
        case "Scte35Source":
            return Optional.ofNullable(clazz.cast(scte35SourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MpdSettings, T> g) {
        return obj -> g.apply((MpdSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MpdSettings> {
        /**
         * Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <Accessibility>
         * elements for embedded 608 captions. This markup isn't generally required, but some video players require it
         * to discover and play embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these
         * elements out. When you enable this setting, this is the markup that MediaConvert includes in your manifest:
         * <Accessibility schemeIdUri="urn:scte:dash:cc:cea-608:2015" value="CC1=eng"/>
         * 
         * @param accessibilityCaptionHints
         *        Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with
         *        <Accessibility> elements for embedded 608 captions. This markup isn't generally required, but some
         *        video players require it to discover and play embedded 608 captions. Keep the default value, Exclude
         *        (EXCLUDE), to leave these elements out. When you enable this setting, this is the markup that
         *        MediaConvert includes in your manifest: <Accessibility schemeIdUri="urn:scte:dash:cc:cea-608:2015"
         *        value="CC1=eng"/>
         * @see MpdAccessibilityCaptionHints
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdAccessibilityCaptionHints
         */
        Builder accessibilityCaptionHints(String accessibilityCaptionHints);

        /**
         * Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with <Accessibility>
         * elements for embedded 608 captions. This markup isn't generally required, but some video players require it
         * to discover and play embedded 608 captions. Keep the default value, Exclude (EXCLUDE), to leave these
         * elements out. When you enable this setting, this is the markup that MediaConvert includes in your manifest:
         * <Accessibility schemeIdUri="urn:scte:dash:cc:cea-608:2015" value="CC1=eng"/>
         * 
         * @param accessibilityCaptionHints
         *        Optional. Choose Include (INCLUDE) to have MediaConvert mark up your DASH manifest with
         *        <Accessibility> elements for embedded 608 captions. This markup isn't generally required, but some
         *        video players require it to discover and play embedded 608 captions. Keep the default value, Exclude
         *        (EXCLUDE), to leave these elements out. When you enable this setting, this is the markup that
         *        MediaConvert includes in your manifest: <Accessibility schemeIdUri="urn:scte:dash:cc:cea-608:2015"
         *        value="CC1=eng"/>
         * @see MpdAccessibilityCaptionHints
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdAccessibilityCaptionHints
         */
        Builder accessibilityCaptionHints(MpdAccessibilityCaptionHints accessibilityCaptionHints);

        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
         * sensitive to very small duration differences between video and audio. For this situation, choose Match video
         * duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
         * (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams
         * with silence or trims them to ensure that the total duration of each audio stream is at least as long as the
         * total duration of the video stream. After padding or trimming, the audio stream duration is no more than one
         * frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the
         * last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file.
         * When you keep the default value, any minor discrepancies between audio and video duration will depend on your
         * output audio codec.
         * 
         * @param audioDuration
         *        Specify this setting only when your output will be consumed by a downstream repackaging workflow that
         *        is sensitive to very small duration differences between video and audio. For this situation, choose
         *        Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec
         *        duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output
         *        audio streams with silence or trims them to ensure that the total duration of each audio stream is at
         *        least as long as the total duration of the video stream. After padding or trimming, the audio stream
         *        duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or
         *        trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds
         *        padding only to the end of the file. When you keep the default value, any minor discrepancies between
         *        audio and video duration will depend on your output audio codec.
         * @see MpdAudioDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdAudioDuration
         */
        Builder audioDuration(String audioDuration);

        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
         * sensitive to very small duration differences between video and audio. For this situation, choose Match video
         * duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec duration
         * (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output audio streams
         * with silence or trims them to ensure that the total duration of each audio stream is at least as long as the
         * total duration of the video stream. After padding or trimming, the audio stream duration is no more than one
         * frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of the
         * last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file.
         * When you keep the default value, any minor discrepancies between audio and video duration will depend on your
         * output audio codec.
         * 
         * @param audioDuration
         *        Specify this setting only when your output will be consumed by a downstream repackaging workflow that
         *        is sensitive to very small duration differences between video and audio. For this situation, choose
         *        Match video duration (MATCH_VIDEO_DURATION). In all other cases, keep the default value, Default codec
         *        duration (DEFAULT_CODEC_DURATION). When you choose Match video duration, MediaConvert pads the output
         *        audio streams with silence or trims them to ensure that the total duration of each audio stream is at
         *        least as long as the total duration of the video stream. After padding or trimming, the audio stream
         *        duration is no more than one frame longer than the video stream. MediaConvert applies audio padding or
         *        trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds
         *        padding only to the end of the file. When you keep the default value, any minor discrepancies between
         *        audio and video duration will depend on your output audio codec.
         * @see MpdAudioDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdAudioDuration
         */
        Builder audioDuration(MpdAudioDuration audioDuration);

        /**
         * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar
         * captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file
         * in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within
         * fragmented MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4
         * files.
         * 
         * @param captionContainerType
         *        Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify
         *        sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a
         *        single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML
         *        format contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your
         *        video and audio fragmented MP4 files.
         * @see MpdCaptionContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdCaptionContainerType
         */
        Builder captionContainerType(String captionContainerType);

        /**
         * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar
         * captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file
         * in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within
         * fragmented MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4
         * files.
         * 
         * @param captionContainerType
         *        Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify
         *        sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a
         *        single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML
         *        format contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your
         *        video and audio fragmented MP4 files.
         * @see MpdCaptionContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdCaptionContainerType
         */
        Builder captionContainerType(MpdCaptionContainerType captionContainerType);

        /**
         * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
         * this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
         * setting SCC XML (sccXml).
         * 
         * @param scte35Esam
         *        Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers
         *        in this output at the insertion points that you specify in an ESAM XML document. Provide the document
         *        in the setting SCC XML (sccXml).
         * @see MpdScte35Esam
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdScte35Esam
         */
        Builder scte35Esam(String scte35Esam);

        /**
         * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
         * this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
         * setting SCC XML (sccXml).
         * 
         * @param scte35Esam
         *        Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers
         *        in this output at the insertion points that you specify in an ESAM XML document. Provide the document
         *        in the setting SCC XML (sccXml).
         * @see MpdScte35Esam
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdScte35Esam
         */
        Builder scte35Esam(MpdScte35Esam scte35Esam);

        /**
         * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         * (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
         * None (NONE) if you don't want those SCTE-35 markers in this output.
         * 
         * @param scte35Source
         *        Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         *        (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output.
         *        Choose None (NONE) if you don't want those SCTE-35 markers in this output.
         * @see MpdScte35Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdScte35Source
         */
        Builder scte35Source(String scte35Source);

        /**
         * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         * (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
         * None (NONE) if you don't want those SCTE-35 markers in this output.
         * 
         * @param scte35Source
         *        Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         *        (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output.
         *        Choose None (NONE) if you don't want those SCTE-35 markers in this output.
         * @see MpdScte35Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdScte35Source
         */
        Builder scte35Source(MpdScte35Source scte35Source);
    }

    static final class BuilderImpl implements Builder {
        private String accessibilityCaptionHints;

        private String audioDuration;

        private String captionContainerType;

        private String scte35Esam;

        private String scte35Source;

        private BuilderImpl() {
        }

        private BuilderImpl(MpdSettings model) {
            accessibilityCaptionHints(model.accessibilityCaptionHints);
            audioDuration(model.audioDuration);
            captionContainerType(model.captionContainerType);
            scte35Esam(model.scte35Esam);
            scte35Source(model.scte35Source);
        }

        public final String getAccessibilityCaptionHints() {
            return accessibilityCaptionHints;
        }

        public final void setAccessibilityCaptionHints(String accessibilityCaptionHints) {
            this.accessibilityCaptionHints = accessibilityCaptionHints;
        }

        @Override
        @Transient
        public final Builder accessibilityCaptionHints(String accessibilityCaptionHints) {
            this.accessibilityCaptionHints = accessibilityCaptionHints;
            return this;
        }

        @Override
        @Transient
        public final Builder accessibilityCaptionHints(MpdAccessibilityCaptionHints accessibilityCaptionHints) {
            this.accessibilityCaptionHints(accessibilityCaptionHints == null ? null : accessibilityCaptionHints.toString());
            return this;
        }

        public final String getAudioDuration() {
            return audioDuration;
        }

        public final void setAudioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
        }

        @Override
        @Transient
        public final Builder audioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        @Transient
        public final Builder audioDuration(MpdAudioDuration audioDuration) {
            this.audioDuration(audioDuration == null ? null : audioDuration.toString());
            return this;
        }

        public final String getCaptionContainerType() {
            return captionContainerType;
        }

        public final void setCaptionContainerType(String captionContainerType) {
            this.captionContainerType = captionContainerType;
        }

        @Override
        @Transient
        public final Builder captionContainerType(String captionContainerType) {
            this.captionContainerType = captionContainerType;
            return this;
        }

        @Override
        @Transient
        public final Builder captionContainerType(MpdCaptionContainerType captionContainerType) {
            this.captionContainerType(captionContainerType == null ? null : captionContainerType.toString());
            return this;
        }

        public final String getScte35Esam() {
            return scte35Esam;
        }

        public final void setScte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
        }

        @Override
        @Transient
        public final Builder scte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
            return this;
        }

        @Override
        @Transient
        public final Builder scte35Esam(MpdScte35Esam scte35Esam) {
            this.scte35Esam(scte35Esam == null ? null : scte35Esam.toString());
            return this;
        }

        public final String getScte35Source() {
            return scte35Source;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        @Override
        @Transient
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        @Transient
        public final Builder scte35Source(MpdScte35Source scte35Source) {
            this.scte35Source(scte35Source == null ? null : scte35Source.toString());
            return this;
        }

        @Override
        public MpdSettings build() {
            return new MpdSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
