/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Output Group settings, including type
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputGroupSettings.Builder, OutputGroupSettings> {
    private static final SdkField<CmafGroupSettings> CMAF_GROUP_SETTINGS_FIELD = SdkField
            .<CmafGroupSettings> builder(MarshallingType.SDK_POJO).memberName("CmafGroupSettings")
            .getter(getter(OutputGroupSettings::cmafGroupSettings)).setter(setter(Builder::cmafGroupSettings))
            .constructor(CmafGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafGroupSettings").build()).build();

    private static final SdkField<DashIsoGroupSettings> DASH_ISO_GROUP_SETTINGS_FIELD = SdkField
            .<DashIsoGroupSettings> builder(MarshallingType.SDK_POJO).memberName("DashIsoGroupSettings")
            .getter(getter(OutputGroupSettings::dashIsoGroupSettings)).setter(setter(Builder::dashIsoGroupSettings))
            .constructor(DashIsoGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashIsoGroupSettings").build())
            .build();

    private static final SdkField<FileGroupSettings> FILE_GROUP_SETTINGS_FIELD = SdkField
            .<FileGroupSettings> builder(MarshallingType.SDK_POJO).memberName("FileGroupSettings")
            .getter(getter(OutputGroupSettings::fileGroupSettings)).setter(setter(Builder::fileGroupSettings))
            .constructor(FileGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileGroupSettings").build()).build();

    private static final SdkField<HlsGroupSettings> HLS_GROUP_SETTINGS_FIELD = SdkField
            .<HlsGroupSettings> builder(MarshallingType.SDK_POJO).memberName("HlsGroupSettings")
            .getter(getter(OutputGroupSettings::hlsGroupSettings)).setter(setter(Builder::hlsGroupSettings))
            .constructor(HlsGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsGroupSettings").build()).build();

    private static final SdkField<MsSmoothGroupSettings> MS_SMOOTH_GROUP_SETTINGS_FIELD = SdkField
            .<MsSmoothGroupSettings> builder(MarshallingType.SDK_POJO).memberName("MsSmoothGroupSettings")
            .getter(getter(OutputGroupSettings::msSmoothGroupSettings)).setter(setter(Builder::msSmoothGroupSettings))
            .constructor(MsSmoothGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("msSmoothGroupSettings").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(OutputGroupSettings::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CMAF_GROUP_SETTINGS_FIELD,
            DASH_ISO_GROUP_SETTINGS_FIELD, FILE_GROUP_SETTINGS_FIELD, HLS_GROUP_SETTINGS_FIELD, MS_SMOOTH_GROUP_SETTINGS_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CmafGroupSettings cmafGroupSettings;

    private final DashIsoGroupSettings dashIsoGroupSettings;

    private final FileGroupSettings fileGroupSettings;

    private final HlsGroupSettings hlsGroupSettings;

    private final MsSmoothGroupSettings msSmoothGroupSettings;

    private final String type;

    private OutputGroupSettings(BuilderImpl builder) {
        this.cmafGroupSettings = builder.cmafGroupSettings;
        this.dashIsoGroupSettings = builder.dashIsoGroupSettings;
        this.fileGroupSettings = builder.fileGroupSettings;
        this.hlsGroupSettings = builder.hlsGroupSettings;
        this.msSmoothGroupSettings = builder.msSmoothGroupSettings;
        this.type = builder.type;
    }

    /**
     * Settings related to your CMAF output package. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job
     * specification, include this object and any required children when you set Type, under OutputGroupSettings, to
     * CMAF_GROUP_SETTINGS.
     * 
     * @return Settings related to your CMAF output package. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your
     *         JSON job specification, include this object and any required children when you set Type, under
     *         OutputGroupSettings, to CMAF_GROUP_SETTINGS.
     */
    public final CmafGroupSettings cmafGroupSettings() {
        return cmafGroupSettings;
    }

    /**
     * Settings related to your DASH output package. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job
     * specification, include this object and any required children when you set Type, under OutputGroupSettings, to
     * DASH_ISO_GROUP_SETTINGS.
     * 
     * @return Settings related to your DASH output package. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your
     *         JSON job specification, include this object and any required children when you set Type, under
     *         OutputGroupSettings, to DASH_ISO_GROUP_SETTINGS.
     */
    public final DashIsoGroupSettings dashIsoGroupSettings() {
        return dashIsoGroupSettings;
    }

    /**
     * Settings related to your File output group. MediaConvert uses this group of settings to generate a single
     * standalone file, rather than a streaming package. When you work directly in your JSON job specification, include
     * this object and any required children when you set Type, under OutputGroupSettings, to FILE_GROUP_SETTINGS.
     * 
     * @return Settings related to your File output group. MediaConvert uses this group of settings to generate a single
     *         standalone file, rather than a streaming package. When you work directly in your JSON job specification,
     *         include this object and any required children when you set Type, under OutputGroupSettings, to
     *         FILE_GROUP_SETTINGS.
     */
    public final FileGroupSettings fileGroupSettings() {
        return fileGroupSettings;
    }

    /**
     * Settings related to your HLS output package. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job
     * specification, include this object and any required children when you set Type, under OutputGroupSettings, to
     * HLS_GROUP_SETTINGS.
     * 
     * @return Settings related to your HLS output package. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your
     *         JSON job specification, include this object and any required children when you set Type, under
     *         OutputGroupSettings, to HLS_GROUP_SETTINGS.
     */
    public final HlsGroupSettings hlsGroupSettings() {
        return hlsGroupSettings;
    }

    /**
     * Settings related to your Microsoft Smooth Streaming output package. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job
     * specification, include this object and any required children when you set Type, under OutputGroupSettings, to
     * MS_SMOOTH_GROUP_SETTINGS.
     * 
     * @return Settings related to your Microsoft Smooth Streaming output package. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your
     *         JSON job specification, include this object and any required children when you set Type, under
     *         OutputGroupSettings, to MS_SMOOTH_GROUP_SETTINGS.
     */
    public final MsSmoothGroupSettings msSmoothGroupSettings() {
        return msSmoothGroupSettings;
    }

    /**
     * Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OutputGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)
     * @see OutputGroupType
     */
    public final OutputGroupType type() {
        return OutputGroupType.fromValue(type);
    }

    /**
     * Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OutputGroupType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)
     * @see OutputGroupType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cmafGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(dashIsoGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(fileGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(msSmoothGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroupSettings)) {
            return false;
        }
        OutputGroupSettings other = (OutputGroupSettings) obj;
        return Objects.equals(cmafGroupSettings(), other.cmafGroupSettings())
                && Objects.equals(dashIsoGroupSettings(), other.dashIsoGroupSettings())
                && Objects.equals(fileGroupSettings(), other.fileGroupSettings())
                && Objects.equals(hlsGroupSettings(), other.hlsGroupSettings())
                && Objects.equals(msSmoothGroupSettings(), other.msSmoothGroupSettings())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputGroupSettings").add("CmafGroupSettings", cmafGroupSettings())
                .add("DashIsoGroupSettings", dashIsoGroupSettings()).add("FileGroupSettings", fileGroupSettings())
                .add("HlsGroupSettings", hlsGroupSettings()).add("MsSmoothGroupSettings", msSmoothGroupSettings())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CmafGroupSettings":
            return Optional.ofNullable(clazz.cast(cmafGroupSettings()));
        case "DashIsoGroupSettings":
            return Optional.ofNullable(clazz.cast(dashIsoGroupSettings()));
        case "FileGroupSettings":
            return Optional.ofNullable(clazz.cast(fileGroupSettings()));
        case "HlsGroupSettings":
            return Optional.ofNullable(clazz.cast(hlsGroupSettings()));
        case "MsSmoothGroupSettings":
            return Optional.ofNullable(clazz.cast(msSmoothGroupSettings()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputGroupSettings, T> g) {
        return obj -> g.apply((OutputGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputGroupSettings> {
        /**
         * Settings related to your CMAF output package. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON
         * job specification, include this object and any required children when you set Type, under
         * OutputGroupSettings, to CMAF_GROUP_SETTINGS.
         * 
         * @param cmafGroupSettings
         *        Settings related to your CMAF output package. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in
         *        your JSON job specification, include this object and any required children when you set Type, under
         *        OutputGroupSettings, to CMAF_GROUP_SETTINGS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmafGroupSettings(CmafGroupSettings cmafGroupSettings);

        /**
         * Settings related to your CMAF output package. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON
         * job specification, include this object and any required children when you set Type, under
         * OutputGroupSettings, to CMAF_GROUP_SETTINGS. This is a convenience that creates an instance of the
         * {@link CmafGroupSettings.Builder} avoiding the need to create one manually via
         * {@link CmafGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link CmafGroupSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #cmafGroupSettings(CmafGroupSettings)}.
         * 
         * @param cmafGroupSettings
         *        a consumer that will call methods on {@link CmafGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cmafGroupSettings(CmafGroupSettings)
         */
        default Builder cmafGroupSettings(Consumer<CmafGroupSettings.Builder> cmafGroupSettings) {
            return cmafGroupSettings(CmafGroupSettings.builder().applyMutation(cmafGroupSettings).build());
        }

        /**
         * Settings related to your DASH output package. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON
         * job specification, include this object and any required children when you set Type, under
         * OutputGroupSettings, to DASH_ISO_GROUP_SETTINGS.
         * 
         * @param dashIsoGroupSettings
         *        Settings related to your DASH output package. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in
         *        your JSON job specification, include this object and any required children when you set Type, under
         *        OutputGroupSettings, to DASH_ISO_GROUP_SETTINGS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashIsoGroupSettings(DashIsoGroupSettings dashIsoGroupSettings);

        /**
         * Settings related to your DASH output package. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON
         * job specification, include this object and any required children when you set Type, under
         * OutputGroupSettings, to DASH_ISO_GROUP_SETTINGS. This is a convenience that creates an instance of the
         * {@link DashIsoGroupSettings.Builder} avoiding the need to create one manually via
         * {@link DashIsoGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashIsoGroupSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dashIsoGroupSettings(DashIsoGroupSettings)}.
         * 
         * @param dashIsoGroupSettings
         *        a consumer that will call methods on {@link DashIsoGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashIsoGroupSettings(DashIsoGroupSettings)
         */
        default Builder dashIsoGroupSettings(Consumer<DashIsoGroupSettings.Builder> dashIsoGroupSettings) {
            return dashIsoGroupSettings(DashIsoGroupSettings.builder().applyMutation(dashIsoGroupSettings).build());
        }

        /**
         * Settings related to your File output group. MediaConvert uses this group of settings to generate a single
         * standalone file, rather than a streaming package. When you work directly in your JSON job specification,
         * include this object and any required children when you set Type, under OutputGroupSettings, to
         * FILE_GROUP_SETTINGS.
         * 
         * @param fileGroupSettings
         *        Settings related to your File output group. MediaConvert uses this group of settings to generate a
         *        single standalone file, rather than a streaming package. When you work directly in your JSON job
         *        specification, include this object and any required children when you set Type, under
         *        OutputGroupSettings, to FILE_GROUP_SETTINGS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileGroupSettings(FileGroupSettings fileGroupSettings);

        /**
         * Settings related to your File output group. MediaConvert uses this group of settings to generate a single
         * standalone file, rather than a streaming package. When you work directly in your JSON job specification,
         * include this object and any required children when you set Type, under OutputGroupSettings, to
         * FILE_GROUP_SETTINGS. This is a convenience that creates an instance of the {@link FileGroupSettings.Builder}
         * avoiding the need to create one manually via {@link FileGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileGroupSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #fileGroupSettings(FileGroupSettings)}.
         * 
         * @param fileGroupSettings
         *        a consumer that will call methods on {@link FileGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileGroupSettings(FileGroupSettings)
         */
        default Builder fileGroupSettings(Consumer<FileGroupSettings.Builder> fileGroupSettings) {
            return fileGroupSettings(FileGroupSettings.builder().applyMutation(fileGroupSettings).build());
        }

        /**
         * Settings related to your HLS output package. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON
         * job specification, include this object and any required children when you set Type, under
         * OutputGroupSettings, to HLS_GROUP_SETTINGS.
         * 
         * @param hlsGroupSettings
         *        Settings related to your HLS output package. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in
         *        your JSON job specification, include this object and any required children when you set Type, under
         *        OutputGroupSettings, to HLS_GROUP_SETTINGS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsGroupSettings(HlsGroupSettings hlsGroupSettings);

        /**
         * Settings related to your HLS output package. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON
         * job specification, include this object and any required children when you set Type, under
         * OutputGroupSettings, to HLS_GROUP_SETTINGS. This is a convenience that creates an instance of the
         * {@link HlsGroupSettings.Builder} avoiding the need to create one manually via
         * {@link HlsGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsGroupSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsGroupSettings(HlsGroupSettings)}.
         * 
         * @param hlsGroupSettings
         *        a consumer that will call methods on {@link HlsGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsGroupSettings(HlsGroupSettings)
         */
        default Builder hlsGroupSettings(Consumer<HlsGroupSettings.Builder> hlsGroupSettings) {
            return hlsGroupSettings(HlsGroupSettings.builder().applyMutation(hlsGroupSettings).build());
        }

        /**
         * Settings related to your Microsoft Smooth Streaming output package. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON
         * job specification, include this object and any required children when you set Type, under
         * OutputGroupSettings, to MS_SMOOTH_GROUP_SETTINGS.
         * 
         * @param msSmoothGroupSettings
         *        Settings related to your Microsoft Smooth Streaming output package. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in
         *        your JSON job specification, include this object and any required children when you set Type, under
         *        OutputGroupSettings, to MS_SMOOTH_GROUP_SETTINGS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msSmoothGroupSettings(MsSmoothGroupSettings msSmoothGroupSettings);

        /**
         * Settings related to your Microsoft Smooth Streaming output package. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON
         * job specification, include this object and any required children when you set Type, under
         * OutputGroupSettings, to MS_SMOOTH_GROUP_SETTINGS. This is a convenience that creates an instance of the
         * {@link MsSmoothGroupSettings.Builder} avoiding the need to create one manually via
         * {@link MsSmoothGroupSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MsSmoothGroupSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #msSmoothGroupSettings(MsSmoothGroupSettings)}.
         * 
         * @param msSmoothGroupSettings
         *        a consumer that will call methods on {@link MsSmoothGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #msSmoothGroupSettings(MsSmoothGroupSettings)
         */
        default Builder msSmoothGroupSettings(Consumer<MsSmoothGroupSettings.Builder> msSmoothGroupSettings) {
            return msSmoothGroupSettings(MsSmoothGroupSettings.builder().applyMutation(msSmoothGroupSettings).build());
        }

        /**
         * Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)
         * 
         * @param type
         *        Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)
         * @see OutputGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputGroupType
         */
        Builder type(String type);

        /**
         * Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)
         * 
         * @param type
         *        Type of output group (File group, Apple HLS, DASH ISO, Microsoft Smooth Streaming, CMAF)
         * @see OutputGroupType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputGroupType
         */
        Builder type(OutputGroupType type);
    }

    static final class BuilderImpl implements Builder {
        private CmafGroupSettings cmafGroupSettings;

        private DashIsoGroupSettings dashIsoGroupSettings;

        private FileGroupSettings fileGroupSettings;

        private HlsGroupSettings hlsGroupSettings;

        private MsSmoothGroupSettings msSmoothGroupSettings;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroupSettings model) {
            cmafGroupSettings(model.cmafGroupSettings);
            dashIsoGroupSettings(model.dashIsoGroupSettings);
            fileGroupSettings(model.fileGroupSettings);
            hlsGroupSettings(model.hlsGroupSettings);
            msSmoothGroupSettings(model.msSmoothGroupSettings);
            type(model.type);
        }

        public final CmafGroupSettings.Builder getCmafGroupSettings() {
            return cmafGroupSettings != null ? cmafGroupSettings.toBuilder() : null;
        }

        public final void setCmafGroupSettings(CmafGroupSettings.BuilderImpl cmafGroupSettings) {
            this.cmafGroupSettings = cmafGroupSettings != null ? cmafGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder cmafGroupSettings(CmafGroupSettings cmafGroupSettings) {
            this.cmafGroupSettings = cmafGroupSettings;
            return this;
        }

        public final DashIsoGroupSettings.Builder getDashIsoGroupSettings() {
            return dashIsoGroupSettings != null ? dashIsoGroupSettings.toBuilder() : null;
        }

        public final void setDashIsoGroupSettings(DashIsoGroupSettings.BuilderImpl dashIsoGroupSettings) {
            this.dashIsoGroupSettings = dashIsoGroupSettings != null ? dashIsoGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder dashIsoGroupSettings(DashIsoGroupSettings dashIsoGroupSettings) {
            this.dashIsoGroupSettings = dashIsoGroupSettings;
            return this;
        }

        public final FileGroupSettings.Builder getFileGroupSettings() {
            return fileGroupSettings != null ? fileGroupSettings.toBuilder() : null;
        }

        public final void setFileGroupSettings(FileGroupSettings.BuilderImpl fileGroupSettings) {
            this.fileGroupSettings = fileGroupSettings != null ? fileGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder fileGroupSettings(FileGroupSettings fileGroupSettings) {
            this.fileGroupSettings = fileGroupSettings;
            return this;
        }

        public final HlsGroupSettings.Builder getHlsGroupSettings() {
            return hlsGroupSettings != null ? hlsGroupSettings.toBuilder() : null;
        }

        public final void setHlsGroupSettings(HlsGroupSettings.BuilderImpl hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings != null ? hlsGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder hlsGroupSettings(HlsGroupSettings hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings;
            return this;
        }

        public final MsSmoothGroupSettings.Builder getMsSmoothGroupSettings() {
            return msSmoothGroupSettings != null ? msSmoothGroupSettings.toBuilder() : null;
        }

        public final void setMsSmoothGroupSettings(MsSmoothGroupSettings.BuilderImpl msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings != null ? msSmoothGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder msSmoothGroupSettings(MsSmoothGroupSettings msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(OutputGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public OutputGroupSettings build() {
            return new OutputGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
