/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * If you work with a third party video watermarking partner, use the group of settings that correspond with your
 * watermarking partner to include watermarks in your output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartnerWatermarking implements SdkPojo, Serializable,
        ToCopyableBuilder<PartnerWatermarking.Builder, PartnerWatermarking> {
    private static final SdkField<NexGuardFileMarkerSettings> NEXGUARD_FILE_MARKER_SETTINGS_FIELD = SdkField
            .<NexGuardFileMarkerSettings> builder(MarshallingType.SDK_POJO)
            .memberName("NexguardFileMarkerSettings")
            .getter(getter(PartnerWatermarking::nexguardFileMarkerSettings))
            .setter(setter(Builder::nexguardFileMarkerSettings))
            .constructor(NexGuardFileMarkerSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nexguardFileMarkerSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NEXGUARD_FILE_MARKER_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final NexGuardFileMarkerSettings nexguardFileMarkerSettings;

    private PartnerWatermarking(BuilderImpl builder) {
        this.nexguardFileMarkerSettings = builder.nexguardFileMarkerSettings;
    }

    /**
     * For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert
     * supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
     * 
     * @return For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking.
     *         MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
     */
    public final NexGuardFileMarkerSettings nexguardFileMarkerSettings() {
        return nexguardFileMarkerSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nexguardFileMarkerSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartnerWatermarking)) {
            return false;
        }
        PartnerWatermarking other = (PartnerWatermarking) obj;
        return Objects.equals(nexguardFileMarkerSettings(), other.nexguardFileMarkerSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PartnerWatermarking").add("NexguardFileMarkerSettings", nexguardFileMarkerSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NexguardFileMarkerSettings":
            return Optional.ofNullable(clazz.cast(nexguardFileMarkerSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartnerWatermarking, T> g) {
        return obj -> g.apply((PartnerWatermarking) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartnerWatermarking> {
        /**
         * For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert
         * supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
         * 
         * @param nexguardFileMarkerSettings
         *        For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking.
         *        MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nexguardFileMarkerSettings(NexGuardFileMarkerSettings nexguardFileMarkerSettings);

        /**
         * For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert
         * supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows. This is a convenience that creates an
         * instance of the {@link NexGuardFileMarkerSettings.Builder} avoiding the need to create one manually via
         * {@link NexGuardFileMarkerSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link NexGuardFileMarkerSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #nexguardFileMarkerSettings(NexGuardFileMarkerSettings)}.
         * 
         * @param nexguardFileMarkerSettings
         *        a consumer that will call methods on {@link NexGuardFileMarkerSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nexguardFileMarkerSettings(NexGuardFileMarkerSettings)
         */
        default Builder nexguardFileMarkerSettings(Consumer<NexGuardFileMarkerSettings.Builder> nexguardFileMarkerSettings) {
            return nexguardFileMarkerSettings(NexGuardFileMarkerSettings.builder().applyMutation(nexguardFileMarkerSettings)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NexGuardFileMarkerSettings nexguardFileMarkerSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(PartnerWatermarking model) {
            nexguardFileMarkerSettings(model.nexguardFileMarkerSettings);
        }

        public final NexGuardFileMarkerSettings.Builder getNexguardFileMarkerSettings() {
            return nexguardFileMarkerSettings != null ? nexguardFileMarkerSettings.toBuilder() : null;
        }

        public final void setNexguardFileMarkerSettings(NexGuardFileMarkerSettings.BuilderImpl nexguardFileMarkerSettings) {
            this.nexguardFileMarkerSettings = nexguardFileMarkerSettings != null ? nexguardFileMarkerSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder nexguardFileMarkerSettings(NexGuardFileMarkerSettings nexguardFileMarkerSettings) {
            this.nexguardFileMarkerSettings = nexguardFileMarkerSettings;
            return this;
        }

        @Override
        public PartnerWatermarking build() {
            return new PartnerWatermarking(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
