/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A policy configures behavior that you allow or disallow for your account. For information about MediaConvert
 * policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
 */
@Generated("software.amazon.awssdk:codegen")
public final class Policy implements SdkPojo, Serializable, ToCopyableBuilder<Policy.Builder, Policy> {
    private static final SdkField<String> HTTP_INPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpInputs").getter(getter(Policy::httpInputsAsString)).setter(setter(Builder::httpInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpInputs").build()).build();

    private static final SdkField<String> HTTPS_INPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpsInputs").getter(getter(Policy::httpsInputsAsString)).setter(setter(Builder::httpsInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpsInputs").build()).build();

    private static final SdkField<String> S3_INPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Inputs").getter(getter(Policy::s3InputsAsString)).setter(setter(Builder::s3Inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Inputs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_INPUTS_FIELD,
            HTTPS_INPUTS_FIELD, S3_INPUTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String httpInputs;

    private final String httpsInputs;

    private final String s3Inputs;

    private Policy(BuilderImpl builder) {
        this.httpInputs = builder.httpInputs;
        this.httpsInputs = builder.httpsInputs;
        this.s3Inputs = builder.s3Inputs;
    }

    /**
     * Allow or disallow jobs that specify HTTP inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpInputs} will
     * return {@link InputPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpInputsAsString}.
     * </p>
     * 
     * @return Allow or disallow jobs that specify HTTP inputs.
     * @see InputPolicy
     */
    public final InputPolicy httpInputs() {
        return InputPolicy.fromValue(httpInputs);
    }

    /**
     * Allow or disallow jobs that specify HTTP inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpInputs} will
     * return {@link InputPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpInputsAsString}.
     * </p>
     * 
     * @return Allow or disallow jobs that specify HTTP inputs.
     * @see InputPolicy
     */
    public final String httpInputsAsString() {
        return httpInputs;
    }

    /**
     * Allow or disallow jobs that specify HTTPS inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpsInputs} will
     * return {@link InputPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpsInputsAsString}.
     * </p>
     * 
     * @return Allow or disallow jobs that specify HTTPS inputs.
     * @see InputPolicy
     */
    public final InputPolicy httpsInputs() {
        return InputPolicy.fromValue(httpsInputs);
    }

    /**
     * Allow or disallow jobs that specify HTTPS inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpsInputs} will
     * return {@link InputPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpsInputsAsString}.
     * </p>
     * 
     * @return Allow or disallow jobs that specify HTTPS inputs.
     * @see InputPolicy
     */
    public final String httpsInputsAsString() {
        return httpsInputs;
    }

    /**
     * Allow or disallow jobs that specify Amazon S3 inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3Inputs} will
     * return {@link InputPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3InputsAsString}.
     * </p>
     * 
     * @return Allow or disallow jobs that specify Amazon S3 inputs.
     * @see InputPolicy
     */
    public final InputPolicy s3Inputs() {
        return InputPolicy.fromValue(s3Inputs);
    }

    /**
     * Allow or disallow jobs that specify Amazon S3 inputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3Inputs} will
     * return {@link InputPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3InputsAsString}.
     * </p>
     * 
     * @return Allow or disallow jobs that specify Amazon S3 inputs.
     * @see InputPolicy
     */
    public final String s3InputsAsString() {
        return s3Inputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpInputsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(httpsInputsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3InputsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy) obj;
        return Objects.equals(httpInputsAsString(), other.httpInputsAsString())
                && Objects.equals(httpsInputsAsString(), other.httpsInputsAsString())
                && Objects.equals(s3InputsAsString(), other.s3InputsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Policy").add("HttpInputs", httpInputsAsString()).add("HttpsInputs", httpsInputsAsString())
                .add("S3Inputs", s3InputsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpInputs":
            return Optional.ofNullable(clazz.cast(httpInputsAsString()));
        case "HttpsInputs":
            return Optional.ofNullable(clazz.cast(httpsInputsAsString()));
        case "S3Inputs":
            return Optional.ofNullable(clazz.cast(s3InputsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Policy, T> g) {
        return obj -> g.apply((Policy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Policy> {
        /**
         * Allow or disallow jobs that specify HTTP inputs.
         * 
         * @param httpInputs
         *        Allow or disallow jobs that specify HTTP inputs.
         * @see InputPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPolicy
         */
        Builder httpInputs(String httpInputs);

        /**
         * Allow or disallow jobs that specify HTTP inputs.
         * 
         * @param httpInputs
         *        Allow or disallow jobs that specify HTTP inputs.
         * @see InputPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPolicy
         */
        Builder httpInputs(InputPolicy httpInputs);

        /**
         * Allow or disallow jobs that specify HTTPS inputs.
         * 
         * @param httpsInputs
         *        Allow or disallow jobs that specify HTTPS inputs.
         * @see InputPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPolicy
         */
        Builder httpsInputs(String httpsInputs);

        /**
         * Allow or disallow jobs that specify HTTPS inputs.
         * 
         * @param httpsInputs
         *        Allow or disallow jobs that specify HTTPS inputs.
         * @see InputPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPolicy
         */
        Builder httpsInputs(InputPolicy httpsInputs);

        /**
         * Allow or disallow jobs that specify Amazon S3 inputs.
         * 
         * @param s3Inputs
         *        Allow or disallow jobs that specify Amazon S3 inputs.
         * @see InputPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPolicy
         */
        Builder s3Inputs(String s3Inputs);

        /**
         * Allow or disallow jobs that specify Amazon S3 inputs.
         * 
         * @param s3Inputs
         *        Allow or disallow jobs that specify Amazon S3 inputs.
         * @see InputPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputPolicy
         */
        Builder s3Inputs(InputPolicy s3Inputs);
    }

    static final class BuilderImpl implements Builder {
        private String httpInputs;

        private String httpsInputs;

        private String s3Inputs;

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            httpInputs(model.httpInputs);
            httpsInputs(model.httpsInputs);
            s3Inputs(model.s3Inputs);
        }

        public final String getHttpInputs() {
            return httpInputs;
        }

        public final void setHttpInputs(String httpInputs) {
            this.httpInputs = httpInputs;
        }

        @Override
        @Transient
        public final Builder httpInputs(String httpInputs) {
            this.httpInputs = httpInputs;
            return this;
        }

        @Override
        @Transient
        public final Builder httpInputs(InputPolicy httpInputs) {
            this.httpInputs(httpInputs == null ? null : httpInputs.toString());
            return this;
        }

        public final String getHttpsInputs() {
            return httpsInputs;
        }

        public final void setHttpsInputs(String httpsInputs) {
            this.httpsInputs = httpsInputs;
        }

        @Override
        @Transient
        public final Builder httpsInputs(String httpsInputs) {
            this.httpsInputs = httpsInputs;
            return this;
        }

        @Override
        @Transient
        public final Builder httpsInputs(InputPolicy httpsInputs) {
            this.httpsInputs(httpsInputs == null ? null : httpsInputs.toString());
            return this;
        }

        public final String getS3Inputs() {
            return s3Inputs;
        }

        public final void setS3Inputs(String s3Inputs) {
            this.s3Inputs = s3Inputs;
        }

        @Override
        @Transient
        public final Builder s3Inputs(String s3Inputs) {
            this.s3Inputs = s3Inputs;
            return this;
        }

        @Override
        @Transient
        public final Builder s3Inputs(InputPolicy s3Inputs) {
            this.s3Inputs(s3Inputs == null ? null : s3Inputs.toString());
            return this;
        }

        @Override
        public Policy build() {
            return new Policy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
