/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to SRT captions. SRT is a sidecar format that holds captions in a file that is separate from the
 * video container. Set up sidecar captions in the same output group, but different output from your video. When you
 * work directly in your JSON job specification, include this object and any required children when you set
 * destinationType to SRT.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtDestinationSettings.Builder, SrtDestinationSettings> {
    private static final SdkField<String> STYLE_PASSTHROUGH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StylePassthrough").getter(getter(SrtDestinationSettings::stylePassthroughAsString))
            .setter(setter(Builder::stylePassthrough))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stylePassthrough").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_PASSTHROUGH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stylePassthrough;

    private SrtDestinationSettings(BuilderImpl builder) {
        this.stylePassthrough = builder.stylePassthrough;
    }

    /**
     * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information
     * from your input captions. MediaConvert uses default settings for any missing style and position information in
     * your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position
     * information from your input captions and use simplified output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stylePassthrough}
     * will return {@link SrtStylePassthrough#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stylePassthroughAsString}.
     * </p>
     * 
     * @return Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
     *         information from your input captions. MediaConvert uses default settings for any missing style and
     *         position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore
     *         the style and position information from your input captions and use simplified output captions.
     * @see SrtStylePassthrough
     */
    public final SrtStylePassthrough stylePassthrough() {
        return SrtStylePassthrough.fromValue(stylePassthrough);
    }

    /**
     * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position information
     * from your input captions. MediaConvert uses default settings for any missing style and position information in
     * your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style and position
     * information from your input captions and use simplified output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stylePassthrough}
     * will return {@link SrtStylePassthrough#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stylePassthroughAsString}.
     * </p>
     * 
     * @return Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
     *         information from your input captions. MediaConvert uses default settings for any missing style and
     *         position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore
     *         the style and position information from your input captions and use simplified output captions.
     * @see SrtStylePassthrough
     */
    public final String stylePassthroughAsString() {
        return stylePassthrough;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stylePassthroughAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtDestinationSettings)) {
            return false;
        }
        SrtDestinationSettings other = (SrtDestinationSettings) obj;
        return Objects.equals(stylePassthroughAsString(), other.stylePassthroughAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtDestinationSettings").add("StylePassthrough", stylePassthroughAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StylePassthrough":
            return Optional.ofNullable(clazz.cast(stylePassthroughAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SrtDestinationSettings, T> g) {
        return obj -> g.apply((SrtDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtDestinationSettings> {
        /**
         * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
         * information from your input captions. MediaConvert uses default settings for any missing style and position
         * information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style
         * and position information from your input captions and use simplified output captions.
         * 
         * @param stylePassthrough
         *        Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
         *        information from your input captions. MediaConvert uses default settings for any missing style and
         *        position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to
         *        ignore the style and position information from your input captions and use simplified output captions.
         * @see SrtStylePassthrough
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SrtStylePassthrough
         */
        Builder stylePassthrough(String stylePassthrough);

        /**
         * Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
         * information from your input captions. MediaConvert uses default settings for any missing style and position
         * information in your input captions. Set Style passthrough to DISABLED, or leave blank, to ignore the style
         * and position information from your input captions and use simplified output captions.
         * 
         * @param stylePassthrough
         *        Set Style passthrough (StylePassthrough) to ENABLED to use the available style, color, and position
         *        information from your input captions. MediaConvert uses default settings for any missing style and
         *        position information in your input captions. Set Style passthrough to DISABLED, or leave blank, to
         *        ignore the style and position information from your input captions and use simplified output captions.
         * @see SrtStylePassthrough
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SrtStylePassthrough
         */
        Builder stylePassthrough(SrtStylePassthrough stylePassthrough);
    }

    static final class BuilderImpl implements Builder {
        private String stylePassthrough;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtDestinationSettings model) {
            stylePassthrough(model.stylePassthrough);
        }

        public final String getStylePassthrough() {
            return stylePassthrough;
        }

        public final void setStylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
        }

        @Override
        @Transient
        public final Builder stylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
            return this;
        }

        @Override
        @Transient
        public final Builder stylePassthrough(SrtStylePassthrough stylePassthrough) {
            this.stylePassthrough(stylePassthrough == null ? null : stylePassthrough.toString());
            return this;
        }

        @Override
        public SrtDestinationSettings build() {
            return new SrtDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
