/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ac3Settings implements SdkPojo, Serializable, ToCopyableBuilder<Ac3Settings.Builder, Ac3Settings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(Ac3Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BitstreamMode").getter(getter(Ac3Settings::bitstreamModeAsString))
            .setter(setter(Builder::bitstreamMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodingMode").getter(getter(Ac3Settings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<Integer> DIALNORM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Dialnorm").getter(getter(Ac3Settings::dialnorm)).setter(setter(Builder::dialnorm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialnorm").build()).build();

    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_LINE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DynamicRangeCompressionLine")
            .getter(getter(Ac3Settings::dynamicRangeCompressionLineAsString))
            .setter(setter(Builder::dynamicRangeCompressionLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionLine")
                    .build()).build();

    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_PROFILE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DynamicRangeCompressionProfile")
            .getter(getter(Ac3Settings::dynamicRangeCompressionProfileAsString))
            .setter(setter(Builder::dynamicRangeCompressionProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionProfile")
                    .build()).build();

    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_RF_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamicRangeCompressionRf").getter(getter(Ac3Settings::dynamicRangeCompressionRfAsString))
            .setter(setter(Builder::dynamicRangeCompressionRf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionRf").build())
            .build();

    private static final SdkField<String> LFE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LfeFilter").getter(getter(Ac3Settings::lfeFilterAsString)).setter(setter(Builder::lfeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lfeFilter").build()).build();

    private static final SdkField<String> METADATA_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataControl").getter(getter(Ac3Settings::metadataControlAsString))
            .setter(setter(Builder::metadataControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataControl").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleRate").getter(getter(Ac3Settings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD,
            BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DIALNORM_FIELD, DYNAMIC_RANGE_COMPRESSION_LINE_FIELD,
            DYNAMIC_RANGE_COMPRESSION_PROFILE_FIELD, DYNAMIC_RANGE_COMPRESSION_RF_FIELD, LFE_FILTER_FIELD,
            METADATA_CONTROL_FIELD, SAMPLE_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer bitrate;

    private final String bitstreamMode;

    private final String codingMode;

    private final Integer dialnorm;

    private final String dynamicRangeCompressionLine;

    private final String dynamicRangeCompressionProfile;

    private final String dynamicRangeCompressionRf;

    private final String lfeFilter;

    private final String metadataControl;

    private final Integer sampleRate;

    private Ac3Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dialnorm = builder.dialnorm;
        this.dynamicRangeCompressionLine = builder.dynamicRangeCompressionLine;
        this.dynamicRangeCompressionProfile = builder.dynamicRangeCompressionProfile;
        this.dynamicRangeCompressionRf = builder.dynamicRangeCompressionRf;
        this.lfeFilter = builder.lfeFilter;
        this.metadataControl = builder.metadataControl;
        this.sampleRate = builder.sampleRate;
    }

    /**
     * Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
     * 
     * @return Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
     * bitstream mode, see ATSC A/52-2012 (Annex E).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Ac3BitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
     *         bitstream mode, see ATSC A/52-2012 (Annex E).
     * @see Ac3BitstreamMode
     */
    public final Ac3BitstreamMode bitstreamMode() {
        return Ac3BitstreamMode.fromValue(bitstreamMode);
    }

    /**
     * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
     * bitstream mode, see ATSC A/52-2012 (Annex E).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitstreamMode}
     * will return {@link Ac3BitstreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #bitstreamModeAsString}.
     * </p>
     * 
     * @return Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
     *         bitstream mode, see ATSC A/52-2012 (Annex E).
     * @see Ac3BitstreamMode
     */
    public final String bitstreamModeAsString() {
        return bitstreamMode;
    }

    /**
     * Dolby Digital coding mode. Determines number of channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Ac3CodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Dolby Digital coding mode. Determines number of channels.
     * @see Ac3CodingMode
     */
    public final Ac3CodingMode codingMode() {
        return Ac3CodingMode.fromValue(codingMode);
    }

    /**
     * Dolby Digital coding mode. Determines number of channels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Ac3CodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Dolby Digital coding mode. Determines number of channels.
     * @see Ac3CodingMode
     */
    public final String codingModeAsString() {
        return codingMode;
    }

    /**
     * Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed through.
     * 
     * @return Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed
     *         through.
     */
    public final Integer dialnorm() {
        return dialnorm;
    }

    /**
     * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in
     * the Dolby Digital stream for the line operating mode. Related setting: When you use this setting, MediaConvert
     * ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For
     * information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of
     * the Dolby Metadata Guide at
     * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionLine} will return {@link Ac3DynamicRangeCompressionLine#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dynamicRangeCompressionLineAsString}.
     * </p>
     * 
     * @return Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
     *         metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this
     *         setting, MediaConvert ignores any value you provide for Dynamic range compression profile
     *         (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and
     *         profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
     *         https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * @see Ac3DynamicRangeCompressionLine
     */
    public final Ac3DynamicRangeCompressionLine dynamicRangeCompressionLine() {
        return Ac3DynamicRangeCompressionLine.fromValue(dynamicRangeCompressionLine);
    }

    /**
     * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in
     * the Dolby Digital stream for the line operating mode. Related setting: When you use this setting, MediaConvert
     * ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For
     * information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of
     * the Dolby Metadata Guide at
     * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionLine} will return {@link Ac3DynamicRangeCompressionLine#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #dynamicRangeCompressionLineAsString}.
     * </p>
     * 
     * @return Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
     *         metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this
     *         setting, MediaConvert ignores any value you provide for Dynamic range compression profile
     *         (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and
     *         profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
     *         https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * @see Ac3DynamicRangeCompressionLine
     */
    public final String dynamicRangeCompressionLineAsString() {
        return dynamicRangeCompressionLine;
    }

    /**
     * When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend that you
     * use the mode-specific settings instead of Dynamic range compression profile (DynamicRangeCompressionProfile). The
     * mode-specific settings are Dynamic range compression profile, line mode (dynamicRangeCompressionLine) and Dynamic
     * range compression profile, RF mode (dynamicRangeCompressionRf). Note that when you specify values for all three
     * settings, MediaConvert ignores the value of this setting in favor of the mode-specific settings. If you do use
     * this setting instead of the mode-specific settings, choose None (NONE) to leave out DRC signaling. Keep the
     * default Film standard (FILM_STANDARD) to set the profile to Dolby's film standard profile for all operating
     * modes.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionProfile} will return
     * {@link Ac3DynamicRangeCompressionProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRangeCompressionProfileAsString}.
     * </p>
     * 
     * @return When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend
     *         that you use the mode-specific settings instead of Dynamic range compression profile
     *         (DynamicRangeCompressionProfile). The mode-specific settings are Dynamic range compression profile, line
     *         mode (dynamicRangeCompressionLine) and Dynamic range compression profile, RF mode
     *         (dynamicRangeCompressionRf). Note that when you specify values for all three settings, MediaConvert
     *         ignores the value of this setting in favor of the mode-specific settings. If you do use this setting
     *         instead of the mode-specific settings, choose None (NONE) to leave out DRC signaling. Keep the default
     *         Film standard (FILM_STANDARD) to set the profile to Dolby's film standard profile for all operating
     *         modes.
     * @see Ac3DynamicRangeCompressionProfile
     */
    public final Ac3DynamicRangeCompressionProfile dynamicRangeCompressionProfile() {
        return Ac3DynamicRangeCompressionProfile.fromValue(dynamicRangeCompressionProfile);
    }

    /**
     * When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend that you
     * use the mode-specific settings instead of Dynamic range compression profile (DynamicRangeCompressionProfile). The
     * mode-specific settings are Dynamic range compression profile, line mode (dynamicRangeCompressionLine) and Dynamic
     * range compression profile, RF mode (dynamicRangeCompressionRf). Note that when you specify values for all three
     * settings, MediaConvert ignores the value of this setting in favor of the mode-specific settings. If you do use
     * this setting instead of the mode-specific settings, choose None (NONE) to leave out DRC signaling. Keep the
     * default Film standard (FILM_STANDARD) to set the profile to Dolby's film standard profile for all operating
     * modes.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionProfile} will return
     * {@link Ac3DynamicRangeCompressionProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dynamicRangeCompressionProfileAsString}.
     * </p>
     * 
     * @return When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend
     *         that you use the mode-specific settings instead of Dynamic range compression profile
     *         (DynamicRangeCompressionProfile). The mode-specific settings are Dynamic range compression profile, line
     *         mode (dynamicRangeCompressionLine) and Dynamic range compression profile, RF mode
     *         (dynamicRangeCompressionRf). Note that when you specify values for all three settings, MediaConvert
     *         ignores the value of this setting in favor of the mode-specific settings. If you do use this setting
     *         instead of the mode-specific settings, choose None (NONE) to leave out DRC signaling. Keep the default
     *         Film standard (FILM_STANDARD) to set the profile to Dolby's film standard profile for all operating
     *         modes.
     * @see Ac3DynamicRangeCompressionProfile
     */
    public final String dynamicRangeCompressionProfileAsString() {
        return dynamicRangeCompressionProfile;
    }

    /**
     * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in
     * the Dolby Digital stream for the RF operating mode. Related setting: When you use this setting, MediaConvert
     * ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For
     * information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of
     * the Dolby Metadata Guide at
     * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionRf} will return {@link Ac3DynamicRangeCompressionRf#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #dynamicRangeCompressionRfAsString}.
     * </p>
     * 
     * @return Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
     *         metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this
     *         setting, MediaConvert ignores any value you provide for Dynamic range compression profile
     *         (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and
     *         profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
     *         https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * @see Ac3DynamicRangeCompressionRf
     */
    public final Ac3DynamicRangeCompressionRf dynamicRangeCompressionRf() {
        return Ac3DynamicRangeCompressionRf.fromValue(dynamicRangeCompressionRf);
    }

    /**
     * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the metadata in
     * the Dolby Digital stream for the RF operating mode. Related setting: When you use this setting, MediaConvert
     * ignores any value you provide for Dynamic range compression profile (DynamicRangeCompressionProfile). For
     * information about the Dolby Digital DRC operating modes and profiles, see the Dynamic Range Control chapter of
     * the Dolby Metadata Guide at
     * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dynamicRangeCompressionRf} will return {@link Ac3DynamicRangeCompressionRf#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #dynamicRangeCompressionRfAsString}.
     * </p>
     * 
     * @return Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
     *         metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this
     *         setting, MediaConvert ignores any value you provide for Dynamic range compression profile
     *         (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and
     *         profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
     *         https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
     * @see Ac3DynamicRangeCompressionRf
     */
    public final String dynamicRangeCompressionRfAsString() {
        return dynamicRangeCompressionRf;
    }

    /**
     * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lfeFilter} will
     * return {@link Ac3LfeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lfeFilterAsString}.
     * </p>
     * 
     * @return Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     * @see Ac3LfeFilter
     */
    public final Ac3LfeFilter lfeFilter() {
        return Ac3LfeFilter.fromValue(lfeFilter);
    }

    /**
     * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lfeFilter} will
     * return {@link Ac3LfeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #lfeFilterAsString}.
     * </p>
     * 
     * @return Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
     * @see Ac3LfeFilter
     */
    public final String lfeFilterAsString() {
        return lfeFilter;
    }

    /**
     * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this
     * audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataControl}
     * will return {@link Ac3MetadataControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metadataControlAsString}.
     * </p>
     * 
     * @return When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
     *         supplied this audio data. If audio was not supplied from one of these streams, then the static metadata
     *         settings will be used.
     * @see Ac3MetadataControl
     */
    public final Ac3MetadataControl metadataControl() {
        return Ac3MetadataControl.fromValue(metadataControl);
    }

    /**
     * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this
     * audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metadataControl}
     * will return {@link Ac3MetadataControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #metadataControlAsString}.
     * </p>
     * 
     * @return When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
     *         supplied this audio data. If audio was not supplied from one of these streams, then the static metadata
     *         settings will be used.
     * @see Ac3MetadataControl
     */
    public final String metadataControlAsString() {
        return metadataControl;
    }

    /**
     * This value is always 48000. It represents the sample rate in Hz.
     * 
     * @return This value is always 48000. It represents the sample rate in Hz.
     */
    public final Integer sampleRate() {
        return sampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dialnorm());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeCompressionLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeCompressionProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicRangeCompressionRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lfeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadataControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ac3Settings)) {
            return false;
        }
        Ac3Settings other = (Ac3Settings) obj;
        return Objects.equals(bitrate(), other.bitrate())
                && Objects.equals(bitstreamModeAsString(), other.bitstreamModeAsString())
                && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(dialnorm(), other.dialnorm())
                && Objects.equals(dynamicRangeCompressionLineAsString(), other.dynamicRangeCompressionLineAsString())
                && Objects.equals(dynamicRangeCompressionProfileAsString(), other.dynamicRangeCompressionProfileAsString())
                && Objects.equals(dynamicRangeCompressionRfAsString(), other.dynamicRangeCompressionRfAsString())
                && Objects.equals(lfeFilterAsString(), other.lfeFilterAsString())
                && Objects.equals(metadataControlAsString(), other.metadataControlAsString())
                && Objects.equals(sampleRate(), other.sampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ac3Settings").add("Bitrate", bitrate()).add("BitstreamMode", bitstreamModeAsString())
                .add("CodingMode", codingModeAsString()).add("Dialnorm", dialnorm())
                .add("DynamicRangeCompressionLine", dynamicRangeCompressionLineAsString())
                .add("DynamicRangeCompressionProfile", dynamicRangeCompressionProfileAsString())
                .add("DynamicRangeCompressionRf", dynamicRangeCompressionRfAsString()).add("LfeFilter", lfeFilterAsString())
                .add("MetadataControl", metadataControlAsString()).add("SampleRate", sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "BitstreamMode":
            return Optional.ofNullable(clazz.cast(bitstreamModeAsString()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "Dialnorm":
            return Optional.ofNullable(clazz.cast(dialnorm()));
        case "DynamicRangeCompressionLine":
            return Optional.ofNullable(clazz.cast(dynamicRangeCompressionLineAsString()));
        case "DynamicRangeCompressionProfile":
            return Optional.ofNullable(clazz.cast(dynamicRangeCompressionProfileAsString()));
        case "DynamicRangeCompressionRf":
            return Optional.ofNullable(clazz.cast(dynamicRangeCompressionRfAsString()));
        case "LfeFilter":
            return Optional.ofNullable(clazz.cast(lfeFilterAsString()));
        case "MetadataControl":
            return Optional.ofNullable(clazz.cast(metadataControlAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ac3Settings, T> g) {
        return obj -> g.apply((Ac3Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ac3Settings> {
        /**
         * Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second. Valid bitrates depend on the coding mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
         * bitstream mode, see ATSC A/52-2012 (Annex E).
         * 
         * @param bitstreamMode
         *        Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the
         *        AC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         * @see Ac3BitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3BitstreamMode
         */
        Builder bitstreamMode(String bitstreamMode);

        /**
         * Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the AC3
         * bitstream mode, see ATSC A/52-2012 (Annex E).
         * 
         * @param bitstreamMode
         *        Specify the bitstream mode for the AC-3 stream that the encoder emits. For more information about the
         *        AC3 bitstream mode, see ATSC A/52-2012 (Annex E).
         * @see Ac3BitstreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3BitstreamMode
         */
        Builder bitstreamMode(Ac3BitstreamMode bitstreamMode);

        /**
         * Dolby Digital coding mode. Determines number of channels.
         * 
         * @param codingMode
         *        Dolby Digital coding mode. Determines number of channels.
         * @see Ac3CodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3CodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * Dolby Digital coding mode. Determines number of channels.
         * 
         * @param codingMode
         *        Dolby Digital coding mode. Determines number of channels.
         * @see Ac3CodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3CodingMode
         */
        Builder codingMode(Ac3CodingMode codingMode);

        /**
         * Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed through.
         * 
         * @param dialnorm
         *        Sets the dialnorm for the output. If blank and input audio is Dolby Digital, dialnorm will be passed
         *        through.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialnorm(Integer dialnorm);

        /**
         * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
         * metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this setting,
         * MediaConvert ignores any value you provide for Dynamic range compression profile
         * (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles,
         * see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * 
         * @param dynamicRangeCompressionLine
         *        Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
         *        metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this
         *        setting, MediaConvert ignores any value you provide for Dynamic range compression profile
         *        (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and
         *        profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         *        https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * @see Ac3DynamicRangeCompressionLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3DynamicRangeCompressionLine
         */
        Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine);

        /**
         * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
         * metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this setting,
         * MediaConvert ignores any value you provide for Dynamic range compression profile
         * (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles,
         * see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * 
         * @param dynamicRangeCompressionLine
         *        Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
         *        metadata in the Dolby Digital stream for the line operating mode. Related setting: When you use this
         *        setting, MediaConvert ignores any value you provide for Dynamic range compression profile
         *        (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and
         *        profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         *        https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * @see Ac3DynamicRangeCompressionLine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3DynamicRangeCompressionLine
         */
        Builder dynamicRangeCompressionLine(Ac3DynamicRangeCompressionLine dynamicRangeCompressionLine);

        /**
         * When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend that
         * you use the mode-specific settings instead of Dynamic range compression profile
         * (DynamicRangeCompressionProfile). The mode-specific settings are Dynamic range compression profile, line mode
         * (dynamicRangeCompressionLine) and Dynamic range compression profile, RF mode (dynamicRangeCompressionRf).
         * Note that when you specify values for all three settings, MediaConvert ignores the value of this setting in
         * favor of the mode-specific settings. If you do use this setting instead of the mode-specific settings, choose
         * None (NONE) to leave out DRC signaling. Keep the default Film standard (FILM_STANDARD) to set the profile to
         * Dolby's film standard profile for all operating modes.
         * 
         * @param dynamicRangeCompressionProfile
         *        When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we
         *        recommend that you use the mode-specific settings instead of Dynamic range compression profile
         *        (DynamicRangeCompressionProfile). The mode-specific settings are Dynamic range compression profile,
         *        line mode (dynamicRangeCompressionLine) and Dynamic range compression profile, RF mode
         *        (dynamicRangeCompressionRf). Note that when you specify values for all three settings, MediaConvert
         *        ignores the value of this setting in favor of the mode-specific settings. If you do use this setting
         *        instead of the mode-specific settings, choose None (NONE) to leave out DRC signaling. Keep the default
         *        Film standard (FILM_STANDARD) to set the profile to Dolby's film standard profile for all operating
         *        modes.
         * @see Ac3DynamicRangeCompressionProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3DynamicRangeCompressionProfile
         */
        Builder dynamicRangeCompressionProfile(String dynamicRangeCompressionProfile);

        /**
         * When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we recommend that
         * you use the mode-specific settings instead of Dynamic range compression profile
         * (DynamicRangeCompressionProfile). The mode-specific settings are Dynamic range compression profile, line mode
         * (dynamicRangeCompressionLine) and Dynamic range compression profile, RF mode (dynamicRangeCompressionRf).
         * Note that when you specify values for all three settings, MediaConvert ignores the value of this setting in
         * favor of the mode-specific settings. If you do use this setting instead of the mode-specific settings, choose
         * None (NONE) to leave out DRC signaling. Keep the default Film standard (FILM_STANDARD) to set the profile to
         * Dolby's film standard profile for all operating modes.
         * 
         * @param dynamicRangeCompressionProfile
         *        When you want to add Dolby dynamic range compression (DRC) signaling to your output stream, we
         *        recommend that you use the mode-specific settings instead of Dynamic range compression profile
         *        (DynamicRangeCompressionProfile). The mode-specific settings are Dynamic range compression profile,
         *        line mode (dynamicRangeCompressionLine) and Dynamic range compression profile, RF mode
         *        (dynamicRangeCompressionRf). Note that when you specify values for all three settings, MediaConvert
         *        ignores the value of this setting in favor of the mode-specific settings. If you do use this setting
         *        instead of the mode-specific settings, choose None (NONE) to leave out DRC signaling. Keep the default
         *        Film standard (FILM_STANDARD) to set the profile to Dolby's film standard profile for all operating
         *        modes.
         * @see Ac3DynamicRangeCompressionProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3DynamicRangeCompressionProfile
         */
        Builder dynamicRangeCompressionProfile(Ac3DynamicRangeCompressionProfile dynamicRangeCompressionProfile);

        /**
         * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
         * metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this setting,
         * MediaConvert ignores any value you provide for Dynamic range compression profile
         * (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles,
         * see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * 
         * @param dynamicRangeCompressionRf
         *        Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
         *        metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this
         *        setting, MediaConvert ignores any value you provide for Dynamic range compression profile
         *        (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and
         *        profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         *        https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * @see Ac3DynamicRangeCompressionRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3DynamicRangeCompressionRf
         */
        Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf);

        /**
         * Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
         * metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this setting,
         * MediaConvert ignores any value you provide for Dynamic range compression profile
         * (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and profiles,
         * see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         * https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * 
         * @param dynamicRangeCompressionRf
         *        Choose the Dolby Digital dynamic range control (DRC) profile that MediaConvert uses when encoding the
         *        metadata in the Dolby Digital stream for the RF operating mode. Related setting: When you use this
         *        setting, MediaConvert ignores any value you provide for Dynamic range compression profile
         *        (DynamicRangeCompressionProfile). For information about the Dolby Digital DRC operating modes and
         *        profiles, see the Dynamic Range Control chapter of the Dolby Metadata Guide at
         *        https://developer.dolby.com/globalassets/professional/documents/dolby-metadata-guide.pdf.
         * @see Ac3DynamicRangeCompressionRf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3DynamicRangeCompressionRf
         */
        Builder dynamicRangeCompressionRf(Ac3DynamicRangeCompressionRf dynamicRangeCompressionRf);

        /**
         * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
         * 
         * @param lfeFilter
         *        Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding
         *        mode.
         * @see Ac3LfeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3LfeFilter
         */
        Builder lfeFilter(String lfeFilter);

        /**
         * Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding mode.
         * 
         * @param lfeFilter
         *        Applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with 3_2_LFE coding
         *        mode.
         * @see Ac3LfeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3LfeFilter
         */
        Builder lfeFilter(Ac3LfeFilter lfeFilter);

        /**
         * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied
         * this audio data. If audio was not supplied from one of these streams, then the static metadata settings will
         * be used.
         * 
         * @param metadataControl
         *        When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
         *        supplied this audio data. If audio was not supplied from one of these streams, then the static
         *        metadata settings will be used.
         * @see Ac3MetadataControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3MetadataControl
         */
        Builder metadataControl(String metadataControl);

        /**
         * When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied
         * this audio data. If audio was not supplied from one of these streams, then the static metadata settings will
         * be used.
         * 
         * @param metadataControl
         *        When set to FOLLOW_INPUT, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that
         *        supplied this audio data. If audio was not supplied from one of these streams, then the static
         *        metadata settings will be used.
         * @see Ac3MetadataControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Ac3MetadataControl
         */
        Builder metadataControl(Ac3MetadataControl metadataControl);

        /**
         * This value is always 48000. It represents the sample rate in Hz.
         * 
         * @param sampleRate
         *        This value is always 48000. It represents the sample rate in Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);
    }

    static final class BuilderImpl implements Builder {
        private Integer bitrate;

        private String bitstreamMode;

        private String codingMode;

        private Integer dialnorm;

        private String dynamicRangeCompressionLine;

        private String dynamicRangeCompressionProfile;

        private String dynamicRangeCompressionRf;

        private String lfeFilter;

        private String metadataControl;

        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(Ac3Settings model) {
            bitrate(model.bitrate);
            bitstreamMode(model.bitstreamMode);
            codingMode(model.codingMode);
            dialnorm(model.dialnorm);
            dynamicRangeCompressionLine(model.dynamicRangeCompressionLine);
            dynamicRangeCompressionProfile(model.dynamicRangeCompressionProfile);
            dynamicRangeCompressionRf(model.dynamicRangeCompressionRf);
            lfeFilter(model.lfeFilter);
            metadataControl(model.metadataControl);
            sampleRate(model.sampleRate);
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getBitstreamMode() {
            return bitstreamMode;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        @Override
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        public final Builder bitstreamMode(Ac3BitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Ac3CodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final Integer getDialnorm() {
            return dialnorm;
        }

        public final void setDialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
        }

        @Override
        public final Builder dialnorm(Integer dialnorm) {
            this.dialnorm = dialnorm;
            return this;
        }

        public final String getDynamicRangeCompressionLine() {
            return dynamicRangeCompressionLine;
        }

        public final void setDynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
        }

        @Override
        public final Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionLine(Ac3DynamicRangeCompressionLine dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine(dynamicRangeCompressionLine == null ? null : dynamicRangeCompressionLine.toString());
            return this;
        }

        public final String getDynamicRangeCompressionProfile() {
            return dynamicRangeCompressionProfile;
        }

        public final void setDynamicRangeCompressionProfile(String dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile = dynamicRangeCompressionProfile;
        }

        @Override
        public final Builder dynamicRangeCompressionProfile(String dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile = dynamicRangeCompressionProfile;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionProfile(Ac3DynamicRangeCompressionProfile dynamicRangeCompressionProfile) {
            this.dynamicRangeCompressionProfile(dynamicRangeCompressionProfile == null ? null : dynamicRangeCompressionProfile
                    .toString());
            return this;
        }

        public final String getDynamicRangeCompressionRf() {
            return dynamicRangeCompressionRf;
        }

        public final void setDynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
        }

        @Override
        public final Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionRf(Ac3DynamicRangeCompressionRf dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf(dynamicRangeCompressionRf == null ? null : dynamicRangeCompressionRf.toString());
            return this;
        }

        public final String getLfeFilter() {
            return lfeFilter;
        }

        public final void setLfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
        }

        @Override
        public final Builder lfeFilter(String lfeFilter) {
            this.lfeFilter = lfeFilter;
            return this;
        }

        @Override
        public final Builder lfeFilter(Ac3LfeFilter lfeFilter) {
            this.lfeFilter(lfeFilter == null ? null : lfeFilter.toString());
            return this;
        }

        public final String getMetadataControl() {
            return metadataControl;
        }

        public final void setMetadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
        }

        @Override
        public final Builder metadataControl(String metadataControl) {
            this.metadataControl = metadataControl;
            return this;
        }

        @Override
        public final Builder metadataControl(Ac3MetadataControl metadataControl) {
            this.metadataControl(metadataControl == null ? null : metadataControl.toString());
            return this;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @Override
        public Ac3Settings build() {
            return new Ac3Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
