/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use automated encoding to have MediaConvert choose your encoding settings for you, based on characteristics of your
 * input video.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedEncodingSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedEncodingSettings.Builder, AutomatedEncodingSettings> {
    private static final SdkField<AutomatedAbrSettings> ABR_SETTINGS_FIELD = SdkField
            .<AutomatedAbrSettings> builder(MarshallingType.SDK_POJO).memberName("AbrSettings")
            .getter(getter(AutomatedEncodingSettings::abrSettings)).setter(setter(Builder::abrSettings))
            .constructor(AutomatedAbrSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abrSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABR_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutomatedAbrSettings abrSettings;

    private AutomatedEncodingSettings(BuilderImpl builder) {
        this.abrSettings = builder.abrSettings;
    }

    /**
     * Use automated ABR to have MediaConvert set up the renditions in your ABR package for you automatically, based on
     * characteristics of your input video. This feature optimizes video quality while minimizing the overall size of
     * your ABR package.
     * 
     * @return Use automated ABR to have MediaConvert set up the renditions in your ABR package for you automatically,
     *         based on characteristics of your input video. This feature optimizes video quality while minimizing the
     *         overall size of your ABR package.
     */
    public final AutomatedAbrSettings abrSettings() {
        return abrSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(abrSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedEncodingSettings)) {
            return false;
        }
        AutomatedEncodingSettings other = (AutomatedEncodingSettings) obj;
        return Objects.equals(abrSettings(), other.abrSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedEncodingSettings").add("AbrSettings", abrSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbrSettings":
            return Optional.ofNullable(clazz.cast(abrSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomatedEncodingSettings, T> g) {
        return obj -> g.apply((AutomatedEncodingSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedEncodingSettings> {
        /**
         * Use automated ABR to have MediaConvert set up the renditions in your ABR package for you automatically, based
         * on characteristics of your input video. This feature optimizes video quality while minimizing the overall
         * size of your ABR package.
         * 
         * @param abrSettings
         *        Use automated ABR to have MediaConvert set up the renditions in your ABR package for you
         *        automatically, based on characteristics of your input video. This feature optimizes video quality
         *        while minimizing the overall size of your ABR package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abrSettings(AutomatedAbrSettings abrSettings);

        /**
         * Use automated ABR to have MediaConvert set up the renditions in your ABR package for you automatically, based
         * on characteristics of your input video. This feature optimizes video quality while minimizing the overall
         * size of your ABR package. This is a convenience method that creates an instance of the
         * {@link AutomatedAbrSettings.Builder} avoiding the need to create one manually via
         * {@link AutomatedAbrSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutomatedAbrSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #abrSettings(AutomatedAbrSettings)}.
         * 
         * @param abrSettings
         *        a consumer that will call methods on {@link AutomatedAbrSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abrSettings(AutomatedAbrSettings)
         */
        default Builder abrSettings(Consumer<AutomatedAbrSettings.Builder> abrSettings) {
            return abrSettings(AutomatedAbrSettings.builder().applyMutation(abrSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomatedAbrSettings abrSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedEncodingSettings model) {
            abrSettings(model.abrSettings);
        }

        public final AutomatedAbrSettings.Builder getAbrSettings() {
            return abrSettings != null ? abrSettings.toBuilder() : null;
        }

        public final void setAbrSettings(AutomatedAbrSettings.BuilderImpl abrSettings) {
            this.abrSettings = abrSettings != null ? abrSettings.build() : null;
        }

        @Override
        public final Builder abrSettings(AutomatedAbrSettings abrSettings) {
            this.abrSettings = abrSettings;
            return this;
        }

        @Override
        public AutomatedEncodingSettings build() {
            return new AutomatedEncodingSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
