/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specific settings for this type of output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputSettings implements SdkPojo, Serializable, ToCopyableBuilder<OutputSettings.Builder, OutputSettings> {
    private static final SdkField<HlsSettings> HLS_SETTINGS_FIELD = SdkField.<HlsSettings> builder(MarshallingType.SDK_POJO)
            .memberName("HlsSettings").getter(getter(OutputSettings::hlsSettings)).setter(setter(Builder::hlsSettings))
            .constructor(HlsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final HlsSettings hlsSettings;

    private OutputSettings(BuilderImpl builder) {
        this.hlsSettings = builder.hlsSettings;
    }

    /**
     * Settings for HLS output groups
     * 
     * @return Settings for HLS output groups
     */
    public final HlsSettings hlsSettings() {
        return hlsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hlsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSettings)) {
            return false;
        }
        OutputSettings other = (OutputSettings) obj;
        return Objects.equals(hlsSettings(), other.hlsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputSettings").add("HlsSettings", hlsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HlsSettings":
            return Optional.ofNullable(clazz.cast(hlsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputSettings, T> g) {
        return obj -> g.apply((OutputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputSettings> {
        /**
         * Settings for HLS output groups
         * 
         * @param hlsSettings
         *        Settings for HLS output groups
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsSettings(HlsSettings hlsSettings);

        /**
         * Settings for HLS output groups This is a convenience method that creates an instance of the
         * {@link HlsSettings.Builder} avoiding the need to create one manually via {@link HlsSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #hlsSettings(HlsSettings)}.
         * 
         * @param hlsSettings
         *        a consumer that will call methods on {@link HlsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsSettings(HlsSettings)
         */
        default Builder hlsSettings(Consumer<HlsSettings.Builder> hlsSettings) {
            return hlsSettings(HlsSettings.builder().applyMutation(hlsSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HlsSettings hlsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSettings model) {
            hlsSettings(model.hlsSettings);
        }

        public final HlsSettings.Builder getHlsSettings() {
            return hlsSettings != null ? hlsSettings.toBuilder() : null;
        }

        public final void setHlsSettings(HlsSettings.BuilderImpl hlsSettings) {
            this.hlsSettings = hlsSettings != null ? hlsSettings.build() : null;
        }

        @Override
        public final Builder hlsSettings(HlsSettings hlsSettings) {
            this.hlsSettings = hlsSettings;
            return this;
        }

        @Override
        public OutputSettings build() {
            return new OutputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
